<?php
/*
 * ----------------------------------------------------------------------------
 * Va-Network.inc.php                                                03/12/2006
 * This script will retrieve various information about configured networks.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.


/**
* Va-Networks.inc.php :: GetNetworkInfo()
*
* This function will return information about all networks that have been
* configured. Networks that have not been configured are ignored.
*
* Variable returned is in the format of: $var[number][settings][network config]
*
* @return array
*/
function GetNetworkInfo() {
    global $VA_SYSPATHS;                    // Include system paths.
    
    $datFile = $VA_SYSPATHS['data'] . '/NETWORKS.LST';
    $netFile = $VA_SYSPATHS['data'] . '/NET.';

    // Set default Vnet values.
    $netInfo[0] = 1;
    $netInfo[1]['netno']   = 1;
    $netInfo[1]['nettype'] = 1;
    $netInfo[1]['desc']    = 'VirtualNet';
    $netInfo[1]['accflag'] = '';
    $netInfo[1]['settings']['systemid'] = 0;

    if (!is_file($datFile)) {
        return $netInfo;
    }

    $cnt       = 1;                         // Set the counter to one (vnet).
    $fileArray = file($datFile);            // Read the file into an array.

    for ($x = 0; $x < count($fileArray); $x++) {
        $line    = trim($fileArray[$x]);        // Read a line.
        $comment = trim(substr($line, 0, 1));   // Determine if the line is commented out.
        if (($line != '') && ($comment != ';')) {
            $pos = strpos($line, ',');          // Determine the position of the comma.
            if ($pos !== FALSE) {
                $netVar = explode(',', $line);          // Explode the line into parts.
                $num  = (integer) $netVar[0];           // Determine the network number.
                $file = $netFile . $num;                // Create the net filename.
                if ((is_file($file)) && ($num > 0)) {   // If the file exists, the network is configured.
                    $netInfo[$num]['netno']   = (integer) $netVar[0];
                    $netInfo[$num]['nettype'] = (integer) $netVar[1];
                    $netInfo[$num]['desc']    = trim($netVar[2]);
                    if (!isset($netVar[3])) {
                        $netInfo[$num]['accflag'] = '';
                    } else {
                        if (trim($netVar[3]) == '-') {
                            $netInfo[$num]['accflag'] = '';
                        } else {
                            $netInfo[$num]['accflag'] = trim($netVar[3]);
                        }
                    }
                    // Additional FIDOnet information.
                    if (isset($netVar[4])) {
                        $netInfo[$num]['zone'] = (integer) $netVar[4];
                    }
                    if (isset($netVar[5])) {
                        $netInfo[$num]['nodelist'] = trim($netVar[5]);
                    }
                    if (isset($netVar[6])) {
                        $netInfo[$num]['nodediff'] = trim($netVar[6]);
                    }
                    if (isset($netVar[7])) {
                        $netInfo[$num]['realname'] = (integer) $netVar[7];
                    }

                    $netSettings = ReadConfig($file);
                    $netInfo[$num]['settings'] = $netSettings;

                    if ($netVar[0] != 1) {
                        $cnt++;                         // Increase the counter.
                    }
                }
            }
        }
    }
    
    $netInfo[0] = $cnt;                     // Set the total number of configured networks.

    return $netInfo;                        // Return the network info.
}


/**
* Va-Networks.inc.php :: GetVnetInfo()
*
* This function will return information about the VirtualNet network, which
* is used more often than any other type of network.
* Variable returned is in the format of: $var[network config]
*
* @return string
*/
function GetVnetInfo() {
    global $VA_SYSPATHS;                    // Include system paths.

    $file = $VA_SYSPATHS['data'] . '/NET.1';
    
    if (!is_file($file)) {                  // If the file is missing, return the default values.
        $vnet['systemid'] = 0;
        return $vnet;
    }
    
    return ReadConfig($file);               // Read the file and return the info.
}


/**
* va-networks.inc.php :: ReadNetworksLst()
*
* This function reads the information in the networks.lst file and places it
* into an array.
*
* The array is in the format $var[number][settings]
*
* @return array
*/
function ReadNetworksLst() {
    global $VA_SYSPATHS;                    // Include system paths.

    $datFile   = $VA_SYSPATHS['data'] . '/NETWORKS.LST';

    if (!is_file($datFile)) {
        return $netInfo;
    }

    $cnt       = 0;                         // Set the counter to zero.
    $fileArray = file($datFile);            // Read the file into an array.
    
    for ($x = 0; $x < count($fileArray); $x++) {
        $line    = trim($fileArray[$x]);        // Read a line.
        $comment = trim(substr($line, 0, 1));   // Determine if the line is commented out.
        if (($line != '') && ($comment != ';')) {
            $pos = strpos($line, ',');          // Determine the position of the comma.
            if ($pos !== FALSE) {
                $netVar = explode(',', $line);      // Explode the line into parts.
                $num  = (integer) $netVar[0];       // Determine the network number.
                $netInfo[$num]['netno']   = (integer) $netVar[0];
                $netInfo[$num]['nettype'] = (integer) $netVar[1];
                $netInfo[$num]['desc']    = trim($netVar[2]);
                if (!isset($netVar[3])) {
                    $netInfo[$num]['accflag'] = '';
                } else {
                    if (trim($netVar[3]) == '-') {
                        $netInfo[$num]['accflag'] = '';
                    } else {
                        $netInfo[$num]['accflag'] = trim($netVar[3]);
                    }
                }
                // Additional FIDOnet information.
                if (isset($netVar[4])) {
                    $netInfo[$num]['zone'] = (integer) $netVar[4];
                }
                if (isset($netVar[5])) {
                    $netInfo[$num]['nodelist'] = trim($netVar[5]);
                }
                if (isset($netVar[6])) {
                    $netInfo[$num]['nodediff'] = trim($netVar[6]);
                }
                if (isset($netVar[7])) {
                    $netInfo[$num]['realname'] = (integer) $netVar[7];
                }
                $cnt++;                             // Increase the counter.
             }
        }
    }

    $netInfo[0] = $cnt;                     // Set the total number of configured networks.

    return $netInfo;                        // Return the network info.
}
?>