<?php
/*
 * ----------------------------------------------------------------------------
 * Va-Events.inc.php                                                 11/24/2006
 * This script will retrieve all of the informaton related to the configured
 * events that are found in EVENTS.CFG.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.


/**
* Va-Events.inc.php :: GetEvents()
*
* Retrieve all of the events information and store it into a multidimensional
* array.
*
* Array format: $event[1]['setting']
*               $event[0] = Total number of events.
*
* @return array
*/
function GetEvents() {
    $fileString = ReadEvents();
    if ($fileString === FALSE) {
        trigger_error(VA_Error(3));
    }

    $events = array();                      // Create the array.
    $offset = 0;

    for ($x = 1; $offset < strlen($fileString); $x++) {
        $events[$x]['time']    = GetString($fileString, 1 + $offset, 5);
        $events[$x]['date']    = GetString($fileString, 6 + $offset, 6);
        $events[$x]['evttype'] = GetInteger($fileString, 12 + $offset);
        $events[$x]['command'] = GetString($fileString, 14 + $offset, 32);
        $offset = 45 * $x;
    }

    $events[0] = $x - 1;                    // Put the number of events in position 0.

    return $events;                         // Return the events.

}


/**
* Va-Events.inc.php :: PutEvents()
*
* This function will change the events.cfg to match the configuration variable
* passed. It then returns the new file string. The configuration variable MUST
* be in the format of $variable[1]['setting'].
*
* @param string $fileString
* @param array $configVariable
* @return string
*/
function PutEvents($fileString, $configVariable) {
    if (!is_string($fileString)) {
        $fileString = (string) $fileString;
    }
    if (!is_array($configVariable)) {
        trigger_error(VA_Error(1));
    }

    $length  = count($configVariable);      // Get the number of elements in the config variable.
    $pointer = 0;                           // Reset the pointer.
    $offset  = 0;

    if (isset($configVariable[0])) {
        $length--;
    }

    for ($x = 1; $pointer < $length; $x++) {
        $total = intval(strlen($fileString) / 45);
        if ($x > $total) {
            $fileString = $fileString . str_pad('', 45, chr(0));
        }

        if (isset($configVariable[$x])) {
            $pointer++;
            if (isset($configVariable[$x]['time']))    $fileString = PutString($fileString, $configVariable[$x]['time'], 1 + $offset, 5);
            if (isset($configVariable[$x]['date']))    $fileString = PutString($fileString, $configVariable[$x]['date'], 6 + $offset, 6);
            if (isset($configVariable[$x]['evttype'])) $fileString = PutInteger($fileString, $configVariable[$x]['evttype'], 12 + $offset);
            if (isset($configVariable[$x]['command'])) $fileString = PutString($fileString, $configVariable[$x]['command'], 14 + $offset, 32);
        }
        $offset = 45 * $x;
    }

    return $fileString;                     // Return the new file string.
}


/**
* Va-Events.inc.php :: ReadEvents()
*
* This function will read the events.cfg file.
*
* @return string
*/
function ReadEvents() {
    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/EVENTS.CFG';
    $fileString = ReadCfgFile($file);       // Read the file.

    return $fileString;                     // Return the file string.
}


/**
* Va-Events.inc.php :: WriteEvents()
*
* This function will write a new events.cfg file based on the file string
* passed to it. If the file string is not in the correct format, then your
* events.cfg file will become corrupt and the BBS could stop functioning!
*
* @param string $fileString
* @return mixed
*/
function WriteEvents($fileString) {
    if (!is_string($fileString)) {
        $fileString = (string) $fileString;
    }

    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/EVENTS.CFG';
    $status = WriteCfgFile($file, $fileString);

    return $status;                         // Return the result status.
}


// Retrieve the events automatically.
$VA_EVENTS = GetEvents();

?>