<?php
/*
 * ----------------------------------------------------------------------------
 * Search.php                                                        08/02/2006
 * This script searches databases and displays its results.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

session_cache_limiter('nocache');                   // Useful if a user hits the back button.

$VA_ACTION = 'Searching Databases';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-main.inc.php');      // Include the main configuration variable.
require_once($includeDir . 'va-networks.inc.php');  // Include network functions.
require_once($includeDir . 'vadv-php_dat.inc.php'); // Include user settings.
require_once('layout_search.inc.php');              // Webpage footer and header.

$userno = $USER['userno'];

if (isset($_REQUEST['t'])) {                // Set the passed variables.
    $t = (integer) $_REQUEST['t'];
} else {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

if (isset($_REQUEST['d'])) {                // Set the passed variables.
    $d = (integer) $_REQUEST['d'];
} else {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

if (($t == 'e') || ($d == 'e')) {           // Get the database information.
    if (($USER['userno'] == 0) ||
        ($USER['userno'] == $CONFIG['guestacct']) ||
        ($USER['securitylevel'] == 0)) {
        die(VA_LoginError());
    }
    $t = 'e';
    $d = 'e';
    $db = SetEmailInfo($userno);
} else {
    $db = GetDbInfo($t, $d);
}
if (!DbAccess($db)) {
    die('<br /><h4>You do not have access to this section. Please press the BACK button on your browser.</h4>');
}

if ((isset($_REQUEST['submit'])) && ($_REQUEST['submit'] == 'Cancel')) {
    if ($db['dbtype'] == 'M') {
        RedirectUser('forum-dispmsg.php?t=' . $t . '&d=' . $d);
    }
    if ($db['dbtype'] == 'F') {
        RedirectUser('files-dispmsg.php?t=' . $t . '&d=' . $d);
    }
    if ($db['dbtype'] == 'E') {
        RedirectUser('email-dispmsg.php');
    }
    RedirectUser('<?php print $rootDir; ?>index.php');
}

if (((!isset($_REQUEST['search'])) || (trim($_REQUEST['search'] == ''))) &&
    ((!isset($_REQUEST['results'])) || (trim($_REQUEST['results'] == ''))) &&
    (isset($_SESSION['searchresults']))) {
    unset($_SESSION['searchresults']);
}

if (((isset($_REQUEST['search'])) && (trim($_REQUEST['search']) != '')) &&
    ((isset($_SESSION['searchresults'])) && ($_SESSION['searchresults']) != '') &&
    ((!isset($_REQUEST['sno'])) || ($_REQUEST['sno'] > 0))) {
    $search = (string) trim(strtolower($_REQUEST['search']));
    if (strlen($search) > 80) {
        $search = substr($search, 0, 80);
    }
} else {
    // No search string specified, so display form to get search specifications.
    SearchHeader();
    
    if (isset($_SESSION['searchresults'])) {
        unset($_SESSION['searchresults']);
        print '<center><span style="font-family: Verdana, Arial, Helvetica; font-size: 12pt; color: #000080"><b>Search Complete. No Results Found.</b></span></center>';
    }
?>

<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#000080">
    <tr>
        <td class="msgBack" align="left">
            <a class="msgBack" href="<?php
                                     if ($db['dbtype'] == 'E') {
                                         print 'email-dispmsg.php">Back to Email';
                                     } else if ($db['dbtype'] == 'F') {
                                         print 'files-dispmsg.php?t=' . $t . '&d=' . $d . '">Back to Files';
                                     } else {
                                         print 'forum-dispmsg.php?t=' . $t . '&d=' . $d . '">Back to Messages';
                                     }
                                     ?></a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<div align="center">
    <center>
    <table border="1" cellspacing="0" cellpadding="4" bordercolor="#000080" width="100%" height="100%">
        <tr>
            <td>
                <form name="search" action="search.php" method="GET">
                <input type="hidden" name="t" value="<?php print $t; ?>">
                <input type="hidden" name="d" value="<?php print $d; ?>">
                <table cellpadding="0" cellspacing="0" width="100%">
                    <tr>
                        <td valign="top">
                            <div align="center">
                                <table cellpadding="4" cellspacing="0" width="100%" height="100%">
                                    <tr>
                                        <td class="msgTitle" colspan="2" align="center" bgcolor="#000080">
                                            Search Query</td>
                                    </tr>
                                    <tr>
                                        <td class="msgHeader" valign="top" rowspan="3" bgcolor="#416DBF">
                                            This performs a database search using
                                            the keywords that you specify. You may
                                            search using <i>any</i> or <i>all</i>
                                            of the words that you enter.<br /><br />
                                            The search results will be displayed when completed. It will
                                            return up to 200 entries.</td>
                                        <td align="center" width="230" bgcolor="#E2E2E2">
                                            <input type="text" name="search" size="32" maxlength="80" tabindex="1"></td>
                                    </tr>
                                    <tr>
                                        <td class="msgBody" align="left" width="230" bgcolor="#E2E2E2">
                                            <input type="radio" value="0" name="type" tabindex="2" checked>Search
                                            for <i>any</i> terms</td>
                                    </tr>
                                    <tr>
                                        <td class="msgBody" align="left" width="230" bgcolor="#E2E2E2">
                                            <input type="radio" value="1" name="type" tabindex="2">Search
                                            for <i>all</i> terms</td>
                                    </tr>
                                </table>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td valign="top">
                            <div align="center">
                                <table cellpadding="4" cellspacing="0" width="100%" height="100%">
                                    <tr>
                                        <td class="msgTitle" colspan="2" align="center" bgcolor="#000080">
                                            Search Options</td>
                                    </tr>
                                    <tr>
<?php
if ($db['dbtype'] != 'F') {
?>
                                        <td class="msgHeader" align="left" valign="top" rowspan="5" bgcolor="#416DBF">
                                            Determine which parts of the message
                                            that you wish to search and how long
                                            ago.</td>
                                        <td class="msgBody" width="230" bgcolor="#E2E2E2">
                                            <select size="1" name="n" tabindex="3">
                                                <option value="30">Last 30 days</option>
                                                <option value="60">Last 60 days</option>
                                                <option value="90">Last 90 days</option>
                                                <option value="365">Last 365 days</option>
                                                <option value="0">All Messages</option>
                                            <select></td>
                                    </tr>
                                    <tr>
                                        <td class="msgBody" width="230" bgcolor="#E2E2E2">
                                            <input type="checkbox" name="f" value="1" tabindex="4" checked>Author</td>
                                    </tr>
                                    <tr>
                                        <td class="msgBody" width="230" bgcolor="#E2E2E2">
                                            <input type="checkbox" name="r" value="1" tabindex="5" checked>Recipient</td>
                                    </tr>
                                    <tr>
                                        <td class="msgBody" width="230" bgcolor="#E2E2E2">
                                            <input type="checkbox" name="s" value="1" tabindex="6" checked>Subject</td>
                                    </tr>
                                    <tr>
                                        <td class="msgBody" width="230" bgcolor="#E2E2E2">
                                            <input type="checkbox" name="b" value="1" tabindex="7">Message Body</td>
                                    </tr>
<?php
} else {
?>
                                        <td class="msgHeader" align="left" valign="top" rowspan="5" bgcolor="#416DBF">
                                            Determine which parts of the file
                                            that you wish to search and how long
                                            ago.</td>
                                        <td class="msgBody" width="230" bgcolor="#E2E2E2">
                                            <select size="1" name="n" tabindex="3">
                                                <option value="30">Last 30 days</option>
                                                <option value="60">Last 60 days</option>
                                                <option value="90">Last 90 days</option>
                                                <option value="365">Last 365 days</option>
                                                <option value="0">All Files</option>
                                            <select></td>
                                    <tr>
                                        <td class="msgBody" width="230" bgcolor="#E2E2E2">
                                            <input type="checkbox" name="f" value="1" tabindex="4" checked>Uploader</td>
                                    </tr>
                                    <tr>
                                        <td class="msgBody" width="230" bgcolor="#E2E2E2">
                                            <input type="checkbox" name="a" value="1" tabindex="8" checked>Filename</td>
                                    </tr>
                                    <tr>
                                        <td class="msgBody" width="230" bgcolor="#E2E2E2">
                                            <input type="checkbox" name="s" value="1" tabindex="6" checked>Description</td>
                                    </tr>
                                    <tr>
                                        <td class="msgBody" width="230" bgcolor="#E2E2E2">
                                            <input type="checkbox" name="b" value="1" tabindex="7">Long Description</td>
                                    </tr>
<?php
}
?>
                                </table>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td valign="top">
                            <div align="center">
                                <table cellpadding="4" cellspacing="0" width="100%" height="100%">
                                    <tr>
                                        <td align="right" bgcolor="#E2E2E2">
                                            <input type="submit" name="submit" value="Submit" tabindex="9">
                                            </form>
                                        </td>
                                        <td align="left" bgcolor="#E2E2E2">
                                            <form name="cancel" action="search.php" method="POST">
                                                <input type="hidden" name="t" value="<?php print $t; ?>">
                                                <input type="hidden" name="d" value="<?php print $d; ?>">
                                                <input type="submit" name="submit" value="Cancel" tabindex="10">
                                            </form>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </td>
                    </tr>
                    </form>
                </table>
            </td>
        </tr>
    </table>
    </center>
</div>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
            <a class="msgBack" href="<?php
                                     if ($db['dbtype'] == 'E') {
                                         print 'email-dispmsg.php">Back to Email';
                                     } else if ($db['dbtype'] == 'F') {
                                         print 'files-dispmsg.php?t=' . $t . '&d=' . $d . '">Back to Files';
                                     } else {
                                         print 'forum-dispmsg.php?t=' . $t . '&d=' . $d . '">Back to Messages';
                                     }
                                     ?></a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>

<?php
    SearchFooter();
    $_SESSION['searchresults'] = ' ';
    die();
}

$opt['default'] = FALSE;

// Setup search options...
if (isset($_REQUEST['type'])) {
    $opt['type'] = (integer) $_REQUEST['type'];
} else {
    $opt['type'] = 0;
}

if (isset($_REQUEST['n'])) {
    $opt['n'] = (integer) $_REQUEST['n'];
} else {
    $opt['n'] = 30;
}

if (isset($_REQUEST['f'])) {
    $opt['f'] = (boolean) $_REQUEST['f'];
    if ($opt['f']) {
        $opt['default'] = TRUE;
    }
} else {
    $opt['f'] = FALSE;
}

if (isset($_REQUEST['r'])) {
    $opt['r'] = (boolean) $_REQUEST['r'];
    if ($opt['r']) {
        $opt['default'] = TRUE;
    }
} else {
    $opt['r'] = FALSE;
}

if (isset($_REQUEST['s'])) {
    $opt['s'] = (boolean) $_REQUEST['s'];
    if ($opt['s']) {
        $opt['default'] = TRUE;
    }
} else {
    $opt['s'] = FALSE;
}

if (isset($_REQUEST['b'])) {
    $opt['b'] = (boolean) $_REQUEST['b'];
    if ($opt['b']) {
        $opt['default'] = TRUE;
    }
} else {
    $opt['b'] = FALSE;
}

if (isset($_REQUEST['a'])) {
    $opt['a'] = (boolean) $_REQUEST['a'];
    if ($opt['a']) {
        $opt['default'] = TRUE;
    }
} else {
    $opt['a'] = FALSE;
}

// If no options, then search subjects.
if (!$opt['default']) {
    $opt['s'] = TRUE;
}

// Search...
if ((isset($_SESSION['searchresults'])) && (isset($_REQUEST['results'])) &&
    (!isset($_REQUEST['sno']))) {
    // Results exist, so no search needed.
    $results = trim($_SESSION['searchresults']);
} else {
    if (isset($_SESSION['searchresults'])) {
        if (isset($_REQUEST['sno'])) {
            $results = $_SESSION['searchresults'];
        } else {
            unset($_SESSION['searchresults']);
            $results = ' ';
        }
    } else {
        $results = ' ';
    }

    if (!isset($_REQUEST['sno'])) {
        $msgno = $db['msgno'];
    } else {
        $msgno = (integer) $_REQUEST['sno'];
        $pct = floor((($db['msgno'] - $msgno) / $db['msgno']) * 100);

    require_once($includeDir. 'html_header.php');
?>

<html>
<head>
<title>Searching...</title>
</head>
<body>
<div align="center">
    <table width="100%" height="75%">
        <tr>
            <td height="100%" width="100%" align="center">
                <table cellpadding="4" cellspacing="0" border="1" bordercolor="#000080">
                    <tr>
                        <td height="100%" width="100%">
                            <table cellpadding="4" cellspacing="0" width="100%" height="100%">
                                <tr>
                                    <td bgcolor="#000080" align="center" width="400" style="font-family: Verdana, Arial, Helvetica; color: #FFFF00">
                                        Searching...</td>
                                </tr>
                                <tr>
                                    <td bgcolor="#E2E2E2" align="center" width="400" height="50" style="font-family: Verdana, Arial, Helvetica; color: #000000">
                                        This may take a few moments... <?php print $pct; ?>%</td>
                                </tr>
                                <tr>
                                    <td bgcolor="#E2E2E2" align="center" width="400" style="font-family: Verdana, Arial, Helvetica; color: #000000">
                                        <table cellpadding="0" cellspacing="0" width="100%" height="100%" border="1" bordercolor="#000000">
                                            <tr>
                                                <td height="20" width="<?php print $pct; ?>%" bgcolor="#FF0000">&nbsp;</td>
                                                <td height="20" bgcolor="#000000">&nbsp;</td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</div>
</body>
</html>

<?php
        ob_flush();
    }

    // Reorganize the search string.
    $q = explode(' ', $search);
    $query = '';
    for ($x = 0; $x < count($q); $x++) {
        if (trim($q[$x]) != '') {
            $query .= trim($q[$x]) . ' ';
        }
    }
    $query = explode(' ', trim($query));

    $datfile = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
    $binfile = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.BIN';
    if (!is_file($datfile)) {
        die('<br /><h4>Requested database is missing. Please press the BACK button on your browser.</h4>');
    }
    $datFileString = ReadCfgFile($datfile);    // Read the file.

    if (!is_file($binfile)) {
        $binFileString = '';
    } else {
        if ($opt['b']) {
            $binFileString = ReadCfgFile($binfile);
        }
    }

    for ($x = $msgno; $x > 0; $x--) {
        $found = FALSE;
        $array = array();
        $msgInfo = GetMessageInfo($db, $x, $datFileString);

        // Check message age.
        if ($opt['n'] > 0) {
            $age = floor((time() - $msgInfo['timestamp']) / 86400);
            if ($age > $opt['n']) {
                break;
            }
        }

        if ((($opt['f']) && (!$found)) &&
            (($db['dbtype'] != 'E') || ($msgInfo['touserno'] == $userno))) {
            for ($y = 0; $y < count($query); $y++) {
                if (stristr(trim($msgInfo['fromhandle']), trim($query[$y])) !== FALSE) {
                    if ($opt['type'] == 0) {
                        $found = TRUE;
                        break;
                    } else {
                        $array[$y] = $query[$y];
                        if (count($array) == count($query)) {
                            $found = TRUE;
                            break;
                        }
                    }
                }
            }
        }
        if ((($opt['r']) && (!$found)) &&
            (($db['dbtype'] != 'E') || ($msgInfo['touserno'] == $userno))) {
            for ($y = 0; $y < count($query); $y++) {
                if (stristr(trim($msgInfo['tohandle']), trim($query[$y])) !== FALSE) {
                    if ($opt['type'] == 0) {
                        $found = TRUE;
                        break;
                    } else {
                        $array[$y] = $query[$y];
                        if (count($array) == count($query)) {
                            $found = TRUE;
                            break;
                        }
                    }
                }
            }
        }
        if ((($opt['s']) && (!$found)) &&
            (($db['dbtype'] != 'E') || ($msgInfo['touserno'] == $userno))) {
            for ($y = 0; $y < count($query); $y++) {
                if (stristr(trim($msgInfo['subject']), trim($query[$y])) !== FALSE) {
                    if ($opt['type'] == 0) {
                        $found = TRUE;
                        break;
                    } else {
                        $array[$y] = $query[$y];
                        if (count($array) == count($query)) {
                            $found = TRUE;
                            break;
                        }
                    }
                }
            }
        }
        if ((($opt['a']) && (!$found)) &&
            (($db['dbtype'] != 'E') || ($msgInfo['touserno'] == $userno))) {
            for ($y = 0; $y < count($query); $y++) {
                if (stristr(trim($msgInfo['attfilename']), trim($query[$y])) !== FALSE) {
                    if ($opt['type'] == 0) {
                        $found = TRUE;
                        break;
                    } else {
                        $array[$y] = $query[$y];
                        if (count($array) == count($query)) {
                            $found = TRUE;
                            break;
                        }
                    }
                }
            }
        }
        if ((($opt['b']) && (!$found)) &&
            (($db['dbtype'] != 'E') || ($msgInfo['touserno'] == $userno))) {
            $message = GetMessage($db, $x, 2, $binFileString, $msgInfo);
            for ($y = 0; $y < count($query); $y++) {
                if (stristr($message, trim($query[$y])) !== FALSE) {
                    if ($opt['type'] == 0) {
                        $found = TRUE;
                        break;
                    } else {
                        $array[$y] = $query[$y];
                        if (count($array) == count($query)) {
                            $found = TRUE;
                            break;
                        }
                    }
                }
            }
        }
        if ($found) {
            $results .= $x . '*';
        }
        if (count(explode('*', $results)) > 200) {
            break;
        }
        if ($x < ($msgno - 100)) {
            $_SESSION['searchresults'] = $results;
            RedirectUser('search.php?t=' . $t . '&d=' . $d . '&search=' . $search . '&type=' . $opt['type'] . '&n=' . $opt['n'] . '&f=' . $opt['f'] . '&r=' . $opt['r'] . '&s=' . $opt['s'] . '&b=' . $opt['b'] . '&a=' . $opt['a'] . '&sno=' . --$x);
        }
    }
    if ($results != '') {
        $results = substr($results, 0, strlen($results) - 1);
    }

    $_SESSION['searchresults'] = $results;
    RedirectUser('search.php?t=' . $t . '&d=' . $d . '&search=' . $search . '&results=1&type=' . $opt['type'] . '&n=' . $opt['n'] . '&f=' . $opt['f'] . '&r=' . $opt['r'] . '&s=' . $opt['s'] . '&b=' . $opt['b'] . '&a=' . $opt['a']);
}

// Put the results into an array.
$resultsArray = explode('*', $results);
sort($resultsArray, SORT_NUMERIC);

// Display results.
SearchHeader();

if ($db['dbtype'] == 'F') {
    // --- FILE LAYOUT ---------------------------------------------------------
    $topic = GetTopicInfo($t, 'M');             // Retrieve the topic information.

    if (trim($topic['desc']) != '') {
        $topicDesc = htmlspecialchars($topic['desc']);
    } else {
        $topicDesc = '(No Topic Description)';
    }

    if (trim($db['desc']) != '') {
        $dbDesc = htmlspecialchars($db['desc']);
    } else {
        $dbDesc = '(No Description)';
    }

    if (strlen($dbDesc) >= 31) {
        $dbDesc = $dbDesc . '...';
    }

    $msgno = count($resultsArray);              // Retrieve the number of messages.

    if (isset($_REQUEST['m'])) {                // Set the passed variables.
        $m = (integer) $_REQUEST['m'];
    } else {
        $m = $msgno;
    }
    if ($m > $msgno) {
        $m = $msgno;
    }
    if ($m <= 0) {
        $m = 1;
    }
?>

<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
<?php
    if ($m > 25) {
        $num = $m - 25;
        $cnt = 25;
        if ($num < 25) {
            $cnt = $num;
        }
        print '<a class="msgBack" href="search.php?t=' . $t . '&d=' . $d . '">Previous ' . $cnt . '</a> |' . "\n";
    }

    if ($m < $msgno) {
        $num = $m + 25;
        if ($num > $msgno) {
            $num = $msgno;
        }
        $cnt = 25;
        if (($msgno - $m) < 25) {
            $cnt = ($msgno - $m);
        }
        print '<a class="msgBack" href="search.php?t=' . $t . '&d=' . $d . '">Next ' . $cnt . '</a> |' . "\n";
    }
    print '<a class="msgBack" href="Search.php?t=' . $t . '&d=' . $d . '">Back to Search</a>' . "\n";
    print '&nbsp;<a class="msgBack" title="Back to ' . HtmlSpace($dbDesc) . '" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '">&lt;--</a>' . "\n";
?>
        </td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<table border="1" width="750" cellspacing="0" cellpadding="2" bordercolor="#666666" style="border-collapse: collapse">
    <tr>
        <td colspan="5" bgcolor="#416DBF" height="33" width="750">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td class="msgTitle" colspan="5" bgcolor="#416DBF" height="33" width="750">
                        &nbsp;&nbsp;<?php
                                    if (trim($db['desc']) != '') {
                                        print HtmlSpace(htmlspecialchars($db['desc']));
                                    } else {
                                        print '(No Description)';
                                    }
                                    ?></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td class="msgHeader" width="30" height="15" bgcolor="#000080"></td>
        <td class="msgHeader" width="385" height="15" bgcolor="#000080" align="left">&nbsp;Description</td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="center">&nbsp;Filename</td>
        <td class="msgHeader" width="60" height="15" bgcolor="#000080" align="center">&nbsp;Size</td>
        <td class="msgHeader" width="175" height="15" bgcolor="#000080" align="center">Date/Time/Uploader</td>
    </tr>
<?php
    // Set the fileString variable.
    $file = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
    if (!is_file($file)) {
        die('<br /><h4>Requested database is missing. Please press the BACK button on your browser.</h4>');
    }
    $fileString = ReadCfgFile($file);           // Read the file.

    // Run the loop that will display the messages.
    for ($x = $m; $x >= ($m - 24); $x--) {
        if ($msgno == 0) {
            print '<tr><td colspan="5"><p align="left"><br /><span class="heading">There are no files in this database.</span><br /><br /></p></td></tr>' . "\n";
            break;
        }

        if ($x <= 0) {
            break;
        }
        $msgInfo = GetMessageInfo($db, $resultsArray[$x - 1], $fileString);    // Get the message information.
        $dateTime = ConvertDateTime($msgInfo['creation']);

        $from = $msgInfo['fromhandle'];
        $pos = strpos($from, '@');                          // Check for email address.
        if (is_int($pos)) {
            $from = substr($from, 0, $pos);
        }
        $char = substr($from, 0, 1);
        if ($char == '<') {
            $from = substr($from, 1);
        }
        if ($char == '"') {
            $pos = strpos($from, '"', 1);
            $from = substr($from, 1, $pos - 1);
        }
        $from = trim(htmlspecialchars($from));

        if ($msgInfo['subject'] == '') {
            $subject = '(No Description)';
        } else {
            $subject = htmlspecialchars(StripANSICodes(StripBBSCodes($msgInfo['subject'])));
        }

        if ($msgInfo['attfilename'] != '') {
            if ($CONFIG['filehost'] != '') {
                $file = ConvertDir($CONFIG['hostname'], $db['filepath']) . '/' . $msgInfo['attfilename'];
            } else {
                $file = $db['filepath'] . '/' . $msgInfo['attfilename'];
            }
        } else {
            $file = '';
        }

        if ($file != '') {
            if (!is_file($file)) {
                $filesize = '0 bytes';
            } else {
                $filesize = filesize($file);
                if ($filesize >= 1073741824) {
                    $filesize = round($filesize / 1073741824, 1) . 'GB';
                } else if ($filesize >= 1048576) {
                    $filesize = round($filesize / 1048576, 1) . 'MB';
                } else if ($filesize >= 1024) {
                    $filesize = intval($filesize / 1024) . 'KB';
                } else {
                    $filesize = $filesize . ' bytes';
                }
            }
        } else {
            $filesize = '0 bytes';
        }
?>
    <tr>
        <td width="30" height="30" bgcolor="#E2E2E2" align="center">
            <img border="0" <?php
                            if ($msgInfo['deleted'] == 0) {
                                print 'src="' . $rootDir . 'images/message.gif" alt="File"';
                            } else {
                                print 'src="' . $rootDir . 'images/message-deleted.gif" alt="File Marked for Deletion"';
                            }
                            ?> width="11" height="11">
            <?php
            if ($msgInfo['attfilename'] != '') {
                print '<img border="0" src="' . $rootDir . 'images/paperclip.gif" alt="Attached File" width="11" height="11">';
            }
            ?></td>
        <td width="385" height="30" align="left">
            <span class="heading">&nbsp;<a href="files-viewmsg.php?t=<?php print $t . '&d=' . $d . '&m=' . $resultsArray[$x - 1] . '">' . HtmlSpace($subject); ?></a>&nbsp;</span></td>
        <td width="100" height="30" bgcolor="#E2E2E2" align="center">
            <span class="boldBody">&nbsp;<?php print htmlspecialchars($msgInfo['attfilename']); ?>&nbsp;</span></td>
        <td width="60" height="30" align="center">
            <span class="body">&nbsp;<?php print $filesize; ?>&nbsp;</span></td>
        <td width="175" height="30" bgcolor="#E2E2E2" align="center">
            <span class="body">&nbsp;<?php print $dateTime['date']; ?></span><span class="msgTime">&nbsp;<?php print $dateTime['time']; ?></span><br /><span class="body">by </span><span class="boldBody"><?php print HtmlSpace($from); ?>&nbsp;</span></td>
    </tr>
<?php
    }
?>
    <tr>
        <td class="msgHeader" bgcolor="#416DBF" align="left" colspan="5" height="25" width="750">&nbsp;</td>
    </tr>
</table>
<?php
    // Setup the previous/next links.
?>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
<?php
    if ($m > 25) {
        $num = $m - 25;
        $cnt = 25;
        if ($num < 25) {
            $cnt = $num;
        }
        print '<a class="msgBack" href="search.php?t=' . $t . '&d=' . $d . '">Previous ' . $cnt . '</a> |' . "\n";
    }

    if ($m < $msgno) {
        $num = $m + 25;
        if ($num > $msgno) {
            $num = $msgno;
        }
        $cnt = 25;
        if (($msgno - $m) < 25) {
            $cnt = ($msgno - $m);
        }
        print '<a class="msgBack" href="search.php?t=' . $t . '&d=' . $d . '">Next ' . $cnt . '</a> |' . "\n";
    }
    print '<a class="msgBack" href="Search.php?t=' . $t . '&d=' . $d . '">Back to Search</a>' . "\n";
    print '&nbsp;<a class="msgBack" title="Back to ' . HtmlSpace($dbDesc) . '" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '">&lt;--</a>' . "\n";
?>
        </td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>

<?php
} else if ($db['dbtype'] == 'E') {
    print 'Not implemented.';
} else {
    // --- MESSAGE LAYOUT ------------------------------------------------------
    $topic = GetTopicInfo($t, 'M');             // Retrieve the topic information.

    if (trim($topic['desc']) != '') {
        $topicDesc = htmlspecialchars($topic['desc']);
    } else {
        $topicDesc = '(No Topic Description)';
    }

    if (trim($db['desc']) != '') {
        $dbDesc = htmlspecialchars($db['desc']);
    } else {
        $dbDesc = '(No Description)';
    }

    if (strlen($dbDesc) >= 31) {
        $dbDesc = $dbDesc . '...';
    }

    $msgno = count($resultsArray);              // Retrieve the number of messages.

    if (isset($_REQUEST['m'])) {                // Set the passed variables.
        $m = (integer) $_REQUEST['m'];
    } else {
        $m = $msgno;
    }
    if ($m > $msgno) {
        $m = $msgno;
    }
    if ($m <= 0) {
        $m = 1;
    }
?>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
<?php
    if ($m > 25) {
        $num = $m - 25;
        $cnt = 25;
        if ($num < 25) {
            $cnt = $num;
        }
        print '<a class="msgBack" href="search.php?t=' . $t . '&d=' . $d . '&m=' . $num . '&search=' . $search . '&results=1">Previous ' . $cnt . '</a> |' . "\n";
    }

    if ($m < $msgno) {
        $num = $m + 25;
        if ($num > $msgno) {
            $num = $msgno;
        }
        $cnt = 25;
        if (($msgno - $m) < 25) {
            $cnt = ($msgno - $m);
        }
        print '<a class="msgBack" href="search.php?t=' . $t . '&d=' . $d . '&m=' . $num . '&search=' . $search . '&results=1">Next ' . $cnt . '</a> |' . "\n";
    }
    print '<a class="msgBack" href="search.php?t=' . $t . '&d=' . $d . '">Back to Search</a>' . "\n";
    print '&nbsp;<a class="msgBack" title="Back to ' . HtmlSpace($dbDesc) . '" href="forum-dispmsg.php?t=' . $t . '&d=' . $d . '">&lt;--</a>' . "\n";
?>
        </td>
        <td align="right">
            <span class="msgBack"><a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></span></td>
    </tr>
</table>
<table border="1" width="750" cellspacing="0" cellpadding="2" bordercolor="#666666" style="border-collapse: collapse">
    <tr>
        <td colspan="5" bgcolor="#416DBF" height="33" width="750">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td align="left" width="100%">
                        <span class="msgTitle">&nbsp;&nbsp;<?php print HtmlSpace($dbDesc) . '&nbsp;&nbsp;-&nbsp;&nbsp;[' . $msgno . ']'; ?></span></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td class="msgHeader" width="30" height="15" bgcolor="#000080"></td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="left">&nbsp;From&nbsp;</td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="left">&nbsp;To&nbsp;</td>
        <td class="msgHeader" width="370" height="15" bgcolor="#000080" align="left">&nbsp;Subject&nbsp;</td>
        <td class="msgHeader" width="150" height="15" bgcolor="#000080" align="center">&nbsp;Date/Time&nbsp;</td>
    </tr>
<?php
    // Set the fileString variable.
    $file = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
    if (!is_file($file)) {
        die('<br /><h4>Requested database is missing. Please press the BACK button on your browser.</h4>');
    }
    $fileString = ReadCfgFile($file);    // Read the file.

    // Run the loop that will display the messages.
    for ($x = $m; $x >= ($m - 24); $x--) {
        if ($msgno == 0) {
            print '<tr><td colspan="5"><p align="left"><br /><span class="heading">There are no messages in this database.</span><br /><br /></p></td></tr>' . "\n";
            break;
        }

        if ($x <= 0) {
            break;
        }
        $msgInfo = GetMessageInfo($db, $resultsArray[$x - 1], $fileString); // Get the message information.
        $dateTime = ConvertDateTime($msgInfo['creation']);

        $from = $msgInfo['fromhandle'];
        $pos = strpos($from, '@');                          // Check for email address.
        if (is_int($pos)) {
            $from = substr($from, 0, $pos);
        }
        $char = substr($from, 0, 1);
        if ($char == '<') {
            $from = substr($from, 1);
        }
        if ($char == '"') {
            $pos = strpos($from, '"', 1);
            $from = substr($from, 1, $pos - 1);
        }
        $from = trim(htmlspecialchars($from));

        $to = $msgInfo['tohandle'];
        $pos = strpos($to, '@');                            // Check for email address.
        if (is_int($pos)) {
            $to = substr($to, 0, $pos);
        }
        $char = substr($to, 0, 1);
        if ($char == '<') {
            $to = substr($to, 1);
        }
        if ($char == '"') {
            $pos = strpos($to, '"', 1);
            $to = substr($to, 1, $pos - 1);
        }
        $to = trim(htmlspecialchars($to));

        if ($msgInfo['subject'] == '') {
            $subject = '(No Subject)';
        } else {
            $subject = htmlspecialchars(StripANSICodes(StripBBSCodes($msgInfo['subject'])));
        }

        $pos = strpos($to, '@');
        if (is_int($pos)) {
            $to = substr($to, 0, $pos);
        }
?>
    <tr>
        <td width="30" height="30" bgcolor="#E2E2E2" align="center">
            <img border="0" <?php
                            if ($msgInfo['deleted'] == 1) {
                                print 'src="' . $rootDir . 'images/message-deleted.gif" alt="Message Marked for Deletion"';
                            } else {
                                print 'src="' . $rootDir . 'images/message.gif" alt="Message"';
                            }
                            ?> width="11" height="11"><?php
                                                      if ($msgInfo['attfilename'] != '') {
                                                          print '<img border="0" src="' . $rootDir . 'images/paperclip.gif" alt="Attached File" width="11" height="11">';
                                                      }
                                                      ?></span></td>
        <td width="100" height="30" align="left">
            <span class="boldBody">&nbsp;<?php print HtmlSpace($from); ?>&nbsp;</span></td>
        <td width="100" height="30" bgcolor="#E2E2E2" align="left">
            <span class="body">&nbsp;<?php print HtmlSpace($to); ?>&nbsp;</span></td>
        <td width="370" height="30" align="left">
            <span class="heading">&nbsp;<?php if (($msgInfo['deleted'] != 1) ||
                                                  ($USER['securitylevel'] >= 255) ||
                                                  (($db['moderator'] == $USER['userno']) &&
                                                   ($db['moderator'] > 0))) {
                                                  print '<a href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $resultsArray[$x - 1] . '">' . HtmlSpace($subject) . '</a>';
                                              } else {
                                                  print $subject;
                                              } ?>&nbsp;</span></td>
        <td width="150" height="30" bgcolor="#E2E2E2" align="center">
            <span class="body">&nbsp;<?php print $dateTime['date']; ?></span><span class="msgTime">&nbsp;<?php print $dateTime['time']; ?>&nbsp;</span></td>
    </tr>
<?php
    }
?>
    <tr>
        <td class="msgHeader" bgcolor="#416DBF" align="left" colspan="5" height="25" width="750">&nbsp;</td>
    </tr>
</table>
<?php
    // Setup the previous/next links.
?>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
<?php
    if ($m > 25) {
        $num = $m - 25;
        $cnt = 25;
        if ($num < 25) {
            $cnt = $num;
        }
        print '<a class="msgBack" href="search.php?t=' . $t . '&d=' . $d . '&m=' . $num . '&search=' . $search . '&results=1">Previous ' . $cnt . '</a> |' . "\n";
    }

    if ($m < $msgno) {
        $num = $m + 25;
        if ($num > $msgno) {
            $num = $msgno;
        }
        $cnt = 25;
        if (($msgno - $m) < 25) {
            $cnt = ($msgno - $m);
        }
        print '<a class="msgBack" href="search.php?t=' . $t . '&d=' . $d . '&m=' . $num . '&search=' . $search . '&results=1">Next ' . $cnt . '</a> |' . "\n";
    }
    print '<a class="msgBack" href="Search.php?t=' . $t . '&d=' . $d . '">Back to Search</a>' . "\n";
    print '&nbsp;<a class="msgBack" title="Back to ' . HtmlSpace($dbDesc) . '" href="forum-dispmsg.php?t=' . $t . '&d=' . $d . '">&lt;--</a>' . "\n";
?>
        </td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<?php
}

SearchFooter();
?>