<?php
/*
 * ----------------------------------------------------------------------------
 * Layout_Email.inc.php                                              10/14/2006
 * This script contains the headers and footers used with the email script.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include the main BBS configuration.
require_once($includeDir . 'va-networks.inc.php');  // Include network information.


/**
* Layout_Email.inc.php :: EmailHeader()
*
* This is the header part of the webpage.
*
*/
function EmailHeader() {
    global $CONFIG;                         // Include the global variable.
    global $VA_MAIN;                        // Include the global variable.
    global $USER;                           // Include current user information.
    global $rootDir;
    global $includeDir;

    require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[E-Mail Area] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    a:active            { color: #FF0000 }
    a:link              { color: #0000D0 }
    a:visited           { color: #0000D0 }
    a:hover             { color: #FF0000 }
    a.msgBack:link      { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited   { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgHeader:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.msgHeader:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    .body               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #000000; }
    .boldBody           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #000000; font-weight: bold }
    .filename           { font-family: Courier New;               font-size: 10pt; color: #000080; font-weight: bold }
    .filesize           { font-family: Courier New;               font-size: 10pt; color: #000080; }
    .heading            { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #000000; font-weight: bold }
    .heading2           { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #000000; }
    .md5                { font-family: Courier New;               font-size: 10pt;  color: #808080; }
    .msgBack            { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .msgBody            { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #000000; }
    .msgHeader          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    .msgTime            { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #666666; }
    .msgTitle           { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight: bold }
    .title              { font-family: Verdana, Arial, Helvetica; font-size: 12pt; color: #000000; font-weight: bold }
-->
</style>
</head>

<body bgcolor="#FFFFFF">

<div align="center">
<center>
<table cellspacing="0" cellpadding="0" width="750" border="0" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td align="left">
            <span class="title"><a href="http://www.vadvphp.com"><img border="0" src="<?php print $rootDir; ?>images/vadv-php.gif" alt="VADV-PHP" width="50" height="30" align="absbottom"></a>&nbsp;&nbsp;&nbsp;<?php print HtmlSpace($VA_MAIN['bbsname']); ?> Email Area</span>
            <hr color="#525552">
            <p><span class="heading">Email Area - </span>
            <span class="body">Read your BBS email from the comfort of your web browser! You may read, post, reply and delete your email.</span></p>

<?php
    if (($USER['userno'] > 0) && ($USER['userno'] != $CONFIG['guestacct'])) {
?>
            <p class="body"><span class="boldBody">You are logged in as: <?php print HtmlSpace($USER['handle']); ?></span> (#<?php print $USER['userno']; ?>)
<?php
        // If mail is forwarded, display a message.
        if ($USER['mailfwdflag'] == 0) {
            print "</p>";
        } else {
            $networks = GetNetworkInfo();
            if (isset($networks[$USER['mailfwdnetno']])) {
                if (($USER['mailfwdnetno'] == 1) && ($USER['mailfwdnode'] == $networks[1]['settings']['systemid'])) {
                    $forward = $USER['mailfwdhandle'] . ' </span>(#' . $USER['mailfwduserno'] . ') LOCAL';
                } else {
                    if ($USER['mailfwdhandle'] == '') {
                        $fwdto = $USER['mailfwduserno'];
                    } else {
                        $fwdto = $USER['mailfwdhandle'];
                    }
                    $forward = $fwdto . ' </span>@' . $USER['mailfwdnode'] . ' ' . $networks[$USER['mailfwdnetno']]['desc'];
                }
                print '<br /><span class="boldBody">Your mail is being forwarded to: ' . $forward . '</p>';
            }
        }
    } else {
?>
            <p><span class="boldBody">You are not logged in. Login <a href="<?php print $rootDir; ?>bbslogin.php?url=<?php print urlencode(GetCurrentURL()); ?>">here</a> for full access priviledges.</span></p>
<?php
    }
}


/**
* Layout_Email.inc.php :: EmailFooter()
*
* This is the footer part of the webpage.
*
*/
function EmailFooter() {
    global $CONFIG;                      // Include the global variable.
?>
        </td>
    </tr>
</table>
</center>
</div>
<table cellspacing="0" cellpadding="0" width="100%" border="0">
    <tr>
        <td align="center">
            <span style="font-family: Verdana, Arial, Helvetica; font-size: 10px; color: #000000">* No date/time conversion performed.</span>
        </td>
    </tr>
</table>

<?php GlobalFooter(0, 1); ?>

</body>

</html>

<?php
}
?>