<?php
/*
 * ----------------------------------------------------------------------------
 * Forum-DispTopics.php                                              08/02/2006
 * This script will display the message forum topics to the user based on the
 * user's security level, access flags and age.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

session_cache_limiter('nocache');                   // Useful if a user hits the back button.

$VA_ACTION = 'Reading Messages';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once('layout_forum.inc.php');               // Webpage header and footer.

// If the newmessagescan parameter is passed, update the user's settings.
if (isset($_GET['newmessagescan'])) {
    if ($_GET['newmessagescan'] == 0) {
        $USER_SETTINGS['newmessagescan'] = 0;
    } else {
        $USER_SETTINGS['newmessagescan'] = 1;
    }
    session_cache_limiter('nocache');
    $fileString = ReadUserSettings();
    $fileString = PutUserSettings($fileString, $userno, $USER_SETTINGS);
    WriteUserSettings($fileString);         // Update the user's settings.
    RedirectUser(GetCurrentUrl(0));         // Reload the page.
}

if (isset($_POST['msgupd'])) {              // Set the passed variables.
    $msgupd = (integer) $_POST['msgupd'];
} else {
    $msgupd = 0;
}

ForumHeader();                              // Display the webpage header.
?>

<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<table border="1" width="750" cellspacing="0" cellpadding="2" bordercolor="#666666" style="border-collapse: collapse">
    <tr>
        <td colspan="3" bgcolor="#416DBF" height="33" width="750">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td align="left" width="100%">
                        <span class="msgTitle">&nbsp;&nbsp;Forum Topics</span></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td class="msgHeader" width="30" height="15" bgcolor="#000080"></td>
        <td class="msgHeader" width="620" height="15" bgcolor="#000080" align="left">&nbsp;Topic&nbsp;</td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="center">&nbsp;Forums&nbsp;</td>
    </tr>

<?php
$topics = GetTopics('M');                   // Get the topic numbers.

// Set the file string variable.
$file = $VA_SYSPATHS['main'] . '/DBGROUP.CFG';
if (!is_file($file)) {
    die('<br /><h4>Requested configuration file is missing. Please press the BACK button on your browser.</h4>');
}
$dbFile = $VA_SYSPATHS['main'] . '/DATABASE.CFG';
if (!is_file($dbFile)) {
    die('<br /><h4>Requested configuration file is missing. Please press the BACK button on your browser.</h4>');
}
$fileString = ReadCfgFile($file);           // Read the file.
$dbFileString = ReadCfgFile($dbFile);       // Read the file.

if ($topics[0] == 0) {
    print '<tr><td colspan="5"><p align="left"><br /><span class="heading">There are no available topics.</span><br /><br /></p></td></tr>' . "\n";
} else {
    for ($x = 1; $x <= $topics[0]; $x++) {
        $topic = GetTopicInfo($topics[$x], 'M', $fileString);   // Retrieve the topic information.
        if (($topic) && ($topic['dbno'] != 0)) {
            if (trim($topic['desc']) != '') {
                $topicDesc = htmlspecialchars($topic['desc']);
            } else {
                $topicDesc = '(No Topic Description)';
            }

            // Get database information and check for new messages.
            $flag = 1;
            $newMessage = 0;
            if (($USER['userno'] > 0) &&
                ($USER['userno'] != $CONFIG['guestacct']) &&
                ($USER_SETTINGS['newmessagescan'] == 0)) {
                for ($y = 1; $flag <= $topic['dbno']; $y++) {
                    $flag++;
                    $db = GetDbInfo($topics[$x], $y, $dbFileString);
                    if (DbAccess($db)) {        // If the user has access...
                        $pntFile = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.QSC';
                        $pntFileString = ReadCfgFile($pntFile);
                        $pnt = GetMessagePointer($db, $USER['userno'], $pntFileString);
                        if ($pnt < $db['msgno']) {
                            if ($msgupd == 0) {     // Check message update.
                                $newMessage = 1;    // New messages detected, update pointer.
                                break;
                            } else {
                                WriteMessagePointer($db, $USER['userno'], $db['msgno'], $pntFileString);
                            }
                        }
                    }
                }
            }
?>

    <tr>
        <td width="30" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <img border="0" <?php
                            if ($newMessage == 1) {
                                print 'src="' . $rootDir . 'images/folder-new.gif" alt="Topic Folder (New Messages!)"';
                            } else {
                                print 'src="' . $rootDir . 'images/folder.gif" alt="Topic Folder"';
                            }
                            ?> width="13" height="11"></td>
        <td width="620" height="30" align="left">
            <span class="heading">&nbsp;<a href="forum-dispdb.php?t=<?php print $topics[$x] . '">' . HtmlSpace($topicDesc); ?></a>&nbsp;</span></td>
        <td width="100" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <span class="msgBody">&nbsp;<?php print $topic['dbno']; ?>&nbsp;</span></td>
    </tr>

<?php
        }
    }
}
?>

    <form name="msgupd" method="post" action="forum-disptopics.php">
        <input type="hidden" name="msgupd" value="1">
        <tr>
            <td class="msgHeader" bgcolor="#416DBF" align="left" colspan="3" height="25" width="750">&nbsp;
                <?php
                if (($USER['userno'] > 0) && ($USER['userno'] != $CONFIG['guestacct'])) {
                    if ($USER_SETTINGS['newmessagescan'] == 0) {
                        print '<a class="msgHeader" href="javascript: document.msgupd.submit()">Update ALL Message Pointers</a> | ' . "\n";
                        print '<a class="msgHeader" href="forum-disptopics.php?newmessagescan=1">Turn Off New Message Scan</a>' . "\n";
                    } else {
                        print '<a class="msgHeader" href="forum-disptopics.php?newmessagescan=0">Turn On New Message Scan</a>' . "\n";
                    }
                }
                ?>
            </td>
        </tr>
    </form>
</table>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>

<?php

ForumFooter();                              // Display the webpage footer.

?>