<?php
/*
 * ----------------------------------------------------------------------------
 * Email-DispMsg.php                                                 05/09/2006
 * This script will display all of the user's email messages.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Reading Email';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-main.inc.php');      // Include the main configuration variable.
require_once($includeDir . 'vadv-php_dat.inc.php'); // Include user settings.
require_once('layout_email.inc.php');               // Webpage header and footer.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    die(VA_LoginError());
}
$userno = $USER['userno'];

// If the hidedeleted parameter is passed, update the user's settings.
if (isset($_GET['hidedeleted'])) {
    if ($_GET['hidedeleted'] == 0) {
        $USER_SETTINGS['hidedeleted'] = 0;
    } else {
        $USER_SETTINGS['hidedeleted'] = 1;
    }
    session_cache_limiter('nocache');
    $fileString = ReadUserSettings();
    $fileString = PutUserSettings($fileString, $userno, $USER_SETTINGS);
    WriteUserSettings($fileString);         // Update the user's settings.
    RedirectUser(GetCurrentUrl(0));         // Reload the page.
}

$db = SetEmailInfo($userno);                // Setup the email database information.
// Determine if the user has access to this section.
if (!DbAccess($db)) {
    die('<br /><h4>You do not have access to this section. Please press the BACK button on your browser.</h4>');
}

$msgno   = $db['msgno'];                    // Retrieve the number of messages.

// Determine if there is posted data to process.
if ((isset($_POST['emailform'])) && (($_POST['emailform'] == 1))) {
    if (isset($_POST['markedmail'])) {
        $marked = $_POST['markedmail'];
    } else {
        $marked = array('');
    }
    $db = SetEmailInfo($USER['userno']);        // Retrieve the database information.

    for ($x = 0; $x < count($marked); $x++) {
        $msg     = $marked[$x];
        $msgInfo = GetMessageInfo($db, $msg);   // Get the message information.

        if ($msgInfo['touserno'] == $userno) {
            //if ($msgInfo['deleted'] == 0) {
                // If an attached file, then delete it. Non-reversible!
                if ($msgInfo['attfilename'] != '') {
                    if ($CONFIG['hostname'] != '') {
                        $file = ConvertDir($CONFIG['hostname'], $db['filepath']) . '/' . $msgInfo['attfilename'];
                    } else {
                        $file = $db['filepath'] . '/' . $msgInfo['attfilename'];
                    }

                    if ($msgInfo['attfilepath'] == '') {
                        if (is_file($file)) {
                            unlink($file);
                        }
                    } else {
                        if ($CONFIG['hostname'] != '') {
                            $userDir = ConvertUnc($VA_SYSPATHS['sysop'] . '/' . $USER['userno'] . '/' . $msgInfo['attfilename']);
                        } else {
                            $userDir = $VA_SYSPATHS['sysop'] . '/' . $USER['userno'] . '/' . $msgInfo['attfilename'];
                        }
                        if ($msgInfo['attfilepath'] == $userDir) {
                            if ($CONFIG['hostname'] != '') {
                                $file = ConvertDir($CONFIG['hostname'], $msgInfo['attfilepath']);
                            } else {
                                $file = $msgInfo['attfilepath'];
                            }
                        }
                        if (is_file($file)) {
                            unlink($file);
                        }
                    }
                    $msgInfo['attfilesize'] = 0;
                    $msgInfo['attfilename'] = '';
                    $msgInfo['attfilepath'] = '';
                }

                // Mark the message as read, and send a oneliner to the sender.
                if ($msgInfo['offline'] == 0) {
                    $msgInfo['offline'] = 1;

                    if ($msgInfo['subject'] == '') {
                        $subject = '(No Subject)';
                    } else {
                        $subject = htmlspecialchars(StripANSICodes(StripBBSCodes($msgInfo['subject'])));
                    }

                    if ($msgInfo['fromnetid'] == 1) {
                        $oneline = $USER['handle'] . ' #' . $USER['userno'] . ' Read Email: ' . $subject;
                        WriteOneliner($msgInfo['fromuserno'], $oneline);
                    }
                }

                // Mark the message as deleted and save the new information.
                $msgInfo['deleted'] = 1;
                WriteMessageInfo($db, $msg, $msgInfo);
            //} else {
            //    $msgInfo['deleted'] = 0;
            //    WriteMessageInfo($db, $msg, $msgInfo);
            //}
        }
    }
}

if ($USER_SETTINGS['hidedeleted'] == 1) {
    $msgstat = GetEmailCount($userno, 0);   // Retrieve the number of user messages.
} else {
    $msgstat = GetEmailCount($userno);
}
$msgcnt     = $msgstat['msgno'];
$msgtotal   = $msgstat['msgtotal'];
$nondeleted = $msgstat['msgtotal'] - $msgstat['deleted'];
$unread     = $msgstat['unread'];
$deleted    = $msgstat['deleted'];

if ($USER_SETTINGS['hidedeleted'] == 1) {
    $msgtotal = $nondeleted;
} else {
    $msgtotal = $msgcnt;
}

if (isset($_GET['m'])) {                    // Set the passed variables.
    $m = (integer) $_GET['m'];
} else {
    $m = $msgcnt;
}
if ($m > $msgcnt) {
    $m = $msgcnt;
}
if ($m <= 0) {
    $m = 1;
}

EmailHeader();                              // Display the webpage header.
?>

<script language="JavaScript" type="text/javascript">
<!--
    var status = "false";
    function CheckBox(name) {
        if (status == "false") {
            for (i = 0; i < document.email.elements.length; i++) {
                if (document.email.elements[i].name == name) {
                    document.email.elements[i].checked = true;
                    status = "true";
                }
            }
        } else {
            for (i = 0; i < document.email.elements.length; i++) {
                if (document.email.elements[i].name == name) {
                    document.email.elements[i].checked = false;
                    status = "false";
                }
            }
        }
    }
//-->
</script>


<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">

<?php
    if ($m > 25) {
        $num = $m - 25;
        $cnt = 25;
        if ($num < 25) {
            $cnt = $num;
        }
        print '<a class="msgBack" href="email-dispmsg.php?m=' . $num . '">Previous ' . $cnt . '</a> |' . "\n";
    }

    if ($m < $msgcnt) {
        $num = $m + 25;
        if ($num > $msgcnt) {
            $num = $msgcnt;
        }
        $cnt = 25;
        if (($msgcnt - $m) < 25) {
            $cnt = ($msgcnt - $m);
        }
        print '<a class="msgBack" href="email-dispmsg.php?m=' . $num . '">Next ' . $cnt . '</a> |' . "\n";
    }
?>

            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<table border="1" width="750" cellspacing="0" cellpadding="2" bordercolor="#666666" style="border-collapse: collapse">
    <tr>
        <td colspan="5" bgcolor="#416DBF" height="33">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td align="left" width="100%">
                        <span class="msgTitle">&nbsp;&nbsp;<?php print htmlspecialchars($db['desc']) . '&nbsp&nbsp-&nbsp&nbsp[' . $unread . ' / ' . $nondeleted . '] (' . $deleted . ')'; ?></span></td>
                    <?php if (($USER['userno'] > 0) && ($USER['userno'] != $CONFIG['guestacct']) && ($USER['securitylevel'] >= $VA_MAIN['emlothers'])) { ?>
                    <form action="post-email.php" name="post" method="POST">
                        <td align="right">
                            <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                            <input type="hidden" name="reply" value="0">
                            <input type="image" name="submit" src="<?php print $rootDir; ?>images/email.gif" border="0" alt="Send a New Email" width="90" height="25">
                        </td>
                    </form>
                    <?php } ?>
                </tr>
            </table>
        </td>
    </tr>
    <form name="email" method="post" action="email-dispmsg.php">
        <input type="hidden" name="referer" value="<?php print GetCurrentURL(0); ?>">
        <input type="hidden" name="emailform" value="1">
    <tr>
        <td class="msgHeader" width="30" height="15" bgcolor="#000080" align="center"><?php
                                                                                      if ((($USER_SETTINGS['hidedeleted'] == 1) && ($nondeleted > 0)) ||
                                                                                          (($USER_SETTINGS['hidedeleted'] == 0) && ($msgcnt > 0))) {
                                                                                          print '<input name="allbox" type="checkbox" onclick="CheckBox(\'markedmail[]\');" title="Select or De-select All Messages">';
                                                                                      }
                                                                                      ?></td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="left">&nbsp;From&nbsp;</td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="left">&nbsp;To&nbsp;</td>
        <td class="msgHeader" width="370" height="15" bgcolor="#000080" align="left">&nbsp;Subject&nbsp;</td>
        <td class="msgHeader" width="150" height="15" bgcolor="#000080" align="center">&nbsp;Date/Time&nbsp;</td>
    </tr>

<?php
// Set the fileString variable.
$file = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
if (!is_file($file)) {
    die('<br /><h4>Requested database is missing. Please press the BACK button on your browser.</h4>');
}
$fileString = ReadCfgFile($file);           // Read the file.

// Run the loop that will display the messages.
$forCnt = $msgtotal;
for ($x = $m; $forCnt >= ($msgtotal - 24); $x--) {
    if (($msgcnt == 0) || (($USER_SETTINGS['hidedeleted'] == 1) && ($nondeleted == 0))) {
        print '<tr><td colspan="5"><p align="left"><br /><span class="heading">You have no messages.</span><br /><br /></p></td></tr>' . "\n";
        break;
    }

    if ($x <= 0) {
        break;
    }
    $msgInfo = GetMessageInfo($db, $msgstat[$x - 1], $fileString);   // Get the message information.
    $dateTime = ConvertDateTime($msgInfo['creation'], 'F j, Y');

    if ($msgInfo['touserno'] == $userno) {  // If to the current user...
        if (($USER_SETTINGS['hidedeleted'] == 0) || ($msgInfo['deleted'] == 0)) {
            $forCnt--;
            $from = $msgInfo['fromhandle'];
            $char = substr($from, 0, 1);
            if ($char == '<') {
                $from = substr($from, 1);
            }
            if ($char == '"') {
                $pos = strpos($from, '"', 1);
                $from = substr($from, 1, $pos - 1);
            }
            $from = trim(htmlspecialchars($from));

            if ($msgInfo['subject'] == '') {
                $subject = '(No Subject)';
            } else {
                $subject = htmlspecialchars(StripANSICodes(StripBBSCodes($msgInfo['subject'])));
            }

            $to = $msgInfo['tohandle'];
            $char = substr($to, 0, 1);
            if ($char == '<') {
                $to = substr($to, 1);
            }
            if ($char == '"') {
                $pos = strpos($to, '"', 1);
                $to = substr($to, 1, $pos - 1);
            }
            $to = trim(htmlspecialchars($to));
?>

    <tr>
        <td width="35" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <input type="checkbox" name="markedmail[]" value="<?php print $msgstat[$x - 1]; ?>"><img border="0" <?php
                                                                                                                if ($msgInfo['deleted'] == 1) {
                                                                                                                    print 'src="' . $rootDir . 'images/message-deleted.gif" alt="Message Marked for Deletion"';
                                                                                                                } else if ($msgInfo['offline'] == 0) {
                                                                                                                    print 'src="' . $rootDir . 'images/message-new.gif" alt="New Message"';
                                                                                                                } else {
                                                                                                                    print 'src="' . $rootDir . 'images/message.gif" alt="Message"';
                                                                                                                }
                                                                                                                ?> width="11" height="11"><?php
                                                                                                                                          if ($msgInfo['attfilename'] != '') {
                                                                                                                                              print '<img border="0" src="' . $rootDir . 'images/paperclip.gif" alt="Attached File" width="11" height="11">';
                                                                                                                                          }
                                                                                                                                          ?></span></td>
        <td width="100" height="30" align="left" nowrap>
            <span class="boldBody">&nbsp;<?php print HtmlSpace($from); ?>&nbsp;</span></td>
        <td width="100" height="30" bgcolor="#E2E2E2" align="left" nowrap>
            <span class="body">&nbsp;<?php print HtmlSpace($to); ?>&nbsp;</span></td>
        <td width="370" height="30" align="left">
            <?php
            if ($msgInfo['offline'] == 1) {
                print '<span class="heading2">';
            } else {
                print '<span class="heading">';
            }
            ?>&nbsp;<a href="email-viewmsg.php?m=<?php print $x . '">' . $subject; ?></a></span></td>
        <td width="150" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <span class="body">&nbsp;<?php print $dateTime['date']; ?></span><span class="msgTime"><br />&nbsp;<?php print $dateTime['time']; ?><?php
                                                                                                                                                if (!$dateTime['tz']) {
                                                                                                                                                    print '*';
                                                                                                                                                }
                                                                                                                                                ?>&nbsp;</span></td>
    </tr>

<?php
        }
    }
}
?>

    </form>
    <tr>
        <td class="msgHeader" bgcolor="#416DBF" align="left" colspan="5" height="25" width="750">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td class="msgHeader" align="left">&nbsp;
                    <?php
                    if ($msgstat['msgtotal'] > 0) {
                        print '<a class="msgHeader" href="javascript: document.email.submit()">Delete Selected Messages</a> | ';
                        if ($USER_SETTINGS['hidedeleted'] == 0) {
                            print '<a class="msgHeader" href="email-dispmsg.php?hidedeleted=1">Hide Deleted Messages</a>';
                        } else {
                            print '<a class="msgheader" href="email-dispmsg.php?hidedeleted=0">Show Deleted Messages</a>';
                        }
                    }
                    ?>
                    </td>
                    <td class="msgHeader" align="right">
                        <a class="msgHeader" href="sentemail-dispmsg.php">View Sent Email</a>&nbsp;
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">

<?php
if ($m > 25) {
    $num = $m - 25;
    $cnt = 25;
    if ($num < 25) {
        $cnt = $num;
    }
    print '<a class="msgBack" href="email-dispmsg.php?m=' . $num . '">Previous ' . $cnt . '</a> |' . "\n";
}

if ($m < $msgcnt) {
    $num = $m + 25;
    if ($num > $msgcnt) {
        $num = $msgcnt;
    }
    $cnt = 25;
    if (($msgcnt - $m) < 25) {
        $cnt = ($msgcnt - $m);
    }
    print '<a class="msgBack" href="email-dispmsg.php?m=' . $num . '">Next ' . $cnt . '</a> |' . "\n";
}
?>

            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>

<?php

EmailFooter();                              // Display the webpage footer.

?>