<?php
/*
 * ----------------------------------------------------------------------------
 * Download.php                                                      12/04/2005
 * This script will allow a web user to download a specified file from a
 * database entry.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Downloading a File';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.
require_once($includeDir . 'va-userfile.inc.php');  // Include user information.
require_once($includeDir . 'va-networks.inc.php');  // Include network information.
require_once($includeDir . 'va-stats.inc.php');     // Include BBS statistics.

// Check the passed parameters. This script will look directly at the database
// to determine the filename instead of passing the filename and path directly.
if (isset($_POST['t'])) {                   // Set the passed variables.
    $t = htmlspecialchars($_POST['t']);
} else {
    die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
}

if (isset($_POST['d'])) {                   // Set the passed variables.
    $d = (integer) $_POST['d'];
} else {
    die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
}

if (isset($_POST['m'])) {                   // Set the passed variables.
    $m = (integer) $_POST['m'];
} else {
    die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
}

// Check to see if this page was referred by another page, and check to see where
// that page was at.
if ((!isset($_SERVER['HTTP_REFERER'])) ||
    (strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === FALSE)) {
    die('<br /><h4>You are not allowed to access this script from an outside source.<br />Press the BACK button on your browser.</h4>');
}

if ($t == 'email') {
    if (($USER['userno'] == 0) || ($USER['userno'] == $CONFIG['guestacct'])) {
        die ('<br /><h4>You do not have access to download this file. Press the BACK button on your browser.</h4>');
    }
    $db = SetEmailInfo($USER['userno']);
} else {
    $db = GetDbInfo($t, $d);                // Retrieve the database information.
}

$msgInfo = GetMessageInfo($db, $m);         // Retrieve the message information.

// Check and make sure that the user has access to the database or is the
// recepient of the email message.
if ($t == 'email') {
    if ($msgInfo['touserno'] != $USER['userno']) {
        die ('<br /><h4>You do not have access to download this file. Press the BACK button on your browser.</h4>');
    }
} else {
    if (($db['minreadsl'] > $USER['securitylevel']) && ($USER['securitylevel'] < 255)) {
        die ('<br /><h4>You do not have access to download this file. Press the BACK button on your browser.</h4>');
    }
}

if ($msgInfo['attfilename'] != '') {
    if ($msgInfo['attfilepath'] != '') {    // If a local attachment.
        $filepath = str_replace('/', "\\", $msgInfo['attfilepath']);
        $pos = strrpos($filepath, "\\");
        $filepath = substr($filepath, 0, $pos);
    } else {
        $filepath = $db['filepath'];
    }
    if ($filepath != '') {
        if ($CONFIG['filehost']) {
            $file = ConvertDir($CONFIG['filehost'], $filepath) . '/' . $msgInfo['attfilename'];
        } else {
            $file = $filepath . '/' . $msgInfo['attfilename'];
        }
    } else {
        $file = $VA_SYSPATHS['sysop'] . '/' . $msgInfo['attfilename'];
    }
} else {
    die('<br /><h4>File is missing. Press the BACK button on your browser.</h4>');
}

if (!is_file($file)) {
    die('<br /><h4>File is missing. Press the BACK button on your browser.</h4>');
}

if (($USER['userno'] > 0) &&
    ($USER['userno'] != $CONFIG['guestacct']) &&
    ($t != 'email')) {                      // Check to see if the user has enough credits.
    $credits = $USER['credits'] - (intval(filesize($file) / 1024) * $VA_MAIN['credperdlk']);
    if (($VA_MAIN['credperdlk'] > 0) &&
        ($credits < 0)) {
        die('<br /><h4>You do not have enough credits to download this file!<br />To gain more credits, try uploading new files or posting in the message area.<br />Press the BACK button on your browser.</h4>');
    } else {                                // Subtract from the user's credits.
        if (($USER['userno'] > 0) &&
            ($credits > 0)) {
            $USER['credits'] = $USER['credits'] - $credits;
            $fileString = ReadUserfile();
            $fileString = PutUser($fileString, $USER['userno'], $USER);
            WriteUserfile($fileString);
        }
    }
}

// Transfer the file.
$transfer = SendFile($file);

if (!$transfer) {
    die('<br /><h4>An error occurred during the transfer. Press the BACK button on your browser.</h4>');
} else {
    // If it transferred, then update the database information.
    if (($USER['userno'] > 0) &&
        ($USER['userno'] != $CONFIG['guestacct']) &&
        ($t != 'email')) {
        // Update user information.
        $USER['dlfiles']++;
        $USER['dlkb'] = $USER['dlkb'] + intval($msgInfo['attfilesize'] / 1024);
        $fileString = ReadUserfile();
        $fileString = PutUser($fileString, $USER['userno'], $USER);
        WriteUserfile($fileString);
    }

    // Update file information.
    $msgInfo['downloadno']++;
    WriteMessageInfo($db, $m, $msgInfo);

    // Update BBS statistics.
    $fileString = ReadStats();
    $stats = GetStats($fileString);
    $stats['downloadstotal']++;
    $stats['downloadstoday']++;
    $fileString = PutStats($fileString, $stats);
    WriteStats($fileString);

    // Log the download.
    $log = 'File Download   "' . $USER['handle'] . '" <-- ' . $file;
    WriteLog('VADV-PHP.LOG', $log);

    // Send a oneliner to the uploader.
    // Steve Winn #1 @1931000 Downloaded ADEX11VA.ZIP
    $vnet = GetVnetInfo();
    $oneliner = $USER['handle'] . ' #' . $USER['userno'] . ' @' . $vnet['systemid'] . ' Downloaded ' . $msgInfo['attfilename'];
    WriteOneliner($msgInfo['fromuserno'], $oneliner);
}

?>