<?php
/*
 * ----------------------------------------------------------------------------
 * BBSRegister.php                                                   10/14/2006
 * This is a new user registration screen for the BBS's VADV-PHP page.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'New User Registration';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Main configuration.
require_once($includeDir . 'forms.inc.php');

if ($VA_MAIN['newuserpw'] != md5(strtoupper(''))) {
    die('<br /><h4>This BBS requires a new user password. Please connect to the BBS to create a new account. Press the BACK button on your browser.</h4>');
}
if (($USER['userno'] > 0) &&
    ($USER['userno'] != $CONFIG['guestacct']) &&
    ($USER['securitylevel'] > 0)) {
    die('<br /><h4>You already have an account and are logged in! Press the BACK button on your browser.</h4>');
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[New User Registration] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow">
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn">
<style type="text/css">
<!--
a.infoBarBody:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.infoBarBody:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.navBar:link         { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.navBar:visited      { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.notify:link         { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFF00; font-weight:bold }
a.notify:visited      { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFF00; font-weight:bold }
a.return:link         { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
a.return:visited      { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
.infoBarBody          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; }
.navBar               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
.newutext             { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #000000; }
.notify               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFF00; font-weight:bold }
.return               { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
.yellowTitle          { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight:bold; font-style:italic }
-->
</style>
</head>

<body bgcolor="#000000" onload="document.registration.username.focus();">

<div align="center">
    <center>
    <table border="1" width="640" cellspacing="0" cellpadding="5" bgcolor="#000080" bordercolor="#FFFFFF">
        <tr>
            <td align="center" valign="top">
                <p class="yellowTitle"><?php print HtmlSpace($VA_MAIN['bbsname']); ?>'s New User Registration</p>
                <table cellspacing="1" width="100%">
                    <tr>
                        <td align="center" valign="top">
                            <?php
                            if (isset($_GET['error'])) {
                                switch ($_GET['error']) {
                                    case 'username':
                                        $error = 'That username is not valid or is already being used. Please choose another.';
                                        break;
                                    case 'password':
                                        $error = 'Please verify your password again.';
                                        break;
                                    case 'realname':
                                        $error = 'You must enter your real name.';
                                        break;
                                    case 'address':
                                        $error = 'You must enter your address.';
                                        break;
                                    case 'city':
                                        $error = 'You must enter your city.';
                                        break;
                                    case 'state':
                                        $error = 'You must enter your state.';
                                        break;
                                    case 'zipcode':
                                        $error = 'You must enter your zip code.';
                                        break;
                                    case 'voice':
                                        $error = 'You must enter your phone number.';
                                        break;
                                    case 'data':
                                        $error = 'You must enter your fax/data number.';
                                        break;
                                    case 'bday':
                                        $error = 'You must enter your birthday.';
                                        break;
                                    case 'bdaydate':
                                        $error = 'The birthday date is invalid.';
                                        break;
                                }
                                print '<span class="infoBarBody">--' . $error . '--</span><br />';
                            }
                            ?>
                            <p><a class="return" href="index.php">Return to main BBS page.</a></p>
                            <?php
                            $file = $VA_SYSPATHS['text'] . '/NWEBUSER.TXT';
                            if (is_file($file)) {
                            ?>
                            <table cellpadding="4" cellspacing="0" border="1" bgcolor="#C0C0C0">
                                <tr>
                                    <td class="newutext" align="left">
                                        <?php
                                            $text = trim(ReadCfgFile($file));
                                            $text = StripANSICodes(StripBBSCodes($text));
                                            print '<PRE>' . $text . '</PRE>';
                                        ?>
                                    </td>
                                </tr>
                            </table>
                            <?php
                            }
                            ?>
                            <?php RegistrationBox(); ?>
                        </td>
                    </tr>
                </table>
                <p><span class="navBar">This page is powered
                by <a class="navBar" href="http://www.vadvphp.com">VADV-PHP</a></span></p>
                <p class="infoBarBody">If you experience any problems
                with this website or need help, contact the
                <a class="infoBarBody" href="mailto:<?php print $CONFIG['webmaster']; ?>">webmaster</a>.<br />
                VADV-PHP Copyright  2002-<?php print date('Y'); ?> Aspect
                Technologies. All Rights Reserved.</p>
            </td>
        </tr>
    </table>
    </center>
</div>

</body>

</html>