' DailyUpdate v1.0
' This program updates the daily maintenance date in main.cfg. This is needed if you are
' performing network processing and daily maintenance without the use of node 1.

'$INCLUDE: 'vadvcfg.bas'

DIM vadv AS cfgMain

CLS
PRINT
PRINT "DailyUpdate v1.0"
PRINT "(c) 2004 Aspect Technologies"
PRINT "----------------------------"
PRINT

' Get configuration.
OPEN "MAIN.CFG" FOR RANDOM ACCESS READ SHARED AS 1 LEN = LEN(vadv)
IF LOF(1) = 0 THEN
    PRINT "MAIN.CFG is missing."
    PRINT
    CLOSE 1
    KILL "MAIN.CFG"
    END
END IF

GET 1, 1, vadv
CLOSE 1

' Update the daily date to today.
today$ = RIGHT$(DATE$, 2) + LEFT$(DATE$, 2) + MID$(DATE$, 4, 2)
vadv.dailydate = today$

' Save configuration.
OPEN "MAIN.CFG" FOR RANDOM ACCESS WRITE SHARED AS 1 LEN = LEN(vadv)
PUT 1, 1, vadv
CLOSE 1

PRINT "DailyUpdate was successful!"
PRINT

END

