#!/usr/bin/perl

# Enthral SVN: $Id: onelinerz.pl 88 2010-11-14 05:05:40Z frank $
# Source: $HeadURL$
# $LastChangedDate: 2010-11-14 00:05:40 -0500 (Sun, 14 Nov 2010) $
# $LastChangedRevision: 88 $
# $LastChangedBy: frank $

# bbs-scene.org global onelinerz
# written by Frank Linhares aka Netsurge
# frank@bbs-scene.org
#
# Pass the user's alias on the commandline like this:
#
# ./onelinerz.pl "users_alias"
#

# Load config
my $config_file = "onelinerz.cfg";
open CONFIG, "$config_file"
  or die
  "Program stopping, couldn't open the configuration file '$config_file'.\n";
my $config = join "", <CONFIG>;
close CONFIG;
eval $config;
die
"Couldn't interpret the configuration file ($config_file) that was given.\nError details follow: $@\n"
  if $@;

# Check for LWP::UserAgent and XML::Simple modules
eval { use LWP::UserAgent; };
if ($@) {
    print "You need the LWP::UserAgent module installed.\r\n";
    exit;
}

eval { use XML::Simple; };
if ($@) {
    print "You need the HTML::Entities module installed.\r\n";
    exit;
}

# User input backspaces
system("stty erase ^H");

$oheader = $linerzpath . "/" . $header;
my $url = "http://bbs-scene.org/api/onelinerz.php?limit";
my $api = $url . "=" . $limit;

my $xmlresponse = &bbssceneApiGet( $username, $password, $api );

# Display Header
open( FILE, "< $oheader" ) or die "Can't open $header : $!";

while (<FILE>) {
    print;
}

close FILE;
print
"\e[30;1m-------------------------------------------------------------------------------\n";

# create xml object
$xml = new XML::Simple( KeyAttr => [] );

&stripIllegal($xml);

# read XML file
$data = $xml->XMLin("$xmlresponse") or die "Can't process onelinerz.xml : $!";

my $i = 0;

# access <node> array
foreach $e ( @{ $data->{node} } ) {

    $oneliner =
        " \e[30;1m(\e[37;1m"
      . $e->{alias}
      . "\e[34;1m/\e[36;1m"
      . $e->{bbsname}
      . "\e[30;1m) \e[30;0m"
      . $e->{oneliner};

    $oneliner = substr( $oneliner, 0, 121 );

    print $oneliner . "\n";

    # Increment the loop counter
    $i++;

    # Check if we've hit the limit
    if ( $i >= $limit ) {

        # Leave the loop
        last;
    }
}

# Print footer
print
"\e[30;1m-------------------------------------------------------------------------------\n";

# If matches no user
if ( grep /^$ARGV[$0]$/i, @twit ) {

    print "\e[30;0myou're not allowed to post a oneliner.\n";

    sleep 3;
    print "\e[2J";
    exit 0;

}
else {

    # Add a oneliner ?
    $addliner = &promptUser(
"\e[30;0madd a oneliner to bbs-scene.org \e[30;1m.\e[37;1my\e[30;1m/\e[37;1mn\e[30;1m. "
    );

    # Process answer
    if ( $addliner =~ m/y/ ) {
        $response = oneliner();
        &bbssceneApiPost( $username, $password, $bbsname, $ARGV[$0],
            $response );
        print "\e[2J";
    }
    else {
        print "\e[2J";
        exit 0;
    }
}

sub stripIllegal {
    my ($input) = @_;

    # allowed: [#x1-#xD7FF] | [#xE000-#xFFFD] | [#x10000-#x10FFFF]
    $input =~ s/[^\x01-\x{D7FF}\x{E000}-\x{FFFD}\x{10000}-\x{10FFFF}]//go;

    # restricted:[#x1-#x8][#xB-#xC][#xE-#x1F][#x7F-#x84][#x86-#x9F]
    $input =~ s/[\x01-\x08\x0B-\x0C\x0E-\x1F\x7F-\x84\x86-\x9F]//go;

    # Strip any backslashes and illegal characters from the user input
    $input =~ s/\\\\([^\\\\])/$1/g;
}

sub promptUser {
    my ( $prompt, $default ) = @_;
    my $defaultValue = $default ? "[$default]" : "";
    print "$prompt$defaultValue: ";
    chomp( my $input = <STDIN> );
    return $input ? $input : $default;
}

sub oneliner {

    # Prompt for oneliner
    $oneliner = &promptUser("");

    # If oneliner is empty clear screen then exit
    if ( $oneliner eq "" ) {
        print "\e[2J";
        exit 0;
    }

    &stripIllegal($oneliner);
    return $oneliner;
}

sub bbssceneApiGet {
    my ( $username, $password, $api ) = @_;
    my $entrybrowser = LWP::UserAgent->new;
    $entrybrowser->agent('bbssceneapi/1.01');
    $entrybrowser->timeout(2);
    $entrybrowser->credentials(
        'bbs-scene.org:80',
        'bbs-scene.org api',
        $username => $password
    );
    my $entry = $entrybrowser->get($api);
    $output = $entry->decoded_content;
    return $output;
}

sub bbssceneApiPost {
    my ( $username, $password, $bbsname, $alias, $oneliner ) = @_;
    my $postbrowser = new LWP::UserAgent;
    $postbrowser->agent('bbssceneapi/1.01');
    $postbrowser->timeout(2);
    $postbrowser->credentials(
        'bbs-scene.org:80',
        'bbs-scene.org api',
        $username => $password
    );
    my $post = $postbrowser->post(
        'http://bbs-scene.org/api/onelinerz.xml',
        {
            bbsname  => $bbsname,
            alias    => $alias,
            oneliner => $oneliner,
        }
    );
}
