Uses Cfg

Type
	NLRec	= Record
	Zone	: String
	Net	: String
	Node	: String
	Region	: String
	BBS	: String
	Loc	: String
	Sysop	: String
	Extra	: String
	URL	: String
End

Var NLFiles	: Array [1..20] Of String
Var Entry	: NLRec
Var NLI		: Byte
Var num		: String
Var NTyp	: String
Var NLPath	: String
Var NLFPtr	: File

Function ReadNodelist(search: String): String
Var N,E	: String = ''
Var I	: Integer=0
Var Done: Boolean=False
Var ShowIt	: Boolean=False
Begin
	fAssign(NLFPtr,NLPath,66)
	fReset(NLFPTR)
	If IOResult = 0 Then Begin
		WriteLn('|CL|11|16Search: '+search+'|CR------------------------------------------------------------------------------')
		Done:=False
		While Not fEof(NLFPtr) And Not Done Do Begin
			fRead(NLFPtr,Entry,SizeOf(Entry))
			N:=Entry.Zone+':'+Entry.Net+'/'+Entry.Node
			If Pos(search,N)  		  > 0 Then ShowIt:=True
			If Pos(search,Upper(Entry.Sysop)) > 0 Then ShowIt:=True
			If Pos(search,Upper(Entry.URL))   > 0 Then ShowIt:=True
			If Pos(search,Upper(Entry.BBS))   > 0 Then ShowIt:=True
			If Pos(search,Upper(Entry.Loc))   > 0 Then ShowIt:=True
			If ShowIt Then Begin
				/*
				If I % 2 = 0 Then
					Write('|15|19')
				Else
					Write('|11|16')
				*/
				Write('|11'+PadRt(N,15,' '))
				Write('|12'+PadRt(Copy(Entry.BBS,1,30),30,' '))
				Write('|05'+PadRt(Copy(Entry.URL,1,30),50,' '))
				Write('|14'+PadRt(Copy(Entry.Sysop,1,30),30,' '))
				Write('|10'+PadRt(Copy(Entry.Loc,1,30),35,' ')+'|11|16')
				I:=I+1
				If I % 11 = 0 Then Begin
					If InputYN('|10 More? |11: ') Then
						WriteLn('|CL|11|16Search: '+search+'|CR------------------------------------------------------------------------------')
					Else
						Done:=True
				End
				ShowIt:=False
			End
		End
		fClose(NLFPtr)
	End	
	ReadNodelist:=N
End


Procedure Main
Var S	: String=''
Var Done: Boolean=False
Begin
	Repeat
		ClrScr
		WriteLn('|10|16')
		WriteLn(PadCt('Nodelist Search',79,' '))
		WriteLn(PadCt('by Darryl Perry, 2012',79,' '))
		WriteLn('')
		WriteLn(PadCt('Search Fidonet-Style nodelists',79,' '))
		WriteLn('|07')
		WriteLn(PadCt('Type in any string to search the nodelist',79,' '))
		WriteLn('')
		WriteLn('               |09EXAMPLE: ')
		WriteLn('')
		WriteLn(PadCt(' |10CYBERIA BBS          |12- |11Search for BBS Names      ',85,' '))
		WriteLn(PadCt(' |10DARRYL PERRY         |12- |11Search for BBS Sysop Names',85,' '))
		WriteLn(PadCt(' |101:106/               |12- |11Search for node numbers   ',85,' '))
		WriteLn('')
		WriteLn('|17 |10Enter search string, /Q to Quit                                               |16|15')
		Write(':')
		S:=Upper(Input(20,20,2,''))
		If S<>'/Q' Then Begin
			ReadNodelist(S)
			Pause	
		End
	Until S='/Q'
End

Begin
	MenuCmd('NA','Nodelist Search')
	NLPath:=CfgDataPath+'nodelist.dat'
	If Not FileExist(NLPath) Then Begin
		WriteLn(NLPath+' not found.')
		WriteLn('Tell your sysop to run PARSENL to create it.')
		pause
	End Else
		Main
End
