// echttp.js v1.1
// HTTP GET & POST functions for Synchronet Bulletin Board Systems
// This is far from a proper implementation of client-side HTTP 1.1, but it
// will grab pages with httpget() and post data with httppost(). Additional
// functionality may be added upon request.
// echicken - echicken@bbs.electronicchicken.com

// New in v1.1: stripHeaders() - removes HTTP headers from a supplied string.
// (It's not the most elegant function; if needed I'll cook up a more flexible
// regex-based method for this at some point.)

load("sbbsdefs.js");
load("sockdefs.js");
var size = 4096; // Maximum number of bytes to read from the HTTP server

// httpget() accepts the following parameters:
// server (IP or FQDN) (eg: the "google.com" portion of "http://google.com/search?q=chicken") (required)
// port number
// timeout (in seconds)
// path portion of URL (eg: the "/search" portion of "http://google.com/search?q=chicken")
// GET variables (eg: the "q=chicken" portion of "http://google.com/search?q=chicken")
// username for HTTP basic authentication
// password for HTTP basic authentication
// Usage example: httpget("bbs-scene.org", 80, 2, "/api/onelinerz.php", "limit=10", "ex@am.ple", "3x4mpl3");
function httpget(server, port, to, path, getdata, username, password) {
	var s = new Socket();
	var srx;
	if(port == "undefined") { port = 80; }
	if(to == "undefined") { to = 5; }
	if(path == "undefined") { path = "/"; }
	s.connect(server, port, timeout=to);
	if(s.is_connected) {
		if(getdata != "undefined") {
			var sendstring = path + "?" + getdata;
		} else {
			var sendstring = path;
		}
		s.send("GET " + sendstring + " HTTP/1.1\n");
		s.send("Host: " + server + "\n");
		s.send("Connection: close\n");
		if(username != "undefined" && password != "undefined") {
			basicauth = base64_encode(username + ":" + password);
			s.send("Authorization: Basic " + basicauth + "\n");
		}
		s.send("\n");
		srx = s.recv(maxlen=size);
		while(s.is_connected) { srx = srx + s.recv(maxlen=size); }
	}
	s.close();
	return srx;
}

// httppost() is much the same as httpget(), except that the fifth parameter will be submitted as POST data rather than GET
// Usage example: httppost("bbs-scene.org", 80, 2, "/api/onelinerz.xml", "bbsname=example&alias=example&oneliner=example", "ex@am.ple", "3x4mpl3");
function httppost(server, port, to, path, postdata, username, password) {
	var s = new Socket();
	var srx;
	if(port == "undefined") { port = 80; }
	if(to == "undefined") { to = 2; }
	if(path == "undefined") { path = "/"; }
	s.connect(server, port, timeout=to);
	if(s.is_connected) {
		s.send("POST " + path + " HTTP/1.1\n");
		s.send("Host: " + server + "\n");
		s.send("Connection: close\n");
		if(username != "undefined" && password != "undefined") {
			basicauth = base64_encode(username + ":" + password);
			s.send("Authorization: Basic " + basicauth + "\n");		
		}
		s.send("Content-Type: application/x-www-form-urlencoded\n");
		s.send("Content-Length: " + postdata.length + "\n\n");
		s.send(postdata + "\n\n");
		srx = s.recv(maxlen=size);
		while(s.is_connected) { srx = srx + s.recv(maxlen=size); }
	}
	s.close();
	return srx;
}

function stripHeaders(stripme) {
	stripme = stripme.replace(/^HTTP.*/, "");
	stripme = stripme.replace(/\nServer.*/, "");
	stripme = stripme.replace(/\nDate.*/, "");
	stripme = stripme.replace(/\nCon.*/g, "");
	stripme = stripme.replace(/\nX-Powered-By.*/, "");
	stripme = stripme.replace(/\nTransfer-Encoding:\schunked.*/, "");
	stripme = stripme.replace(/\nAllow.+/, "");
	stripme = stripme.replace(/\nAccept-Ranges.+/, "");
	stripme = stripme.replace(/\n\w*/g, "");
	stripme = stripme.replace(/\n0\s*$/g, "");
	stripme = stripme.replace(/\n\s*|\s*\n/g, "");
	stripme = stripme.replace(/\n/g, "");
	stripme = stripme.replace(/\r/g, "");
	stripme = stripme.replace(/\t/g, "");
	stripme = stripme.replace(/<\?xml.*\?>/, "");
	return stripme;
}