// onelinerz.js v3
// bbs-scene.org global oneliners for Synchronet bulletin board systems
// echicken - echicken@bbs.electronicchicken.com

load("sbbsdefs.js");
load("echttp.js");
var esc = String.fromCharCode(27);

iniFile = new File(system.ctrl_dir + "bbs-scene.ini");
iniFile.open("r");
var BBSSceneAccount = iniFile.iniGetObject("Account");
var onelinerzPrefs = iniFile.iniGetObject("onelinerz");
iniFile.close();

// Dynamically set oneLinerLength based on alias & BBS name lengths & limits
function lengthCalc(a, b, c) {
	var sizer = a;
	if(b.length < onelinerzPrefs.aliasLength) {
		sizer = sizer + b.length;
	} else {
		sizer = sizer + onelinerzPrefs.aliasLength;
	}
	if(c.length < onelinerzPrefs.BBSNameLength) {
		sizer = sizer + c.length;
	} else {
		sizer = sizer + onelinerzPrefs.BBSNameLength;
	}
	var oneLinerLength = 79 - sizer;
	return oneLinerLength;
}

// Some of this is probably redundant, but just in case anybody tries any funny business . . .
function clean_input(string) {
	string = strip_exascii(string);
	string = strip_ctrl(string);
	string = truncsp(string);
	string = string.replace(/<(.|\n)*?>/g, "");
	return string;
}

// A line input function that parses pipe codes on the fly.
// Pretty basic for now, but can be improved upon if necessary.
var bs = String.fromCharCode(8);
function lineInput(len) {
	console.pushxy();
	var x = 0;
	var i = "";
	var l = 0;
	while(ascii(x) != 27 && ascii(x) != 13 && l <= len) {
		x = console.getkey();
		if(ascii(x) == 8) {
			if(i.substr(i.length - 3, 3).search(/\|\d\d/) > -1) {
				i = i.substr(0, i.length - 3);
			} else {
				i = i.substr(0, i.length - 1);
			}
			console.popxy();
			console.putmsg(i + " " + bs);
			l = l - 1;
			if(l < 0) { l = 0; }
		} else if(l < len && ascii(x) != 13 && ascii(x) != 27 && ascii(x) != 30 && ascii(x) != 29 && ascii(x) != 10 && ascii(x) != 6) {
			i = i + x;
			if(i.substr(i.length - 3, 3).search(/\|\d\d/) > -1) {
				console.popxy();
				console.putmsg(i + "   " + bs + bs + bs);
				l = l - 2;
			} else {
				console.popxy();
				console.putmsg(i);
				l++;
			}
		}
		discard = 0;
	}
	console.print(esc + "[0;37;40m");
	if(ascii(x) == 27) { i = ""; }
	return i;
}

var onelinerz = httpget(BBSSceneAccount.server, BBSSceneAccount.port, BBSSceneAccount.timeout, BBSSceneAccount.apiPath + "onelinerz.php", "limit=" + onelinerzPrefs.limit + "&ansi=" + onelinerzPrefs.colourCodes, BBSSceneAccount.username, BBSSceneAccount.password);
if(onelinerz != "undefined") {
	console.clear();
	bbs.menu(onelinerzPrefs.displayFile);
	for(x = 1; x <= 79; x++) { console.print(esc + "[1;30;40m-"); }
	console.crlf();
	onelinerz = stripHeaders(onelinerz);	
	var x = new XML(onelinerz);
	for each(var node in x.node) {
		var diff = node.oneliner.toString().length - node.oneliner.toString().replace(/\|\d\d/g, "").length;
		oneLinerLength = lengthCalc(4, node.alias, node.bbsname);
		console.putmsg(esc + "[1;30;40m" + "(" + esc + onelinerzPrefs.ansiColourAlias + node.alias.substr(0, onelinerzPrefs.aliasLength) + esc + "[1;34;40m@" + esc + onelinerzPrefs.ansiColourBBSName + node.bbsname.substr(0, onelinerzPrefs.BBSNameLength) + esc + "[1;30;40m) " + esc + onelinerzPrefs.ansiColourOneliner + html_decode(node.oneliner.substr(0, oneLinerLength + diff)));
		console.crlf();
	}
	for(x = 1; x <= 79; x++) { console.print(esc + "[1;30;40m-"); }
	console.crlf();
	
	var banned = 0;
	var userrealname = user.name.toUpperCase();
	var useralias = user.alias.toUpperCase();
	var userhandle = user.handle.toUpperCase();
	var bannedUsers = onelinerzPrefs.bannedUsers.split(/,/);
	for(i in bannedUsers) {
		if(userrealname == bannedUsers[i].toUpperCase() || useralias == bannedUsers[i].toUpperCase() || userhandle == bannedUsers[i].toUpperCase() || useralias == "") {
			banned = 1;
		}
	}
	if(banned == 0) {
		console.pushxy();
		if(!console.noyes("Post a oneliner to bbs-scene.org")) {
			oneLinerLength = lengthCalc(4, user.alias, onelinerzPrefs.BBSName);
			console.popxy(); console.clearline();
			console.print(esc + "[1;30;40m" + "(" + esc + onelinerzPrefs.ansiColourAlias + user.alias.substr(0, onelinerzPrefs.aliasLength) + esc + "[1;34;40m@" + esc + onelinerzPrefs.ansiColourBBSName + onelinerzPrefs.BBSName.substr(0, onelinerzPrefs.BBSNameLength) + esc + "[1;30;40m) " + esc + "[1;37;40m");
			var oneliner = lineInput(oneLinerLength);
			if(oneliner != "" && oneliner != null && oneliner != "undefined") {
				oneliner = clean_input(oneliner);
				httppost(BBSSceneAccount.server, BBSSceneAccount.port, BBSSceneAccount.timeout, BBSSceneAccount.apiPath + "onelinerz.xml", "bbsname=" + onelinerzPrefs.BBSName + "&alias=" + user.alias + "&oneliner=" + oneliner, BBSSceneAccount.username, BBSSceneAccount.password);
			}
		}
	} else {
		console.print(esc + "[1;37;40m" + "You do not have permission to post oneliners to bbs-scene.org.");
	}
}