/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __USERSPB_H )
	#include "userspb.h"
#endif

#if !defined( PB_SDK ) && !defined( __PBCONFIG_H )
	#include "pbconfig.h"
#endif

/*
 * local: opens the USERSPB file in desired mode
*/
	FILE *
_openUsersPB( const char *mode )
{
	char path[MAXPATH];

#if !defined( PB_SDK )
	CONFIG cfg, *Config = &cfg;
	if( -1 == ReadConfig( &cfg ) ) return NULL;
#endif
	sprintf( path, "%s\\USERSPB.BBS", Config->msgpath );

	return fopen( path, mode );
}

/*
 * returns total number of entries in the USERSPB file
*/
	int
NumUsersPB( void )
{
	FILE *fp;
	 int num;

	fp = _openUsersPB( "rb" );
	if( !fp ) return -1;

	fseek( fp, 0L, SEEK_END );

	num = (int)l_div( ftell(fp), (long)sizeof(USERSPB) );
	fclose(fp);

	return num;
}


/*
 * reads a USERSPB record
*/
	int
ReadUsersPB( int n, USERSPB *us )
{
	FILE *fp;
	 int  retval = 0;

	fp = _openUsersPB( "rb" );
	if( !fp ) return -1;

	fseek( fp, l_mul( (long)(n - 1), (long)sizeof(USERSPB) ), SEEK_SET );
	if( 1 != fread(us, sizeof(USERSPB), 1, fp ) ) retval = -1;
	fclose( fp );

	return retval;
}

/*
 * writes a user record to USERSPB
*/
	int
WriteUsersPB( int n, USERSPB *us )
{
	FILE *fp;
	 int  retval = 0;

	fp = _openUsersPB( "r+b" );
	if( !fp ) return 0;

	fseek( fp, l_mul( (long)(n - 1), (long)sizeof(USERSPB)), SEEK_SET );
	if( 1 != fwrite(us, sizeof(USERSPB), 1, fp ) ) retval = -1;
	fclose(fp);

	return retval;
}
