/*
 * This file is part of VizPak (PEX)
 *
 * Copyright (C) 1995-1997 by Branislav L. Slantchev
 * A Product of Silicon Creations, Inc.
 *
 * This file is distributed under the terms and conditions of the GNU
 * General Public License. For more information, refer to the file
 * Copying.Doc which is included in the archive.
*/
#include "vizpak.h"
#include "pblsdk.h"

#ifndef PB_SDK
	#include <stdio.h>
	#include <string.h>
	#include <stdlib.h>
	#include <dos.h>
#else
	#include "pblibc.h"
#endif

Bounce::Bounce(int argc, char *argv[], char *argv0)
	:AbstractViz(argc, argv, argv0, AbstractViz::normalFancy,
				 AbstractViz::dontCenter)
	,m_eraseString(0)
{
	if( (m_nTextSize >= m_bounds.b.x - m_bounds.a.x + 1)
		|| (m_bounds.b.y <= m_bounds.a.y) )
	{
		Log(LOG_FRIEND, "vizPak: bouncer received bad coordinates");
		exit(EXIT_FAILURE);
	}

	// if 'reverse', we will not be clearing the tail
	if( !(m_flags & reverse) )
	{
		if( 0 == (m_eraseString = new char [m_nTextSize + 1]) )
		{
			Log(LOG_FRIEND, "vizPak: i ran out of memory!");
			exit(EXIT_FAILURE);
		}
		memset(m_eraseString, ' ', m_nTextSize);
		m_eraseString[m_nTextSize] = EOS;
	}
}

Bounce::~Bounce()
{
	if( m_eraseString ) delete[] m_eraseString;
}

void
Bounce::effect()
{
	/* init starting variables and display string */
	int x  = m_bounds.a.x;
	int y  = m_bounds.a.y;
	int dx = 1;
	int dy = 1;
	m_bounds.b.x -= m_nTextSize;  /* adjust end to allow for whole string */

	if( m_flags & fancy ) textattr(m_palette[0]);
	else textattr(m_nColor);

	gotoxy(x, y);
	cprintf(m_text);

	for( ;; )
	{
		/* see if we need to reverse the increments */
		if( x == m_bounds.b.x ) dx = -1;
		else if( x == m_bounds.a.x ) dx = 1;

		if( y == m_bounds.b.y ) dy = -1;
		else if( y == m_bounds.a.y ) dy = 1;

		/* erase old string if not 'reverse' */
		if( !(m_flags & reverse) )
		{
			gotoxy(x, y);
			cprintf(m_eraseString);
		}

		/* display new string */
		x += dx;
		y += dy;
		gotoxy(x, y);
		putns(m_text, m_nTextSize);

		if( 0 != (m_exitCode = PeekChar()) ) return;

		delay( m_nDelay );
	}
}
