
/* ------------------------------------------------------------
 * Filename ............... QuoteBrd.Cpp
 *
 * General Purpose ........ QuoteBoard class
 * ------------------------------------------------------------
 * First date ............. 30/05/95 10:17
 *
 * First in version ....... 1.00
 *
 * Written by ............. Alain Schellinck
 *
 * Copyright .............. Nephilim software development
 * ------------------------------------------------------------
 *
 *       See the GNU.DOC file before using this source!
 *
 * ------------------------------------------------------------
 * Revisions:
 * ----------
 *
 *   Date   | By |                  Purpose                   |
 * ---------+----+--------------------------------------------+
 *          |    |                                            |
 *          |    |                                            |
 *          |    |                                            |
 */

/*-------------------------------------------------------------------------*/

#include "thequote.hpp"
#pragma  hdrstop

/*-------------------------------------------------------------------------*/

#include "quotebrd.hpp"

/*-------------------------------------------------------------------------*/

#define MaxBoards    10000

/*--] Code [-------------------------------------] QuoteBoard [------------*/

/*
 * Routine   : QuoteBoard()
 * Purpose   : the constructor
 * ------------------------------------------------------------------------
 * Parameters: None
 * Return    : None
 *
 */

QuoteBoard::QuoteBoard()
{
   flags = new BytT[MaxBoards / 8];
   setAll();
}

/*
 * Routine   : ~QuoteBoard()
 * Purpose   : the destructor
 * ------------------------------------------------------------------------
 * Parameters: None
 * Return    : None
 *
 */

QuoteBoard::~QuoteBoard()
{
   delete flags;
}

/*
 * Routine   : setAll()
 * Purpose   : enable all boards
 * ------------------------------------------------------------------------
 * Parameters: None
 * Return    : None
 *
 */

void QuoteBoard::setAll()
{
   memset(flags, MaxBoards / 8, 0xFF);
}

/*
 * Routine   : resetAll()
 * Purpose   : disable all boards
 * ------------------------------------------------------------------------
 * Parameters: None
 * Return    : None
 *
 */

void QuoteBoard::resetAll()
{
   memset(flags, MaxBoards / 8, 0x00);
}

/*
 * Routine   : set()
 * Purpose   : enable the specified board
 * ------------------------------------------------------------------------
 * Parameters: board number
 * Return    : None
 *
 */

void QuoteBoard::set(IntT boardNum)
{
   boardNum--;

   IntT flagNum = boardNum / 8;
   IntT bitNum  = boardNum % 8;

   flags[flagNum] |= (1 << bitNum);
}

/*
 * Routine   : reset()
 * Purpose   : disable the specified board
 * ------------------------------------------------------------------------
 * Parameters: board number
 * Return    : None
 *
 */

void QuoteBoard::reset(IntT boardNum)
{
   boardNum--;

   IntT flagNum = boardNum / 8;
   IntT bitNum  = boardNum % 8;

   flags[flagNum] &= ~(1 << bitNum);
}

/*
 * Routine   : get()
 * Purpose   : get the flag for the specified board
 * ------------------------------------------------------------------------
 * Parameters: board number
 * Return    : True if ENABLED, False if NOT
 *
 */

FlgT QuoteBoard::get(IntT boardNum)
{
   boardNum--;

   FlgT ret_val = False;
   IntT flagNum = boardNum / 8;
   IntT bitNum  = boardNum % 8;

   if(flags[flagNum] & (1 << bitNum))
      ret_val = True;

   return(ret_val);
}

/*---------------------------] END OF THE CODE [---------------------------*/
