//
// ProBoard RIP-library
//
// version 1.0 (c) Edwin Groothuis
//
// This RIP-library is not freeware. It's not allowed to use this code
// without mentioning me in the documentation as something like
// "This program uses the ProBoard RIP-library by Edwin Groothuis."
// and telling me you're using this library. Maybe you could give me
// a registrered copy of the program which uses this library (hint,
// hint). It's not allowed to spread this library with a modified source.
//
// Disclaimer: This library is not 100% bugfree. I've tried to find all
//             the typos, bugs etc but it's possible you still can find
//             one. If you do, please let me know so I can fix it and
//             give people using this library an update.
//
// Author:
// Edwin Groothuis                   ECA-BBS
// Johann Strausslaan 1              +31-40-550352 (14k4/V42B)
// 5583ZA Aalst-Waalre               2:284/205.1@fidonet
// The Netherlands                   115:3145/102.1@pascal-net
//
//
// 1994 mar 14 mon: First start
//

//  Query RIPscrip version number.  RIPterm will respond with
//  RIPSCRIPxxyyvs where "xx" is equal to the major version
//  number (zero padded), "yy" is equal to the minor version
//  number (zero padded), "v" is the vendor code of the
//  terminal program (see below), and "s" is the vendor's
//  sub-version code for their software.  For v1.54, the
//  returned sequence for RIPterm (Vendor Code "1") would be
//  RIPSCRIP015410.  Another example, v1.23 with a Vendor Code
//  of "2" and a sub-revision code of "5" would return
//  RIPSCRIP012325.
//
//  Valid Vendor Codes are:
//
//       CODE   VENDOR
//       =================================================
//         0    Generic RIPscrip terminal (vendor unknown)
//         1    RIPterm (from TeleGrafix Communications)
//         2    Qmodem Pro (from Mustang Software, Inc)
//
//  This ANSI sequence is often used for "Auto-Sensing" if a
//  RIPscrip terminal exists on the remote end of the
//  connection.  If a non-RIPscrip terminal receives this
//  ANSI sequence, it will ignore it.
char    *RIP_version(void);

//  Enabled RIPscrip processing.  Any RIPscrip sequences will
//  be parsed and processed.
void    RIP_enable(void);

//  Disables all RIPscrip processing.  Any RIPscrip sequences
//  are interpreted as raw text.
void    RIP_disable(void);

// Define the size and location of the Text Window, wraparound and
// fontsize: 0     8x8          0-79     0-42
//           1     7x8          0-90     0-42
//           2     8x14         0-79     0-24
//           3     7x14         0-90     0-24
//           4     16x14        0-39     0-24
void    RIP_text_window(int x1,int y1,int x2,int y2,bool wrap,int size);

// Define the size & location of the Graphics Window
void    RIP_viewport(int x1,int y1,int x2,int y2);

// Clear Graphics/Text Windows & reset to full screen
// This command will set the Text Window to a full 80x43 EGA hi-res text
// mode, place the cursor in the upper left corner, clear the screen,
// and zoom the Graphics Window to full 640x350 EGA screen.  Both
// windows are filled with the current graphics background color.  Also,
// all Mouse Regions and Mouse Buttons are deleted and the Clipboard is
// erased.
void    RIP_reset_windows(void);

// Clears Text Window to current background color
void    RIP_erase_window(void);

// Clear Graphics Window to current background color
void    RIP_erase_view(void);

// Move text cursor to row & column in Text Window
void    RIP_gotoxy(int x,int y);

// Move cursor to upper-left corner of Text Window
void    RIP_home(void);

// Erase current line from cursor to end of line
void    RIP_erase_eol(void);

// Set current Drawing Color for graphics
// Value   Color
// -------------------------------------------------------
// 00      Black (00 is always the background color)
// 01      Blue
// 02      Green
// 03      Cyan
// 04      Red
// 05      Magenta
// 06      Brown
// 07      Light Gray
// 08      Dark Gray
// 09      Light Blue
// 0A      Light Green
// 0B      Light Cyan
// 0C      Light Red
// 0D      Light Magenta
// 0E      Yellow
// 0F      White
void    RIP_color(int c);

// Set 16-color Palette from master 64-color palette
// The default 16-color RIP palette is:
//
// 16-Color RIP Palette     Master 64-Color EGA
//     Color Code           Palette Color Code       Color
// ---------------------------------------------------------------
//        00                     0  (00)             Black
//        01                     1  (01)             Blue
//        02                     2  (02)             Green
//        03                     3  (03)             Cyan
//        04                     4  (04)             Red
//        05                     5  (05)             Magenta
//        06                     7  (06)             Brown
//        07                     20 (0K)             Light Gray
//        08                     56 (1K)             Dark Gray
//        09                     57 (1L)             Light Blue
//        0A                     58 (1M)             Light Green
//        0B                     59 (1N)             Light Cyan
//        0C                     60 (1O)             Light Red
//        0D                     61 (1P)             Light Magenta
//        0E                     62 (1Q)             Yellow
//        0F                     63 (1R)             White
void    RIP_set_palette(int c1,int c2,int c3,int c4,int c5,int c6,int c7,int c8,
                        int c9,int c10,int c11,int c12,int c13,int c14,int c15,int c16);

// Set color of 16-color Palette from Master Palette
void    RIP_one_palette(int color,int value);

// Set drawing mode for graphics primitives
// Mode   Description
// ------------------------------------------
// 00     Normal drawing mode (overwrite)
// 01     XOR (complimentary) mode
void    RIP_write_mode(int mode);

// Move the current drawing position to (X,Y)
void    RIP_move(int x,int y);

// Draw text in current font/color at current spot
// This command displays text at the current location in the graphics
// window, as set with the RIP_MOVE command.  The text is also affected
// by the most recent settings of these commands:
//
// Command            Description of Command
// ----------------------------------------------------------------
// RIP_FONT_STYLE     font style (character set, direction, size)
// RIP_WRITE_MODE     drawing mode (normal or XOR)
// RIP_COLOR          drawing color (from the 16-color RIP palette)
void    RIP_text(char *s);

// Draw text in current font/color at specific spot
void    RIP_text_xy(int x,int y,char *s);

// Select current font style, orientation and size
//   Font   Description of Font
//   ---------------------------------------------
//   00     Default 8x8 font            Bit-Mapped
//   01     Triplex Font                Scalable
//   02     Small Font                  Scalable
//   03     Sans Serif Font             Scalable
//   04     Gothic [Old English] Font   Scalable
//   05     Script Font                 Scalable
//   06     Simplex Font                Scalable
//   07     Triplex Script Font         Scalable
//   08     Complex Font                Scalable
//   09     European Font               Scalable
//   0A     Bold Font                   Scalable
//
// For the Direction parameter, use 00 to indicate horizontal and 01 for
// vertical.
//
// For the Size parameter, use 01 for the normal default size, 02 for x2
// magnification, 03 for x3 magnification, ... , and 0A for x10
// magnification.
void    RIP_font_style(int font,int direction,int size);

// Draws a one pixel using current drawing color
void    RIP_pixel(int x,int y);

// Draw a line in the current color/line style
void    RIP_line(int x1,int y1,int x2,int y2);

// Draw a rectangle in current color/line style
// The rectangle interior is not filled by RIP_RECTANGLE.
void    RIP_rectangle(int x1,int y1,int x2,int y2);

// Draw filled rectangle with fill color/pattern
void    RIP_bar(int x1,int y1,int x2,int y2);

// Draw circle in current color and line thickness
void    RIP_circle(int x,int y,int radius);


// Draw elliptical arc in current color/line style
// The X radius is half the full width of the ellipse, the Y radius is
// half the full height.
void    RIP_oval(int x,int y,int start_angle,int end_angle,
                 int radius_x,int radius_y);

// Draw filled ellipse using current color/pattern
void    RIP_filled_oval(int x,int y,int radius_x,int radius_y);

// Draw circular arc in current color/line thickness
void    RIP_arc(int x,int y,int start_angle,int end_angle,int radius);

// Draw an elliptical arc
void    RIP_oval_arc(int x,int y,int start_angle,int end_angle,
                     int radius_x,int radius_y);

// Draws a circular pie slice
void    RIP_pie_slice(int x,int y,int start_angle,int end_angle,int radius);

// Draws an elliptical pie slice
void    RIP_oval_pie_slice(int x,int y,int start_angle,int end_angle,
                           int radius_x,int radius_y);

// Draw a bezier curve
//                        X2
//
//                       *****
//                     **     ****
//                    *           **            X4
//                   *              **          *
//                 X1                 *       **
//                                     *    **
//                                      ****
//
//                                       X3
//
// NOTE: Points 2 and 3 are not actually on the curve - points 1 and 4 are.
// seg is the number of segments the curve must be drawn in
void    RIP_bezier(int x1,int y1,int x2,int y2,
                   int x3,int y3,int x4,int y4,int seg);

// Draw polygon in current color/line-style. NYI
void    RIP_polygon(void);

// Draw filled polygon in current color/fill pattern. NYI
void    RIP_fill_polygon(void);

// Draw a Poly-Line (multi-faceted line). NYI
void    RIP_polyline(void);

// Flood fill screen area with current fill settings
// This command performs a "flood fill" emanating from the given <x,y>
// point.  The fill "oozes" in all directions up to <border> color, but
// the border itself is not changed.
void    RIP_fill(int x,int y,int bordercolor);

// Defines a line style and thickness
// Style   Description           Binary            Hex
// ----------------------------------------------------
// 00      Normal, Solid Line    1111111111111111  FFFF
// 01      Dotted Line           0011001100110011  3333
// 02      Centered Line         0001111000111111  1E3F
// 03      Dashed Line           0001111100011111  1F1F
// 04      Custom Defined line (see about <user_pat> below)
//
// Thick   Description
// -------------------------------
// 01      Lines are 1 pixel wide
// 03      Lines are 3 pixels wide
//
// If the <style> is set to a value of 4 (custom pattern), then the
// <user_pat> parameter is used as a 16-bit representation of the pixels
// in the line pattern.  For example:
//
// Repeating Pattern     Binary Coding     Hex     Decimal
// -------------------------------------------------------
//  - - - - - - - -    1010101010101010    AAAA     43690
//  ----    ----       1111000011110000    F0F0     61680
//
// So, the most-significant-bit of <user_pat> is toward the starting
// point of the line or border that uses this fill pattern.  If the
// <style> parameter is not 4, then the <user_pat> parameter is ignored.
void    RIP_line_style(int style,long userpattern,int thickness);

// Set current fill style (predefined) & fill color
// Pattern  Description                 Example       Misc
// -----------------------------------------------------------------
//   00     Fill with background color                (color #0)
//   01     Solid Fill                                (fill color)
//   02     Line Fill                   -----------   (thick lines)
//   03     Light Slash Fill            /  /  /  /    (thin lines)
//   04     Normal Slash Fill           // // // //   (thick lines)
//   05     Normal Backslash Fill       \\ \\ \\ \\   (thick lines)
//   06     Light Backslash Fill        \  \  \  \    (thin lines)
//   07     Light Hatch Fill            ###########   (thin lines)
//   08     Heavy Cross Hatch Fill      XXXXXXXXXXX   (thin lines)
//   09     Interleaving Line Fill      +-+-+-+-+-+   (thin lines)
//   0A     Widely spaced dot fill      . : . : . :   (pixels only)
//   0B     Closely spaced dot fill     :::::::::::   (pixels only)
void    RIP_fill_style(int pattern,int color);

// Set user-definable (custom) fill pattern/color
// This command allows you to specify a user-defined, custom Fill
// Pattern.  This pattern supersedes the predefined patterns of
// RIP_FILL_STYLE.  A custom fill pattern is an 8x8 pixel array defining
// which pixels should be drawn in the current fill color (as set by the
// <col> parameter here).  The other pixels in the fill area are set to
// the current background color (color 00, typically black).
void    RIP_fill_pattern(int c1,int c2,int c3,int c4,
                         int c5,int c6,int c7,int c8,int color);

// Defines a rectangular hot mouse region
void    RIP_mouse(int x1,int y1,int x2,int y2,
                  int invert,int clr,char *text);

// Destroys all previously defined hot mouse regions
void    RIP_kill_mouse_fields(void);

// Define a rectangular text region
// This command defines a rectangular portion of the graphics viewport
// that is to display text, usually a long stream of text.  Following
// this command should be a number of RIP_REGION_TEXT commands with the
// text to be displayed.  The RIP_END_TEXT terminates this stream of
// text, something like this:
//
// RIP_BEGIN_TEXT
//      RIP_REGION_TEXT
//      RIP_REGION_TEXT
//      RIP_REGION_TEXT
//      :
//      RIP_REGION_TEXT
// RIP_END_TEXT
void    RIP_begin_text(int x1,int y1,int x2,int y2);

// Display a line of text in rectangular text region
//
// Justify   Description
// ------------------------------------------------------------------
//  FALSE    Don't right/left justify.  Left-justify only
//  TRUE     Perform right/left margin justification of this line of
//           text.
//
// If a text line falls off the bottom of the region, it is discarded --
// the rectangular Text Region does not scroll.
void    RIP_region_text(bool justify, char *text);

// End a rectangular text region
void    RIP_end_text(void);

// Copy rectangular image to clipboard (as icon)
void    RIP_get_image(int x1,int y1,int x2,int y2);

// Pastes the clipboard contents onto the screen
// Mode   Description                                          Logical
// -------------------------------------------------------------------
//  00    Paste the image on-screen normally                   (COPY)
//  01    Exclusive-OR  image with the one already on screen   (XOR)
//  02    Logically OR  image with the one already on screen   (OR)
//  03    Logically AND image with the one already on screen   (AND)
//  04    Paste the inverse of the image on the screen         (NOT)
void    RIP_put_image(int x,int y,int mode);

// Write contents of the clipboard (icon) to disk
void    RIP_write_icon(char *filename);

// Loads and displays a disk-based icon to screen
// Mode   Description                                         Logical
// ------------------------------------------------------------------
//  00    Paste the image on-screen normally                   (COPY)
//  01    Exclusive-OR  image with the one already on screen   (XOR)
//  02    Logically OR  image with the one already on screen   (OR)
//  03    Logically AND image with the one already on screen   (AND)
//  04    Paste the inverse of the image on the screen         (NOT)
void    RIP_load_icon(int x,int y,int mode,bool clipboard,char *filename);

// Button style definition
// Value   Description of Orientation
// -------------------------------------------------
//  00     Display label above button
//  01     Display label to the left of button
//  02     Display label in the center of the button
//  03     Display label to the right of button
//  04     Display label beneath the button
//
// Value Description of Flags Field #1   Icon Clip  Plain Mouse No-Mouse
// ---------------------------------------------------------------------
//     1 Button is a "Clipboard Button"   N     Y     N     Y     Y
//     2 Button is "Invertable"           Y     Y     Y     Y     N
//     4 Reset screen after button click  Y     Y     Y     Y     N
//     8 Display Chisel special effect    Y     Y     Y     Y     Y
//    16 Display Recessed special effect  Y     Y     Y     Y     Y
//    32 Dropshadow the label (if any)    Y     Y     Y     Y     Y
//    64 Auto-stamp image onto Clipboard  Y     Y     Y     Y     Y
//   128 Button is an "Icon Button"       Y     N     N     Y     Y
//   256 Button is a "Plain Button"       N     N     Y     Y     Y
//   512 Display Bevel special effect     Y     Y     Y     Y     Y
//  1024 Button is a Mouse Button         Y     Y     Y     Y     N
//  2048 Underline hot-key in label       Y     Y     Y     Y     N
//  4096 Make Icon Button use Hot Icons   Y     N     N     Y     N
//  8192 Adj. vertical centering of label Y     Y     Y     Y     Y
// 16384 Button belongs to a Radio Group  Y     Y     Y     Y     N
// 32768 Display Sunken special effect    Y     Y     Y     Y     Y
//
// Val Description of Flags Field #2    Icon Clip Plain Mouse No-Mouse
// -------------------------------------------------------------------
//  1  Button is in a check box group     Y    Y    Y     Y       N
//  2  Highlight hotkey character         Y    Y    Y     Y       N
//  4  Explode (zoom out when clicked)    Y    Y    Y     Y       N
//  8  Left Justify Label (top/ctr/btm)   Y    Y    Y     Y       Y
// 16  Right Justify Label (top/ctr/btm)  Y    Y    Y     Y       Y
void    RIP_button_style(int width,int height,int orient,long flags,
                         int size,int dfore,int dback,int bright,
                         int dark,int surface,int group_no,int flags2,
                         int uline_col,int corner_col);

// Define a Mouse Button
// flags: Value  Description
//        --------------------------------------------------
//          1    Draw button as already selected
//          2    Button is "default" when <ENTER> is pressed
//
// text ::= [icon-file][[<>text-label][<>host-command]]
void    RIP_button(int x1,int y1,int x2,int y2,int hotkey,int flags,char *text);

// Define a text variable
// text ::= variable-identifier[,field-width]:[?question-text?][default-value]
void    RIP_define(int flags,char *text);

// Query the contents of a text variable
// Mode     Description
// ----------------------------------------------------------------
//  0    Process the query command NOW (upon receipt)
//  1    Process when mouse clicked in Graphics Window
//  2    Process when mouse clicked in Text Window (any text
//       variables that return X or Y mouse coordinates return TEXT
//       coordinates, not graphics coordinates in this mode.  These
//       coordinates are two-digit values instead of the graphical
//       values that are four digits).
// text: See HOSTS COMMANDS
// ret : true -> wait for returnvalues after delaytime
char    *RIP_query(int mode,char *text,bool ret,int delaytime,char *s);

// Copy screen region up/down
// Due to hardware restrictions, the X0 and X1 parameters must be evenly
// divisible by eight (8) (e.g., 0, 8, 16, etc.).  If the X0 and X1
// parameters are NOT evenly divisible by eight, then the X0 parameter
// will be reduced to the next most eight-pixel boundary, and the X1
// parameter will be increased to the next eight-pixel boundary.
//
// If the destination region would place the image partially off-screen,
// then the entire command is ignored!
void    RIP_copy_region(int x1,int y1,int x2,int y2,int newy);

// Playback local .RIP file
void    RIP_read_scene(char *filename);

// Query existing information on a particular file
// Mode  Description
// ----------------------------------------------------------------------
//  00   Simply query the existence of the file.  If it exists, a "1" is
//       returned.  Otherwise a "0" is returned to the Host (without a
//       carriage return).
//  01   Same as 0, except a carriage return is added after the
//       response.
//  02   Queries the existence of a file.  If it does not exist, a "0"
//       is returned to the Host followed by a carriage return.  If it
//       does exist, the returned text is a "1." followed by the file
//       size (in decimal).  The return sequence is terminated by a
//       carriage return.  An example of the returned text could be
//       "1.20345".
//  03   Queries extended return information.  If the file does not
//       exist, a "0" is returned followed by a carriage return.  If it
//       does exist, the text returned to the Host is in the Format:
//       1.size.date.time <cr>.  An example of a return statement could
//       be "1.20345.01/02/93.03:04:30<cr>"
//  04   Queries extended return information.  If the file does not
//       exist, a "0" is returned followed by a carriage return.  If it
//       does exist, the text returned to the Host is in the Format:
//       1.filename.size.date.time <cr>. An example of a return
//       statement could be "1.MYFILE.RIP.20345.01/02/93.03:04:30 <cr>".
//       Note that the file extension adds another period into the
//       return text.
char    *RIP_file_query(int mode,char *filename);

// Enter block transfer mode with host
void    RIP_enter_block_mode(bool upload,int protocol,int filetype,char *fname);

// End of RIPscrip Scene
void    RIP_no_more(void);

// Colordefinitions
#define RIP_BLACK          0x0
#define RIP_BLUE           0x1
#define RIP_GREEN          0x2
#define RIP_CYAN           0x3
#define RIP_RED            0x4
#define RIP_MAGENTA        0x5
#define RIP_BROWN          0x6
#define RIP_LIGHT_GRAY     0x7
#define RIP_DARK_GRAY      0x8
#define RIP_LIGHT_BLUE     0x9
#define RIP_LIGHT_GREEN    0xA
#define RIP_LIGHT_CYAN     0xB
#define RIP_LIGHT_RED      0xC
#define RIP_LIGHT_MAGENTA  0xD
#define RIP_YELLOW         0xE
#define RIP_WHITE          0xF

// Putoptions
#define     NORMAL_PUT  00
#define     XOR_PUT     01
#define     OR_PUT      02
#define     AND_PUT     03
#define     NOT_PUT     04    

// Host commands (See RIP_query())
#define RIP_VERSION       "$RIPVER$"    // RIPSCRIP015300
#define RIP_DATE          "$DATE$"      // 01/01/93
#define RIP_MONTH         "$MONTH$"     // Januari
#define RIP_MONTHNUM      "$MONTHNUM$"  // 01
#define RIP_DAY           "$DAY$"       // 01
#define RIP_DOY           "$DOY$"       // 01 (day of year)
#define RIP_YEAR          "$YEAR$"      // 93
#define RIP_FYEAR         "$FYEAR$"     // 1993
#define RIP_TIME          "$TIME$"      // 18:09:03
#define RIP_HOUR          "$HOUR$"      // 10 (01-12)
#define RIP_MHOUR         "$MHOUR$"     // 18 (00-23)
#define RIP_MIN           "$MIN$"       // 09
#define RIP_SEC           "$SEC$"       // 03
#define RIP_AMPM          "$AMPM$"      // PM
#define RIP_DATETIME      "$DATETIME$"  // Sat Dec 19 14:38:50 1993
#define RIP_TIMEZONE      "$TIMEZONE$"  // CET
#define RIP_DOW           "$DOW$"       // Sunday
#define RIP_ADOW          "$ADOW$"      // Sun
#define RIP_WDAY          "$WDAY$"      // 2 (0=Sunday)
#define RIP_WOY           "$WOY$"       // 32 (sunday=1st dow)
#define RIP_WOYM          "$WOYM$"      // 31 (monday=1st dow)
#define RIP_BEEP          "$BEEP$"      // ^G
#define RIP_BLIP          "$BLIP$"      // (Blipping sound)
#define RIP_MUSIC         "$MUSIC$"     // (Cheerful sound)
#define RIP_ALARM         "$ALARM$"     // (Alarm sound)
#define RIP_PHASERS       "$PHASER$"    // (Phasers sound)
#define RIP_REVPHASERS    "$REVPHASER$" // (Phasers sounds)
#define RIP_MOUSEX        "$X$"         // 0012
#define RIP_MOUSEY        "$Y$"         // 0012
#define RIP_MOUSEXY       "$XY$"        // 0012:0012
#define RIP_MOUSEXYB      "$XYM$"       // 0012:0012:001 (LMR)
#define RIP_MOUSEB        "$M$"         // 001 (LMR)
#define RIP_MOUSESTATS    "$MSTATS$"    // YES
#define RIP_RESET         "$RESET$"     // identical to !|*
#define RIP_SAVEALL       "$SAVEALL$"   // Saves the current screen
#define RIP_RESTOREALL    "$RESTOREALL$"// Restore a saved screen
#define RIP_EGW           "$EGW$"       // Erase Graphical Window
#define RIP_SAVE          "$SAVE$"      // Save graphics screen
#define RIP_SAVE0         "$SAVE0$"     // Save graphics screen #0
#define RIP_SAVE1         "$SAVE1$"     // Save graphics screen #1
#define RIP_SAVE2         "$SAVE2$"     // Save graphics screen #2
#define RIP_SAVE3         "$SAVE3$"     // Save graphics screen #3
#define RIP_SAVE4         "$SAVE4$"     // Save graphics screen #4
#define RIP_SAVE5         "$SAVE5$"     // Save graphics screen #5
#define RIP_SAVE6         "$SAVE6$"     // Save graphics screen #6
#define RIP_SAVE7         "$SAVE7$"     // Save graphics screen #7
#define RIP_SAVE8         "$SAVE8$"     // Save graphics screen #8
#define RIP_SAVE9         "$SAVE9$"     // Save graphics screen #9
#define RIP_RESTORE       "$RESTORE$"   // Restore graphics screen
#define RIP_RESTORE0      "$RESTORE0$"  // Restore graphics screen #0
#define RIP_RESTORE1      "$RESTORE1$"  // Restore graphics screen #1
#define RIP_RESTORE2      "$RESTORE2$"  // Restore graphics screen #2
#define RIP_RESTORE3      "$RESTORE3$"  // Restore graphics screen #3
#define RIP_RESTORE4      "$RESTORE4$"  // Restore graphics screen #4
#define RIP_RESTORE5      "$RESTORE5$"  // Restore graphics screen #5
#define RIP_RESTORE6      "$RESTORE6$"  // Restore graphics screen #6
#define RIP_RESTORE7      "$RESTORE7$"  // Restore graphics screen #7
#define RIP_RESTORE8      "$RESTORE8$"  // Restore graphics screen #8
#define RIP_RESTORE9      "$RESTORE9$"  // Restore graphics screen #9
#define RIP_SMF           "$SMF$"       // Save Mouse Fields
#define RIP_RMF           "$RMF$"       // Restore Mouse Fields
#define RIP_MKILL         "$MKILL$"     // Kill Mouse Fields
#define RIP_ETW           "$ETW$"       // Erase Text Window
#define RIP_DTW           "$DTW$"       // Disable Text Window
#define RIP_STW           "$STW$"       // Save Text Window
#define RIP_RTW           "$RTW$"       // Restore Text Window
#define RIP_TWIN          "$TWIN$"      // YES (Text Window Status)
#define RIP_TWFONT        "$TWFONT$"    // 1 (Active Text Font)
#define RIP_TWH           "$TWH$"       // 25 (Text Window Height)
#define RIP_TWW           "$TWW$"       // 80 (Text Window Width)
#define RIP_TWX0          "$TWX0$"      // 0 (Text Window X0)
#define RIP_TWY0          "$TWY0$"      // 0 (Text Window Y0)
#define RIP_TWX1          "$TWX1$"      // 0 (Text Window X1)
#define RIP_TWY1          "$TWY1$"      // 0 (Text Window Y1)
#define RIP_CURX          "$CURX$"      // 2 (Text Cursor X)
#define RIP_CURY          "$CURY$"      // 2 (Text Cursor Y)
#define RIP_CON           "$CON$"       // Enable Text Cursor
#define RIP_COFF          "$COFF$"      // Disable Text Cursor
#define RIP_CURSOR        "$CURSOR$"    // YES (Text Cursor Status)
#define RIP_SCB           "$SCB$"       // Save ClipBoard
#define RIP_RCB           "$RCB$"       // Restore Clipboard
#define RIP_PCB           "$PCB$"       // Paste Clipboard
#define RIP_STATBAR       "$STATBAR$"   // YES (Status Bar Status)
#define RIP_BARON         "$BARON$"     // Show Status Bar
#define RIP_BAROFF        "$BAROFF$"    // Hide Status Bar
#define RIP_VT102ON       "$VT102ON$"   // Turn on VT-102 keyboard mode
#define RIP_VT102OFF      "$VT102OFF$"  // Turn off VT-102 keyboard mode
#define RIP_DWAYON        "$DWAYON$"    // Turn on doorway mode
#define RIP_DWAYOFF       "$DWAYOFF$"   // Turn off doorway mode
#define RIP_HKEYON        "$HKEYON$"    // Enable hotkeys
#define RIP_HKEYOFF       "$HKEYOFF$"   // Disable hotkeys
#define RIP_TABON         "$TABON$"     // Enable TAB key Mouse Field select
#define RIP_TABOFF        "$TABOFF$"    // Disable TAB key Mouse Field select
#define RIP_APP0          "$APP0$"      // External Application #0 Call
#define RIP_APP1          "$APP1$"      // External Application #1 Call
#define RIP_APP2          "$APP2$"      // External Application #2 Call
#define RIP_APP3          "$APP3$"      // External Application #3 Call
#define RIP_APP4          "$APP4$"      // External Application #4 Call
#define RIP_APP5          "$APP5$"      // External Application #5 Call
#define RIP_APP6          "$APP6$"      // External Application #6 Call
#define RIP_APP7          "$APP7$"      // External Application #7 Call
#define RIP_APP8          "$APP8$"      // External Application #8 Call
#define RIP_APP9          "$APP9$"      // External Application #9 Call
