;
;   Copyright (C) 1994 Moir Brandts Honk
;   Distributed under license by the Free Software Foundation, Inc.
;
;This file is part of MBH PEX development kit.
;
;MBH PEX LIB is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation; either version 2, or (at your option)
;any later version.
;
;MBH PEX LIB is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with MBH PEX LIB; see the file COPYING.  If not, write to
;the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;
;Report problems and direct all questions to:
;
;
;Moir Brandts Honk      LINEA DATARUM & TABULA FIBULARUM       Moir Brandts Honk
;
;    (sysop -[TJS]-)
;    The Netherlands
;
;    netmail:
;         Fido: 2:281/522.7
;         THANet Hub: 70:3170/100
;
;    phone:
;                USR/DS: +31-70-3461215
;          ZyXEL 1496E+: +31-70-3457929
;         LineLink 144e: +31-70-3452981
;
;    Snail Mail:
;         P.O. Box 709
;         2501 CS  Den Haag
;         The Netherlands
;
;------------------------------------------------------------------------------
;
; This module defines the startup code to be linked with your code...
;
; Note that this object is required to be the first one in your
; object list as transferred to the linker...
;
; Completely replaces C0L.OBJ (large model Borland standard startup code)
;
; For use with the PEX (Proboard Executable) library
;
; Code (c) June 1994, Insh_Allah
;
; small parts are adapted from the
; Borland C/C++ Run Time Library - Version 5.0
; Copyright (c) 1987, 1992 by Borland International
; All Rights Reserved.
;

                   .286

                   locals

                   DGROUP GROUP _DATA,XIFB,XIFE,XCFB,XCFE,_INIT_,_INITEND_,_EXIT_,_EXITEND_,_BSS,_BSSEND

;
;                  Segment and Group declarations
;
_TEXT              SEGMENT BYTE PUBLIC 'CODE'
                   ENDS
_FARDATA           SEGMENT PARA PUBLIC 'FAR_DATA'
                   ENDS
_FARBSS            SEGMENT PARA PUBLIC 'FAR_BSS'
                   ENDS
_DATA              SEGMENT PARA PUBLIC 'DATA'
                   ENDS

;
; the following four segments are used by the Borland compiler
; for:
; 1) C++ global initializers & destructors
; 2) #pragma init & exit functions...
;
_INIT_             SEGMENT WORD PUBLIC 'INITDATA'
InitStart          label byte
                   ENDS
_INITEND_          SEGMENT BYTE PUBLIC 'INITDATA'
InitEnd            label byte
                   ENDS
_EXIT_             SEGMENT WORD PUBLIC 'EXITDATA'
ExitStart          label byte
                   ENDS
_EXITEND_          SEGMENT BYTE PUBLIC 'EXITDATA'
ExitEnd            label byte
                   ENDS

;
; the following four segments are 'used' by Proboard users who like
; to run a list of functions of type 'void init(void);' or
; 'void exit(void)' for initializers & destructors respectively...
;
; the initializers located in the XIF segement are executed after
; all functions in segment 'INITDATA' are executed, while
; the destructors inside the XCF segement are executed _before_
; all destructors in the segment 'EXITDATA' have executed...
;
; best guess is, the two segments represent the Microsoft C++
; equivalent of the segments INITDATA and EXIDATA ...
;
XIFB               SEGMENT WORD PUBLIC 'XIF'
PexInitStart       label byte
                   ENDS
XIFE               SEGMENT BYTE PUBLIC 'XIF'
PexInitEnd         label byte
                   ENDS
XCFB               SEGMENT WORD PUBLIC 'XCF'
PexExitStart       label byte
                   ENDS
XCFE               SEGMENT BYTE PUBLIC 'XCF'
PexExitEnd         label byte
                   ENDS

;
; some more regular segment definitions...
;
_BSS               SEGMENT WORD PUBLIC 'BSS'
                   ENDS
_BSSEND            SEGMENT BYTE PUBLIC 'BSSEND'
                   ENDS
_STACK             SEGMENT STACK 'STACK'
                   ENDS

;
; structure definition of message when PEX is called as normal MSDOS
; executable...
;
ME                 STRUC               ; message struct
messagesize        dw        ?         ; length of message in bytes
messagestring      dd        ?         ; pointer to the message itself...
ME                 ENDS

                   ASSUME  CS:_TEXT, DS:DGROUP

; External References

extrn              _PB_DOS_Message:FAR ; Message struct pointer...

extrn              _main:FAR
extrn              _exit:FAR           ; defined in 'atexit.asm'

                   SUBTTL    Start Up Code
                   PAGE
;
;
;
;                            Start Up Code                                                                                   */
;                            ~~~~~~~~~~~~~                                                                                   */
;
;
;

STACKSIZE          equ       128       ; OWN_STACK size

;
; At the start, DS and ES both point to the segment prefix.
; SS points to the stack segment
;

_TEXT              SEGMENT
                   assume  cs:_TEXT

;------------------------------------------------------------  CODE  ----

;
;
;                 Proboard entry hook block!
;
;

entry_Cleanup      dw        offset _PB_Cleanup, seg _PB_Cleanup

                                       ; This is the first entry of the
                                       ; Proboard V2.x jump-table. This
                                       ; pointer directs PB to the global
                                       ; Initializer routines which are
                                       ; used to run various pieces of
                                       ; init-code, e.g. C++ Constructors
                                       ; of globally declared objects.
                                       ; NOTE that these pieces of code
                                       ; are run BEFORE main() is called!

entry_Init         dw        offset _PB_Initialize2, seg _PB_Initialize2

                                       ; This is the second entry of the
                                       ; Proboard V2.x jump-table. This
                                       ; pointer directs PB to the global
                                       ; Cleanup routines which are used
                                       ; to run various pieces of
                                       ; cleanup-code, e.g. C++
                                       ; Destructors of globally declared
                                       ; objects. NOTE that these pieces
                                       ; of code are executed AFTER the
                                       ; PEX main() program has exitted!

PB_recog_1         dw        4250h
                                       ; Proboard searches the binary .PEX
                                       ; file for two sequences, located
                                       ; at the labels 'PB_recog_1' and
                                       ; 'PB_recog_2' respectively.
                                       ;
                                       ; 'PB_recog_1' must be filled with
                                       ; the byte-sequence "PB".
                                       ;
                                       ; 'PB_recog_2' must be filled with
                                       ; one word. This word contains the
                                       ; version of the Proboard SDK
                                       ; module the PEX binary has been
                                       ; compiled with, multiplied by
                                       ; 100(decimal). Thus v2.01 will
                                       ; result in the byte sequence 'C9
                                       ; 00'...

entry_Main         dw        offset _PB_main_entry, seg _PB_main_entry

                                       ; This is the third entry of the
                                       ; Proboard V2.x jump-table. This
                                       ; pointer directs PB to the main
                                       ; part of your program. After
                                       ; executing a couple of necessary
                                       ; initializations, the main()
                                       ; function is called...

entry_FunctionTable dw       offset _func_ptr_tbl_PB_, seg _func_ptr_tbl_PB_

                                       ; This is the fourth entry of the
                                       ; Proboard V2.x jump-table. This
                                       ; pointer directs PB to the
                                       ; function pointer table which is
                                       ; filled by PB with pointers to
                                       ; functions which are made globally
                                       ; avialable from inside Proboard,
                                       ; e.g. printf(), WaitKey() and many
                                       ; others.

entry_VariableTable dw       offset CurUser, seg CurUser

                                       ; This is the fifth entry of the
                                       ; Proboard V2.x jump-table. This
                                       ; pointer directs PB to the data
                                       ; pointer table which is filled by
                                       ; PB with variable values which are
                                       ; made globally avialable from
                                       ; inside Proboard, e.g. NodeNumber.
                                       ; NOTE that everyone of these
                                       ; values are READ-ONLY, as they are
                                       ; defined 'const' in the
                                       ; headerfile...

PB_recog_2         dw        0C9h
                                       ; Proboard searches the binary .PEX
                                       ; file for two sequences, located
                                       ; at the labels 'PB_recog_1' and
                                       ; 'PB_recog_2' respectively.
                                       ;
                                       ; 'PB_recog_1' must be filled with
                                       ; the byte-sequence "PB".
                                       ;
                                       ; 'PB_recog_2' must be filled with
                                       ; one word. This word contains the
                                       ; version of the Proboard SDK
                                       ; module the PEX binary has been
                                       ; compiled with, multiplied by
                                       ; 100(decimal). Thus v2.01 will
                                       ; result in the byte sequence 'C9
                                       ; 00'...

;
;         dos entry code for non-Proboard calls
;

;
;
;                       program entry point
;
;

dosentry           proc      near

                   mov       ax,DGROUP
                   mov       ds,ax
                   lds       bx,dword ptr _PB_DOS_Message ; ('ProBoard SDK 2.01')
                   mov       ax,ds               ; test if NULL pointer...
                   or        ax,bx
                   jz        @@No_Message

                   mov       cx,ds:[bx.messagesize]   ; length of message
                   lds       dx,ds:[bx.messagestring]
                   mov       bx,1                ; stdout
                   mov       ah,40H
                   int       21h                 ; DOS Services  ah=function 40h
                                                 ;  write buffer at ds:dx
@@No_Message:      mov       ax,4C01h
                   int       21h                 ; DOS Services  ah=function 4Ch
                                                 ;  terminate with al=return code

old_sp_stored      dw        0                   ; pushed SP value on entry of main()
                                                 ;  of Proboard
dosentry           endp

;
;         the main() Proboard entry point
;

_PB_main_entry     proc      far
                   public    C _PB_main_entry

                   push      bp
                   mov       bp,sp

                   mov       cs:old_sp_stored,sp

                   mov       ax,DGROUP
                   mov       ds,ax

                   ;
                   ; the real Initialize: Proboard doesn't init the DATA
                   ; segement BEFORE Initialization phase but after ... 8-[[[
                   ;
                   ; So we decided to move the initialize code into the
                   ; main part of the PEX startup code...
                   ;
                   call      _PB_Initialize      ; init everything for C/C++

                   push      cs                  ; segment envp_fake
                   push      offset envp_fake    ; for the nerdz: envp[0] == NULL
                   ;
                   ; now let's go for 'argv'
                   ;
                   push      es
                   les       bx,[bp+08h]
                   push      word ptr [bp+0Ah]
                   push      word ptr [bp+8]
                   ;
                   ; and last of all: 'argc'
                   ;
                   mov       ax,[bp+6]
                   ;
                   ; fix 'argv[]' bugs in Proboard PEX interface: no more
                   ; than 9 PEX parameters (argc > 10 fails!)
                   ;
                   cmp       ax,10
                   jbe       @@no_philippe_fix
                   mov       ax,10
@@no_philippe_fix:
                   push      ax
                   ;
                   ; fix argv[argc] = NULL
                   ;
                   shl       ax,2                ; ax * 4
                   add       bx,ax
                   xor       ax,ax               ; 0
                   mov       es:[bx],ax
                   mov       es:[bx+2],ax

                   call      far ptr _main
                   ;
                   ; since Proboard has 'void exit(void);' it is logical
                   ; that 'main()' doesn't return any return-value either.
                   ; No AX return value to consider here...
                   ;
                   ; no stack correction required either...
                   ;
                   jmp       _exit               ; resolve atexit() functions

return_to_PB:
                   push      cs:PB_recog_1
                   pop       ds
                   pop       bp
                   retf                          ; Return far

envp_fake:         dd        0                   ; NULL pointer...

_PB_main_entry               endp

;
;         Proboard made this func avialable...
;

___exit            proc      far
                   public    C ___exit

                   xor       ax,ax               ; return value:
                                                 ; 0 = not TSR
exit_to_PB:
                   mov       sp,cs:old_sp_stored
                   jmp       short return_to_PB

___exit            endp


;
;         Proboard made this func avialable...
;

ExitTSR            proc      far
                   public    C ExitTSR

                   mov       ax,-1               ; return value:
                                                 ; -1 = PEX TSR style exit
                   mov       sp,cs:old_sp_stored
                   jmp       short return_to_PB

ExitTSR            endp


;
;         Proboard entry point for initialization BEFORE main()
;

_PB_Initialize2    proc      far
                   ;
                   ; just return...
                   ; init is done lateron...
                   ;
                   push      bp                  ; prepare stack correctly ...

                   jmp       short return_to_PB  ; and do a do-nothing

_PB_Initialize2    endp

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; _PB_Initialize has been moved to the main part.
;
; Philippe Leybaert should explain what _PB_Init_Xtra and Co. should
; do, since I've not discovered any .PEX which forces the extra funcs
; to do anything more but to return after checking two offsets are
; equal... (segments XIF & XCF are empty...)
;
; This code has been included for educational purposes only :-)
;

_PB_Initialize     proc      near

                   push      bp
                   mov       bp,sp
                   push      si
                   push      di
                   mov       ax,DGROUP
                   mov       ds,ax
                   mov       es,ax
                   mov       si,offset DGROUP:InitStart    ; si = start of table
                   mov       di,offset DGROUP:InitEnd      ; di = end of table
                   call      Initialize
                   call      _PB_Init_Xtra
                   pop       di
                   pop       si
                   pop       bp
                   ret

_PB_Initialize     endp

;
;         Proboard entry point for cleanup AFTER main()
;

_PB_Cleanup        proc      far
                   push      bp                  ; prepare stack correctly ...
                   mov       bp,sp
                   push      si
                   push      di
                   mov       ax,DGROUP
                   mov       ds,ax
                   mov       es,ax
                   call      _PB_Cleanup_Xtra    ; original SDK kit: called AFTER 'Cleanup'
                          
                   mov       ax,DGROUP
                   mov       ds,ax
                   mov       es,ax
                   mov       si,offset DGROUP:ExitStart
                   mov       di,offset DGROUP:ExitEnd
                   call      Cleanup
          
                   pop       di
                   pop       si

                   jmp       short return_to_PB  ; and do return

_PB_Cleanup        endp
                   
;
;         Initialize C++ global constructors...
;

; ripped from the Borland C++ 3.x C0.ASM code. (Like Philippe did too!)

;------------------------------------------------------------------
;       Loop through a startup/exit (SE) table,
;       calling functions in order of priority.
;       ES:SI is assumed to point to the beginning of the SE table
;       ES:DI is assumed to point to the end of the SE table
;       First 64 priorities are reserved by Borland
;------------------------------------------------------------------

PNEAR              EQU       0
PFAR               EQU       1
NOTUSED            EQU       0ffh

SE                 STRUC
calltype           db        ?                                                               ; 0=near,1=far,ff=not used
priority           db        ?                                                               ; 0=highest,ff=lowest
addrlow            dw        ?
addrhigh           dw        ?
SE                 ENDS

Initialize         proc near

@@Start:           mov       ax,100h             ; start with lowest priority
                   mov       dx,di               ; sentinel to end of table
                   mov       bx,si               ; bx = start of table

@@TopOfTable:      cmp       bx,di               ; and the end of the table?
                   je        @@EndOfTable        ; yes, exit the loop
                   cmp       es:[bx.calltype],NOTUSED  ; check the call type
                   je        @@Next
                   mov       cl, es:[bx.priority]    ; move priority to CX
                   xor       ch, ch
                   cmp       cx,ax               ; check the priority
                   jae       @@Next              ; too high?      skip
                   mov       ax,cx               ; keep priority
                   mov       dx,bx               ; keep index in dx
@@Next:            add       bx,SIZE SE          ; bx = next item in table
                   jmp       @@TopOfTable

@@EndOfTable:      cmp       dx,di               ; did we exhaust the table?
                   je        @@Done              ; yes, quit
                   mov       bx,dx               ; bx = highest priority item
                   cmp       es:[bx.calltype],PNEAR    ; is it near or far?
                   mov       es:[bx.calltype],NOTUSED  ; wipe the call type
                   push      es                        ; save es
                   je        @@NearCall

@@FarCall:         call      DWORD PTR es:[bx.addrlow]
                   pop       es                  ; restore es
                   jmp       short @@Start

@@NearCall:        call      WORD PTR es:[bx.addrlow]
                   pop       es                  ; restore es
                   jmp       short @@Start

@@Done:            ret

                   endp

;
; For educational purposes: the commented code below is Philippe's:
; compare with the code above and be surprised ;-))
;
; Initialize      proc    far
; loc_16:
;                 mov     ax,100h
;                 mov     dx,di
;                 mov     bx,si
; loc_17:
;                 cmp     bx,di
;                 je      loc_19
;                 cmp     byte ptr es:[bx],0FFh
;                 je      loc_18
;                 mov     cl,es:[bx+1]
;                 xor     ch,ch
;                 cmp     cx,ax
;                 jae     loc_18
;                 mov     ax,cx
;                 mov     dx,bx
; loc_18:
;                 add     bx,6
;                 jmp     short loc_17
; loc_19:
;                 cmp     dx,di
;                 je      loc_ret_21
;                 mov     bx,dx
;                 cmp     byte ptr es:[bx],0
;                 mov     byte ptr es:[bx],0FFh
;                 push    es
;                 jz      loc_20
;                 call    dword ptr es:[bx+2]
;                 pop     es
;                 jmp     short loc_16
; loc_20:
;                 call    word ptr es:[bx+2]
;                 pop     es
;                 jmp     short loc_16
;
; loc_ret_21:
;                 retn
;
; Initialize      endp
;

;
;         Run C++ global destructors...
;

Cleanup            proc near

@@Start:           mov     ah,0                    ; start with highest priority
                   mov     dx,di                   ; set sentinel to end of table
                   mov     bx,si                   ; bx = start of table

@@TopOfTable:      cmp     bx,di                   ; and the end of the table?
                   je      @@EndOfTable            ; yes, exit the loop
                   cmp     es:[bx.calltype],NOTUSED; check the call type
                   je      @@Next
                   cmp     es:[bx.priority],ah     ; check the priority
                   jb      @@Next                  ; too low?  skip
                   mov     ah,es:[bx.priority]     ; keep priority
                   mov     dx,bx                   ; keep index in dx
@@Next:            add     bx,SIZE SE              ; bx = next item in table
                   jmp     @@TopOfTable

@@Done:            ret

@@EndOfTable:      cmp     dx,di                   ; did we exhaust the table?
                   je      @@Done                  ; yes, quit
                   mov     bx,dx                   ; bx = highest priority item
                   cmp     es:[bx.calltype],PNEAR  ; is it near or far?
                   mov     es:[bx.calltype],NOTUSED; wipe the call type
                   push    es                      ; save es
                   je      @@NearCall

@@FarCall:
                   call    DWORD PTR es:[bx.addrlow]
                   pop     es                      ; restore es
                   jmp     @@Start

@@NearCall:
                   call    WORD PTR es:[bx.addrlow]
                   pop     es                      ; restore es
                   jmp     @@Start

                   endp

;------------------------------------------------------------------
;
; Same comment as for Initialize: The code below is Philippe's...
;
; Cleanup         proc    far
; loc_22:
;                 mov     ah,0
;                 mov     dx,di
;                 mov     bx,si
; loc_23:
;                 cmp     bx,di
;                 je      loc_25
;                 cmp     byte ptr es:[bx],0FFh
;                 je      loc_24
;                 cmp     es:[bx+1],ah
;                 jb      loc_24
;                 mov     ah,es:[bx+1]
;                 mov     dx,bx
; loc_24:
;                 add     bx,6
;                 jmp     short loc_23
; loc_25:
;                 cmp     dx,di
;                 je      loc_ret_27
;                 mov     bx,dx
;                 cmp     byte ptr es:[bx],0
;                 mov     byte ptr es:[bx],0FFh
;                 push    es
;                 jz      loc_26
;                 call    dword ptr es:[bx+2]
;                 pop     es
;                 jmp     short loc_22
; loc_26:
;                 call    word ptr es:[bx+2]
;                 pop     es
;                 jmp     short loc_22
;
; loc_ret_27:
;                 retn
;
; Cleanup         endp
;

;
;         Proboard: extra (unused?) function for initializers
;

_PB_Init_Xtra   proc    near

;
; Philippe's code incorporated an empty, unused
; segment called XIF, which will probably be
; filled with a list of function pointers, which
; are sequentially called...
;
; use of this segment is unknown...
;
                   mov     di,offset DGROUP:PexInitStart        ;di = start of table
loc_28:
                   cmp     di,offset DGROUP:PexInitEnd
                   jbe     loc_ret_30
                   sub     di,4
                   mov     ax,[di]
                   or      ax,[di+2]
                   jz      loc_29
                   call    dword ptr [di]
loc_29:
                   jmp     short loc_28
loc_ret_30:
                   ret

_PB_Init_Xtra   endp


;
;         Proboard: extra (unused?) function for destructors (cleanup)
;

_PB_Cleanup_Xtra        proc    near

;
; Philippe's code incorporated an empty, unused
; segment called XCF, which will probably be
; filled with a list of function pointers, which
; are sequentially called...
;
; use of this segment is unknown...
;

                   mov     di,offset DGROUP:PexExitStart        ;di = start of table
loc_31:
                   cmp     di,offset DGROUP:PexExitEnd
                   jae     loc_ret_33
                   mov     ax,[di]
                   or      ax,[di+2]
                   jz      loc_32
                   call    dword ptr [di]
loc_32:
                   add     di,4
                   jmp     short loc_31
loc_ret_33:
                   ret

_PB_Cleanup_Xtra        endp


;
;
; The function pointer table...
; At version 2.01, Proboard consumes 211 entries...
;
;
;
; __bsearch() and __qsort() are unsupported (NULL-pointers) by Proboard.
;

_func_ptr_tbl_PB_  dd        256 dup ( 87654321h )         ; Proboard function addresses table [256]


;
;         common used caller to globally available Proboard functions
;

_call_ext_func_PB_ proc    far

                   mov     bx,offset _func_ptr_tbl_PB_
                   mov     cl,2
                   xor     ah,ah
                   shl     ax,cl
                   add     bx,ax
                   push    cs:PB_recog_1
                   pop     ds
                   call    dword ptr cs:[bx]
                   mov     cx,seg DGROUP
                   mov     ds,cx
                   ret

_call_ext_func_PB_ endp


;
;         Proboard made this func avialable...
;

l_mul              proc    far
                   public C l_mul
                   mov     al,0
                   jmp     short _call_ext_func_PB_
l_mul              endp


;
;         Proboard made this func avialable...
;

l_div              proc    far
                   public C l_div
                   mov     al,1
                   jmp     short _call_ext_func_PB_
l_div              endp


;
;         Proboard made this func avialable...
;

l_mod              proc    far
                   public C l_mod
                   mov     al,2
                   jmp     short _call_ext_func_PB_
l_mod              endp


;
;         Proboard made this func avialable...
;

ul_div             proc    far
                   public C ul_div
                   mov     al,3
                   jmp     short _call_ext_func_PB_
ul_div             endp


;
;         Proboard made this func avialable...
;

ul_mod             proc    far
                   public C ul_mod
                   mov     al,4
                   jmp     short _call_ext_func_PB_
ul_mod             endp


;
;         Proboard made this func avialable...
;

l_shl              proc    far
                   public C l_shl
                   mov     al,5
                   jmp     short _call_ext_func_PB_
l_shl              endp


;
;         Proboard made this func avialable...
;

l_shr              proc    far
                   public C l_shr
                   mov     al,6
                   jmp     short _call_ext_func_PB_
l_shr              endp


;
;         Proboard made this func avialable...
;

ul_shl             proc    far
                   public C ul_shl
                   mov     al,7
                   jmp     short _call_ext_func_PB_
ul_shl             endp


;
;         Proboard made this func avialable...
;

ul_shr             proc    far
                   public C ul_shr
                   mov     al,8
                   jmp     short _call_ext_func_PB_
ul_shr             endp


;
;         Proboard made this func avialable...
;

fopen              proc    far
                   public C fopen
                   mov     al,9
                   jmp     short _call_ext_func_PB_
fopen              endp


;
;         Proboard made this func avialable...
;

freopen            proc    far
                   public C freopen
                   mov     al,0Ah
                   jmp     short _call_ext_func_PB_
freopen            endp


;
;         Proboard made this func avialable...
;

fseek              proc    far
                   public C fseek
                   mov     al,0Bh
                   jmp     short _call_ext_func_PB_
fseek              endp


;
;         Proboard made this func avialable...
;

ftell              proc    far
                   public C ftell
                   mov     al,0Ch
                   jmp     short _call_ext_func_PB_
ftell              endp


;
;         Proboard made this func avialable...
;

fgets              proc    far
                   public C fgets
                   mov     al,0Dh
                   jmp     short _call_ext_func_PB_
fgets              endp


;
;         Proboard made this func avialable...
;

fgetc              proc    far
                   public C fgetc
                   mov     al,0Eh
                   jmp     short _call_ext_func_PB_
fgetc              endp


;
;         Proboard made this func avialable...
;

fflush             proc    far
                   public C fflush
                   mov     al,0Fh
                   jmp     short _call_ext_func_PB_
fflush             endp


;
;         Proboard made this func avialable...
;

fclose             proc    far
                   public C fclose
                   mov     al,10h
                   jmp     short _call_ext_func_PB_
fclose             endp


;
;         Proboard made this func avialable...
;

fputs              proc    far
                   public C fputs
                   mov     al,11h
                   jmp     short _call_ext_func_PB_
fputs              endp


;
;         Proboard made this func avialable...
;

getc               proc    far
                   public C getc
                   mov     al,12h
                   jmp     short _call_ext_func_PB_
getc               endp


;
;         Proboard made this func avialable...
;

getchar            proc    far
                   public C getchar
                   mov     al,13h
                   jmp     short _call_ext_func_PB_
getchar            endp


;
;         Proboard made this func avialable...
;

gets               proc    far
                   public C gets
                   mov     al,14h
                   jmp     short _call_ext_func_PB_
gets               endp


;
;         Proboard made this func avialable...
;

fputc              proc    far
                   public C fputc
                   mov     al,15h
                   jmp     short _call_ext_func_PB_
fputc              endp


;
;         Proboard made this func avialable...
;

putc               proc    far
                   public C putc
                   mov     al,16h
                   jmp     short _call_ext_func_PB_
putc               endp


;
;         Proboard made this func avialable...
;

putchar            proc    far
                   public C putchar
                   mov     al,17h
                   jmp     short _call_ext_func_PB_
putchar            endp


;
;         Proboard made this func avialable...
;

puts               proc    far
                   public C puts
                   mov     al,18h
                   jmp     short _call_ext_func_PB_
puts               endp


;
;         Proboard made this func avialable...
;

fread              proc    far
                   public C fread
                   mov     al,19h
                   jmp     _call_ext_func_PB_
fread              endp


;
;         Proboard made this func avialable...
;

fwrite             proc    far
                   public C fwrite
                   mov     al,1Ah
                   jmp     _call_ext_func_PB_
fwrite             endp


;
;         Proboard made this func avialable...
;

printf             proc    far
                   public C printf
                   mov     al,1Bh
                   jmp     _call_ext_func_PB_
printf             endp


;
;         Proboard made this func avialable...
;

fprintf            proc    far
                   public C fprintf
                   mov     al,1Ch
                   jmp     _call_ext_func_PB_
fprintf            endp


;
;         Proboard made this func avialable...
;

vfprintf           proc    far
                   public C vfprintf
                   mov     al,1Dh
                   jmp     _call_ext_func_PB_
vfprintf           endp


;
;         Proboard made this func avialable...
;

vprintf            proc    far
                   public C vprintf
                   mov     al,1Eh
                   jmp     _call_ext_func_PB_
vprintf            endp


;
;         Proboard made this func avialable...
;

sprintf            proc    far
                   public C sprintf
                   mov     al,1Fh
                   jmp     _call_ext_func_PB_
sprintf            endp


;
;         Proboard made this func avialable...
;

vsprintf           proc    far
                   public C vsprintf
                   mov     al,20h
                   jmp     _call_ext_func_PB_
vsprintf           endp


;
;         Proboard made this func avialable...
;

setbuf             proc    far
                   public C setbuf
                   mov     al,21h
                   jmp     _call_ext_func_PB_
setbuf             endp


;
;         Proboard made this func avialable...
;

setvbuf            proc    far
                   public C setvbuf
                   mov     al,22h
                   jmp     _call_ext_func_PB_
setvbuf            endp


;
;         Proboard made this func avialable...
;

rename             proc    far
                   public C rename
                   mov     al,23h
                   jmp     _call_ext_func_PB_
rename             endp


;
;         Proboard made this func avialable...
;

rewind             proc    far
                   public C rewind
                   mov     al,24h
                   jmp     _call_ext_func_PB_
rewind             endp


;
;         Proboard made this func avialable...
;

clearerr           proc    far
                   public C clearerr
                   mov     al,25h
                   jmp     _call_ext_func_PB_
clearerr           endp


;
;         Proboard made this func avialable...
;

feof               proc    far
                   public C feof
                   mov     al,26h
                   jmp     _call_ext_func_PB_
feof               endp


;
;         Proboard made this func avialable...
;

isalnum            proc    far
                   public C isalnum
                   mov     al,27h
                   jmp     _call_ext_func_PB_
isalnum            endp


;
;         Proboard made this func avialable...
;

isalpha            proc    far
                   public C isalpha
                   mov     al,28h
                   jmp     _call_ext_func_PB_
isalpha            endp


;
;         Proboard made this func avialable...
;

iscntrl            proc    far
                   public C iscntrl
                   mov     al,29h
                   jmp     _call_ext_func_PB_
iscntrl            endp


;
;         Proboard made this func avialable...
;

isdigit            proc    far
                   public C isdigit
                   mov     al,2Ah
                   jmp     _call_ext_func_PB_
isdigit            endp


;
;         Proboard made this func avialable...
;

isgraph            proc    far
                   public C isgraph
                   mov     al,2Bh
                   jmp     _call_ext_func_PB_
isgraph            endp


;
;         Proboard made this func avialable...
;

islower            proc    far
                   public C islower
                   mov     al,2Ch
                   jmp     _call_ext_func_PB_
islower            endp


;
;         Proboard made this func avialable...
;

isprint            proc    far
                   public C isprint
                   mov     al,2Dh
                   jmp     _call_ext_func_PB_
isprint            endp


;
;         Proboard made this func avialable...
;

ispunct            proc    far
                   public C ispunct
                   mov     al,2Eh
                   jmp     _call_ext_func_PB_
ispunct            endp


;
;         Proboard made this func avialable...
;

isspace            proc    far
                   public C isspace
                   mov     al,2Fh
                   jmp     _call_ext_func_PB_
isspace            endp


;
;         Proboard made this func avialable...
;

isupper            proc    far
                   public C isupper
                   mov     al,30h
                   jmp     _call_ext_func_PB_
isupper            endp


;
;         Proboard made this func avialable...
;

isxdigit           proc    far
                   public C isxdigit
                   mov     al,31h
                   jmp     _call_ext_func_PB_
isxdigit           endp


;
;         Proboard made this func avialable...
;

toupper            proc    far
                   public C toupper
                   mov     al,32h
                   jmp     _call_ext_func_PB_
toupper            endp


;
;         Proboard made this func avialable...
;

tolower            proc    far
                   public C tolower
                   mov     al,33h
                   jmp     _call_ext_func_PB_
tolower            endp


;
;         Proboard made this func avialable...
;

int86              proc    far
                   public C int86
                   mov     al,34h
                   jmp     _call_ext_func_PB_
int86              endp


;
;         Proboard made this func avialable...
;

int86x             proc    far
                   public C int86x
                   mov     al,35h
                   jmp     _call_ext_func_PB_
int86x             endp


;
;         Proboard made this func avialable...
;

intdos             proc    far
                   public C intdos
                   mov     al,36h
                   jmp     _call_ext_func_PB_
intdos             endp


;
;         Proboard made this func avialable...
;

intdosx            proc    far
                   public C intdosx
                   mov     al,37h
                   jmp     _call_ext_func_PB_
intdosx            endp


;
;         Proboard made this func avialable...
;

dos_findfirst      proc    far
                   public C dos_findfirst
                   mov     al,38h
                   jmp     _call_ext_func_PB_
dos_findfirst      endp


;
;         Proboard made this func avialable...
;

dos_findnext       proc    far
                   public C dos_findnext
                   mov     al,39h
                   jmp     _call_ext_func_PB_
dos_findnext       endp


;
;         Proboard made this func avialable...
;

read               proc    far
                   public C read
                   mov     al,3Ah
                   jmp     _call_ext_func_PB_
read               endp


;
;         Proboard made this func avialable...
;

write              proc    far
                   public C write
                   mov     al,3Bh
                   jmp     _call_ext_func_PB_
write              endp


;
;         Proboard made this func avialable...
;

open               proc    far
                   public C open
                   mov     al,3Ch
                   jmp     _call_ext_func_PB_
open               endp


;
;         Proboard made this func avialable...
;

creat              proc    far
                   public C creat
                   mov     al,3Dh
                   jmp     _call_ext_func_PB_
creat              endp


;
;         Proboard made this func avialable...
;

close              proc    far
                   public C close
                   mov     al,3Eh
                   jmp     _call_ext_func_PB_
close              endp


;
;         Proboard made this func avialable...
;

unlink             proc    far
                   public C unlink
                   mov     al,3Fh
                   jmp     _call_ext_func_PB_
unlink             endp


;
;         Proboard made this func avialable...
;

remove             proc    far
                   public C remove
                   mov     al,40h
                   jmp     _call_ext_func_PB_
remove             endp


;
;         Proboard made this func avialable...
;

chsize             proc    far
                   public C chsize
                   mov     al,41h
                   jmp     _call_ext_func_PB_
chsize             endp


;
;         Proboard made this func avialable...
;

dup                proc    far
                   public C dup
                   mov     al,42h
                   jmp     _call_ext_func_PB_
dup                endp


;
;         Proboard made this func avialable...
;

dup2               proc    far
                   public C dup2
                   mov     al,43h
                   jmp     _call_ext_func_PB_
dup2               endp


;
;         Proboard made this func avialable...
;

lseek              proc    far
                   public C lseek
                   mov     al,44h
                   jmp     _call_ext_func_PB_
lseek              endp


;
;         Proboard made this func avialable...
;

access             proc    far
                   public C access
                   mov     al,45h
                   jmp     _call_ext_func_PB_
access             endp


;
;         (unofficial) Proboard made this func avialable...
;

filesize           proc    far
                   public C filesize
                   mov     al,46h
                   jmp     _call_ext_func_PB_
filesize           endp


;
;         Proboard made this func avialable...
;

filelength         proc    far
                   public C filelength
                   mov     al,47h
                   jmp     _call_ext_func_PB_
filelength         endp


;
;         Proboard made this func avialable...
;

isatty             proc    far
                   public C isatty
                   mov     al,48h
                   jmp     _call_ext_func_PB_
isatty             endp


;
;         Proboard made this func avialable...
;

atoi               proc    far
                   public C atoi
                   mov     al,49h
                   jmp     _call_ext_func_PB_
atoi               endp


;
;         Proboard made this func avialable...
;

atol               proc    far
                   public C atol
                   mov     al,4Ah
                   jmp     _call_ext_func_PB_
atol               endp


;
;         Proboard made this func avialable...
;

strtol             proc    far
                   public C strtol
                   mov     al,4Bh
                   jmp     _call_ext_func_PB_
strtol             endp


;
;         Proboard made this func avialable...
;

rand               proc    far
                   public C rand
                   mov     al,4Ch
                   jmp     _call_ext_func_PB_
rand               endp


;
;         Proboard made this func avialable...
;

srand              proc    far
                   public C srand
                   mov     al,4Dh
                   jmp     _call_ext_func_PB_
srand              endp


;
;         Proboard made this func avialable...
;

calloc             proc    far
                   public C calloc
                   mov     al,4Eh
                   jmp     _call_ext_func_PB_
calloc             endp


;
;         Proboard made this func avialable...
;

free               proc    far
                   public C free
                   mov     al,4Fh
                   jmp     _call_ext_func_PB_
free               endp


;
;         Proboard made this func avialable...
;

malloc             proc    far
                   public C malloc
                   mov     al,50h
                   jmp     _call_ext_func_PB_
malloc             endp


;
;         Proboard made this func avialable...
;

realloc            proc    far
                   public C realloc
                   mov     al,51h
                   jmp     _call_ext_func_PB_
realloc            endp


;
;         Proboard made this func avialable...
;

getenv             proc    far
                   public C getenv
                   mov     al,52h
                   jmp     _call_ext_func_PB_
getenv             endp


;
;         Proboard made this func avialable...
;

___bsearch         proc    far          ; NOT implemented yet!
                   public C ___bsearch
                   mov     al,53h
                   jmp     _call_ext_func_PB_
___bsearch         endp


;
;         Proboard made this func avialable...
;

___qsort           proc    far          ; NOT implemented yet!
                   public C ___qsort
                   mov     al,54h
                   jmp     _call_ext_func_PB_
___qsort           endp


;
;         Proboard made this func avialable...
;

abs                proc    far
                   public C abs
                   mov     al,55h
                   jmp     _call_ext_func_PB_
abs                endp


;
;         Proboard made this func avialable...
;

labs               proc    far
                   public C labs
                   mov     al,56h
                   jmp     _call_ext_func_PB_
labs               endp


;
;         Proboard made this func avialable...
;

memcpy             proc    far
                   public C memcpy
                   mov     al,57h
                   jmp     _call_ext_func_PB_
memcpy             endp


;
;         Proboard made this func avialable...
;

memmove            proc    far
                   public C memmove
                   mov     al,58h
                   jmp     _call_ext_func_PB_
memmove            endp


;
;         Proboard made this func avialable...
;

strcpy             proc    far
                   public C strcpy
                   mov     al,59h
                   jmp     _call_ext_func_PB_
strcpy             endp


;
;         Proboard made this func avialable...
;

strncpy            proc    far
                   public C strncpy
                   mov     al,5Ah
                   jmp     _call_ext_func_PB_
strncpy            endp


;
;         Proboard made this func avialable...
;

strcat             proc    far
                   public C strcat
                   mov     al,5Bh
                   jmp     _call_ext_func_PB_
strcat             endp


;
;         Proboard made this func avialable...
;

strncat            proc    far
                   public C strncat
                   mov     al,5Ch
                   jmp     _call_ext_func_PB_
strncat            endp


;
;         Proboard made this func avialable...
;

memcmp             proc    far
                   public C memcmp
                   mov     al,5Dh
                   jmp     _call_ext_func_PB_
memcmp             endp


;
;         Proboard made this func avialable...
;

strcmp             proc    far
                   public C strcmp
                   mov     al,5Eh
                   jmp     _call_ext_func_PB_
strcmp             endp


;
;         Proboard made this func avialable...
;

strncmp            proc    far
                   public C strncmp
                   mov     al,5Fh
                   jmp     _call_ext_func_PB_
strncmp            endp


;
;         Proboard made this func avialable...
;

memchr             proc    far
                   public C memchr
                   mov     al,60h
                   jmp     _call_ext_func_PB_
memchr             endp


;
;         Proboard made this func avialable...
;

strchr             proc    far
                   public C strchr
                   mov     al,61h
                   jmp     _call_ext_func_PB_
strchr             endp


;
;         Proboard made this func avialable...
;

strcspn            proc    far
                   public C strcspn
                   mov     al,62h
                   jmp     _call_ext_func_PB_
strcspn            endp


;
;         Proboard made this func avialable...
;

strpbrk            proc    far
                   public C strpbrk
                   mov     al,63h
                   jmp     _call_ext_func_PB_
strpbrk            endp


;
;         Proboard made this func avialable...
;

strrchr            proc    far
                   public C strrchr
                   mov     al,64h
                   jmp     _call_ext_func_PB_
strrchr            endp


;
;         Proboard made this func avialable...
;

strspn             proc    far
                   public C strspn
                   mov     al,65h
                   jmp     _call_ext_func_PB_
strspn             endp


;
;         Proboard made this func avialable...
;

strstr             proc    far
                   public C strstr
                   mov     al,66h
                   jmp     _call_ext_func_PB_
strstr             endp


;
;         Proboard made this func avialable...
;

strtok             proc    far
                   public C strtok
                   mov     al,67h
                   jmp     _call_ext_func_PB_
strtok             endp


;
;         Proboard made this func avialable...
;

memset             proc    far
                   public C memset
                   mov     al,68h
                   jmp     _call_ext_func_PB_
memset             endp


;
;         Proboard made this func avialable...
;

strlen             proc    far
                   public C strlen
                   mov     al,69h
                   jmp     _call_ext_func_PB_
strlen             endp


;
;         Proboard made this func avialable...
;

memicmp            proc    far
                   public C memicmp
                   mov     al,6Ah
                   jmp     _call_ext_func_PB_
memicmp            endp


;
;         Proboard made this func avialable...
;

stpcpy             proc    far
                   public C stpcpy
                   mov     al,6Bh
                   jmp     _call_ext_func_PB_
stpcpy             endp


;
;         Proboard made this func avialable...
;

strcmpl            proc    far
                   public C strcmpl
                   mov     al,6Ch
                   jmp     _call_ext_func_PB_
strcmpl            endp


;
;         Proboard made this func avialable...
;

strnicmp           proc    far
                   public C strnicmp
                   mov     al,6Dh
                   jmp     _call_ext_func_PB_
strnicmp           endp


;
;         Proboard made this func avialable...
;

strdup             proc    far
                   public C strdup
                   mov     al,6Eh
                   jmp     _call_ext_func_PB_
strdup             endp


;
;         Proboard made this func avialable...
;

strlwr             proc    far
                   public C strlwr
                   mov     al,6Fh
                   jmp     _call_ext_func_PB_
strlwr             endp


;
;         Proboard made this func avialable...
;

strupr             proc    far
                   public C strupr
                   mov     al,70h
                   jmp     _call_ext_func_PB_
strupr             endp


;
;         Proboard made this func avialable...
;

strnset            proc    far
                   public C strnset
                   mov     al,71h
                   jmp     _call_ext_func_PB_
strnset            endp


;
;         Proboard made this func avialable...
;

strrev             proc    far
                   public C strrev
                   mov     al,72h
                   jmp     _call_ext_func_PB_
strrev             endp


;
;         Proboard made this func avialable...
;

strset             proc    far
                   public C strset
                   mov     al,73h
                   jmp     _call_ext_func_PB_
strset             endp


;
;         Proboard made this func avialable...
;

swab               proc    far
                   public C swab
                   mov     al,74h
                   jmp     _call_ext_func_PB_
swab               endp


;
;         Proboard made this func avialable...
;

clock              proc    far
                   public C clock
                   mov     al,75h
                   jmp     _call_ext_func_PB_
clock              endp


;
;         Proboard made this func avialable...
;

time               proc    far
                   public C time
                   mov     al,76h
                   jmp     _call_ext_func_PB_
time               endp


;
;         Proboard made this func avialable...
;

mktime             proc    far
                   public C mktime
                   mov     al,77h
                   jmp     _call_ext_func_PB_
mktime             endp


;
;         Proboard made this func avialable...
;

asctime            proc    far
                   public C asctime
                   mov     al,78h
                   jmp     _call_ext_func_PB_
asctime            endp


;
;         Proboard made this func avialable...
;

ctime              proc    far
                   public C ctime
                   mov     al,79h
                   jmp     _call_ext_func_PB_
ctime              endp


;
;         Proboard made this func avialable...
;

localtime          proc    far
                   public C localtime
                   mov     al,7Ah
                   jmp     _call_ext_func_PB_
localtime          endp


;
;         Proboard made this func avialable...
;

gmtime             proc    far
                   public C gmtime
                   mov     al,7Bh
                   jmp     _call_ext_func_PB_
gmtime             endp


;
;         Proboard made this func avialable...
;

strftime           proc    far
                   public C strftime
                   mov     al,7Ch
                   jmp     _call_ext_func_PB_
strftime           endp


;
;         Proboard made this func avialable...
;

sleep              proc    far
                   public C sleep
                   mov     al,7Dh
                   jmp     _call_ext_func_PB_
sleep              endp


;
;         Proboard made this func avialable...
;

usleep             proc    far
                   public C usleep
                   mov     al,7Eh
                   jmp     _call_ext_func_PB_
usleep             endp


;
;         Proboard made this func avialable...
;

msleep             proc    far
                   public C msleep
                   mov     al,7Fh
                   jmp     _call_ext_func_PB_
msleep             endp


;
;         Proboard made this func avialable...
;

form               proc    far
                   public C form
                   mov     al,80h
                   jmp     _call_ext_func_PB_
form               endp


;
;         Proboard made this func avialable...
;

MemAvail           proc    far
                   public C MemAvail
                   mov     al,81h
                   jmp     _call_ext_func_PB_
MemAvail           endp


;
;         Proboard made this func avialable...
;

SetColor           proc    far
                   public C SetColor
                   mov     al,82h
                   jmp     _call_ext_func_PB_
SetColor           endp


;
;         Proboard made this func avialable...
;

MenuFunction       proc    far
                   public C MenuFunction
                   mov     al,83h
                   jmp     _call_ext_func_PB_
MenuFunction       endp


;
;         Proboard made this func avialable...
;

WaitKey            proc    far
                   public C WaitKey
                   mov     al,84h
                   jmp     _call_ext_func_PB_
WaitKey            endp


;
;         Proboard made this func avialable...
;

WaitKeys           proc    far
                   public C WaitKeys
                   mov     al,85h
                   jmp     _call_ext_func_PB_
WaitKeys           endp


;
;         Proboard made this func avialable...
;

Input              proc    far
                   public C Input
                   mov     al,86h
                   jmp     _call_ext_func_PB_
Input              endp


;
;         Proboard made this func avialable...
;

Log                proc    far
                   public C Log
                   mov     al,87h
                   jmp     _call_ext_func_PB_
Log                endp


;
;         Proboard made this func avialable...
;

HangUp             proc    far
                   public C HangUp
                   mov     al,88h
                   jmp     _call_ext_func_PB_
HangUp             endp


;
;         Proboard made this func avialable...
;

PostMessage        proc    far
                   public C PostMessage
                   mov     al,89h
                   jmp     _call_ext_func_PB_
PostMessage        endp


;
;         Proboard made this func avialable...
;

ReadMsgArea        proc    far
                   public C ReadMsgArea
                   mov     al,8Ah
                   jmp     _call_ext_func_PB_
ReadMsgArea        endp


;
;         Proboard made this func avialable...
;

MsgEd              proc    far
                   public C MsgEd
                   mov     al,8Bh
                   jmp     _call_ext_func_PB_
MsgEd              endp


;
;         Proboard made this func avialable...
;

AddTime            proc    far
                   public C AddTime
                   mov     al,8Ch
                   jmp     _call_ext_func_PB_
AddTime            endp


;
;         Proboard made this func avialable...
;

TimeLeft           proc    far
                   public C TimeLeft
                   mov     al,8Dh
                   jmp     _call_ext_func_PB_
TimeLeft           endp


;
;         Proboard made this func avialable...
;

TimeOnline         proc    far
                   public C TimeOnline
                   mov     al,8Eh
                   jmp     _call_ext_func_PB_
TimeOnline         endp


;
;         Proboard made this func avialable...
;

CheckAccess        proc    far
                   public C CheckAccess
                   mov     al,8Fh
                   jmp     _call_ext_func_PB_
CheckAccess        endp


;
;         Proboard made this func avialable...
;

SuspendTimer       proc    far
                   public C SuspendTimer
                   mov     al,90h
                   jmp     _call_ext_func_PB_
SuspendTimer       endp


;
;         Proboard made this func avialable...
;

RestartTimer       proc    far
                   public C RestartTimer
                   mov     al,91h
                   jmp     _call_ext_func_PB_
RestartTimer       endp


;
;         Proboard made this func avialable...
;

_InstallHandler    proc    far
                   public C _InstallHandler
                   mov     al,92h
                   jmp     _call_ext_func_PB_
_InstallHandler    endp


;
;         Proboard made this func avialable...
;

EnableStop         proc    far
                   public C EnableStop
                   mov     al,93h
                   jmp     _call_ext_func_PB_
EnableStop         endp


;
;         Proboard made this func avialable...
;

DisableStop        proc    far
                   public C DisableStop
                   mov     al,94h
                   jmp     _call_ext_func_PB_
DisableStop        endp


;
;         Proboard made this func avialable...
;

Stopped            proc    far
                   public C Stopped
                   mov     al,95h
                   jmp     _call_ext_func_PB_
Stopped            endp


;
;         Proboard made this func avialable...
;

IO_SendByte        proc    far
                   public C IO_SendByte
                   mov     al,96h
                   jmp     _call_ext_func_PB_
IO_SendByte        endp


;
;         Proboard made this func avialable...
;

IO_ReadByte        proc    far
                   public C IO_ReadByte
                   mov     al,97h
                   jmp     _call_ext_func_PB_
IO_ReadByte        endp


;
;         Proboard made this func avialable...
;

IO_Carrier         proc    far
                   public C IO_Carrier
                   mov     al,98h
                   jmp     _call_ext_func_PB_
IO_Carrier         endp


;
;         Proboard made this func avialable...
;

IO_ByteReady       proc    far
                   public C IO_ByteReady
                   mov     al,99h
                   jmp     _call_ext_func_PB_
IO_ByteReady       endp


;
;         Proboard made this func avialable...
;

IO_BufEmpty        proc    far
                   public C IO_BufEmpty
                   mov     al,9Ah
                   jmp     _call_ext_func_PB_
IO_BufEmpty        endp


;
;         Proboard made this func avialable...
;

IO_StartBreak      proc    far
                   public C IO_StartBreak
                   mov     al,9Bh
                   jmp     _call_ext_func_PB_
IO_StartBreak      endp


;
;         Proboard made this func avialable...
;

IO_StopBreak       proc    far
                   public C IO_StopBreak
                   mov     al,9Ch
                   jmp     _call_ext_func_PB_
IO_StopBreak       endp


;
;         Proboard made this func avialable...
;

IO_DTR             proc    far
                   public C IO_DTR
                   mov     al,9Dh
                   jmp     _call_ext_func_PB_
IO_DTR             endp


;
;         Proboard made this func avialable...
;

PostInfo           proc    far
                   public C PostInfo
                   mov     al,9Eh
                   jmp     _call_ext_func_PB_
PostInfo           endp


;
;         Proboard made this func avialable...
;

ShowHotkeyFile     proc    far
                   public C ShowHotkeyFile
                   mov     al,9Fh
                   jmp     _call_ext_func_PB_
ShowHotkeyFile     endp


;
;         Proboard made this func avialable...
;

ShowHotkeyANSIFile      proc    far
                   public C ShowHotkeyANSIFile
                   mov     al,0A0h
                   jmp     _call_ext_func_PB_
ShowHotkeyANSIFile      endp


;
;         Proboard made this func avialable...
;

PlayMusic          proc    far
                   public C PlayMusic
                   mov     al,0A1h
                   jmp     _call_ext_func_PB_
PlayMusic          endp


;
;         Proboard made this func avialable...
;

AdjustTime         proc    far
                   public C AdjustTime
                   mov     al,0A2h
                   jmp     _call_ext_func_PB_
AdjustTime         endp


;
;         Proboard made this func avialable...
;

ReadUser           proc    far
                   public C ReadUser
                   mov     al,0A3h
                   jmp     _call_ext_func_PB_
ReadUser           endp


;
;         Proboard made this func avialable...
;

WriteUser          proc    far
                   public C WriteUser
                   mov     al,0A4h
                   jmp     _call_ext_func_PB_
WriteUser          endp


;
;         Proboard made this func avialable...
;

ReadMessage        proc    far
                   public C ReadMessage
                   mov     al,0A5h
                   jmp     _call_ext_func_PB_
ReadMessage        endp


;
;         Proboard made this func avialable...
;

WriteMSGTMP        proc    far
                   public C WriteMSGTMP
                   mov     al,0A6h
                   jmp     _call_ext_func_PB_
WriteMSGTMP        endp


;
;         Proboard made this func avialable...
;

AppendMSGTMP       proc    far
                   public C AppendMSGTMP
                   mov     al,0A7h
                   jmp     _call_ext_func_PB_
AppendMSGTMP       endp


;
;         Proboard made this func avialable...
;

ShowMessage        proc    far
                   public C ShowMessage
                   mov     al,0A8h
                   jmp     _call_ext_func_PB_
ShowMessage        endp


;
;         Proboard made this func avialable...
;

CreateMessageText       proc    far
                   public C CreateMessageText
                   mov     al,0A9h
                   jmp     _call_ext_func_PB_
CreateMessageText       endp


;
;         Proboard made this func avialable...
;

FirstMessage       proc    far
                   public C FirstMessage
                   mov     al,0AAh
                   jmp     _call_ext_func_PB_
FirstMessage       endp


;
;         Proboard made this func avialable...
;

NextMessage        proc    far
                   public C NextMessage
                   mov     al,0ABh
                   jmp     _call_ext_func_PB_
NextMessage        endp


;
;         Proboard made this func avialable...
;

DeleteMessage      proc    far
                   public C DeleteMessage
                   mov     al,0ACh
                   jmp     _call_ext_func_PB_
DeleteMessage      endp


;
;         Proboard made this func avialable...
;

PostNetmail        proc    far
                   public C PostNetmail
                   mov     al,0ADh
                   jmp     _call_ext_func_PB_
PostNetmail        endp


;
;         Proboard made this func avialable...
;

MarkMessage        proc    far
                   public C MarkMessage
                   mov     al,0AEh
                   jmp     _call_ext_func_PB_
MarkMessage        endp


;
;         Proboard made this func avialable...
;

ReadMarkedMessages      proc    far
                   public C ReadMarkedMessages
                   mov     al,0AFh
                   jmp     _call_ext_func_PB_
ReadMarkedMessages      endp


;
;         Proboard made this func avialable...
;

ListMarkedMessages      proc    far
                   public C ListMarkedMessages
                   mov     al,0B0h
                   jmp     _call_ext_func_PB_
ListMarkedMessages      endp


;
;         Proboard made this func avialable...
;

UnMarkAllMessages       proc    far
                   public C UnMarkAllMessages
                   mov     al,0B1h
                   jmp     _call_ext_func_PB_
UnMarkAllMessages       endp


;
;         Proboard made this func avialable...
;

Ask                proc    far
                   public C Ask
                   mov     al,0B2h
                   jmp     _call_ext_func_PB_
Ask                endp


;
;         Proboard made this func avialable...
;

PeekChar           proc    far
                   public C PeekChar
                   mov     al,0B3h
                   jmp     _call_ext_func_PB_
PeekChar           endp


;
;         Proboard made this func avialable...
;

ScanKey            proc    far
                   public C ScanKey
                   mov     al,0B4h
                   jmp     _call_ext_func_PB_
ScanKey            endp


;
;         Proboard made this func avialable...
;

InitLineCounter    proc    far
                   public C InitLineCounter
                   mov     al,0B5h
                   jmp     _call_ext_func_PB_
InitLineCounter    endp


;
;         Proboard made this func avialable...
;

LineCounter        proc    far
                   public C LineCounter
                   mov     al,0B6h
                   jmp     _call_ext_func_PB_
LineCounter        endp


;
;         Proboard made this func avialable...
;

ReadFileArea       proc    far
                   public C ReadFileArea
                   mov     al,0B7h
                   jmp     _call_ext_func_PB_
ReadFileArea       endp


;
;         Proboard made this func avialable...
;

CreateMessageTextString proc    far
                   public C CreateMessageTextString
                   mov     al,0B8h
                   jmp     _call_ext_func_PB_
CreateMessageTextString endp


;
;         Proboard made this func avialable...
;

FuzzySearch        proc    far
                   public C FuzzySearch
                   mov     al,0B9h
                   jmp     _call_ext_func_PB_
FuzzySearch        endp


;
;         Proboard made this func avialable...
;

_RemoveHandler     proc    far
                   public C _RemoveHandler
                   mov     al,0BAh
                   jmp     _call_ext_func_PB_
_RemoveHandler     endp


;
;         Proboard made this func avialable...
;

ExternalInput      proc    far
                   public C ExternalInput
                   mov     al,0BBh
                   jmp     _call_ext_func_PB_
ExternalInput      endp


;
;         Proboard made this func avialable...
;

GotoXY             proc    far
                   public C GotoXY
                   mov     al,0BCh
                   jmp     _call_ext_func_PB_
GotoXY             endp


;
;         Proboard made this func avialable...
;

SetFullColor       proc    far
                   public C SetFullColor
                   mov     al,0BDh
                   jmp     _call_ext_func_PB_
SetFullColor       endp


;
;         Proboard made this func avialable...
;

putenv             proc    far
                   public C putenv
                   mov     al,0BEh
                   jmp     _call_ext_func_PB_
putenv             endp


;
;         Proboard made this func avialable...
;

ErrorLevel         proc    far
                   public C ErrorLevel
                   mov     al,0BFh
                   jmp     _call_ext_func_PB_
ErrorLevel         endp


;
;         Proboard made this func avialable...
;

ClrEol             proc    far
                   public C ClrEol
                   mov     al,0C0h
                   jmp     _call_ext_func_PB_
ClrEol             endp


;
;         Proboard made this func avialable...
;

GetIniVar          proc    far
                   public C GetIniVar
                   mov     al,0C1h
                   jmp     _call_ext_func_PB_
GetIniVar          endp


;
;         Proboard made this func avialable...
;

SetIniVar          proc    far
                   public C SetIniVar
                   mov     al,0C2h
                   jmp     _call_ext_func_PB_
SetIniVar          endp


;
;         Proboard made this func avialable...
;

NumMsgAreas        proc    far
                   public C NumMsgAreas
                   mov     al,0C3h
                   jmp     _call_ext_func_PB_
NumMsgAreas        endp


;
;         Proboard made this func avialable...
;

NumFileAreas       proc    far
                   public C NumFileAreas
                   mov     al,0C4h
                   jmp     _call_ext_func_PB_
NumFileAreas       endp


;
;         Proboard made this func avialable...
;

GetLastRead        proc    far
                   public C GetLastRead
                   mov     al,0C5h
                   jmp     _call_ext_func_PB_
GetLastRead        endp


;
;         Proboard made this func avialable...
;

SetLastRead        proc    far
                   public C SetLastRead
                   mov     al,0C6h
                   jmp     _call_ext_func_PB_
SetLastRead        endp


;
;         Proboard made this func avialable...
;

ReadHandler        proc    far
                   public C ReadHandler
                   mov     al,0C7h
                   jmp     _call_ext_func_PB_
ReadHandler        endp


;
;         Proboard made this func avialable...
;

RestoreHandler     proc    far
                   public C RestoreHandler
                   mov     al,0C8h
                   jmp     _call_ext_func_PB_
RestoreHandler     endp


;
;         Proboard made this func avialable...
;

ParseStringVars    proc    far
                   public C ParseStringVars
                   mov     al,0C9h
                   jmp     _call_ext_func_PB_
ParseStringVars    endp


;
;         Proboard made this func avialable...
;

LocalDisplay       proc    far
                   public C LocalDisplay
                   mov     al,0CAh
                   jmp     _call_ext_func_PB_
LocalDisplay       endp


;
;         Proboard made this func avialable...
;

ShowRIPscrip       proc    far
                   public C ShowRIPscrip
                   mov     al,0CBh
                   jmp     _call_ext_func_PB_
ShowRIPscrip       endp


;
;         Proboard made this func avialable...
;

RIP                proc    far
                   public C RIP
                   mov     al,0CCh
                   jmp     _call_ext_func_PB_
RIP                endp


;
;         Proboard made this func avialable...
;

RemoteDisplay      proc    far
                   public C RemoteDisplay
                   mov     al,0CDh
                   jmp     _call_ext_func_PB_
RemoteDisplay      endp


;
;         Proboard made this func avialable...
;

MsgNum             proc    far
                   public C MsgNum
                   mov     al,0CEh
                   jmp     _call_ext_func_PB_
MsgNum             endp


;
;         Proboard made this func avialable...
;

MsgId              proc    far
                   public C MsgId
                   mov     al,0CFh
                   jmp     _call_ext_func_PB_
MsgId              endp


;
;         Proboard made this func avialable...
;

HighMsg            proc    far
                   public C HighMsg
                   mov     al,0D0h
                   jmp     _call_ext_func_PB_
HighMsg            endp


;
;         Proboard made this func avialable...
;

NumMsgs            proc    far
                   public C NumMsgs
                   mov     al,0D1h
                   jmp     _call_ext_func_PB_
NumMsgs            endp


;
;         Proboard made this func avialable...
;

TimeUntilEvent     proc    far
                   public C TimeUntilEvent
                   mov     al,0D2h
                   jmp     _call_ext_func_PB_
TimeUntilEvent     endp


;
;         (unofficial) Proboard made this func avialable...
;

ResetInactivity    proc    far
                   public C ResetInactivity
                   mov     al,0D3h
                   jmp     _call_ext_func_PB_
ResetInactivity    endp


;
;         Proboard made this func avialable...
;

_fut_func_3        proc    far
                   public C _fut_func_3
                   mov     al,0D4h
                   jmp     _call_ext_func_PB_
_fut_func_3        endp


;
;         Proboard made this func avialable...
;

_fut_func_4        proc    far
                   public C _fut_func_4
                   mov     al,0D5h
                   jmp     _call_ext_func_PB_
_fut_func_4        endp


;
;         Proboard made this func avialable...
;

_fut_func_5        proc    far
                   public C _fut_func_5
                   mov     al,0D6h
                   jmp     _call_ext_func_PB_
_fut_func_5        endp


;
;         Proboard made this func avialable...
;

_fut_func_6        proc    far
                   public C _fut_func_6
                   mov     al,0D7h
                   jmp     _call_ext_func_PB_
_fut_func_6        endp


;
;         Proboard made this func avialable...
;

_fut_func_7        proc    far
                   public C _fut_func_7
                   mov     al,0D8h
                   jmp     _call_ext_func_PB_
_fut_func_7        endp


;
;         Proboard made this func avialable...
;

_fut_func_8        proc    far
                   public C _fut_func_8
                   mov     al,0D9h
                   jmp     _call_ext_func_PB_
_fut_func_8        endp


;
;         Proboard made this func avialable...
;

_fut_func_9        proc    far
                   public C _fut_func_9
                   mov     al,0DAh
                   jmp     _call_ext_func_PB_
_fut_func_9        endp


;
;         Proboard made this func avialable...
;

_fut_func_10       proc    far
                   public C _fut_func_10
                   mov     al,0DBh
                   jmp     _call_ext_func_PB_
_fut_func_10       endp


;
;         Proboard made this func avialable...
;

_fut_func_11       proc    far
                   public C _fut_func_11
                   mov     al,0DCh
                   jmp     _call_ext_func_PB_
_fut_func_11       endp


;
;         Proboard made this func avialable...
;

_fut_func_12       proc    far
                   public C _fut_func_12
                   mov     al,0DDh
                   jmp     _call_ext_func_PB_
_fut_func_12       endp


;
;         Proboard made this func avialable...
;

_fut_func_13       proc    far
                   public C _fut_func_13
                   mov     al,0DEh
                   jmp     _call_ext_func_PB_
_fut_func_13       endp


;
;         Proboard made this func avialable...
;

_fut_func_14       proc    far
                   public C _fut_func_14
                   mov     al,0DFh
                   jmp     _call_ext_func_PB_
_fut_func_14       endp


;
;         Proboard made this func avialable...
;

_fut_func_15       proc    far
                   public C _fut_func_15
                   mov     al,0E0h
                   jmp     _call_ext_func_PB_
_fut_func_15       endp


;
;         Proboard made this func avialable...
;

_fut_func_16       proc    far
                   public C _fut_func_16
                   mov     al,0E1h
                   jmp     _call_ext_func_PB_
_fut_func_16       endp


;
;         Proboard made this func avialable...
;

_fut_func_17       proc    far
                   public C _fut_func_17
                   mov     al,0E2h
                   jmp     _call_ext_func_PB_
_fut_func_17       endp


;
;         Proboard made this func avialable...
;

_fut_func_18       proc    far
                   public C _fut_func_18
                   mov     al,0E3h
                   jmp     _call_ext_func_PB_
_fut_func_18       endp


;
;         Proboard made this func avialable...
;

_fut_func_19       proc    far
                   public C _fut_func_19
                   mov     al,0E4h
                   jmp     _call_ext_func_PB_
_fut_func_19       endp


;
;         Proboard made this func avialable...
;

_fut_func_20       proc    far
                   public C _fut_func_20
                   mov     al,0E5h
                   jmp     _call_ext_func_PB_
_fut_func_20       endp


;
;         Proboard made this func avialable...
;

_fut_func_21       proc    far
                   public C _fut_func_21
                   mov     al,0E6h
                   jmp     _call_ext_func_PB_
_fut_func_21       endp


;
;         Proboard made this func avialable...
;

_fut_func_22       proc    far
                   public C _fut_func_22
                   mov     al,0E7h
                   jmp     _call_ext_func_PB_
_fut_func_22       endp


;
;         Proboard made this func avialable...
;

_fut_func_23       proc    far
                   public C _fut_func_23
                   mov     al,0E8h
                   jmp     _call_ext_func_PB_
_fut_func_23       endp


;
;         Proboard made this func avialable...
;

_fut_func_24       proc    far
                   public C _fut_func_24
                   mov     al,0E9h
                   jmp     _call_ext_func_PB_
_fut_func_24       endp


;
;         Proboard made this func avialable...
;

_fut_func_25       proc    far
                   public C _fut_func_25
                   mov     al,0EAh
                   jmp     _call_ext_func_PB_
_fut_func_25       endp


;
;         Proboard made this func avialable...
;

_fut_func_26       proc    far
                   public C _fut_func_26
                   mov     al,0EBh
                   jmp     _call_ext_func_PB_
_fut_func_26       endp


;
;         Proboard made this func avialable...
;

_fut_func_27       proc    far
                   public C _fut_func_27
                   mov     al,0ECh
                   jmp     _call_ext_func_PB_
_fut_func_27       endp


;
;         Proboard made this func avialable...
;

_fut_func_28       proc    far
                   public C _fut_func_28
                   mov     al,0EDh
                   jmp     _call_ext_func_PB_
_fut_func_28       endp


;
;         Proboard made this func avialable...
;

_fut_func_29       proc    far
                   public C _fut_func_29
                   mov     al,0EEh
                   jmp     _call_ext_func_PB_
_fut_func_29       endp


;
;         Proboard made this func avialable...
;

_fut_func_30       proc    far
                   public C _fut_func_30
                   mov     al,0EFh
                   jmp     _call_ext_func_PB_
_fut_func_30       endp


;
;         Proboard made this func avialable...
;

_fut_func_31       proc    far
                   public C _fut_func_31
                   mov     al,0F0h
                   jmp     _call_ext_func_PB_
_fut_func_31       endp


;
;         Proboard made this func avialable...
;

_fut_func_32       proc    far
                   public C _fut_func_32
                   mov     al,0F1h
                   jmp     _call_ext_func_PB_
_fut_func_32       endp


;
;         Proboard made this func avialable...
;

_fut_func_33       proc    far
                   public C _fut_func_33
                   mov     al,0F2h
                   jmp     _call_ext_func_PB_
_fut_func_33       endp


;
;         Proboard made this func avialable...
;

_fut_func_34       proc    far
                   public C _fut_func_34
                   mov     al,0F3h
                   jmp     _call_ext_func_PB_
_fut_func_34       endp


;
;         Proboard made this func avialable...
;

_fut_func_35       proc    far
                   public C _fut_func_35
                   mov     al,0F4h
                   jmp     _call_ext_func_PB_
_fut_func_35       endp


;
;         Proboard made this func avialable...
;

_fut_func_36       proc    far
                   public C _fut_func_36
                   mov     al,0F5h
                   jmp     _call_ext_func_PB_
_fut_func_36       endp


;
;         Proboard made this func avialable...
;

_fut_func_37       proc    far
                   public C _fut_func_37
                   mov     al,0F6h
                   jmp     _call_ext_func_PB_
_fut_func_37       endp


;
;         Proboard made this func avialable...
;

_fut_func_38       proc    far
                   public C _fut_func_38
                   mov     al,0F7h
                   jmp     _call_ext_func_PB_
_fut_func_38       endp


;
;         Proboard made this func avialable...
;

_fut_func_39       proc    far
                   public C _fut_func_39
                   mov     al,0F8h
                   jmp     _call_ext_func_PB_
_fut_func_39       endp


;
;         Proboard made this func avialable...
;

_fut_func_40       proc    far
                   public C _fut_func_40
                   mov     al,0F9h
                   jmp     _call_ext_func_PB_
_fut_func_40       endp


;
;         Proboard made this func avialable...
;

_fut_func_41       proc    far
                   public C _fut_func_41
                   mov     al,0FAh
                   jmp     _call_ext_func_PB_
_fut_func_41       endp


;
;         Proboard made this func avialable...
;

_fut_func_42       proc    far
                   public C _fut_func_42
                   mov     al,0FBh
                   jmp     _call_ext_func_PB_
_fut_func_42       endp


;
;         Proboard made this func avialable...
;

_fut_func_43       proc    far
                   public C _fut_func_43
                   mov     al,0FCh
                   jmp     _call_ext_func_PB_
_fut_func_43       endp


;
;         Proboard made this func avialable...
;

_fut_func_44       proc    far
                   public C _fut_func_44
                   mov     al,0FDh
                   jmp     _call_ext_func_PB_
_fut_func_44       endp


;
;         Proboard made this func avialable...
;

_fut_func_45       proc    far
                   public C _fut_func_45
                   mov     al,0FEh
                   jmp     _call_ext_func_PB_
_fut_func_45       endp


;
;         Proboard made this func avialable...
;

_fut_func_46       proc    far
                   public C _fut_func_46
                   mov     al,0FFh
                   jmp     _call_ext_func_PB_
_fut_func_46       endp


; -------------------------------------------------------------------------

_TEXT              ENDS

                   SUBTTL Start Up Data Area
                   PAGE

;[]------------------------------------------------------------[]
;|        Start Up Data Area                                    |                                                         |
;|                                                              |                                                                                                 |
;|        WARNING                                               |
;|           Do not move any variables in the data              |
;|           segment unless you're absolutely sure              |
;|           that it does not matter.                           |
;|                                                              |
;[]------------------------------------------------------------[]

_DATA              SEGMENT

                   public C  CurUser
                   public C  LoginDate
                   public C  LoginTime
                   public C  UserRecNr
                   public C  _unknown_dat_01
                   public C  Limits
                   public C  NumLimits
                   public C  _unknown_dat_02
                   public C  NetEntered
                   public C  _unknown_dat_03
                   public C  _unknown_dat_04
                   public C  EchoEntered
                   public C  _unknown_dat_05
                   public C  _unknown_dat_06
                   public C  NumUsers
                   public C  _unknown_dat_07
                   public C  NodeNumber
                   public C  _unknown_dat_10
                   public C  CurMenu
                   public C  UserFirstName
                   public C  PrevUser
                   public C  StartupPath
                   public C  SysPath
                   public C  Config
                   public C  PBVersion
                   public C  _unknown_dat_08
                   public C  BaudRate
                   public C  Beta
                   public C  _unknown_dat_09
                   public C  PageReason
                   public C  PageCount
                   public C  _fut_dat_06
                   public C  _fut_dat_07
                   public C  _fut_dat_08
                   public C  _fut_dat_09
                   public C  _fut_dat_10
                   public C  _fut_dat_11
                   public C  _fut_dat_12
                   public C  _fut_dat_13
                   public C  _fut_dat_14
                   public C  _fut_dat_15
                   public C  _fut_dat_16
                   public C  _fut_dat_17
                   public C  _fut_dat_18
                   public C  _fut_dat_19
                   public C  _fut_dat_20

;------------------------------------------------------------  DATA  ----

                   public C fptrPB

fptrPB             dw     offset _func_ptr_tbl_PB_, seg _func_ptr_tbl_PB_       ; pointer to function table...

CurUser            dw      0ABCDh, 0ABCDh          ; Current user online        (R/W)
LoginDate          dw      0ABCDh, 0ABCDh          ; Login date of user         (R/W)
LoginTime          dw      0ABCDh, 0ABCDh          ; Login time of user         (R/W)
UserRecNr          dw      0ABCDh                  ; Record # of current user   (R/O)
_unknown_dat_01    dw      0ABCDh                  ; undocumented Proboard variable(s)
Limits             dw      0ABCDh, 0ABCDh          ; Limits per level           (R/O)
NumLimits          dw      0ABCDh                  ; # limits in limits[] array (R/O)
_unknown_dat_02    dw      0ABCDh                  ; undocumented Proboard variable(s)
NetEntered         db      0CDh                    ; Netmail entered            (R/O)
_unknown_dat_03    db      0ABh                    ; undocumented Proboard variable(s)
_unknown_dat_04    dw      0ABCDh                  ; undocumented Proboard variable(s)
EchoEntered        db      0CDh                    ; Echomail entered           (R/O)
_unknown_dat_05    db      0ABh                    ; undocumented Proboard variable(s)
_unknown_dat_06    dw      0ABCDh                  ; undocumented Proboard variable(s)
NumUsers           dw      0ABCDh                  ; # users in userfile        (R/O)
_unknown_dat_07    dw      0ABCDh                  ; undocumented Proboard variable(s)
NodeNumber         dw      0ABCDh                  ; Current node number        (R/O)
_unknown_dat_10    dw      0ABCDh                  ; undocumented Proboard variable(s)
CurMenu            dw      0ABCDh, 0ABCDh          ; Current menu name          (R/O)
UserFirstName      dw      0ABCDh, 0ABCDh          ; First name of current user (R/O)
PrevUser           dw      0ABCDh, 0ABCDh          ; Name of previous user      (R/O)
StartupPath        dw      0ABCDh, 0ABCDh          ; Startup path               (R/O)
SysPath            dw      0ABCDh, 0ABCDh          ; ProBoard system path       (R/O)
Config             dw      0ABCDh, 0ABCDh          ; ProBoard config-record     (R/O)
PBVersion          dw      0ABCDh                  ; Version number of ProBoard (R/O)
_unknown_dat_08    dw      0ABCDh                  ; undocumented Proboard variable(s)
BaudRate           dd      0ABCDABCDh              ; Baud rate (0=local)        (R/O)
Beta               dw      0ABCDh                  ; Beta nr (0xFFFF=release)   (R/O)
_unknown_dat_09    dw      0ABCDh                  ; undocumented Proboard variable(s)
PageReason         dw      0ABCDh, 0ABCDh          ; Reason for sysop paging    (R/W)
PageCount          dw      0ABCDh, 0ABCDh          ; Number of sysop pages      (R/W)
_fut_dat_06        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_07        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_08        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_09        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_10        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_11        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_12        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_13        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_14        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_15        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_16        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_17        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_18        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_19        dd      0ABCDABCDh              ; undocumented Proboard variable(s)
_fut_dat_20        dd      0ABCDABCDh              ; undocumented Proboard variable(s)

_DATA              ENDS

_STACK             SEGMENT
                   db      STACKSIZE dup(?)               ;minimum stack size
                   ENDS

                   END  dosentry
                   ;
                   ; as DOS executable, this code should
                   ; be entered at 'dosentry'.
                   ;




































