/*
 * This file is part of P2iLC (EXE)
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A Product of Silicon Creations, Inc.
 *
 * This file is distributed under the terms and conditions of the GNU
 * General Public License. For more information, refer to the file
 * 'copying.doc' which is included in the archive.
 *
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pblib.h"
#include "fail.h"
#include "ctl.h"
#include "lastcall.h"
#include "mailhist.h"

#define _VERSION "v1.2r1"

/*
 * converts a C string to Pascal style
*/
    char*
c2pStr(char *dest, const char *src)
{
    int cLen = strlen(src);

    if( 255 < cLen ) cLen = 255;
    memmove(&dest[1], src, cLen);
    dest[0] = (unsigned char)cLen;
    return dest;
}

	int
main( int argc, char *argv[] )
{
	char         proPath[MAXPATH];    // path to the BINLOG.PB file
    char         imSysPath[MAXPATH];  // path to IM main and sys dirs
    char         imHistPath[MAXPATH]; // path to IM inbound history
    int          task = 1;
    struct _ctl  fdsys;
    struct date  ddate;
    struct time  dtime;
    MAILHIST     mailhist;
    LASTCALL     lastcall;
    BINLOG       binlog;
    FILE        *fp;

    // brag some
    fprintf(stderr, "P2iLC %s - Update InterMail with last ProBoard caller\n"
    				"    Compiled on %s at %s\n"
					"    Copyright (C) 1995 by Branislav L. Slantchev\n"
					"    A Product of Silicon Creations, Inc. (PB-GNU)\n\n",
					_VERSION, __DATE__, __TIME__ );

    // get the task
    if( 1 < argc ) task = atoi(argv[1]);

    // get the path to the binary log file (ProBoard)
    if( getenv("PROBOARD") )
		sprintf(proPath, "%s\\BINLOG.PB", getenv("PROBOARD"));
	else fail("Unable to find the ProBoard environment.");

    // get the path to InterMail's last caller file
    if( getenv("IM") ){
    	sprintf(imSysPath, "%s\\FD.SYS", getenv("IM"));
        if( !(fp = fopen(imSysPath, "rb")) )
        	fail("Unable to open InterMail config file '%s'", imSysPath);
        fread(&fdsys, sizeof(fdsys), 1, fp);
        fclose(fp);
        if( 1 < task ){
	        sprintf(imSysPath, "%sLASTCALL.%03d", fdsys.s.systempath, task);
            sprintf(imHistPath, "%sINBOUND.%03d", fdsys.s.systempath, task);
        }
        else{
        	sprintf(imSysPath, "%sLASTCALL.IM", fdsys.s.systempath);
            sprintf(imHistPath, "%sINBOUND.HIS", fdsys.s.systempath);
        }
	}
    else fail("Unable to find the InterMail environment.");

    // now, get the info from the ProBoard's binlog
    if( !(fp = fopen(proPath, "rb")) )
    	fail("Unable to read the binary log '%s'", proPath);
    fseek(fp, 0, SEEK_END);
    fseek(fp, -(long)sizeof(binlog), SEEK_CUR);
    if( 1 != fread(&binlog, sizeof(binlog), 1, fp) )
    	fail("Error reading the binary log '%s'", proPath);
    fclose(fp);

    // now, open the last caller file, and read in the structure
    if( !(fp = fopen(imSysPath, "r+b")) )
    	fail("Unable to open the last caller file '%s'", imSysPath);
    if( 1 != fread(&lastcall, sizeof(lastcall), 1, fp) )
    	fail("Error reading the last caller file '%s'", imSysPath);

    // update the information there
    c2pStr(lastcall.system_name, binlog.name);
    c2pStr(lastcall.location, binlog.city);

    ddate.da_year = (int)binlog.date[2] + 1900;
    ddate.da_day  = (int)binlog.date[0];
    ddate.da_mon  = (int)binlog.date[1];

    dtime.ti_hour = (int)binlog.timeOut[0];
    dtime.ti_min  = (int)binlog.timeOut[1];
    dtime.ti_sec  = (int)binlog.timeOut[2];
    dtime.ti_hund = 0;

	// why do we need this patch, a 5-hour difference
    dtime.ti_hour = (dtime.ti_hour + 19) % 24;
    lastcall.time = dostounix(&ddate, &dtime);

    // write the structure back
    fseek(fp, 0L, SEEK_SET);
	fwrite(&lastcall, sizeof(lastcall), 1, fp);
    fclose(fp);

    // now open the history file
    if( !(fp = fopen(imHistPath, "r+b")) )
    	fail("Unable to open inbound history file '%s'", imHistPath);

    mailhist.year  = (int)binlog.date[2] + 1900;
    mailhist.month = (int)binlog.date[1];
    mailhist.day   = (int)binlog.date[0];
    mailhist.hour  = (int)binlog.timeOut[0];
    mailhist.min   = (int)binlog.timeOut[1];
    mailhist.sec   = (int)binlog.timeOut[2];

    c2pStr(mailhist.system_name, binlog.name);
    c2pStr(mailhist.city, binlog.city);

    mailhist.rcvd_bytes = (long)binlog.kbUp * 1024L;
	mailhist.sent_bytes = (long)binlog.kbDown * 1024L;

    mailhist.zone  = 0;
    mailhist.net   = binlog.baud / 100;
    mailhist.node  = binlog.yells;
    mailhist.point = 0;

    mailhist.cost = 0;

    // update the file (append the record)
    fseek(fp, 0L, SEEK_END);
    fwrite(&mailhist, sizeof(mailhist), 1, fp);
    fclose(fp);

	return 0;
}
