/*
**  mailhist.h (InterMail)
**
**  Copyright 1989-1994 InterZone Software, Inc. All rights reserved.
**
**  Record format for INBOUND.HIS and OUTBOUND.HIS (Mail history)
**  Mail servers after #1 use INBOUND.002, INBOUND.003, etc.
**
**  Last revision:  1-24-94
**
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*/

/*
**  The first record in the .HIS files is not a valid history entry. It
**  contains the date/time when the .HIS file was last packed or when
**  it was created if it has never been packed. So if you're reading the
**  .HIS files for any reason, skip the first record and you'll be at the
**  first valid record.
**
**  Note that the two char[] arrays are Borland Pascal style strings. The 
**  first byte is the length byte. The actual string starts at [1] and 
**  the string is NOT NUL terminated. In pascal they would be 
**  declared as string[30] and string[40].
*/
typedef struct
    {
    word    year,                           /* 1990 - xxxx */
            month,                          /*    1 - 12   */
            day,                            /*    1 - 31   */
            hour,                           /*    0 - 23   */
            min,                            /*    0 - 59   */
            sec,                            /*    0 - 59   */
            zone,net,node,point;
    char    system_name[31],
            city[41];
    dword   rcvd_bytes,sent_bytes;
    word    cost;
    }
    MAILHIST, *MAILHISTPTR;

/* end of file "mailhist.h" */

