/*
 * $Id: pb2inet.cpp,v 2.0 1995/07/25 08:13:13 JOHN Exp $
 *
 * $Log: pb2inet.cpp,v $
 * Revision 2.0  1995/07/25 08:13:13  JOHN
 * Initial Version 2.0
 *
 *
 */

/*
 PB2INET ProBoard PEX
 Copyright (C) 1994 by John Maddox

 This file is part of P2I200AX.ZIP.

 PB2INET is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 PB2INET is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with PB2INET; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <pb_sdk.h>
#define   EOF (-1)
char Editor_Cmd[61];
char Edit_Type[4];
char Edit_Cmd[80];
char To_Name[53];
char Ini_Email_Area_Name[80];
char Message_Area_Name[80];

void Read_Ini(), Call_Editor(),Rewrite_Info();
bool Ask_Address(), Write_Message(), Check_If_Area();

void main (void)
 {
  Read_Ini();
  if (Check_If_Area())
   {
    if (Ask_Address())
     {
      Call_Editor();
      Write_Message();
     }
   }
  else
   Call_Editor();
  exit();
 }

/*************************************************************************
 * Function name: Read_Ini
 * Inputs:        None
 * Returns:       None
 * Purpose:       This function reads a standard Ini file and the fills
 *                the varaibles with that data
 *************************************************************************/
void Read_Ini (void)
 {
  char var[80];
  char inifile[120];

  sprintf(inifile,"%s\\pb2inet",Config->pexpath);
  sprintf(var,"EmailAreaName");
  GetIniVar(inifile,var,Ini_Email_Area_Name,80);
  sprintf(var,"EditorType");
  GetIniVar(inifile,var,Edit_Type,4);
  sprintf(var,"EditorCommand");
  GetIniVar(inifile,var,Edit_Cmd,80);
 }

/*************************************************************************
 * Function Name: Ask_Address
 * Inputs:        None
 * Returns:       A value to the calling program if the user entered
 *                correct data
 * Purpose:       This function gets the address from a user and calls
 *                the function that gets the rest of the data.
 *************************************************************************/
bool Ask_Address(void)
 {
  printf("\n\7Write to Internet address: ");
  SetColor(CYAN);
  Input(To_Name,52,INPUT_ALL);
  strlwr(To_Name);
  if(strlen(To_Name)==0)
   return(FALSE);
  else
   return(TRUE);
 }

/*************************************************************************
 * Function name: Write_Message
 * Inputs:        None
 * Returns:       A number indicating success or failure
 * Purpose:       This function creates a standard MSGTMP file and inserts
 *                the TO: <internet address> on the first line
 *************************************************************************/
bool Write_Message(void)
 {
  FILE *msgtmp;
  FILE *tmpmsg;
  char ch;

  if((msgtmp=fopen("msgtmp","r"))==NULL)
   return(FALSE);
  ch=getc(msgtmp);
  if(ch==EOF)
   {
    fclose(msgtmp);
    return(FALSE);
   }
  else
   {
    tmpmsg=fopen("tmpmsg","w");
    fprintf(tmpmsg,"TO: %s\n\n",To_Name);
    while(ch!=EOF)
     {
      putc(ch,tmpmsg);
      ch=getc(msgtmp);
     }
    fclose(msgtmp);
    fclose(tmpmsg);
    remove("msgtmp");
    rename("tmpmsg","msgtmp");
   }
  return(TRUE);
 }

/*************************************************************************
 * Function name: Call_Editor
 * Inputs:        None
 * Returns:       None
 * Purpose:       This function crhecks to see which editor is being used
 *                and then issues the approriate run command
 *************************************************************************/
void Call_Editor (void)
 {
  if (strnicmp("PEX",Edit_Type,3) == 0)
   MenuFunction(MENU_RUN_SDKFILE,Edit_Cmd);
  else
   MenuFunction(MENU_SHELL,Edit_Cmd);
 }

/*************************************************************************
 * Function name: Check_If_Area
 * Inputs:        None
 * Returns:       1 if the area is an internet area; 0 otherwise
 * Purpose:       This function reads the MSGINF file and checks if the
 *                current area is the internet area.
 *************************************************************************/
bool Check_If_Area(void)
 {
  FILE *msginf;
  char str[80];

  msginf = fopen("msginf","r");
  fgets(str,32,msginf);            ** From Name
  fgets(str,80,msginf);            ** To Name
  fgets(str,80,msginf);            ** Subject
  fgets(str,11,msginf);            ** Message Number
  fgets(Message_Area_Name,80,msginf);  ** Message Area Title
  fclose(msginf);
  if (strncmp(Message_Area_Name,Ini_Email_Area_Name,
      strlen(Ini_Email_Area_Name)) == 0)
   return (TRUE);
  else
   return (FALSE);
 }

