/***********************************************************************
*                                                                      *
*  Implementation of the output for edit                               *
*                                                                      *
*  Purpose : Output functions for edit                                 *
*                                                                      *
*  Author  : Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*  eMail   : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*                                                                      *
* $Log: output.cpv $
// Revision 1.3  1994/09/08  08:00:47  BRAINBOX
// 1. Bounce checked by I_A
//
// Revision 1.2  1994/08/25  20:07:38  BRAINBOX
// 1. Minor reconstructions
//
// Revision 1.1  1994/08/23  21:57:59  BRAINBOX
// Initial revision
//                                                                *
*                                                                      *
************************************************************************
*/
#ifndef _OUTPUT_CPP
#define _OUTPUT_CPP

#include "TERM.CPP"
#include "OUTPUT.HPP"


Output::Output(void)
{
   nr++ ;
   sprintf(outputFilename,"_OUTPUT_.%03i",nr) ;
   fpOut = fopen(outputFilename,"w+b") ;      // No checking is done!
}

int Output::setOutputFile(char *fileName)
{
   fclose(fpOut) ;
   unlink(outputFilename) ;

   strcpy(outputFilename,fileName) ;
   if ( (fpOut = fopen(outputFilename,"w+b")) == NULL )      // No checking is done!
      return 1;
   else
      return 0 ;
}

void Output::outTextattr(unsigned char col)
{
static   char Ansi_Ctl[40] ; // I_A: was '20'

   if (outputmode & OUTPUT_CON)
   {
      switch(termmode)
      {
         case TERM_SCREEN:
            textattr(col) ;
            break ;
         case TERM_ANSI:
            ColorAnsi(col, Ansi_Ctl) ;
            printf("%s",Ansi_Ctl) ;
            break ;
      }
   }
   if (outputmode & OUTPUT_FILE)
   {
      switch(termmode)
      {
         // case TERM_SCREEN is just impossible
         case TERM_ANSI:
            ColorAnsi(col, Ansi_Ctl) ;
            fprintf(fpOut,"%s",Ansi_Ctl) ;
            break ;
      }
      fflush(fpOut) ;
   }
}

void Output::outPrintf(char *st)
{
   if (outputmode & OUTPUT_CON)
   {
      switch(termmode)
      {
         case TERM_SCREEN:
            cprintf("%s",st) ;
            break ;
         case TERM_ANSI:
            printf("%s",st) ;
            break ;
      }
   }
   if (outputmode & OUTPUT_FILE)
   {
      switch(termmode)
      {
         // case TERM_SCREEN is just impossible
         case TERM_ANSI:
            fprintf(fpOut,"%s",st) ;
            break ;
      }
      fflush(fpOut) ;
   }
}


void Output::outChar(char c)
{
   if (outputmode & OUTPUT_CON)
   {
      switch(termmode)
      {
         case TERM_SCREEN:
            cprintf("%c",c) ;
            break ;
         case TERM_ANSI:
            printf("%c",c) ;
            break ;
      }
   }
   if (outputmode & OUTPUT_FILE)
   {
      switch(termmode)
      {
         // case TERM_SCREEN is just impossible
         case TERM_ANSI:
            fprintf(fpOut,"%c",c) ;
            break ;
      }
      fflush(fpOut) ;
   }
}

void Output::outGotoxy(int x,int y)
{
   char Ansi_Ctl[40] ; // I_A: was 20

   if (outputmode & OUTPUT_CON)
   {
      switch(termmode)
      {
         case TERM_SCREEN:
            gotoxy(x,y) ;
            break ;
         case TERM_ANSI:
            GotoAnsi(x,y, Ansi_Ctl) ;
            printf("%s",Ansi_Ctl) ;
      }
   }
   if (outputmode & OUTPUT_FILE)
   {
      switch(termmode)
      {
         case TERM_ANSI:
            GotoAnsi(x,y, Ansi_Ctl) ;
            fprintf(fpOut,"%s",Ansi_Ctl) ;
      break ;
      }
      fflush(fpOut) ;
   }
}


unsigned int  Output::getOutput(void)
{
   return outputmode ;
}


void  Output::setOutput(unsigned int outp)
{
   outputmode = outp ;
}


char *Output::getOutputFile(void)
{
   return outputFilename ;
}

#endif
