@echo off
goto Begin
**
** update.bat - Update the PB-Lib C/C++ Library with Add-on Modules
**
** Copyright (c) 1996 by Branislav L. Slantchev
** A Product of Silicon Creations, Inc.
**
:Begin
if not [%1] == [] goto Proc
	echo Update v1.0r1 Copyright (c) 1996 by Branislav L. Slantchev
	echo 
	echo Usage: %0 filename [[-L] [-C] [-V]] [[-c] [-o] [-p]]
	echo 
	echo     filename: path and name of the source file (no extension)
	echo     -L      : put the module in the PB-Lib library
	echo     -C      : put the module in the Classes library
	echo     -V      : put the module in the TurboVision library
	echo 
	echo (** Note: you can use only one of the three switches above **)
	echo (**       '-p' option is not compatible with '-V' option!  **)
	echo 
	echo     -c      : compile the regular EXE mode
	echo     -o      : compile the overlay version
	echo     -p      : compile the SDK version
	echo 
	echo (** Note: you can use only one of the three switches above **)
	echo 
	echo If you don't specify any parameters, all versions will be made
	echo and included in all library files. This is the default mode and
	echo should be used unless the documentation that came with the
	echo specific module states otherwise. You have to specify the second
	echo parameter, the third is optional.
	echo 
goto End

rem ***********************************************************************
rem * check the environment and the command line options
rem ***********************************************************************
:Proc
	if not [%SILICON%] == [] goto CheckName
	echo %0: can't find the SILICON environment...
	goto End
:CheckName
	if exist %1.* goto CheckBorland
	echo %0: don't know how to update '%1'
	goto End
:CheckBorland
	if exist borland.bat goto MakeFile
	echo %0: can't find 'Borland.Bat' in current directory.
	goto End
rem ***********************************************************************
rem ** make the appropriate version of the file
rem ***********************************************************************
:MakeFile
	call borland.bat
	if [%2] == [-L] goto Make
	if [%2] == [-C] goto Make
	if [%2] == [-V] goto Make
	echo %0: you must specify the library file with second option.
	goto End
:Make
	if [%3] == [-o] goto MakeOvl
	if [%3] == [-p] goto MakePex

	bcc -c -ml -P -I%INCLUDE%;%SILICON%\H -o%1.OBX %1
	if [%3] == [-c] goto MakeLib
:MakeOvl
	bcc -c -ml -P -I%INCLUDE%;%SILICON%\H -O1 -y -Vs -B -o%1.OBV %1
	if [%3] == [-o] goto MakeLib
:MakePex
	bcc -c -ml -P -I%SILICON%\H -DPB_SDK -o%1.OBP %1
	if [%3] == [-p] goto MakeLib

rem ***********************************************************************
rem ** Add the module to the appropriate file in the library
rem ***********************************************************************
:MakeLib
	if [%2] == [-L] set _M=LIB
	if [%2] == [-C] set _M=LCS
	if [%2] == [-V] set _M=VIS
	if [%3] == [-o] goto LibOvl
	if [%3] == [-p] goto LibPex

	tlib /C /0 %SILICON%\LIB\PB%_M%_EX.LIB -+ %1.OBX
	if [%3] == [-c] goto Unset
:LibOvl
	tlib /C /0 %SILICON%\LIB\PB%_M%_OV.LIB -+ %1.OBV
	if [%3] == [-o] goto Unset
:LibPex
	tlib /C /0 %SILICON%\LIB\PB%_M%_PX.LIB -+ %1.OBP
	if [%3] == [-p] goto Unset

rem ***********************************************************************
rem ** Remove used environment and object file
rem ***********************************************************************
:Unset
	set _M=
	del %1.OB?
	echo 
	echo %0: Done!
	echo 
	echo You might want to remove the .BAK files in %SILICON%\LIB now...
	echo 
:End
