//
// testedit.cpp - TEditLine class usage example (in EXE mode, same in SDK)
//
// Copyright (c) 1996 by Branislav L. Slantchev
// A Product of Silicon Creations, Inc.
//
// Source is for purely educational purposes only. It is provided as a
// service to all PB-Lib users. It is not supported by Silicon Creations.
//
#include "class/editline.h"
#include "class/scankey.h"
#include "class/dlist.h"
#include <conio.h>

const char *choice[7] =
{
    "Yes", "No", "Cancel", "Yeppers", "Nada", "Maybe", "Never"
};

int main()
{
    TKeyboard   kbd;          // create a keyboard handler
    TDoubleList list(False);  // items are static, don't purge them
    ushort      key;

    // create a normal input line
    TEditLine line1(CRect(13,5,50,6), 60);

    // create an input line for numbers (positive/negative)
    TEditNumber line2(CRect(13,7,50,8), 60, edit::blank);

    // create an input line for date input in American format
    TEditDate line3(CRect(13,9,23,10), edit::american|edit::show);

    // create an input line for a filename input, with wildcards
    TEditFile line4(CRect(13,11,50,12), 60, edit::wildcards|edit::upper);

	// link in some items in the string list
    for( short i = 0; i < 7; ++i ) list.link((void *)choice[i]);

    // create the combo box with the list we just created
    // the list is not dynamically allocated => no TEditCombo::dispose
    TEditCombo line5(CRect(13,13,50,14), edit::init, &list);

    // create the password input box
    TEditPassword line6(CRect(13,15,50,16), 15, edit::proboard);

    // some rudimentary screen initialization
    textattr(7);  clrscr();
    gotoxy(1,5);  cprintf("Edit text  :");
    gotoxy(1,7);  cprintf("Edit number:");
    gotoxy(1,9);  cprintf("Edit date  :");
    gotoxy(1,11); cprintf("Enter file :");
    gotoxy(1,13); cprintf("Toggle item:");
    gotoxy(1,15); cprintf("Enter input:");

    // the following are necessary so we can see the input areas
	line2.draw(); line3.draw(); line4.draw(); line5.draw(); line6.draw();

    // this is the pointer we will use to switch from line to line
    TEditLine *p = &line1;

    // this will focus and redraw the first line, that's why we
    // didn't need to call line1.draw() as for the others above
	p->setState(True);

    // loop until Escape is pressed
    while( kbdEsc != (key = kbd.get()) ){

        // if Tab is pressed or down arrow, switch to next line
    	if( kbdTab == key || kbdDown == key ){

    	    // reset the current state (redraws as inactive line)
            p->setState(False);

            // adjust the pointer as needed
            if( p == &line1 ) p = &line2;
            else if( p == &line2 ) p = &line3;
            else if( p == &line3 ) p = &line4;
            else if( p == &line4 ) p = &line5;
            else if( p == &line5 ) p = &line6;
            else p = &line1;

            // focus the new line (this redraws the line as active)
            p->setState(True);
        }
        // not special key, hand it over to the current input line
        // for further processing
        else p->handle(key);
    }

    return 0;
}
