/*
 FileNav, File Library Navigator
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of FileNav.

 FileNav is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 FileNav is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with FileNav; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __ASMDEF_H )
#define __ASMDEF_H

/*
 ***************************************************************************
                 Macros for the inline assembler modules
 ***************************************************************************
*/

#if defined( __COMPACT__ ) || defined( __LARGE__ ) || defined( __HUGE__ )
	#define FDATA 1
#else
	#define FDATA 0
#endif

#if defined( __MEDIUM__ ) || defined( __LARGE__ ) || defined( __HUGE__ )
	#define FCODE 1
#else
	#define FCODE 0
#endif


/*
 * use those macros instead of les and lds and push/pop ds with lds
*/
#if FDATA
	#define __pushDS  _asm push ds
	#define __popDS   _asm pop  ds
	#define LES_           les
	#define LDS_           lds
#else
	#define __pushDS
	#define __popDS
	#define LES_           mov
	#define LDS_           mov
#endif

/*
 * used to load word or byte parameters from the stack
*/
#define BYTE_0(b)          byte ptr (b)
#define BYTE_1(b)          byte ptr (b)[1]
#define WORD_0(w)          word ptr (w)
#define WORD_1(w)          word ptr (w)[2]

/*
 * Use those for functions returning long/ulong to avoid compiler warning
 * when the return value is already in DX:AX.  Example: return RET_LONG;
*/
#define RET_LONG  (long)((void _seg *)(_DX) + (void near *)(_AX))
#define RET_ULONG (unsigned long)((void _seg *)(_DX) + (void near *)(_AX))

#endif
