


GETOPT(3)           Linux Programmer's Manual           GETOPT(3)


NNAAMMEE
       getopt - Read command line options

SSYYNNOOPPSSIISS
       ##iinncclluuddee <<uunniissttdd..hh>>

       iinntt ggeettoopptt((iinntt _a_r_g_c,, cchhaarr ** ccoonnsstt _a_r_g_v_[_],,
                  ccoonnsstt cchhaarr **_o_p_t_s_t_r_i_n_g));;

       eexxtteerrnn cchhaarr **_o_p_t_a_r_g;;
       eexxtteerrnn iinntt _o_p_t_i_n_d,, _o_p_t_e_r_r,, _o_p_t_o_p_t;;

       ##iinncclluuddee <<ggeettoopptt..hh>>

       iinntt ggeettoopptt__lloonngg((iinntt _a_r_g_c,, cchhaarr ** ccoonnsstt _a_r_g_v_[_],,
                       ccoonnsstt cchhaarr **_s_h_o_r_t_o_p_t_s,,
                       ccoonnsstt ssttrruucctt ooppttiioonn **_l_o_n_g_o_p_t_s,, iinntt _l_o_n_g_i_n_d));;

DDEESSCCRRIIPPTTIIOONN
       The  ggeettoopptt(())  function parses the command line arguments.
       Its arguments _a_r_g_c and _a_r_g_v are  the  argument  count  and
       array  as passed to the mmaaiinn(()) function on program invoca-
       tion.  _o_p_t_s_t_r_i_n_g is a list of available option characters.
       If  such  a  character  is followed by a colon, the option
       takes an argument, which is placed in _o_p_t_a_r_g.

       The external variable _o_p_t_i_n_d is  the  index  of  the  next
       array  element  of _a_r_g_v_[_] to be processed; it communicates
       from one call of ggeettoopptt(()) to the  next  which  element  to
       process.

       The ggeettoopptt__lloonngg(()) function works like ggeettoopptt(()) except that
       it also accepts long options, started out by  two  dashes.
       If these take values, it is either in the form ----aarrgg==vvaalluuee
       or ----aarrgg vvaalluuee.  It takes the  additional  arguments  _l_o_n_-
       _g_o_p_t_s  which is a pointer to the first element of an array
       of ssttrruucctt ooppttiioonn declared in <<ggeettoopptt..hh>> as

          struct option {
              const char *name;
              int has_arg;
              int *flag;
              int val;
          };

          The meaning of the different fields are:

       _n_a_m_e   is the name of the long option.

       _h_a_s___a_r_g
              is a boolean value which should be set  to  nonzero
              if the long option takes a value.

       _f_l_a_g   determines   the   return  value  if  ggeettoopptt__lloonngg(())



GNU                       April 25, 1993                        1





GETOPT(3)           Linux Programmer's Manual           GETOPT(3)


              returns a value for a long option; if  it  is  non-
              zero,  zero is returned as a function value, other-
              wise _v_a_l.

       _v_a_l    determines the value to return if _f_l_a_g is zero.

       The last element of  the  array  has  to  be  filled  with
       zeroes.

       The  _o_p_t_i_o_n___i_n_d_e_x  points  to the index of the long option
       relative to _l_o_n_g_o_p_t_s.

RREETTUURRNN VVAALLUUEE
       The ggeettoopptt(()) function returns the option character if  the
       option  was found successfully, ':' if there was a missing
       parameter for one of  the  options,  '?'  for  an  unknown
       option character and -1 for the end of the option list.

EEXXAAMMPPLLEE
       The  following  example  program,  from  the  source code,
       illustrates the use of ggeettoopptt__lloonngg(()) with most of its fea-
       tures.

       #include <stdio.h>

       int
       main (argc, argv)
            int argc;
            char **argv;
       {
         int c;
         int digit_optind = 0;

         while (1)
           {
             int this_option_optind = optind ? optind : 1;
             int option_index = 0;
             static struct option long_options[] =
             {
            {"add", 1, 0, 0},
            {"append", 0, 0, 0},
            {"delete", 1, 0, 0},
            {"verbose", 0, 0, 0},
            {"create", 1, 0, 'c'},
            {"file", 1, 0, 0},
            {0, 0, 0, 0}
             };

             c = getopt_long (argc, argv, "abc:d:012",
                        long_options, &option_index);
             if (c == -1)
            break;

             switch (c)



GNU                       April 25, 1993                        2





GETOPT(3)           Linux Programmer's Manual           GETOPT(3)


            {
            case 0:
              printf ("option %s", long_options[option_index].name);
              if (optarg)
                printf (" with arg %s", optarg);
              printf ("0);
              break;

            case '0':
            case '1':
            case '2':
              if (digit_optind != 0 && digit_optind != this_option_optind)
                printf ("digits occur in two different argv-elements.0);
              digit_optind = this_option_optind;
              printf ("option %c0, c);
              break;

            case 'a':
              printf ("option a0);
              break;

            case 'b':
              printf ("option b0);
              break;

            case 'c':
              printf ("option c with value `%s'0, optarg);
              break;

            case 'd':
              printf ("option d with value `%s'0, optarg);
              break;

            case '?':
              break;

            default:
              printf ("?? getopt returned character code 0%o ??0, c);
            }
           }

         if (optind < argc)
           {
             printf ("non-option ARGV-elements: ");
             while (optind < argc)
            printf ("%s ", argv[optind++]);
             printf ("0);
           }

         exit (0);
       }

BBUUGGSS
       This manpage is confusing.



GNU                       April 25, 1993                        3





GETOPT(3)           Linux Programmer's Manual           GETOPT(3)


CCOONNFFOORRMMSS TTOO
       ggeettoopptt(()) :
              POSIX.1






















































GNU                       April 25, 1993                        4


