# Makefile for the Borland C++ 3.1 Compiler
#
# fls MS-DOS Standard Executable
# Copyright (C) 1995 by Branislav L. Slantchev
#
# This file is part of the fls.
#
# fls is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2.
#
# fls is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with fls; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#

.AUTODEPEND

CC = bcc +FLS.CFG
TLINK = tlink
LIBPATH = C:\LIB
INCLUDEPATH = C:\INC;.

.c.obj:
  $(CC) -c {$< }

EXE_dependencies =  \
 main.obj \
 basename.obj \
 fail.obj \
 getopt.obj \
 listarea.obj \
 getopt1.obj \
 templ.obj \
 cfmt.obj

fls.exe: fls.cfg $(EXE_dependencies)
  $(TLINK) /x/n/c/P-/L$(LIBPATH) @&&|
c0s.obj+
main.obj+
basename.obj+
fail.obj+
getopt.obj+
listarea.obj+
getopt1.obj+
templ.obj+
cfmt.obj
fls

emu.lib+
maths.lib+
cs.lib
|


main.obj: fls.cfg main.c
basename.obj: fls.cfg basename.c
fail.obj: fls.cfg fail.c
getopt.obj: fls.cfg getopt.c
listarea.obj: fls.cfg listarea.c
getopt1.obj: fls.cfg getopt1.c
templ.obj: fls.cfg templ.c
cfmt.obj: fls.cfg cfmt.c

clean:
	del main.obj
	del basename.obj
	del fail.obj
	del getopt.obj
	del listarea.obj
	del getopt1.obj
	del templ.obj
	del cfmt.obj

fls.cfg: fls.mak
  copy &&|
-G
-O
-Og
-Oe
-Om
-Ov
-Ol
-Ob
-Op
-Oi
-Z
-k-
-vi-
-wbbf
-wpin
-wamb
-wamp
-wasm
-wpro
-wcln
-wdef
-wsig
-wnod
-wstv
-wucp
-wuse
-weas
-wpre
-n.
-I$(INCLUDEPATH)
-L$(LIBPATH)
-P.C
| fls.cfg


