/***********************************************************************
*                                                                      *
*   Program  FULLEDIT                                                  *
*   Author   Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*   eMail  : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*   Purpose  Fullscreen editor for Proboard                            *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*   This source is copyrighted and distributed under the GNU license   *
*                                                                      *
*   If you use parts of this source and distribute compiled versions   *
*   of it, you have to make your source available!!!                   *
*                                                                      *
*                                                                      *
*----------------------------------------------------------------------*
*  $Log: fulledit.cpv $
// Revision 1.10  1995/05/27  11:31:13  BRAINBOX
// Version 0.71
//
// Revision 1.9  1995/05/14  15:12:18  BRAINBOX
// Version 0.7
//
// Revision 1.8  1994/09/08  11:44:27  BRAINBOX
// 1. Support for different character sets
//
// Revision 1.6  1994/08/27  11:21:14  BRAINBOX
// 1. Added quote colors to quote lines
//                                                *
*  Revision 1.5  1994/08/20  13:31:10  BRAINBOX                        *
*  1. More functionality implemented (insertmode, deleteword etc.)     *
*  2. Help implemented                                                 *
*  3. Border and edit border implemented                               *
*                                                                      *
*  Revision 1.4  1994/08/12  14:23:34  BRAINBOX                        *
*  1. Attempt to write a CTRL A                                        *
*                                                                      *
*  Revision 1.3  1994/08/11  22:31:52  BRAINBOX                        *
*  1. First gamma version for distribution                             *
*                                                                      *
*                                                                      *
************************************************************************
*/

#include "PB_MBH.H"
#include "quote.cpp"
#include "border.hpp"

#define VERSION "FullEdit 0.71 "

bool exitFullEdit ;

unsigned char HeaderBack, HeaderTop, HeaderBot,
              HeaderTXT1, HeaderTXT2,
              StatusBack, StatusTop, StatusBot,
              StatusTXT1,
              EditBack, EditTXT1,
              HelpBack, HelpTop, HelpBot ;
char exotic[MAXPATH] ;

struct MSGINF
{
   char from[36] ;
   char to[36] ;
   char subj[72] ;

   char msgnr[11] ;
   char area[36] ;
   char priv[4] ;
} ;



class FullEdit : public QuoteEdit
{
   public:

      FullEdit(int x1, int y1, int x2, int y2, unsigned char *s)
         : QuoteEdit(x1, y1, x2, y2, s){ ; } ;
      int processKey(unsigned int)  ;
} ;

class HelpEdit : public Edit
{
   public:

      HelpEdit(int x1, int y1, int x2, int y2, unsigned char *s)
         : Edit(x1, y1, x2, y2, s) { ; } ;
      int processKey(unsigned int)  ;
} ;

int FullEdit::processKey(unsigned int key)
{
   switch (key)
   {
   case KEY_ESC:
      exitFullEdit = TRUE ;
      break ;
   }
   // Process some exotic keys :-)
   if (strchr(exotic,key) != NULL)
      Edit::addchar(key) ;
   return key ;
}

int HelpEdit::processKey(unsigned int key)
{
   return key ;
}

int readMsgInf(MSGINF *inf)
{
   FILE *in ;

   if ( (in=fopen("MSGINF","rt")) == NULL)
   {
#ifdef _PB_SDK_H
      strcpy(inf->from, CurUser->name) ;
      strcpy(inf->to, "") ;
      strcpy(inf->msgnr, "") ;
      strcpy(inf->subj,"") ;
      strcpy(inf->area,"") ;
      strcpy(inf->priv,"") ;
#endif
      return 1 ;
   }
   fgets(inf->from,35,in) ;
   inf->from[strlen(inf->from) -1] = '\0' ;
   fgets(inf->to,35,in) ;
   inf->to[strlen(inf->to) -1] = '\0' ;
   fgets(inf->subj,71,in) ;
   inf->subj[strlen(inf->subj) -1] = '\0' ;
   fgets(inf->msgnr,10,in) ;
   inf->msgnr[strlen(inf->msgnr) -1] = '\0' ;
   fgets(inf->area,35,in) ;
   inf->area[strlen(inf->area) -1] = '\0' ;
   fgets(inf->priv,4,in) ;
   inf->priv[strlen(inf->priv) -1] = '\0' ;
   fclose(in) ;

   return 0 ;
}

void readColors(char *inifile)
{
   strcpy(exotic,"") ;
#ifdef _PB_SDK_H
   char value[256] ;

   if (GetIniVar(inifile,"HeaderBack",value,255))
      HeaderBack = atoi(value) ;
   if (GetIniVar(inifile,"HeaderTop",value,255))
      HeaderTop = atoi(value) ;
   if (GetIniVar(inifile,"HeaderBot",value,255))
      HeaderBot = atoi(value) ;
   if (GetIniVar(inifile,"HeaderTXT1",value,255))
      HeaderTXT1 = atoi(value) ;
   if (GetIniVar(inifile,"HeaderTXT2",value,255))
      HeaderTXT2 = atoi(value) ;

   if (GetIniVar(inifile,"StatusBack",value,255))
      StatusBack = atoi(value) ;
   if (GetIniVar(inifile,"StatusTop",value,255))
      StatusTop = atoi(value) ;
   if (GetIniVar(inifile,"StatusBot",value,255))
      StatusBot = atoi(value) ;
   if (GetIniVar(inifile,"StatusTXT1",value,255))
      StatusTXT1 = atoi(value) ;

   if (GetIniVar(inifile,"EditBack",value,255))
      EditBack = atoi(value) ;
   if (GetIniVar(inifile,"EditTXT1",value,255))
      EditTXT1 = atoi(value) ;

   if (GetIniVar(inifile,"HelpBack",value,255))
      HelpBack = atoi(value) ;
   if (GetIniVar(inifile,"HelpTop",value,255))
      HelpTop = atoi(value) ;
   if (GetIniVar(inifile,"HelpBot",value,255))
      HelpBot = atoi(value) ;

   GetIniVar(inifile,"Exotic",exotic,MAXPATH) ;
#endif
}

void initColors(void)
{
   HeaderBack = (C_LIGHTGRAY << 4) | C_BLACK ;
   HeaderTop  = (C_LIGHTGRAY << 4) | C_WHITE ;
   HeaderBot  = (C_LIGHTGRAY << 4) | C_DARKGRAY ;
   HeaderTXT1 = (C_LIGHTGRAY << 4) | C_BLUE ;
   HeaderTXT2 = (C_LIGHTGRAY << 4) | C_RED ;

   StatusBack = (C_LIGHTGRAY << 4) | C_RED ;
   StatusTop  = (C_LIGHTGRAY << 4) | C_WHITE ;
   StatusBot  = (C_LIGHTGRAY << 4) | C_DARKGRAY ;
   StatusTXT1 = (C_LIGHTGRAY << 4) | C_LIGHTGREEN ;

   EditBack   = (C_LIGHTGRAY << 4) | C_BLUE ;
   EditTXT1   = (C_LIGHTGRAY << 4) | C_LIGHTBLUE ;

   HelpBack   = (C_RED << 4) | C_YELLOW ;
   HelpTop    = (C_RED << 4) | C_BROWN ;
   HelpBot    = (C_RED << 4) | C_LIGHTRED ;
}

// The editor part itself
int doedit(MSGINF *inf)
{
   unsigned int key ;
   char     abblist[MAXPATH] ;
   char     helpfile[MAXPATH] ;
   char     inifile[MAXPATH] ;
   int      y_status ;
   bool     ini ;


#ifdef _PB_SDK_H
   sprintf(abblist,"%s\\FULLEDIT.LST",Config->pexpath) ;
   sprintf(helpfile,"%s\\FULLEDIT.HLP",Config->pexpath) ;
   sprintf(inifile,"%s\\FULLEDIT.INI",Config->pexpath) ;

   y_status = 7 + CurUser->screenLength - 5 - 3 - 2 ; // minus HEADER, STATUS, RESERVE
   FullEdit edit(1,6,80,CurUser->screenLength - 5,(unsigned char *) "") ;
#else
   strcpy(abblist,"FULLEDIT.LST") ;
   strcpy(helpfile,"FULLEDIT.HLP") ;
   strcpy(inifile,"FULLEDIT.INI") ;

   y_status = 21 ;
   FullEdit edit(1,6,80,24 - 5,(unsigned char*) "") ;
#endif


    initColors() ;

    ini = !access(inifile,0) ;
#ifdef _PB_SDK_H
    if (ini)
      readColors(inifile) ;

	 if ( access("MSGTMP",0) == 0 )
	 {
       printf("\nDo you want to use the quote ") ;
       if (Ask(TRUE))
          if (edit.loadFile("MSGTMP") != 0)
             edit.setText("Error loading quote") ;
	 }
#else
       if (edit.loadFile("MSGTMP") != 0)
#endif


   clrscr() ;
   Border headerborder(3, 2, 78, 4);
   Border statusborder(3, y_status, 78, y_status);
   headerborder.setTopColor(HeaderTop) ;
   headerborder.setBotColor(HeaderBot) ;
   statusborder.setTopColor(StatusTop) ;
   statusborder.setBotColor(StatusBot) ;
   headerborder.open();
   statusborder.open();



   textattr(HeaderBack) ;
   gotoxy(5,2)  ; cprintf("From :") ;
   gotoxy(5,3)  ; cprintf("To   :") ;
   gotoxy(5,4)  ; cprintf("Subj :") ;

   gotoxy(49,2) ; cprintf("Area  :") ;
   gotoxy(49,3) ; cprintf("MsgNr :") ;

   textattr(HeaderTXT1) ;
   gotoxy(12,2) ; cprintf("%.35s",inf->from) ;
   gotoxy(12,3) ; cprintf("%.35s",inf->to) ;
   gotoxy(57,3) ; cprintf("%.5s",inf->msgnr) ;

   textattr(HeaderTXT2) ;
   gotoxy(12,4) ; cprintf("%.35s",inf->subj) ;
   gotoxy(57,2) ; cprintf("%.20s",inf->area) ;


   edit.setColor( EditBack ) ;
   edit.setQuoteColor(EditTXT1) ;
   edit.loadAbbreviation(abblist) ;


   edit.setInput(INPUT_KEYBOARD | INPUT_PEXUSER) ;
   edit.Output::setTerm(TERM_SCREEN) ;
   edit.Instream::setTerm(TERM_SCREEN) ;
   edit.setOutput(OUTPUT_CON) ;


   edit.redraw() ;


   do
   {
      exitFullEdit = FALSE ;
      textattr(StatusBack ) ;
      gotoxy(4,y_status) ; cprintf("   Press <ESC> for menu options                         ") ;
      textattr(StatusTXT1) ;
      cprintf(VERSION) ;
      edit.redrawCursor() ;
      key = NULL ;
      while (!exitFullEdit)
      {
         if ((key = edit.poll()) != NULL)
            edit.interpKey(key) ;
#ifdef _PB_SDK_H
         if (BaudRate != 0)
            if (!IO_Carrier())
            {
               unlink("MSGTMP") ;
               exit(1) ;
            }

#endif
      }
      textattr(StatusBack) ;
      gotoxy(4,y_status) ; cprintf("   <A> Abort   <S> Save   <Enter> continue editing        <H> Help      ") ;

#ifdef _PB_SDK_H
      key = WaitKeys("HAS\r") ;
#else
      key = toupper(getch()) ;
#endif

       if ( key == 'H' ) {
          HelpEdit help(10, 8, 70, y_status - 5, (unsigned char *) "");
          if (help.loadFile(helpfile) == 0)
          {
             help.setColor(HelpBack) ;
             help.setEditable(FALSE);
             help.setInput(INPUT_KEYBOARD | INPUT_PEXUSER) ;

             help.setTopColor(HelpTop) ;
             help.setBotColor(HelpBot) ;
             help.setBorder(1) ;
             help.drawborder();

             help.redraw();
             help.change();
             edit.redraw();
          }
          else
          {
             gotoxy(4,y_status) ;
             cprintf("   No help available.                Press any key to continue      ") ;
#ifdef _PB_SDK_H
             key = WaitKey() ;
#else
             key = toupper(getch()) ;
#endif
          }
          key = '\r';
       }  // end Help key pressed
   } while (key == '\r') ;


    if (key == 'S')
    {
      edit.saveFile("MSGTMP") ;

    }
	 if ( key == 'A' )
			unlink("MSGTMP") ;
    printf("\n") ;
	 return 0 ;
}

int main()
{
   MSGINF msginf ;

#ifdef _PB_SDK_H
   if ( (CurUser->uFlags & UFLAG_ANSI) ||
        (CurUser->uFlags & UFLAG_AVATAR) ||
        (CurUser->uFlags & UFLAG_AVTPLUS) )
   {
#endif
      readMsgInf(&msginf) ;
      return doedit(&msginf) ;
#ifdef _PB_SDK_H
   } else
   {
      printf("You can't use the full screen editor in ASCII mode.\nShould I change your settings. ") ;
      if (Ask(TRUE))
      {
         CurUser->uFlags = CurUser->uFlags | UFLAG_ANSI ;
         readMsgInf(&msginf) ;
         doedit(&msginf) ;
         CurUser->uFlags = CurUser->uFlags & ~UFLAG_ANSI ;
      }
      else
      {
         CurUser->uFlags = CurUser->uFlags & ~UFLAG_FSED ;
      }
   }
#endif
   return 0 ;
}
