Uses Cfg;
Uses User;

Type
  RecUser = Record                                         // USERS.DAT
    PermIdx      : Array[1..8] Of Byte;    
    Handle       : String[30];                             // Handle
    Various      : Array[1..1013] Of Byte;    
    
    Calls        : LongInt;                                // Number of calls to BBS
    CallsToday   : Word;                              // Number of calls today
    DLs          : Word;                              // # of downloads
    DLsToday     : Word;                              // # of downloads today
    DLk          : LongInt;                                // # of downloads in K
    DLkToday     : LongInt;                                // # of downloaded K today
    ULs          : LongInt;                                // total number of uploads
    ULk          : LongInt;                                // total number of uploaded K
    Posts        : LongInt;                                // total number of msg posts
    Emails       : LongInt;                                // total number of sent email
    TimeLeft     : LongInt;
    Various2     : Array[1..446] Of Byte;
  End;

Type
  RecLastOn = Record                                            // CALLERS.DAT
    DateTime1  : LongInt;
    NewUser    : Boolean;
    PeerIP     : String[15];
    PeerHost   : String[50];
    Node       : Byte;
    CallNum    : LongInt;
    Handle     : String[30];
    City       : String[25];
    Address    : String[30];
    Gender     : Char;
    EmailAddr  : String[35];
    UserInfo2  : String[30];
    OptionData : Array[1..10] of String[60];
                          // Reserved Block Additions
    ExitTime   : LongInt; // 4 : Exit Time to get duration
    
    Reserved   : Array[1..33] of Byte; 
                          // Actual size is 53. Minus 4 for the added fields
                          // equals 49 for the rest of the block.
                          
                          // 1 : Hacked           - 1 = True - 0 = False
                          // 2 : Drop Carrier     - 1 = True - 0 = False
                          // 3 : Downloaded Files - 0 = None
                          // 4 : Uploaded Files   - 0 = None
                          // 5 : Posted Msgs      - 0 = None
    PostsToday  : LongInt;
    LoginTime   : LongInt;
    UpFiles     : LongInt;
    UpkFiles    : LongInt;
  End;
  
Var CallersFile	: String = CfgDataPath+'callers.dat';
Var UsersFile	: String = CfgDataPath+'users.dat';

Procedure GetUserInfo(Handle:String; Var rec:RecUser);
Var Fp	 : file
Var ii   : Integer;
Var User : RecUser;
Begin
	fAssign(Fp,UsersFile,66);
	fReset(Fp);
  FillChar(User, SizeOf(User), #0);
  ii:=0;
	If IoResult = 0 Then Begin
		While Not fEof(fp) Do Begin
			fReadRec(Fp,User);
      If User.Handle = Handle Then Begin
        rec := User;
        Break;
      End;
      ii := ii + 1;
    End;
		fClose(Fp);
	End;
End;

Procedure SetUpLogin;
Var
  Fp   : File;
  User : RecLastOn;
  tUser: RecLastOn;
  pUser : RecUser;
  i,d  : Byte;
Begin
  fAssign(Fp,CallersFile,66);
	fReset(Fp);
  i:=0;
	If IoResult <> 0 Then Exit;
  
 While i<=9 Do Begin
    fSeek(fp,(9-i)*SizeOf(User));
    fReadRec(Fp,User);
    if Upper(User.Handle) = Upper(UserAlias) Then Break;
    i := i + 1;
  End;
  GetUserInfo(User.Handle,pUser);
  User.UpFiles:=pUser.ULs;    // Save Total ULs
  User.UpkFiles:=pUser.ULk;   // Save Total ULk
  User.PostsToday := pUser.Posts;  // Save Total Posts
  fSeek(fp,(9-i)*SizeOf(User));
  fWriteRec(Fp,User);
  fClose(Fp);
End;

Procedure SetUpLogOut;
Var
  Fp   : File;
  User : RecLastOn;
  tUser: RecLastOn;
  pUser : RecUser;
  i,d  : Byte;
Begin
  fAssign(Fp,CallersFile,66);
	fReset(Fp);
  i:=0;
	If IoResult <> 0 Then Exit;
  
 While i<=9 Do Begin
    fSeek(fp,(9-i)*SizeOf(User));
    fReadRec(Fp,User);
    if Upper(User.Handle) = Upper(UserAlias) Then Break;
    i := i + 1;
  End;
  GetUserInfo(User.Handle,pUser);
  User.UpFiles:=pUser.ULs - User.UpFiles;
  User.UpkFiles:=pUser.ULk -User.UpkFiles;
  User.PostsToday :=pUser.Posts - User.PostsToday;
  fSeek(fp,(9-i)*SizeOf(User));
  fWriteRec(Fp,User);
  fClose(Fp);
End;


Procedure SetData(P: Byte; F:Byte);
Var
  Fp   : File;
  User : RecLastOn;
  tUser: RecLastOn;
  i,d  : Byte;
Begin
  fAssign(Fp,CallersFile,66);
	fReset(Fp);
  i:=0;
	If IoResult <> 0 Then Exit;
  
  While i<=9 Do Begin
    fSeek(fp,(9-i)*SizeOf(User));
    fReadRec(Fp,User);
    if Upper(User.Handle) = Upper(UserAlias) Then Break;
    i := i + 1;
  End;
  User.Reserved[P]:=F;
  fSeek(fp,(9-i)*SizeOf(User));
  fWriteRec(Fp,User);
  fClose(Fp);
End;

Function ReadData(P: Byte):Byte;
Var
  Fp   : File;
  User : RecLastOn;
  tUser: RecLastOn;
  i,d  : Byte;
Begin
  fAssign(Fp,CallersFile,66);
	fReset(Fp);
  i:=0;
	If IoResult <> 0 Then Exit;
  
  While i<=9 Do Begin
    fSeek(fp,(9-i)*SizeOf(User));
    fReadRec(Fp,User);
    if Upper(User.Handle) = Upper(UserAlias) Then Break;
    i := i + 1;
  End;
  ReadData:=User.Reserved[P];
  
  fClose(Fp);
End;

Procedure SetExitTime(T:LongInt);
Var
  Fp   : File;
  User : RecLastOn;
  tUser: RecLastOn;
  i,d  : Byte;
Begin
  fAssign(Fp,CallersFile,66);
	fReset(Fp);
  i:=0;
	If IoResult <> 0 Then Exit;
  
  While i<=9 Do Begin
    fSeek(fp,(9-i)*SizeOf(User));
    fReadRec(Fp,User);
    if Upper(User.Handle) = Upper(UserAlias) Then Break;
    i := i + 1;
  End;
  User.ExitTime:=T;
  fSeek(fp,(9-i)*SizeOf(User));
  fWriteRec(Fp,User);
  fClose(Fp);
End;

Procedure SetLoginTime(T:LongInt);
Var
  Fp   : File;
  User : RecLastOn;
  tUser: RecLastOn;
  i,d  : Byte;
Begin
  fAssign(Fp,CallersFile,66);
	fReset(Fp);
  i:=0;
	If IoResult <> 0 Then Exit;
  
   While i<=9 Do Begin
    fSeek(fp,(9-i)*SizeOf(User));
    fReadRec(Fp,User);
    if Upper(User.Handle) = Upper(UserAlias) Then Break;
    i := i + 1;
  End;
  User.LoginTime:=T;
  fSeek(fp,(9-i)*SizeOf(User));
  fWriteRec(Fp,User);
  fClose(Fp);
End;

Function ReadExitTime:LongInt;
Var
  Fp   : File;
  User : RecLastOn;
  i    : Byte;
Begin
  fAssign(Fp,CallersFile,66);
	fReset(Fp);
  i:=0;
	If IoResult <> 0 Then Exit;

  While i<=9 Do Begin
    fSeek(fp,(9-i)*SizeOf(User));
    fReadRec(Fp,User);
    
    if Upper(User.Handle) = Upper(UserAlias) Then Break;
    i := i + 1;
  End;

  ReadExitTime:=User.ExitTime;
  
  fClose(Fp);
End;

Var
  P1,P2,P3: String;

// Main Block
Begin
  
  If ParamCount < 1 Then Begin
    WriteLn('|15|16No parameters. Read the Sysop.txt for help|07');
    Pause;
    Exit;
  End;
  
  GetThisUser;
  
  P1 := Upper(ParamStr(1));
  P2 := Upper(ParamStr(2));

  If P1 = 'LOGIN' Then Begin
    SetLoginTime(Timer);
    SetUpLogin;
  End Else If P1 = 'LOGOUT' Then Begin
    SetExitTime(Timer);
    SetUpLogOut;
  End Else SetData(Str2Int(P1), Str2Int(P2));
  
End;
