(*
   RCS AutoMSG
   
   Copyright 2020 Black Panther(RCS) <dan@castlerockbbs.com>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
     
2020-10-29  Black Panther(RCS)  <dan@castlerockbbs.com>

*)

(*
 ---------------------------------------------------------------------------
 zAutoMSG (C) 1999 By zoob.  All Rights Reserved.
 RCSAutoMSG (C) 2020 By Black Panther(RCS).  All Rights Reserved.
 ---------------------------------------------------------------------------
 Feel free to modify this, but give credit to me if you release it.
 ---------------------------------------------------------------------------
 Updated by Black Panther(RCS) to use with Mystic v1.12A46+
*)

USES CFG
USES USER

Const
  ProgName = 'RCS Auto Message'
  ProgVer  = '7.2(RCS)'

Var
  F1       :String=cfgdatapath+'rcsauto.lst'
  F2       :String=cfgdatapath+'rcsauto.tmp'
  A        :Byte
  B        :Byte
  C1       :String
  C2       :String
  txtToUse :Array[1..16] of string
  fptr     :File
  msgenter :Boolean=false

Procedure Ask
Begin
  If InputYN('|09D|03o you want to add something? ')=false then Halt
  If Not FileExist(F1) then
  Begin
	  fAssign(fptr,F1,66)
	  fReWrite(fptr)
    fClose(fptr)
  End
  For A := 1 to 12 do
  Begin
    B := A + 4
    txtToUse[A] := txtToUse[B]
  End
  GetThisUser
  txtToUse[13] := userAlias
  WriteLn('|09Y|03ou have three lines.  Press enter on unused lines.')
  Write(c1+'1: '+c2) txtToUse[14] := Input(70, 70, 11, '')
  If txtToUse[14] <> '' then
  Begin
    Write(c1+'2: '+c2) txtToUse[15] := Input(70, 70, 11, '')
    Write(c1+'3: '+c2) txtToUse[16] := Input(70, 70, 11, '')
  end Else
  Begin
    WriteLn(c2+'aborted')
    Halt
  End
  fAssign(fptr,F2,66)
  fReWrite(fptr)
  For A := 1 to 16 do
    FWriteLn(fptr,txtToUse[A])
  FClose(fptr)
  If Not FileCopy(F2, F1) then
  Begin
    Repeat
      Delay(100)
    Until FileCopy(F2, F1)
  End
  FileErase(F2)
End
  
Procedure init
Begin
  Case Upper(ParamStr(1)) of  //This can be called with a color parameter
    'BLUE'   : 
       Begin
         c1 :='|01'
         c2 :='|09'
       End
    'GREEN'  :
       Begin
         c1 :='|02'
         c2 :='|10'
       End
    'CYAN'   :
       Begin
         c1 :='|03'
         c2 :='|11'
       End
    'RED'    :
       Begin
         c1 :='|04'
         c2 :='|12'
       End
    'MAGENTA':  
       Begin
         c1 :='|05'
         c2 :='|13'
       End
    'YELLOW' :
       Begin
         c1 :='|06'
         c2 :='|14'
       End
    'GREY'   :
       Begin
         c1 :='|07'
         c2 :='|15'
       End
  Else
    Begin
      c1 :='|01'
      c2 :='|09'
    End 
    msgenter:=true
End  
  
procedure show
Begin  
  WriteLn('|08--- '+c2+ProgName+' '+c1+'v'+ProgVer+' by '+c2+'Black Panther(RCS)')
  If Not FileExist (F1) then
  Begin
    WriteLn('|08--- '+c2+'n'+c1+'o|08 messages available')
    WriteLn('|08')
    Ask
  End
  Else
  Begin
    fAssign(fptr,F1,66)
    fReset(fptr)
    For A := 1 To 16 do
      FReadLn(fptr, txtToUse[A])
    FClose(fptr)
  End
  A := 0
  Repeat
  Begin
    A := A + 1
    WriteLn('|08--- '+c2+txtToUse[A])
    A := A + 1
    WriteLn('|08 '+c1+txtToUse[A])
    A := A + 1
    WriteLn('|08 '+c1+txtToUse[A])
    A := A + 1
    WriteLn('|08 '+c1+txtToUse[A])
    If A < 16 Then
      WriteLn('|08')
    Else
      WriteLn('|08|CR')
  Until A > 15
End

Begin
  clrscr
  init
  Show
  Ask
  if msgenter then show
End
