(*
   RCS Game Room
   
   Copyright 2021 RCS Development Team <rcs@castlerockbbs.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
   
**************

In the ANSI file, there needs to be indicators as to where the menu is going
to be displayed, along with where the marquee will be displayed. This is done
with the |!1 type of MCI code within the ANSI.

|!1 and |!2 indicate the top left and bottom right of the area for the menu to
display.

|!3 and |!4 indicate the beginning and end of the area which will be where the
marquee will display.

When placing MCI codes such as the above indicators into an ANSI, it's important 
to know that those MCI codes add 3-6 characters to the total width of your 
ansi, example:  |!1 adds 3 characters.  When displayed on the BBS, Mystic will 
reduce the characters by 3 after the MCI code is executed.  As a result, 
modifying the included ansi's will require working within a text editor to insert 
3 spaces after each indicator.  If you are not comfortable with modifying ANSI's, 
it's recommended to use the included with this mod and/or to seek assistance on 
The Underground Discord Server under the RCS Discussion and Help Channel, 
@ https://discord.gg/FdF3ECjF48

**************

Releases:
  v1.2  - 22 May 2021

*)

Uses
  Cfg,
  User
  
Const
  //*****  Linux Command lines  *****
  
  //BBSLink Command line information
  BBSL_BFR_CMD     = 'python2 bbslink.py'    //BBSLink Command line before door code
  BBSL_AFT_CMD     = '%#'                    //Command line after door code
  
  //DoorParty Command line information
  DP_BFR_CMD       = 'dp.sh %U'              //DoorParty Command line before door code
  DP_AFT_CMD       = ''                      //Command line after door code
  
  //*****  Windows Command lines  *****
  
  //BBSLink Command line information
  //BBSL_BFR_CMD     = 'c:\mystic\bbslink\bbslink.bat'    //BBSLink Command line before door code
  //BBSL_AFT_CMD     = '%Pdoor32.sys'                    //Command line after door code
  
  //DoorParty Command line information
  //DP_BFR_CMD       = 'c:\mystic\doorparty\dp.bat %3 %U'             //DoorParty Command line before door code
  //DP_AFT_CMD       = ''                      //Command line after door code
  
  //Sub-directory where .INI files are located - from scripts directory
  MENU_SUB_DIR     = 'rcsmenus'
  
  //Sub-directory where data files will be located - from scripts directory
  DATA_SUB_DIR     = 'rcsmenudat'
  
  //Name indicated in the ini file for your top (main) menu
  //This needs to match what it in the ini file, as it determines which Top 5 to display
  MAIN_MENU        = 'Main'
  
  //This is the command separator for use in the INI files. Some command lines include
  //specific characters which could not then be used as a separator. If you need to change
  //this, make sure you change it in ALL of the INI files. CHANGE WITH CAUTION as this
  //could cause major issues with some commands!
  CMD_SEPARATOR    = '='
  
  
// *** DO NOT EDIT BELOW THIS LINE!!  *** //

  PROG_NAME        = 'RCS Game Room'
  PROG_VER         = '1.2'
  keyHome          = #71;      
  keyCursorUp      = #72;     
  keyPgUp          = #73;
  keyCursorLeft    = #75;      
  KeyNum5          = #76;     
  keyCursorRight   = #77;
  keyEnd           = #79;
  keyCursorDown    = #80;
  keyPgDn          = #81;

Type
  MenuItem = Record
    X       : Byte
    Y       : Byte
    On      : String[30]
    Off     : String[30]
    Key     : Byte
    KeyChar : Char
    Name    : String[30]
    SecLev  : Byte
    MysCmd  : String[5]
    MysData : String
  End
  
Type
  MenuSave = Record
    Name    : String[30]
    Category: String[30]
    Played  : Integer
  End
  
Var
  MYST_DOOR_CMD  : String='DD'               //Default Mystic Menu Command
                                             //Door Commands within the .ini files will overwrite this default, along with OS dependent settings
  OS        : String[10]
  ItemNum   : Byte
  Menu      : Array[1..36] of MenuItem
  PrevMenu  : Array[1..5] of String[10]
  MenuCnt   : Byte
  ANSI      : String[20]
  Cat       : String[30]
  HotKeyOn  : String
  HotKeyOff : String
  NameOn    : String
  NameOff   : String
  MarColor  : Byte
  MarDelay  : Integer
  Idx       : Byte=1
  Ch        : Char
  Mi        : Byte
  KeyOpt    : Byte
  Done      : Boolean=False
  Hg        : Boolean=False
  ScrnLen   : Byte
  PageTop   : Byte
  PageLeft  : Byte
  PageLen   : Byte
  PageWide  : Byte
  LineCnt   : Integer=1
  MenuCount : MenuSave
  Top5Str   : String
  BannerX1  : Byte
  BannerX2  : Byte
  BannerY   : Byte
  TimeStart : LongInt
  
Procedure CheckTimeOut;
Begin
  If CfgTimeOut>0 Then
  Begin
    If Timer-TimeStart>CfgTimeOut Then 
    Begin
      WriteLn(GetPrompt(136));
      SysopLog(PROG_NAME+': Inactivity timeout');
      write('|[1')
      HangUp;
    End
  End;
End;

Function IsNumber(str:String):Boolean   //unused at this time
Begin
  IsNumber:=Str2Int(str) > 0 Or str = '0'
End
  
Procedure Init
Begin
  Case OSType of
    0: OS:='Windows'
    1: OS:='Linux'
    2: OS:='Mac'
  End
  write('|00|[0')
  If OSType=0 Then MYST_DOOR_CMD:='D3'
  Else MYST_DOOR_CMD:='DD'
End

Function RemoveSpaces(s:String):String
Var
  x  : Byte
Begin
  x:=Length(s)
  Repeat
    If s[x]=' ' Then Delete(s,x,1)
    x:=x-1
  Until s[x]<>' '
  RemoveSpaces:=s
End
  
Procedure ReadIni(ini:String):Boolean
Var
  fptr    : File
  s       : String
  Count   : Byte=1
  Count1  : Byte=1
  Temp    : String
  KeyWord : String
  Opt     : String
  c       : Byte
Begin
  PrevMenu[MenuCnt]:=ini
  SysopLog(PROG_NAME+': Reading '+ini+'.ini file')
  For Count1:=1 To 36 Do
    FillChar(Menu[Count1], sizeof(Menu[Count1]),'');
  fAssign(fptr,AddSlash(CfgMpePath+MENU_SUB_DIR)+Ini+'.ini',66)
  fReset(fptr)
  If IoResult=0 Then
  Begin
    While Not fEof(fptr) Do
    Begin
      fReadLn(fptr,s)
      KeyWord:=Upper(WordGet(1,s,CMD_SEPARATOR))
      Opt:=RemoveSpaces(WordGet(2,s,CMD_SEPARATOR))
      Case KeyWord of
        'CATEGORY'          : Cat:=Opt
        'ANSI'              : ANSI:=Opt
        'HOT_KEY_ON_COLOR'  : Begin
                                If Opt[1]='|' Then
                                  HotKeyOn:=Opt
                                Else 
                                Begin
                                  For c:=1 to Length(Opt) Do
                                    If Ord(Opt[c])<48 Or Ord(Opt[c])>58 Then
                                      HotKeyOn:='|15'
                                  If HotKeyOn<>'|15' Then
                                    HotKeyOn:='|'+Opt
                                End
                              End
        'HOT_KEY_OFF_COLOR' : Begin
                                If Opt[1]='|' Then
                                  HotKeyOff:=Opt
                                Else
                                Begin
                                  For c:=1 to Length(Opt) Do
                                    If Ord(Opt[c])<48 Or Ord(Opt[c])>58 Then
                                      HotKeyOff:='|08'
                                  If HotKeyOff<>'|08' Then
                                    HotKeyOff:='|'+Opt
                                End
                              End
        'TEXT_ON_COLOR'     : Begin
                                If Opt[1]='|' Then
                                  NameOn:=Opt
                                Else
                                Begin
                                  For c:=1 to Length(Opt) Do
                                    If Ord(Opt[c])<48 Or Ord(Opt[c])>58 Then
                                      NameOn:='|15'
                                  If NameOn<>'|15' Then
                                    NameOn:='|'+Opt
                                End
                              End
        'TEXT_OFF_COLOR'    : Begin
                                If Opt[1]='|' Then
                                  NameOff:=Opt
                                Else
                                Begin
                                  For c:=1 to Length(Opt) Do
                                    If Ord(Opt[c])<48 Or Ord(Opt[c])>58 Then
                                      NameOff:='|08'
                                  If NameOff<>'|08' Then
                                    NameOff:='|'+Opt
                                End
                              End
        'MAR_TXT_COLOR'     : Begin
                                For c:=1 to Length(Opt) Do
                                  If Ord(Opt[c])<48 Or Ord(Opt[c])>58 Then
                                    MarColor:=11
                                If MarColor<>11 Then
                                  MarColor:=Str2Int(Opt)
                              End
        'MAR_DELAY_TIME'    : Begin
                                For c:=1 to Length(Opt) Do
                                  If Ord(Opt[c])<48 Or Ord(Opt[c])>58 Then
                                    MarDelay:=100
                                If MarDelay<>100 Then
                                  MarDelay:=Str2Int(Opt)
                              End
        'MENU'              : Begin
                                If Ord(WordGet(2,s,CMD_SEPARATOR))>=65 Then
                                Begin
                                  Menu[Count].KeyChar:=WordGet(2,s,CMD_SEPARATOR)
                                  Menu[Count].Key:=Count
                                End
                                Else If Ord(WordGet(2,s,CMD_SEPARATOR))<=57 Then
                                Begin
                                  Menu[Count].Key:=Str2Int(WordGet(2,s,CMD_SEPARATOR))
                                  Menu[Count].KeyChar:=''
                                End
                                Menu[Count].Name:=RemoveSpaces(WordGet(3,s,CMD_SEPARATOR))
                                Menu[Count].SecLev:=Str2Int(WordGet(4,s,CMD_SEPARATOR))
                                If WordGet(5,s,CMD_SEPARATOR)<>'' Then
                                  Menu[Count].MysCmd:=WordGet(5,s,CMD_SEPARATOR)
                                Else Menu[Count].MysCmd:=MYST_DOOR_CMD
                                Menu[Count].MysData:=Copy(s,WordPos(6,s,CMD_SEPARATOR),Length(s))
                                Menu[Count].On:=PadRt(Menu[Count].Name,30,' ')
                                Menu[Count].Off:=PadRt(Menu[Count].Name,30,' ')
                                If UserSec >= Menu[Count].SecLev Then
                                  Count:=Count+1
                                Else If UserSec < Menu[Count].SecLev Then
                                Begin
                                  Menu[Count].Key:=-1
                                  Menu[Count].KeyChar:=''
                                  Menu[Count].Name:=''
                                  Menu[Count].SecLev:=0
                                End
                              End
      End
    End
    fClose(fptr)
    ReadIni:=True
  End
  Else 
  Begin
    SysopLog(PROG_NAME+': Unable to open '+ini+'.ini file!')
    WriteLn('Unable to open Menu ini file')
    Delay(1000)
    ReadIni:=False
  End
  Mi:=Count-1
End

Procedure DrawMainScreen
Var X1, X2, Y1, Y2, X3, X4, Y3, Y4, Attr: Byte
Begin
  ClrScr
  DispFile(ANSI)
  GetScreenInfo(1,X1,Y1,Attr)
  GetScreenInfo(2,X2,Y2,Attr)
  GetScreenInfo(3,X3,Y3,Attr)
  GetScreenInfo(4,X4,Y4,Attr)
  PageTop:=Y1
  PageLeft:=X1
  PageLen:=Y2-Y1
  PageWide:=X2-X1
  BannerX1:=X3
  BannerX2:=X4
  BannerY:=Y3
End

Procedure DisplayMenu
Var
  X     : Byte=1
  Y     : Byte=1
  Count : Byte=1
Begin
  TextColor(7)
  X:=PageLeft
  Y:=PageTop
  For Count:=LineCnt to (PageLen-1)+LineCnt Do
  Begin
    Menu[Count].X:=X
    Menu[Count].Y:=Y
    GotoXY(X,Y)
    If (Menu[Count].Key<=9)And(Menu[Count].Key>0) Then
      Write(HotKeyOff+Int2Str(Menu[Count].Key)+' '+NameOff+PadRt(Menu[Count].Off,PageWide-1,' '))
    Else If (Ord(Menu[Count].KeyChar)>=65) And (Ord(Menu[Count].KeyChar)<=90) Then
      Write(HotKeyOff+Menu[Count].KeyChar+' '+NameOff+PadRt(Menu[Count].Off,PageWide-1,' '))
    Y:=Y+1
  End
  GotoXY(Menu[Idx].X,Menu[Idx].Y)
  If (Menu[Idx].Key<=9)And(Menu[Idx].Key>0) Then
    Write(HotKeyOn+Int2Str(Menu[Idx].Key)+' '+NameOn+PadRt(Menu[Idx].On,PageWide-1,' '))
  Else If (Ord(Menu[Idx].KeyChar)>=65) And (Ord(Menu[Count].KeyChar)<=90) Then
    Write(HotKeyOn+Menu[Idx].KeyChar+' '+NameOn+PadRt(Menu[Idx].On,PageWide-1,' '))
End

Procedure ReadTop5
Var
  fptr    : File
  s       : String=''
  fname2  : String
Begin
  Top5Str:=''
  If Cat=MAIN_MENU Then
    fname2:=AddSlash(CfgMpePath+DATA_SUB_DIR)+'rcsmenu.top'
  Else
    fname2:=AddSlash(CfgMpePath+DATA_SUB_DIR)+'rcsmenu.'+Cat+'.top'
  fAssign(fptr,fname2,66)
  fReset(fptr)
  If IoResult=0 Then
  Begin
    While Not fEof(fptr) Do
    Begin
      fReadLn(fptr,s)
      Top5Str:=StripR(Top5Str,' ')+'  '+PadRt(s,Length(s)+1,' ')
      s:=''
    End
  End
  fClose(fptr)
End

Procedure EndMPL
Var
  Temp  : String
Begin
  ClrScr
  Temp:=PROG_NAME+' v'+PROG_VER+' '+OS
  GotoXY(1,TermSizeY/2)
  WriteLn(PadCT(Temp,TermSizeX-1,' '))
  GotoXY(1,TermSizeY-1)
  Delay(1000)
  Write('|[1')
  SysopLog(PROG_NAME+': '+UserAlias+' just left the MPL')
  Halt
End

Procedure TopFive(cat1:String)
Var
  fptr    : File
  fptr1   : File
  MenuTop : Array[1..100] of MenuSave
  d,z,y   : Integer=1
  x,i,temp: Integer
  fname   : String
  fname1  : String
Begin
  If cat1=MAIN_MENU Then
    fname:=AddSlash(CfgMpePath+DATA_SUB_DIR)+'rcsmenu.dat'
  Else
    fname:=AddSlash(CfgMpePath+DATA_SUB_DIR)+'rcsmenu.'+cat1+'.dat'
  fAssign(fptr,fname,66)
  fReset(fptr)
  If IoResult=0 Then
  Begin
    While Not fEof(fptr) Do
    Begin
      x:=x+1
      fSeek(fptr,(x-1)*SizeOf(MenuCount))
      fRead(fptr,MenuTop[x],SizeOf(MenuCount))
    End
    fClose(fptr)
  End
  Else SysopLog(PROG_NAME+': Unable to open data file '+fname)
  temp:=x+1
  i:=x
  For d:=1 to i do
  Begin
    For z:=d+1 to i Do
    Begin
      If MenuTop[d].Played<MenuTop[z].Played Then
      Begin
        MenuTop[temp]:=MenuTop[d]
        MenuTop[d]:=MenuTop[z]
        MenuTop[z]:=MenuTop[temp]
        MenuTop[temp].Name:=''
      End
    End
  End
  If Cat1=MAIN_MENU Then
    fname1:=AddSlash(CfgMpePath+DATA_SUB_DIR)+'rcsmenu.top'
  Else
    fname1:=AddSlash(CfgMpePath+DATA_SUB_DIR)+'rcsmenu.'+cat1+'.top'
  fAssign(fptr1,fname1,66)
  fReWrite(fptr1)
  If IoResult=0 Then
  Begin
    For y:=1 to 5 Do
      If MenuTop[y].Name<>'' Then
      Begin
        fWriteLn(fptr1,StripR(MenuTop[y].Name,' ')+' - '+Int2Str(MenuTop[y].Played))
      End
  End
  fClose(fptr1)
End

Procedure SaveInfo
Var
  fptr   : File
  fptr1  : File
  done1  : Boolean=false
  done2  : Boolean=false
  Count  : Integer=1
  fname  : String
  fnamem : String
Begin
  fname:=AddSlash(CfgMpePath+DATA_SUB_DIR)+'rcsmenu.'+Cat+'.dat'
  fnamem:=AddSlash(CfgMpePath+DATA_SUB_DIR)+'rcsmenu.dat'
  fAssign(fptr,fname,66)
  fAssign(fptr1,fnamem,66)
  if Not fileExist(fname) Then
    fReWrite(fptr)
  Else fReset(fptr)
  If Not fileExist(fnamem) Then
    fReWrite(fptr1)
  Else fReset(fptr1)
  If IoResult=0 Then
  Begin
    While (not fEof(fptr)) And (not done1) Do
    Begin
      fSeek(fptr,(Count-1)*SizeOf(MenuCount))
      fReadRec(Fptr,MenuCount)
      If MenuCount.Name=Menu[KeyOpt].Name And MenuCount.Category=Cat Then
      Begin
        MenuCount.Played:=MenuCount.Played+1
        fSeek(fptr,(Count-1)*SizeOf(MenuCount))
        fWrite(Fptr,MenuCount,SizeOf(MenuCount))
        done1:=true
      End
      Count:=Count+1
    End
    Count:=1
    While (not fEof(fptr1)) And (not done2) Do
    Begin
      fSeek(fptr1,(Count-1)*SizeOf(MenuCount))
      fReadRec(Fptr1,MenuCount)
      If MenuCount.Name = Menu[KeyOpt].Name And MenuCount.Category = Cat Then
      Begin
        MenuCount.Played:=MenuCount.Played+1
        fSeek(fptr1,(Count-1)*SizeOf(MenuCount))
        fWrite(Fptr1,MenuCount,SizeOf(MenuCount))
        done2:=true
      End
      Count:=Count+1
    End
    If Not done1 Then
    Begin
      fSeek(fptr,fsize(fptr))
      MenuCount.Name:=StripR(Menu[KeyOpt].Name,' ')
      MenuCount.Played:=1
      MenuCount.Category:=Cat
      fWrite(fptr,MenuCount,SizeOf(MenuCount))
      done1:=true
    End
    If Not done2 Then
    Begin
      fSeek(fptr1,fsize(fptr1))
      MenuCount.Name:=StripR(Menu[KeyOpt].Name,' ')
      MenuCount.Played:=1
      MenuCount.Category:=Cat
      fWrite(fptr1,MenuCount,SizeOf(MenuCount))
      done2:=true
    End
  End
  fClose(fptr)
  fClose(fptr1)
End

Procedure RunCmd(x:Byte)
Var
  temp   : String
Begin
  If WordGet(1,Upper(Menu[x].MysData),' ')='BBSLINK' Then 
  Begin
    temp:=Menu[x].MysData
    Delete(temp,1,8)
    Menu[x].MysData:=BBSL_BFR_CMD+' '+temp+' '+BBSL_AFT_CMD
    SysopLog(PROG_NAME+': '+Menu[x].MysCmd+' '+Menu[x].MysData)
  End
  Else If WordGet(1,Upper(Menu[x].MysData),' ')='DOORPARTY' Then
  Begin
    temp:=Menu[x].MysData
    Delete(temp,1,10)
    Menu[x].MysData:=DP_BFR_CMD+' '+temp+' '+DP_AFT_CMD
    SysopLog(PROG_NAME+': '+Menu[x].MysCmd+' '+Menu[x].MysData)
  End
  Else SysopLog(PROG_NAME+': '+Menu[x].MysCmd+' '+Menu[x].MysData)
  SaveInfo
  TopFive(cat)
  MenuCmd(Menu[x].MysCmd,Menu[x].MysData)
  ReadIni(PrevMenu[MenuCnt])
End

Procedure RunCmdChar(key:Char)
Var
  temp   : String
  x      : Byte
Begin
  key:=Upper(key)
  Repeat
    x:=x+1
  Until Menu[x].KeyChar=key Or x>36
  If Menu[x].MysData<>'' Or x<=36 Then
  Begin
    If WordGet(1,Upper(Menu[x].MysData),' ')='BBSLINK' Then 
    Begin
      temp:=Menu[x].MysData
      Delete(temp,1,8)
      Menu[x].MysData:=BBSL_BFR_CMD+' '+temp+' '+BBSL_AFT_CMD
      SysopLog(PROG_NAME+': '+Menu[x].MysCmd+' '+Menu[x].MysData)
    End
    Else If WordGet(1,Upper(Menu[x].MysData),' ')='DOORPARTY' Then
    Begin
      temp:=Menu[x].MysData
      Delete(temp,1,10)
      Menu[x].MysData:=DP_BFR_CMD+' '+temp+' '+DP_AFT_CMD
      SysopLog(PROG_NAME+': '+Menu[x].MysCmd+' '+Menu[x].MysData)
    End
    Else SysopLog(PROG_NAME+': '+Menu[x].MysCmd+' '+Menu[x].MysData)
    SaveInfo
    TopFive(cat)
    If (Menu[x].MysCmd<>'') And (Menu[x].MysData<>'') Then MenuCmd(Menu[x].MysCmd,Menu[x].MysData)
  End
  ReadIni(PrevMenu[MenuCnt])
End
  
Procedure Display  
Var
  Count1  : Byte=1
  x,y,z   : Byte
  temp1   : String
Begin
  TimeStart:=Timer
  DrawMainScreen
  DisplayMenu
  If Cat=MAIN_MENU Then TopFive(Cat)
  ReadTop5
  x:=BannerX2-BannerX1
  y:=1
  z:=0
  repeat
    If y<x Then                                   //Banner Display code segment
    Begin
      temp1:=''
      temp1:=StrRep(' ',x-y)+Copy(Top5Str,1,y)
    End
    Else If y>=x Then
    Begin
      temp1:=''
      temp1:=Copy(Top5Str,1+z,x-1)+' '
      z:=z+1
    End
    If y>Length(Top5Str)+BannerX2-BannerX1 Then
    Begin
      y:=1
      z:=1
    End
    WriteXY(BannerX1,BannerY,MarColor,temp1)
    Delay(MarDelay)
    y:=y+1
    
    if keypressed then 
    begin
      TimeStart:=Timer
      Ch:=readkey;
      if isarrow then 
      begin
        case Ch of 
          (*keyhome,keypgup: Begin
                             idx:=1;
                             LineCnt:=1
                           End
          keyend,keypgdn : Begin
                             idx:=mi;
                             LineCnt:=mi-PageLen+1
                           End *)
          keycursordown  : begin
                             idx:=idx+1;
                             if idx>mi then 
                             Begin
                               idx:=1;
                               LineCnt:=1
                             End
                             Else If (idx>PageLen)And(idx<mi+1)And(LineCnt<mi-PageLen+1) Then LineCnt:=LineCnt+1
                           end;
          keycursorup :    begin
                             if idx=1 then 
                             Begin
                               idx:=mi
                               LineCnt:=mi-PageLen+1
                               If LineCnt<1 Then LineCnt:=1
                             End
                             else
                             Begin
                               idx:=idx-1;
                               If Idx<LineCnt Then
                                 LineCnt:=LineCnt-1
                             End
                           end;
        end;
      end else 
      begin
        case Upper(Ch) of
          #27 : begin 
                  If MenuCnt=1 Then
                    done:=true
                  Else 
                  Begin
                    MenuCnt:=MenuCnt-1
                    ReadIni(PrevMenu[MenuCnt])
                    LineCnt:=1
                    Idx:=1
                    TextColor(7)
                    ClrScr
                    Display
                  End
                end;
          #13 : case idx of
                    Menu[Idx].Key : 
                    Begin
                      TextColor(7)
                      ClrScr
                      If (Upper(Menu[Idx].MysCmd)<>'MENU')And(UserSec>=Menu[Idx].SecLev) Then
                      Begin
                        KeyOpt:=Idx
                        RunCmd(Idx)
                        Display
                      End
                      Else if (Upper(Menu[Idx].MysCmd)='MENU')And(UserSec>=Menu[Idx].SecLev) Then
                      Begin
                        MenuCnt:=MenuCnt+1
                        If ReadIni(Menu[Idx].MysData) Then
                        Begin
                          LineCnt:=1
                          Idx:=1
                          Display
                        End
                        Else 
                        Begin
                          MenuCnt:=MenuCnt-1
                          ReadIni(PrevMenu[MenuCnt])
                          LineCnt:=1
                          Idx:=1
                          Display
                        End
                      End
                      ClrScr
                      DisplayMenu
                      GotoXY(1,ScrnLen)
                    End
                End
          #48,#49,#50,#51,#52,#53,#54,#55,#56,#57 :
            Begin
              ClrScr
              TextColor(7)
              If (Upper(Menu[Str2Int(Ch)].MysCmd)<>'MENU')And(UserSec>=Menu[Str2Int(Ch)].SecLev) Then
              Begin
                KeyOpt:=Str2Int(Ch)
                RunCmd(Str2Int(Ch))
                Display
              End
              Else If (Upper(Menu[Str2Int(Ch)].MysCmd)='MENU')And(UserSec>=Menu[Str2Int(Ch)].SecLev) Then
              Begin
                LineCnt:=1
                Idx:=1
                MenuCnt:=MenuCnt+1
                If ReadIni(Menu[Str2Int(Ch)].MysData) Then
                  Display
                Else
                Begin
                  MenuCnt:=MenuCnt-1
                  ReadIni(PrevMenu[MenuCnt])
                  Display
                End
              GotoXY(1,ScrnLen)
              End
            End
          'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z' : 
                   Begin
                     ClrScr
                     Repeat
                       Count1:=Count1+1
                     Until Upper(Ch)=Upper(Menu[Count1].KeyChar) Or Count1>36
                     KeyOpt:=Count1
                     TextColor(7)
                     If (Upper(Menu[Count1].MysCmd)<>'MENU')And(UserSec>=Menu[Count1].SecLev) Then
                     Begin
                       RunCmdChar(Ch)
                       Display
                     End
                     Else If (Upper(Menu[Count1].MysCmd)='MENU')And(UserSec>=Menu[Count1].SecLev) Then
                     Begin
                       LineCnt:=1
                       Idx:=1
                       MenuCnt:=MenuCnt+1
                       If ReadIni(Menu[Str2Int(Ch)].MysData) Then
                         Display
                       Else
                       Begin
                         MenuCnt:=MenuCnt-1
                         ReadIni(PrevMenu[MenuCnt])
                         Display
                       End
                     End
                     ClrScr
                     DisplayMenu
                     GotoXY(1,ScrnLen)
                   End
        End
      end;
      PurgeInput
      If Not Done Then DisplayMenu
    end;
    CheckTimeout
  until done;
  TextColor(7)
End

Procedure install(inipath:String)
Var
  Temp  : String
  Temp1 : String
Begin
  ClrScr
  If Not DirExist(AddSlash(CfgMpePath)+MENU_SUB_DIR) Then
  Begin
    Temp:=AddSlash(CfgMpePath)+MENU_SUB_DIR
    Temp1:=AddSlash(CfgTextPath)
    inipath:=AddSlash(inipath)
    If OSType=0 Then MenuCmd('DD','md '+AddSlash(CfgMpePath)+MENU_SUB_DIR)
    Else MenuCmd('DD','mkdir '+Temp)
    Temp:=AddSlash(Temp)
    FindFirst(inipath+'rcs*.ini',66)
    While DosError=0 Do
    Begin
      If FileCopy(inipath+DirName,Temp+DirName) Then 
      Begin
        SysopLog(inipath+DirName+' copied to '+AddSlash(Temp+DirName))
        FileErase(inipath+DirName)
      End
      Else SysopLog(inipath+DirName+' could not be copied')
      FindNext
    End
    FindClose
  End
  FindFirst(inipath+'*.ans',66)
  While DosError=0 Do
  Begin
    If FileCopy(inipath+DirName,AddSlash(CfgTextPath)+DirName) Then
    Begin
      SysopLog(inipath+DirName+' copied to '+AddSlash(CfgTextPath)+DirName)
      FileErase(inipath+DirName)
    End
    Else SysopLog(inipath+DirName+' could not be copied')
    FindNext
  End
  FindClose
  If Not DirExist(AddSlash(CfgMpePath)+DATA_SUB_DIR) Then
  Begin
    Temp:=AddSlash(CfgMpePath)+DATA_SUB_DIR
    If OSType=0 Then MenuCmd('DD','md '+Temp)
    Else MenuCmd('DD','mkdir '+Temp)
  End
  pause
  EndMPL
End

Procedure HelpScreen
Begin
  ClrScr
  WriteLn('|07|CR')
  WriteLn('                           '+PROG_NAME+' v'+PROG_VER)
  WriteLn('')
  WriteLn(' Command Line Parameters:')
  WriteLn('')
  WriteLn('rcsmenu rcsmenu')
  WriteLn('        Runs MPL using rcsmenu.ini as Main menu. Do NOT include .ini!')
  WriteLn('')
  WriteLn('rcsmenu install path/to/temp/directory')
  WriteLn('        Creates directories, and moves files into place')
  WriteLn('')
  WriteLn('')
  Halt
End

Var
  IniFile : String
  Temp    : String
Begin
  ClrScr
  If ParamCount<1 Then 
  Begin
    SysopLog(PROG_NAME+'Incorrect number of parameters')
    HelpScreen
  End
  GetThisUser
  Init
  If Upper(ParamStr(1))='INSTALL' Then 
  Begin
    Write('|[1')
    If ParamCount<2 Then HelpScreen
    Else Install(ParamStr(2))
    EndMPL
  End
  IniFile:=ParamStr(1)
  ClrScr
  MenuCnt:=1
  PrevMenu[MenuCnt]:=IniFile
  ScrnLen:=TermSizeY
  ReadIni(IniFile)
  Display
  EndMPL
End;
