(*
  RCS Mods o5/13/2o21
  Mystic AFK Modification Version 1.1
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
  MA 02110-1301, USA.
  
 **************************************************************************
  
  What does it do?
  Sometimes users idle on your BBS. This mod waits for XXX seconds of IDLE and 
  then displays info to the user that they are about to go 'AFK' before setting 
  their online status to 'AFK' in node status, displays this info to the user and 
  then starts a screen-saver. If user reaches your BBSes XX minute max timeout, 
  they are disconnected with info. If the user presses a button they are returned 
  to normal node status and released to the BBS.
  
  Before user is deemed AFK their Node Status is 'User is possibly AFK!'
  When user is AFK their Node Status is 'Away from keyboard!'
  When user is returning from AFK their Node Status is 'Coming back from AFK!'  
*)

Uses Cfg
Uses User

Const
  PROG_NAME = 'Mystic AFK'
  PROG_VER  = '1.1'

Var //sysOp Modifiable Settings!
  afkString        : String = 'Away from keyboard!' //AFK Node Status String
  possiblyAFK      : String = 'User is possibly AFK!' //'possibly AFK' Node Status String
  returnString     : String = 'Coming back from AFK!' //Returning from AFK Node Status String
  rainSpeed        : String = '3' //Speed of Matrix Rain, 0-10 accepted
  rainColor        : String = 'magenta' //Color of Matrix Rain, green/magenta/red/white/yellow/blue/cyan/black accepted
  
// ------------- Don't edit below ------------- Unless yer uber-1337 -------------
Var
  Ch               : Char
  fptr             : File
  KeyCount         : Integer = 0
  TimeOut          : Byte = 20
  TimeStart        : LongInt
  ExpireTime       : LongInt = Timer + TimeOut + 1
  Remain           : Byte = TimeOut
  PrevRemain       : Byte = Remain + 1
  ansiY            : Byte = 17
  ansiX            : Byte = 47
  fontHeight       : Byte = 3
  screenSaver      : String
  afkNotifyBkColor : String = '|16|15'
  afkNotifyXY      : String = '|[X63|[Y17'
  str              : String
  path_Separator   : String
  ansiPath         : String = AddSlash(addslash(cfgTextPath)+'afk'+path_Separator); //need to add trailing slash on end...
  ansi             : String

Procedure CheckTimeOut;
Begin
  If CfgTimeOut>0 Then
  Begin
    If Timer-TimeStart>CfgTimeOut Then 
    Begin
      WriteLn(GetPrompt(136));
      SysopLog(PROG_NAME+PROG_VER+': Inactivity timeout');
      write('|[1')
    dispfile('afk_hangup')
      HangUp;
    End
  End;
End;

Procedure Init
Begin
  Case OSType of
    0   : Begin
            screenSaver:= 'ansiMode'
            path_Separator:='\'
          End
    1,2 : Begin
            screenSaver:='stty cols 80 rows 25 && cmatrix -bas -C ' + rainColor + ' -u' + rainSpeed
            path_Separator:='/'
          End
  End
End

Begin
  Init
  clrScr
  gotoXY(1,1)
  dispfile('afk_notify')
  menucmd('NA',possiblyAFK)
  Repeat
    Remain := ExpireTime - Timer
    ansi   := ansiPath + Int2Str(Remain) + '.ans'
    If PrevRemain > Remain Then 
    Begin
      If Remain < 0 Then Remain := 0
      fAssign(fptr,ansi, 66)
      fReset(fptr)
      While Not fEof(fptr) Do
      Begin
        fReadLn(fptr,str)
        gotoXY(ansiX,ansiY)
        write(str)
        ansiY := ansiY + 1
      End
      ansiY := ansiY - fontHeight
      fClose(fptr)
      PrevRemain := Remain
    End
    if KeyPressed then Halt
    If Timer > ExpireTime then      
    Begin
      TimeStart:=Timer
      If screenSaver = 'ansiMode' then
      Begin
        clrScr
        menucmd('NA',afkString)
        dispfile('afk_screensaver')
        Repeat
          CheckTimeOut
        Until Keypressed
        Ch:=Readkey
        clrScr
        dispfile('afk_return')
        menucmd('NA',returnString)      
        write('|PN')
        clrScr
        Halt
      End
      Else
      Begin
        menuCmd('NA',afkString)
        menuCmd('DD',screenSaver)
        clrScr
        dispfile('afk_return')
        menucmd('NA',returnString)
        write('|PN')
        clrScr
        Halt
      End
    End 
    Delay(50)
  Until KeyCount > 1
  break
End
