' FileName: MysBinkD.Bas
' Date: 4/20/2017
' Author: Ben Ritchey
' Description: Generate Inbound/Outbound BinkD Traffic Report

#COMPILER PBCC 5
#COMPILE EXE
#DIM ALL

FUNCTION PBMAIN () AS LONG
Local RC as integer
Local NodeDte, NodeDWk, ByteWk, DateFrom, DateTo, NodeWk, BkNode, A as string
Local J, ByteTotal, TotC, TotF, TotR, TotS, K, Tot, L, Cnt as long
Local ByteVal, FileSent, FileRecv, ByteSent, ByteRecv as long
Local BSSuf, BRSuf, NoNode, TblWk, AMTbl, NMTbl as string

Local Pct as double
Local PgmVer as String

' Do NOT change format of next line except x-x !!!
  PgmVer=" MysBinkD v1.0.P "

AMTbl="JanFebMarAprMayJunJulAugSepOctNovDecn/a"
NMTbl=" 01 02 03 04 05 06 07 08 09 10 11 12 00"
NoNode="Unknown n/a .."

Open "MysBinkD1.txt" for output as #2
TotC=0: DateFrom="": DateTo="": BkNode=""

If not isfile("logs\server_binkp.log") goto NOBinkP

Open "logs\server_binkp.log" for input as #1

While not eof(1)
  Line input #1,A

  L=instr(A," Authenticating")
  If L>0 then
    BkNode=trim$(mid$(A,L+16))
    K=instr(BkNode,"@")
    If K>0 then BkNode=mid$(BkNode,1,K-1)
    K=instr(BkNode," ")
    If K>0 then BkNode=mid$(BkNode,1,K-1)
    For J=1 to 13
      If mid$(A,1,3)=mid$(AMTbl,((J-1)*3)+1,3) then
        TblWk=mid$(NMTbl,((J-1)*3)+1,3): J=13
      End if
    Next J
    BkNode=BkNode+" "+TblWk+mid$(A,4,3)
    Incr TotC
    If TotC=1 then DateFrom=mid$(A,1,12)
  End if

  L=instr(A," Unsecured session")
  If L>0 then
    BkNode="Unsecured"
    For J=1 to 13
      If mid$(A,1,3)=mid$(AMTbl,((J-1)*3)+1,3) then
        TblWk=mid$(NMTbl,((J-1)*3)+1,3): J=13
      End if
    Next J
    BkNode=BkNode+" "+TblWk+mid$(A,4,3)
    Incr TotC
    If TotC=1 then DateFrom=mid$(A,1,12)
  End if

  L=instr(A," Receiving")
  If L>0 then
    ByteWk=""
    K=instr(A,"(")
    If K>0 then 
      ByteWk=trim$(mid$(A,K+1))
      K=instr(ByteWk," bytes)")
      If K>0 then ByteWk=mid$(ByteWk,1,K-1)
      For L=2 to len(ByteWk)
        If mid$(ByteWk,L,1)="," then
          ByteWk=mid$(ByteWk,1,L-1)+mid$(ByteWk,L+1)
        End if
      Next L
    End if
    If BkNode="" then BkNode=NoNode
    If ByteWk="" then ByteWk="0"
    Print #2,BkNode;space$(24-len(BkNode));" Recv ";ByteWk
    ByteTotal=ByteTotal+val(ByteWk)
  End if

  L=instr(A," Sending")
  If L>0 then
    ByteWk=""
    K=instr(A,"(")
    If K>0 then 
      ByteWk=trim$(mid$(A,K+1))
      K=instr(ByteWk," bytes)")
      If K>0 then ByteWk=mid$(ByteWk,1,K-1)
      For L=2 to len(ByteWk)
        If mid$(ByteWk,L,1)="," then
          ByteWk=mid$(ByteWk,1,L-1)+mid$(ByteWk,L+1)
        End if
      Next L
    End if
    If BkNode="" then BkNode=NoNode
    If ByteWk="" then ByteWk="0"
    Print #2,BkNode;space$(24-len(BkNode));" Sent ";ByteWk
    ByteTotal=ByteTotal+val(ByteWk)
  End if

WEnd
DateTo=mid$(A,1,12)
Close #1

NOBinkP:

If not isfile("logs\fidopoll.log") goto NOFPoll

Open "logs\fidopoll.log" for input as #1
BkNode=""

While not eof(1)
  Line input #1,A

  L=instr(A," Polling BINKP node")
  If L>0 then
    BkNode=trim$(mid$(A,L+20))
    K=instr(BkNode,"@")
    If K>0 then BkNode=mid$(BkNode,1,K-1)
    K=instr(BkNode," ")
    If K>0 then BkNode=mid$(BkNode,1,K-1)
    For J=1 to 13
      If mid$(A,1,3)=mid$(AMTbl,((J-1)*3)+1,3) then
        TblWk=mid$(NMTbl,((J-1)*3)+1,3): J=13
      End if
    Next J
    BkNode=BkNode+" "+TblWk+mid$(A,4,3)
    Incr TotC
    If TotC=1 and DateFrom="" then DateFrom=mid$(A,1,12)
  End if

  L=instr(A," Receiving")
  If L>0 then
    ByteWk=""
    K=instr(A,"(")
    If K>0 then 
      ByteWk=trim$(mid$(A,K+1))
      K=instr(ByteWk," bytes)")
      If K>0 then ByteWk=mid$(ByteWk,1,K-1)
      For L=2 to len(ByteWk)
        If mid$(ByteWk,L,1)="," then
          ByteWk=mid$(ByteWk,1,L-1)+mid$(ByteWk,L+1)
        End if
      Next L
    End if
    If BkNode="" then BkNode=NoNode
    If ByteWk="" then ByteWk="0"
    Print #2,BkNode;space$(24-len(BkNode));" Recv ";ByteWk
    ByteTotal=ByteTotal+val(ByteWk)
  End if

  L=instr(A," Sending")
  If L>0 then
    ByteWk=""
    K=instr(A,"(")
    If K>0 then 
      ByteWk=trim$(mid$(A,K+1))
      K=instr(ByteWk," bytes)")
      If K>0 then ByteWk=mid$(ByteWk,1,K-1)
      For L=2 to len(ByteWk)
        If mid$(ByteWk,L,1)="," then
          ByteWk=mid$(ByteWk,1,L-1)+mid$(ByteWk,L+1)
        End if
      Next L
    End if
    If BkNode="" then BkNode=NoNode
    If ByteWk="" then ByteWk="0"
    Print #2,BkNode;space$(24-len(BkNode));" Sent ";ByteWk
    ByteTotal=ByteTotal+val(ByteWk)
  End if
WEnd
If DateTo="" then DateTo=mid$(A,1,12)

NOFPoll:

Close
Shell "cmd /c type MysBinkD1.txt |sort >MysBinkD2.txt"

Open "MysBinkD2.txt" for input as #1
Open "MysBinkD.Rpt" for output as #2

Print #2
Print #2,mid$(PgmVer,10,7);space$(10);" Mystic BinkD Data Transfer Report ";space$(7);date$
'Print #2
Print #2,space$(16);"From  ";DateFrom;"  to  ";DateTo
Print #2
L=len(command$)
Print #2,space$(((66-L)/2)-1);chr$(214);string$(L+2,chr$(196));chr$(183)
Print #2,space$(((66-L)/2)-1);chr$(179);" ";command$;" ";chr$(179)
Print #2,space$(((66-L)/2)-1);chr$(211);string$(L+2,chr$(196));chr$(189)
Print #2
Print #2,"ķ"
Print #2,"              Last  Sent  Received ĴPct of"
Print #2,"Node Address  Conn    Files    Bytes     Files    Bytes TBytes"
Print #2,"Ķ"
Print #2,"                                                                    "

BkNode="": Cnt=0: TotF=0: TotR=0: TotS=0
FileSent=0: FileRecv=0: ByteSent=0: ByteRecv=0

While not eof(1)
  Line input #1,A
  NodeWk=trim$(mid$(A,1,24))
  L=instr(NodeWk," ")
  NodeDWk=mid$(NodeWk,L+1)
      For J=1 to 12
      If mid$(NodeDWk,1,3)=mid$(NMTbl,((J-1)*3)+1,3) then
        mid$(NodeDwk,1,3)=mid$(AMTbl,((J-1)*3)+1,3): J=12
      End if
    Next J
  NodeWk=mid$(NodeWk,1,L-1)
  ByteVal=val(mid$(A,31))

  If NodeWk<>BkNode then
    If BkNode<>"" then

      TotF=TotF+FileSent
      TotF=TotF+FileRecv
      TotS=TotS+ByteSent
      TotR=TotR+ByteRecv
      Pct=Int(((ByteSent+ByteRecv)/ByteTotal)*1000)/10

      Print #2,"";BkNode;space$(14-len(BkNode));NodeDte;" ";
      Print #2,using$("###,###",FileSent);"   ";
      BSSuf=" "
      If ByteSent>999 then ByteSent=ByteSent/1000: BSSuf="k"
      If ByteSent>999 then ByteSent=ByteSent/1000: BSSuf="M"
      Print #2,using$("###,###",ByteSent);BSSuf;"   ";

      Print #2,using$("###,###",FileRecv);"   ";
      BRSuf=" "
      If ByteRecv>999 then ByteRecv=ByteRecv/1000: BRSuf="k"
      If ByteRecv>999 then ByteRecv=ByteRecv/1000: BRSuf="M"
      Print #2,using$("###,###",ByteRecv);BRSuf;
      If Pct>0 then 
        Print #2,"  ";using$("###.#",Pct);"%"
       else
        Print #2,"        "
      End if
    End if
    BkNode=NodeWk
    NodeDte=NodeDWk
    FileSent=0: FileRecv=0: ByteSent=0: ByteRecv=0
  End if

  If instr(A," Sent ")>0 then
    Incr FileSent
    ByteSent=ByteSent+ByteVal
    NodeDte=NodeDWk
  End if

  If instr(A," Recv ")>0 then
    Incr FileRecv
    ByteRecv=ByteRecv+ByteVal
    NodeDte=NodeDWk
  End if

WEnd:

' Get last one!
      TotF=TotF+FileSent
      TotF=TotF+FileRecv
      TotS=TotS+ByteSent
      TotR=TotR+ByteRecv
      Pct=Int(((ByteSent+ByteRecv)/ByteTotal)*1000)/10
      Print #2,"";BkNode;space$(14-len(BkNode));NodeDte;" ";
      Print #2,using$("###,###",FileSent);"   ";
      BSSuf=" "
      If ByteSent>999 then ByteSent=ByteSent/1000: BSSuf="k"
      If ByteSent>999 then ByteSent=ByteSent/1000: BSSuf="M"
      Print #2,using$("###,###",ByteSent);BSSuf;"   ";

      Print #2,using$("###,###",FileRecv);"   ";
      BRSuf=" "
      If ByteRecv>999 then ByteRecv=ByteRecv/1000: BRSuf="k"
      If ByteRecv>999 then ByteRecv=ByteRecv/1000: BRSuf="M"
      Print #2,using$("###,###",ByteRecv);BRSuf;
      If Pct>0 then 
        Print #2,"  ";using$("###.#",Pct);"%"
       else
        Print #2,"        "
      End if

'Print #2
Print #2,"";string$(68,"");""
'Print #2
Print #2
Print #2,space$(12);"ķ"
Print #2,space$(12);"    Total Connects   =         ";using$("###,###",TotC);"       "
Print #2,space$(12);"                                             "
Print #2,space$(12);"    Total Files      =     ";using$("###,###,###",TotF);"       "
Print #2,space$(12);"                                             "
Print #2,space$(12);"    Total Bytes SENT = ";using$("###,###,###,###",TotS);"       "
Print #2,space$(12);"    Total Bytes RECV = ";using$("###,###,###,###",TotR);"       "
Print #2,space$(12);"    Total BYTES      = ";using$("###,###,###,###",ByteTotal);"       "
Print #2,space$(12);"Ľ"
Print #2
Print #2,space$(23);" -=:{ End of Report }:=-"
Print #2
ENDITALL:
Close
Kill "MysBinkD1.txt"
Kill "MysBinkD2.txt"
End RC

END FUNCTION

