
//
// Paging Module v1.3 (linux) [Mystic]
// 
// Includes options for
// - Text Messages
// - Audio Playback
// - Sysop availability status message
// - Login Alert (audio and/or text)
// - Email Notifications
// 
// DEVELOPED / SUPPORT
//
// CLUTCH BBS
// Sysop: niter3
// Telnet: clutch.darktech.org
// URL: http://clutch.darktech.org
// Developer: n3! (niter3)
// Alpha Tester: caphood (Hawk Hubbard : ACiDic Team Leader)
// 
// NOTES / TO-DO:
//
// - Update the mail procedure and change "sysop_name" to the name of the sysop.
// - Review and update the CONFIG SECTION to your liking. Out of respect, please leave the version number in place for support
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE PAGING (Text)
//
// To get a status of the sysop availability, add the following menu item.
// 
//	command: (GX) Execute MPL program
//	Data: cl_paging page_text
// 
// ------------------------------------------------------------------------------------------------
//
// ENABLE PAGING (Audio)
//
// To use audio paging, set the menu command as follows
// 
//	command: (GX) Execute MPL program
//	Data: cl_paging page_audio
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE PAGING (Text & Audio)
//
//	command: (GX) Execute MPL program
//	Data: cl_paging page_all
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE LOGIN ALERT (Text)
//
//	command: (GX) Execute MPL program
//	Data: cl_paging alert_text
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE LOGIN ALERT (Audio)
//
//	command: (GX) Execute MPL program
//	Data: cl_paging alert_audio
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE LOGIN ALERT (Text & Audio)
//
//	command: (GX) Execute MPL program
//	Data: cl_paging alert_all
//
// ------------------------------------------------------------------------------------------------
//
// SYSOP STATUS MESSAGE
//
// To get a status of the sysop availability, add the following menu item.
// 
//	command: (GX) Execute MPL program
//	Data: cl_paging status
// 


Uses USER
Uses CFG

Begin

Var MyFile : file;
Var MyFile2 : file;
Var Str : string;
Var time : string;         
Var temp_time : string;
Var cstart : string
Var cend : string
Var cend_real : integer
Var avail : string
Var tz : string
Var ver : string
Var node : string
Var bbsname : string
Var ip : string
Var email : string
Var ansi : string
Var prbarloc : string
Var prbarlength : string
Var prbarbottom : string
Var prbarcolor : string
Var prtxtcolor : string
Var prbarcur : string
Var prbarclear : string
Var anibarbg : string
Var anibarfg : string
Var anibarbrac : string
Var snd_page : string
Var snd_alert : string
Var sysoppage_msg : string
Var sysopout_msg : string
Var sysopinstatus_msg : string
Var sysopoutstatus_msg : string
Var sysopmail_msg : string
Var method_text : string
Var method_audio : string
Var method_all : string

GetThisUser

cstart := int2str(cfgchatstart)
cend := int2str(cfgchatend)
cend_real := cfgchatend
cend_real := cend_real - 1

//-------------------------------------------------------------------------------$
// CONFIG SECTION

ansi := 'cl_paging.ans'													// Ansi File to Use
tz := 'est'														// Timezone region ***
email := '0'														// E-mail Notification - 1 = receive an email upon page
avail := '|08|[Y11|[X04|16|08page reason?|08|[Y11|[X51|16|08availability: |03' + cstart + '-' + cend + '|08 ' + tz + '' // Availability location
ver := '|[Y08|[X71|16|08v1.3'												// Version Location and Information
method_text := '|08|[Y08|[X54< |11text|08 / |08audio |08>'								// Page Method String
method_audio := '|08|[Y08|[X54< |08text|08 / |11audio |08>'								// Page Method String
method_all := '|08|[Y08|[X54< |11text|08 / |11audio |08>'								// Page Method String
snd_page := 'axelf.mp3'													// Paging MP3 to use
snd_alert := 'alert.mp3'												// Alert MP3 to use 
prbarloc := '|[Y10|[X01|16|08:'												// Prompt bar location
prbarcur := '|[Y10|08:|15|19'												// Prompt bar cursor location
prbarlength := '|$D75 |16|08:'												// prompt bar length
prbarbottom := '|[Y11|[X01|08|16|$D76--'										// Prompt bar bottom
prbarcolor := '|19'													// Prompt bar bar color
prtxtcolor := '|15'													// Prompt bar text color
prbarclear := '|[Y10|[X02|16|$D75 |15|08:'										// Prompt bar clear bg color
anibarbg := '|03'													// Animation Bar Background Color
anibarfg := '|11'													// Animation Bar Forground Color
anibarbrac := '|08'													// Animation Bar Bracket Color
sysoppage_msg := '|[Y13|[X24|15p|07aging |15t|07he |15s|07ysop |15p|07lease |15b|07e |15p|07atient'			// Sysop Page Message
sysopmail_msg : = '|CR|[X24|15s|07end |15t|07he |15s|07ysop a |15m|07essage? '									// Sysop Mail Message
sysopinstatus_msg := '|07The sysop is currently |19|15 IN |16|07 OUT|CR|CR|PA'						// Sysop IN Status Message
sysopoutstatus_msg := '|07The sysop is currently  IN |19|15 OUT |16|CR|CR|PA'						// Sysop OUT Status Message
sysopout_msg := '|[Y10|[X01|08|16:|15 |SN |07is currently unavailable.  |PA'						// Sysop Out Message

//-------------------------------------------------------------------------------

ip := mci2str('UX')
bbsname := mci2str('BN')
node := int2str(Nodenum)
temp_time := timestr(datetime,false);    
time := temp_time;                   

	 If cfgchatend = 00 or cfgchatend = 0 then cfgchatend :=24
		delete(temp_time,3,1); 
		time := copy(temp_time,1,2);

// -----------------------------------------------------------------------------------------------------------
// Mail procedure  *** UPDATE BELOW TO REFLECT YOUR SYSOP NAME ***

procedure mail
begin

If inputny(sysopmail_msg); Then
menucmd('MW','/To:sysop_name /SUBJ:Page_Attempt'); // Update to reflect Sysop Name

end

//-------------------------------------------------------------------------------
// Page Animation

procedure page_anima
begin

writeln(sysoppage_msg)
writeln(anibarbrac + '|[Y15|[X25[|[X56|08]') // brackets
writeln(anibarbg + '|[Y15|[X26|$D30') // bg 
writeln(anibarfg + '|[Y15|[X26|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE')

end

//------------------------------------------------------------------------------------------------------------
// Sysop IN status

procedure sysopINstatus
begin
CLRSCR

writeln(sysopinstatus_msg)

end


// ------------------------------------------------------------------------------------------------------------
// Sysop OUT status

procedure sysopOUTstatus
begin
CLRSCR

writeln(sysopoutstatus_msg)

end

// ------------------------------------------------------------------------------------------------------------
// Sysop E-Mail

procedure sysop_email
begin

	if email = '1' then

		fAssign (MyFile2, '/tmp/cl_email.txt', 66);
		frewrite(MyFile2)
                fwriteln(MyFile2, bbsname);	
		fwriteln(MyFile2, UserAlias);
		fwriteln(MyFile2, node);
		fwriteln(MyFile2, ip);
		fwriteln(MyFile2, Str);
		fclose(MyFile2)
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')
		
end


// -----------------------------------------------------------------------------------------------------------
// Sysop IN all - Audio and Text

procedure sysopINall
begin

CLRSCR
dispfile (ansi)
writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + prbarbottom + ver + avail)
writeln(method_all)

write(prbarcur)
Str := Input (73, 73, 1, '')

	If Str = '' Then
		exit

	Else If Str <> '' Then 

		fAssign (MyFile, '/tmp/cl_temp.txt', 66);
		frewrite(MyFile)
		fwriteln(MyFile, UserAlias);
		fwriteln(MyFile, Str);
		fwriteln(MyFile, node);
                fwriteln(MyFile, bbsname);	
		fwriteln(MyFile, ip);
		fclose(MyFile)
	
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')
		menucmd('DD','sudo -b mpg123 -q ' + CFGSYSPATH + 'scripts/' + snd_page + '')
		sysop_email()
		page_anima()
		mail()

end


// -----------------------------------------------------------------------------------------------------------
// Sysop IN Audio

procedure sysopINaudio
begin

CLRSCR
dispfile (ansi)

writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + prbarbottom + ver + avail)
writeln(method_audio)


write(prbarcur)
Str := Input (73, 73, 1, '')

	If Str = '' Then
		exit

	Else If Str <> '' Then 

		menucmd('DD','sudo -b mpg123 -q ' + CFGSYSPATH + 'scripts/' + snd_page + '')
		sysop_email()
		page_anima()
		mail()
end


// ------------------------------------------------------------------------------------------------------------------------
// Sysop IN text

procedure sysopINtext
begin

CLRSCR
dispfile (ansi)

writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + prbarbottom + ver + avail)
writeln(method_text)

write(prbarcur)
Str := Input (73, 73, 1, '')

	If Str = '' Then
		exit

	Else If Str <> '' Then 

		fAssign (MyFile, '/tmp/cl_temp.txt', 66);
		frewrite(MyFile)
		fwriteln(MyFile, UserAlias);
		fwriteln(MyFile, Str);
	        fwriteln(MyFile, node);
	        fwriteln(MyFile, bbsname);
		fwriteln(MyFile, ip);
		fclose(MyFile)
			
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')
		sysop_email()
		page_anima()
		mail()
end


// -----------------------------------------------------------------------------------------------------------------------
// Sysop OUT

procedure sysopOUT
begin

CLRSCR
dispfile (ansi)

writeln(prbarloc + prbarcolor + prtxtcolor + prbarclear + prbarbottom + ver + avail)
writeln('|08|[Y08|[X54< |08text|08 / |08audio |08>')
writeln(sysopout_msg)
mail()
	
end


// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert Audio

Procedure sysop_alert_audio
begin

		menucmd('DD','sudo -b mpg123 -q ' + CFGSYSPATH + 'scripts/' + snd_alert + '')


end


// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert Text

Procedure sysop_alert_text
begin



		fAssign (MyFile, '/tmp/cl_alert.txt', 66);
		frewrite(MyFile)
		fwriteln(MyFile, UserAlias);
		fwriteln(MyFile, bbsname);
		fwriteln(MyFile, node);
		fwriteln(MyFile, ip);
		fclose(MyFile)
		
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')


end


// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert ALL

Procedure sysop_alert_all
begin


		fAssign (MyFile, '/tmp/cl_alert.txt', 66);
		frewrite(MyFile)
		fwriteln(MyFile, UserAlias);
		fwriteln(MyFile, bbsname);
		fwriteln(MyFile, node);
		fwriteln(MyFile, ip);
		fclose(MyFile)
		
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')

		menucmd('DD','sudo -b mpg123 -q ' + CFGSYSPATH + 'scripts/' + snd_alert + '')


end

// ------------------------------------------------------------------------------------------------------------------------
// Starts Sysop IN text

Procedure sysop_page_text
Begin

	If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINtext
	Else
		sysopOUT

End


//------------------------------------------------------------------------------------------------------------
// Starts Sysop IN audio

procedure sysop_page_audio
begin

If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINaudio
        Else
		sysopOUT

end


//------------------------------------------------------------------------------------------------------------
// Starts Sysop IN all

procedure sysop_page_all
begin

If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINall
        Else
		sysopOUT

end


// ------------------------------------------------------------------------------------------------------------
// Starts status message

procedure sysop_status
begin

If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINstatus
        Else
		sysopOUTstatus

end


// ------------------------------------------------------------------------------------------------------------
// ERROR MESSAGE

procedure error
begin

CLRSCR
writeln('|12ERROR!|CR|CR|07Please configure the following options.|CR|CRPage_Text - Text Message|CRPage_Audio - Audio Playback|CRPage_All - Text Messsage & Audio playback')
writeln('Alert_Text - Text when somebody logs in|CRAlert_Audio - Alert via audio when somebody logs in|CRAlert_All - Alert via text & audio when somebody logs in')
writeln('Status - Sysop Availability Message|CR|CRIn order to receive an email. Set the variable "email" to 1 in cl_paging.mps.')
writeln('|CR|PA')
end


// ------------------------------------------------------------------------------------------------------------
// ::: Main Program :::

Case Upper(ParamStr(1)) of
	'PAGE_TEXT'   : sysop_page_text;
	'PAGE_AUDIO'  : sysop_page_audio;
	'PAGE_ALL'    : sysop_page_all;
	'ALERT_AUDIO' : sysop_alert_audio;
	'ALERT_TEXT'  : sysop_alert_text;
	'ALERT_ALL'   : sysop_alert_all;	
	'STATUS'      : sysop_status;
Else
	error

End

End
