/****************************************************************/
/* Works out our current IP address, creates an e-mail that     */
/* will inform a list of people about the address.              */
/*                                                              */
/*       Programmer:      P. Moylan                             */
/*       Last modified:   17 June 2002                          */
/*                                                              */
/*   Usage:    makeletter namelist messagefilename              */
/*                                                              */
/*        where namelist is a file containing a list of mail    */
/*        recipients, one per line, and messagefilename is the  */
/*        name of the file we must create.                      */
/*                                                              */
/*   Suggestion: Write another script that calls this one and   */
/*   then calls a third script to send the mail.  If Weasel is  */
/*   installed then the Weasel 'qmail' utility can be used as   */
/*   the third script that sends the message.                   */
/*                                                              */
/****************************************************************/

parse arg namelist MessageFileName

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Write the file to be mailed.  */

CALL Stream MessageFileName, 'C', 'OPEN WRITE'
CALL LineOut MessageFileName, 'From: FtpInfo'
CALL CharOut MessageFileName, 'To: '

/* Insert the list of names from the namelist. */

CALL Stream namelist, 'C', 'OPEN READ'
name = LineIn(namelist)
CALL CharOut MessageFileName, name
DO FOREVER
    name = LineIn(namelist)
    IF name = '' THEN LEAVE
    CALL LineOut MessageFileName, ','
    CALL CharOut MessageFileName, '    'name
END
CALL LineOut MessageFileName, ''
CALL Stream namelist, 'C', 'CLOSE'
CALL LineOut MessageFileName, 'Subject: Address of FTP server'
CALL LineOut MessageFileName, ''
CALL Stream MessageFileName, 'C', 'CLOSE'

/* Append the output of the 'hostid' command. */

'@hostid >>'MessageFileName

/* All finished. */

RETURN

