Uses Cfg
Uses User

Const	BLK	= 0
Const	BLU	= 1
Const	GRN	= 2
Const CYN	= 3
Const RED	= 4
Const PNK	= 5
Const YLO	= 6
Const WHT	= 7
Const BLD	= 8

Const	WARM	= 1
Const	COLD	= 2

Const SysopACS = 's255'

Const TelnetPath = '/usr/bin/telnet '

Const	ListTop	= 2
Const ListBot	= 23
Const ListLt	= 2
Const	ListRt	= 28
Const	ListHead	= ' BBS List '

Const EditTop	= 2
Const EditBot	= 12
Const	EditLt	= 30
Const EditRt	= 78
Const	EditHead	= ' BBS Info '

Const MenuTop	= 14
Const MenuBot	= 23
Const	MenuLt	= 30
Const MenuRt	= 78
Const MenuHead	= ' Menu '

Var ListActive	: Byte = (WHT*16)+(BLU)			// Black on White
Var ListBar		: Byte = (BLU*16)+(WHT+BLD) 	// White on Blue
Var ListDel		: Byte = (WHT*16)+(BLK)
Var ListDelBar	: Byte = (RED*16)+(WHT+BLD)
Var EditMain	: Byte = (WHT*16)+BLK
Var EditItem	: Byte = (WHT*16)+(GRN+BLD)


Type BBSRec	= Record
  cType	: Byte
  Phone	: String[15]
  Telnet	: String[40]
  Name	: String[30]
  City 	: String[25]
  Sysop	: String[30]
  Nodes	: String[6]
  Soft	: String[10]
  Deleted: Boolean
  AddedBy: String[30]
  Verified : LongInt
  Extra1 : LongInt
  Extra2 : Integer
End

Var Entry		: BBSRec
Var ListName   : String;
Var ListFile	: String
Var ListBox		: LongInt
Var EditBox		: LongInt
Var MenuBox		: LongInt
Var InputBox	: LongInt
Var AccessBy	: Array [1..3] of String
Var ADAttr		: Array [1..2] of Byte
Var Ok2Tel		: Byte = COLD
Var Ok2Use		: Byte = COLD
Var Ok2Add		: Byte = COLD
Var EntryCnt	: Integer = 0
Var W				: String
Var L				: Byte
Var AddACS		: String = 's1'
Var TelACS		: String = 's100'
Var BBIFile		: String

Procedure MakeWindow
Var X,Y	: Integer
Var S		: String
Begin
	X:=ListBot-ListTop-1
	Y:=EditLt+1
	ClassCreate(ListBox,'box')
	BoxHeader(ListBox,2,(RED*16)+WHT+BLD,ListHead)
	ClassCreate(EditBox,'box')
	BoxHeader(EditBox,2,(RED*16)+WHT+BLD,EditHead)
	ClassCreate(MenuBox,'box')
	BoxHeader(MenuBox,2,(RED*16)+WHT+BLD,MenuHead)
	ClassCreate(InputBox,'input')

	ClrScr
	BoxOpen(ListBox,ListLt,ListTop,ListRt,ListBot)
	BoxOpen(EditBox,EditLt,EditTop,EditRt,EditBot)
	BoxOpen(MenuBox,MenuLt,MenuTop,MenuRt,MenuBot)

	WriteXY(Y,EditTop+1,EditMain,'  Name: ')
	WriteXY(Y,EditTop+2,EditMain,'    By: ')
	WriteXY(Y,EditTop+3,EditMain,'   URL: ')
	WriteXY(Y,EditTop+4,EditMain,' Phone: ')
	WriteXY(Y,EditTop+5,EditMain,' Nodes: ')
	WriteXY(Y,EditTop+6,EditMain,' Sysop: ')
	WriteXY(Y,Edittop+7,EditMain,'  City: ')
	WriteXY(Y,EditTop+8,EditMain,' SoftW: ')
   WriteXY(Y,EditTop+9,EditMain,' Vfied: ')

	S:=PadCt(' BBS List Admin Manager ',MenuRt-MenuLt-3,#196)
	WritexY(MenuLt+2,MenuBot-2,EditMain,S)
	WritexY(MenuLt+2,MenuBot-1,ADAttr[WARM],PadCt('By Darryl Perry, 2013',MenuRt-MenuLt-3,' '))
End

Procedure CloseWindow
Begin
	BoxClose(ListBox)	
	BoxClose(EditBox)	
	BoxClose(MenuBox)	
	ClassFree(ListBox)
	ClassFree(EditBox)
	ClassFree(MenuBox)
	ClassFree(InputBox)
End

Procedure Help
Var HelpBox	: LongInt
Begin
	ClassCreate(HelpBox,'box')
	BoxHeader(HelpBox,0,(BLU*16)+WHT+BLD,' Help ')
	BoxOpen(HelpBox,15,3,65,20)
	WriteXY(17, 5,(WHT*16)+WHT+BLD,#016+#017+#030+#031+': Rt, Lt, Up, Dn')
	WriteXY(17, 6,(WHT*16)+WHT+BLD,'ESC : Quit the programm')
	WriteXY(17, 7,(WHT*16)+WHT+BLD,' A  : Add a new entry')
	WriteXY(17, 8,(WHT*16)+WHT+BLD,' E  : Edit the highlighted entry')
	WriteXY(17, 9,(WHT*16)+WHT+BLD,' E  : Delete (Mark) the highlighted entry')
	WriteXY(17,10,(WHT*16)+WHT+BLD,' V  : Verify the highlighted entry')
	WriteXY(17,11,(WHT*16)+WHT+BLD,' M  : Send email to the entry owner')
	WriteXY(17,12,(WHT*16)+WHT+BLD,' T  : Telnet to the highlighted entry')
	WriteXY(17,13,(WHT*16)+WHT+BLD,' S  : Show Short List in Mystic')
	WriteXY(17,14,(WHT*16)+WHT+BLD,' W  : Download the list')
	WriteXY(17,17,ADAttr[WARM],'(X)-: Option is available to use')
	WriteXY(17,18,ADAttr[COLD],'(X)-: Option is NOT available to use')
	ReadKey
	BoxClose(HelpBox)
	ClassFree(HelpBox)
End

Procedure ErrorMsg(S:String)
Var ErrorBox	: LongInt
Var M,I,WC		: Byte=1
Begin
	ClassCreate(ErrorBox,'box')
	WC:=WordCount(S,'&')
	For I:=1 To WC Do Begin
		If Length(WordGet(I,S,'&')) > M Then
			M:=Length(WordGet(I,S,'&'))
	End
	BoxHeader(ErrorBox,0,(RED*16)+WHT+BLD,'Error!')
	BoxOpen(ErrorBox,40-(M/2)-2,5,40+(M/2)+1,5+WC+2)
	For I:=1 To WC Do Begin
		WriteXY(40-(M/2),6+I,(WHT*16)+WHT+BLD,PadCt(WordGet(I,S,'&'),M,' '))
	End
	ReadKey
	BoxClose(ErrorBox)
	ClassFree(ErrorBox)	
End

Function ReadEntry(I:Integer):Boolean
Var Ret	: Boolean = False
Var Fp	: File
Begin
	fAssign(Fp,ListName,66)
	fReset(Fp)
	If IoResult = 0 Then Begin
		fSeek(Fp,(I-1)*SizeOf(Entry))
		If Not fEof(Fp) Then Begin
			fRead(Fp,Entry,SizeOf(Entry))
			Ret:=True
		End
		fClose(Fp)
	End
	ReadEntry:=Ret
End

Procedure SaveEntry(I:Integer)
Var Fp	: File
Begin
	fAssign(Fp,ListName,66)
	fReset(Fp)
	If IoResult <> 0 Then 
		fReWrite(Fp)
	Else 
		fSeek(Fp,(I-1)*SizeOf(Entry))
	fWrite(Fp,Entry,SizeOf(Entry))
	fClose(Fp)
End

Procedure ListEntries(T,B:Integer)
Var X,F,K,I	: Integer
Var S		: String
Begin
	F:=ListBot-ListTop-1
	X:=ListRt-ListLt-2
	For I:=1 To F Do Begin
		K:=I+T-1
		If ReadEntry(K) Then Begin
			S:=PadRt(StripMCI(Entry.Name),X,' ')
			If I = B Then
				If Entry.Deleted Then
					WriteXY(ListLt+2,ListTop+I,ListDelBar,S)
				Else
					WriteXY(ListLt+2,ListTop+I,ListBar,S)
			Else
				If Entry.Deleted Then
					WriteXY(ListLt+2,Listtop+I,ListDel,S)
				Else
					WriteXY(ListLt+2,Listtop+I,ListActive,S)
		End Else Begin
			WriteXY(ListLt+2,ListTop+I,ListActive,PadRt(' ',X,' '))
		End
	End
End

Function CheckDupe(R:Integer):Boolean
Var Saved	: BBSRec
Var C,X		: Integer=1
Var Ret		: Boolean=True
Begin
	Saved:=Entry
	C:=Saved.CType
	While ReadEntry(X) And Ret Do Begin
		If X <> R Then Begin
			If C = 1 Or C = 2 Then 
				If Entry.Telnet = Saved.Telnet Then Ret:=False
			If C = 0 Or C = 2 Then
				If Entry.Phone  = Saved.Phone  Then Ret:=False
		End
		X:=X+1
	End
	Entry:=Saved
	CheckDupe:=Ret
End

Procedure RightSide(I:Integer)
Var X	: Byte = EditLt+8
Begin
	If ReadEntry(I) Then Begin
		If Ok2Use = COLD Then 
			If StripMCI(Entry.AddedBy)=StripMCI(UserAlias) Or ACS(SysopACS) Then
				Ok2Use:=WARM
		WriteXY(X,EditTop+1,EditItem,PadRt(Entry.Name,40,' '))
		WriteXY(X,EditTop+2,EditItem,PadRt(accessby[Entry.CType+1],40,' '))
		WriteXY(X,EditTop+3,EditItem,PadRt(Entry.Telnet,40,' '))
		WriteXY(X,EditTop+4,EditItem,PadRt(Entry.Phone,40,' '))
		WriteXY(X,EditTop+5,EditItem,PadRt(Entry.Nodes,40,' '))
		WriteXY(X,EditTop+6,EditItem,PadRt(Entry.Sysop,40,' '))
		WriteXY(X,Edittop+7,EditItem,PadRt(Entry.City,40,' '))
		WriteXY(X,EditTop+8,EditItem,PadRt(Entry.Soft,40,' '))
      WriteXY(X,EditTop+9,EditItem,PadRt(DateStr(Entry.Verified, 1),40,' '))
	End
End

Procedure Edit(I:Integer)
Var InPos	: Byte = 1
Var X			: Byte = EditLt+8
Var Done		: Boolean = False
Var S			: String
Begin
	PurgeInput
  	InputOptions (InputBox,    // Input class handle
                31,          // Attribute of inputted text
                25,          // Attribute to use for field input filler
                #176,        // Character to use for field input filler
                #9 + #27,    // Input will exit on these "low" ascii characters
                             // TAB
          #75+#77+#72+#80);  // Input will exit on these "extended" characters
                             // UP and DOWN arrows

	If I > 0 Then 
		ReadEntry(I) 
	Else Begin 
		EntryCnt:=EntryCnt+1
		I:=EntryCnt	
	End

	While Not Done Do Begin
		WriteXY(X,EditTop+1,EditItem,PadRt(Entry.Name,40,' '))
		WriteXY(X,EditTop+2,EditItem,PadRt(accessby[Entry.CType+1],40,' '))
		WriteXY(X,EditTop+3,EditItem,PadRt(Entry.Telnet,40,' '))
		WriteXY(X,EditTop+4,EditItem,PadRt(Entry.Phone,40,' '))
		WriteXY(X,EditTop+5,EditItem,PadRt(Entry.Nodes,40,' '))
		WriteXY(X,EditTop+6,EditItem,PadRt(Entry.Sysop,40,' '))
		WriteXY(X,Edittop+7,EditItem,PadRt(Entry.City,40,' '))
		WriteXY(X,EditTop+8,EditItem,PadRt(Entry.Soft,40,' '))
      WriteXY(X,EditTop+9,EditItem,PadRt(DateStr(Entry.Verified, 1),20,' '))
		WriteXY(X+25,EditTop+9,(RED*16)+WHT+BLD,' SAVE ')
		WriteXY(X+33,EditTop+9,(RED*16)+WHT+BLD,' QUIT ')

		Case InPos of
			1:Entry.Name  :=InputString(InputBox,X,EditTop+1,30,30,1,Entry.Name);
			2:Begin
				S:=PadRt(AccessBy[Entry.CType+1],40,' ')
				If InputEnter(InputBox,X,EditTop+2,Length(S),S) Then Begin
					Entry.CType:=Entry.CType+1
					If Entry.CType > 2 Then Entry.CType:=0
				End
			End
			3:Entry.Telnet:=InputString(InputBox,X,EditTop+3,40,40,1,Entry.Telnet);
			4:Entry.Phone :=InputString(InputBox,X,EditTop+4,15,15,1,Entry.Phone);
			5:Entry.Nodes :=InputString(InputBox,X,EditTop+5,40,40,1,Entry.Nodes);
			6:Entry.Sysop :=InputString(InputBox,X,EditTop+6,30,30,1,Entry.Sysop);
			7:Entry.City  :=InputString(InputBox,X,EditTop+7,25,25,1,Entry.City);
			8:Entry.Soft  :=InputString(InputBox,X,EditTop+8,10,10,1,Entry.Soft);
	  	   9:If InputEnter(InputBox,X+25,EditTop+9,6,#016+'SAVE'+#017) Then Begin
					If CheckDupe(I) Then Begin
						MenuCmd('-S','BLAM:'+UserAlias+' Edited '+Entry.Name)
						SaveEntry(I)
						Done:=True;
					End Else Begin
			ErrorMsg('This is a duplicate entry&Please use a different address')
					End
				 End
	  	  10:If InputEnter(InputBox,X+33,EditTop+9,6,#016+'QUIT'+#017) Then Done:=True;
		End

		Case InputExit(InputBox) of
      	#09,#77,#80 : If InPos < 10 Then InPos := InPos + 1 Else InPos := 1;
      	    #75,#72 : If InPos > 1  Then InPos := InPos - 1 Else InPos := 10;
			#27 : Done:=True;
		End
	End
End

Procedure AddNew
Begin
	Entry.AddedBy:=UserAlias
	Entry.Name:='New BBS'
	Entry.City:='New City'
	Entry.Sysop:='New Sysop'
	Entry.Soft:='Mystic'
	Entry.CType:=1
	Entry.Phone:='None'	
	Entry.Telnet:='bbs.domain.org'
	Entry.Deleted:=False
	Entry.Nodes:='5'
End

Procedure DeleteEntry(I:Integer)
Begin
	If ReadEntry(I) Then Begin
		If Entry.Deleted Then Entry.Deleted:=False
		Else	Entry.Deleted:=True
		SaveEntry(I)
	End
End

Procedure VerifyEntry(I:Integer)
Begin
	If ReadEntry(I) Then Begin
		Entry.Verified:=DateTime
		SaveEntry(I)
	End
End

Procedure TelnetTo(I:Integer)
Begin
	If ReadEntry(I) Then Begin
		CloseWindow
		Write('|CL|CR|CR|11|16')
		MenuCmd('D-',TelnetPath+Replace(Entry.Telnet,':',' '))
		MenuCmd('-S','BLAM:'+UserAlias+' telnetted to '+Entry.Name)
		pause
		MakeWindow
	End
End

Procedure EmailOwner(I:Integer)
Begin
	If ReadEntry(I) Then Begin
		CloseWindow
		MenuCmd('MW','/TO:'+Replace(Entry.AddedBy,' ','_'))
		MakeWindow
	End
End

Procedure ShowList
Begin
	CloseWindow
	MenuCmd('BS',ListFile+';SEARCH')
	Pause
	MakeWindow
End

Procedure DownloadList
Begin
	CloseWindow
	MenuCmd('GX','bbslist '+ListFile)
	MakeWindow
End

Procedure Main
Var Done	: Boolean = False
Var Ch	: Char
Var Y,X,Top,Bar	: Integer = 1
Var R		: Integer
Begin
	X:=ListBot-ListTop-1
	Y:=EditLt+1

	While Not Done Do Begin
		R:=Top+Bar-1
		Ok2Use:=COLD
		ListEntries(Top,Bar)
		RightSide(Top+Bar-1)
		WriteXY(MenuLt+18,MenuTop+2,ADAttr[WARM]  ,'(V)erify   ')
		WriteXY(MenuLt+18,MenuTop+1,ADAttr[Ok2Add],'(A)dd New  ')
		WriteXY(MenuLt+33,MenuTop+1,ADAttr[WARM]  ,'(ESC)=Quit ')
		WriteXY(MenuLt+2 ,MenuTop+2,ADAttr[Ok2Use],'(E)dit     ')

		If Entry.Deleted Then
			WriteXY(MenuLt+2,MenuTop+1,ADAttr[Ok2Use],'un(D)elete ')
		Else
			WriteXY(MenuLt+2,MenuTop+1,ADAttr[Ok2Use],'(D)elete   ')

		WriteXY(MenuLt+33,MenuTop+2,ADAttr[WARM]  ,'(?)=Help   ')

		WriteXY(MenuLt+2 ,MenuTop+3,ADAttr[WARM],'(S)how List')
		WriteXY(MenuLt+18,MenuTop+3,ADAttr[WARM],'Do(W)nload ')
		WriteXY(MenuLt+2 ,MenuTop+5,ADAttr[WARM],'e(M)ail ')
		WriteXY(MenuLt+10 ,MenuTop+5,EditItem,PadRt(Entry.AddedBy,30,' '))
		WriteXY(MenuLt+2 ,MenuTop+6,ADAttr[Ok2Tel],'(T)elnet to ')
		WriteXY(MenuLt+14,MenuTop+6,EditItem,PadRt(Entry.Telnet,30,' '))
		Ch:=ReadKey
		If IsArrow Then Begin
			Case Ch Of
				#77:	Begin
					If R+X<EntryCnt Then
						Top:=Top+X
				End
				#75: Begin
					If R-X>0 Then
						Top:=Top-X
				End
				#80: 	Begin
						If Bar+Top-1 < EntryCnt Then Begin
							If Bar < X Then 
								Bar:=Bar+1 
							Else Begin
								Bar:=X
								Top:=Top+1
							End
						End
				End
				#72: 	If Bar > 1 Then 
							Bar:=Bar-1 
						Else Begin
							Bar:=1
							If Top > 1 Then
								Top:=Top-1
						End
			End
		End Else Begin
			Ch:=Upper(Ch)
			Case Ch Of
				#27: Done:=True
//				#13: Done:=True
				'A': If Acs(AddACS) And Ok2Add=WARM Then Begin AddNew; Edit(-1); End
				'D': If Ok2Use = WARM Then DeleteEntry(Top+Bar-1)
				'E': If Ok2Use = WARM Then Edit(Top+Bar-1)
				'M': EmailOwner(Top+Bar-1)
				'T': If Ok2Tel = WARM Then TelnetTo(Top+Bar-1)
				'V': VerifyEntry(Top+Bar-1)
				'S': ShowList
				'W': DownloadList
				'?': Help						
			End
		End	
	End
End

Begin

	ListFile:='bbslist'

	For L:=1 to ParamCount Do Begin
		If Pos('/ADDACS:',Upper(ParamStr(L))) > 0 Then Begin
			AddACS:=ParamStr(L)
			Delete(AddACS,1,8)
		End Else Begin If Pos('/BBIFILE:',Upper(ParamStr(L))) > 0 Then Begin
			Listfile:=ParamStr(L)
			Delete(ListFile,1,9)
			ListFile:=JustFileName(ListFile)	
		End Else Begin If Pos('/TELNETACS:',Upper(ParamStr(L))) > 0 Then Begin
			TelACS:=ParamStr(L)
			Delete(TelACS,1,11)
		End Else Begin
		WriteLn ('Invalid command line option.');
		WriteLn ('');
		WriteLn ('Usage:')
		WriteLn ('  GY-BLAM </BBIFILE:<bbslist file>> [[/ADDACS:<acs string>]')
		WriteLn ('')
		WriteLn ('  /BBIFILE:<bbslist file>')
		WriteLn ('      Name of the BBSLIST.BBI file found in DATA directory.')
		WriteLn ('      Default is "BBSLIST"')
		WriteLn ('')
		WriteLn ('  /ADDACS:<acs string>')
		WriteLn ('      ACS string to allow adding new BBSes to the list.')
		WriteLn ('      Example: /ADDACS:s10')
		WriteLn ('      Default is "s1"')
		WriteLn ('')
		WriteLn ('  /TELNETACS:<acs string>')
		WriteLn ('      ACS string to allow telnetting to BBSes from the list.')
		WriteLn ('      Example: /TELNETACS:s10')
		WriteLn ('      Default is "s100"')
		WriteLn ('|CR|PA');
		Halt
		End
		End
		End
	End

	Ok2Add:=COLD
	If Acs(AddAcs) 	Then Ok2Add:=Warm
	If Acs(TelACS) Then Ok2Tel:=Warm

	GetThisUser
	ListName := CfgDataPath + ListFile +'.bbi';
	AccessBy[1]:='DialUp'
	AccessBy[2]:='Telnet'
	AccessBy[3]:='DialUp and Telnet'

	ADAttr[WARM]:=(WHT*16)+(WHT+BLD)
	ADAttr[COLD]:=(WHT*16)+(BLK+BLD)

	While ReadEntry(EntryCnt+1) Do EntryCnt:=EntryCnt+1

	MakeWindow
	Main
	CloseWindow
	Write('|11|16')
End


