#!/usr/bin/python3

"""
   ---------------------------------------------------------------------------
   terminal client for 16colo.rs ftp site                                 xqtr
   --------------------------------------------------------------------------- 

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
   
   _            _   _              ___          _    _       
  /_\  _ _  ___| |_| |_  ___ _ _  |   \ _ _ ___(_)__| |               8888
 / _ \| ' \/ _ \  _| ' \/ -_) '_| | |) | '_/ _ \ / _` |            8 888888 8
/_/ \_\_||_\___/\__|_||_\___|_|   |___/|_| \___/_\__,_|            8888888888
                                                                   8888888888
         DoNt Be aNoTHeR DrOiD fOR tHe SySteM                      88 8888 88
                                                                   8888888888
    .o HaM RaDiO    .o ANSi ARt!       .o MySTiC MoDS              "88||||88"
    .o NeWS         .o WeATheR         .o FiLEs                     ""8888""
    .o GaMeS        .o TeXtFiLeS       .o PrEPardNeSS                  88
    .o TuTors       .o bOOkS/PdFs      .o SuRVaViLiSM          8 8 88888888888
    .o FsxNet       .o SurvNet         .o More...            888 8888][][][888
                                                               8 888888##88888
   TeLNeT : andr01d.zapto.org:9999                             8 8888.####.888
   SySoP  : xqtr                   eMAiL: xqtr@gmx.com         8 8888##88##888
   DoNaTe : https://paypal.me/xqtr    
"""

import os
import sys
import tty,termios
import ftplib
import base64
from time import sleep

dizx = 31
dizy = 6
dizw = 46
dizh = 15

delay = 0.05

bbs_address = "mybbs.zapto.org"

bg = base64.b64decode(\
'G1sxOzM3bdsbWzQ3bd8bWzQwbd/f3yDfIN/f398bWzA7Mzc7NDBtIN/f39/f39/f3yDfIN/fG1sx'+
'OzMwbd8bWzA7Mzc7NDBt3xtbMTszMG3fG1swOzM3OzQwbd/fG1sxOzMwbd/f3yDf39/f3xtbMDsz'+
'Nzs0MG3fG1sxOzMwbd/f3yAbWzA7Mzc7NDBt39/f39/f39/f3yDf39/f39/fIN8gIN/fIN8bWzFt'+
'39/fIN8bWzQ3bd8bWzQwbdsbWzBtDQobWzFt2xtbMDszNzs0MG0gG1sxbcnNG1swOzM3OzQwbc3E'+
'xMQbWzFtIBtbMzBtxBtbMzdtxCAbWzMwbfobWzA7Mzc7NDBtIBtbMW2/G1swOzM3OzQwbSAbWzFt'+
'yc3NG1swOzM3OzQwbSAgxMTExMTExMTExMTExMTExMTEG1sxbcTExMTEG1swOzM3OzQwbcQbWzFt'+
'xMQbWzA7Mzc7NDBtICAgG1sxbcTExBtbMDszNzs0MG3EG1sxbcTExMQbWzA7Mzc7NDBtxBtbMW3E'+
'G1swOzM3OzQwbSAgICAbWzFtxMTExBtbMDszNzs0MG0gIBtbMTszMG3EICD6ICAbWzM3bb8bWzA7'+
'Mzc7NDBtIBtbMW3bG1swbQ0KG1sxbdsbWzA7Mzc7NDBtILogG1sxbTE2Y29sby5ycxtbMDszNzs0'+
'MG0guiC6G1sxbSAvG1swOzM3OzQwbSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg'+
'ICAgICAgICAgICAgICAgICAgICAgIBtbMW26G1swOzM3OzQwbSAbWzFt3BtbMG0NChtbMTs0N23c'+
'G1swOzM3OzQwbSDAIBtbMTszMG36G1swOzM3OzQwbSAbWzFtxCDEG1swOzM3OzQwbcTExM0bWzFt'+
'zbwbWzA7Mzc7NDBtIMAg+iD6IBtbMW3EG1szMG0gICDEIMQbWzA7Mzc7NDBtICAbWzFtxBtbMDsz'+
'Nzs0MG0gG1sxbcTExMTExMTEG1swOzM3OzQwbcTExMTExMTExMTExMTExMTExMTExBtbMW3ExMTE'+
'xMTExMTEG1swOzM3OzQwbcQgG1sxbc3NvBtbMDszNzs0MG0gG1sxbd8bWzBtDQobWzFt3xtbMDsz'+
'Nzs0MG0gG1sxbcnNzRtbMDszNzs0MG3NG1sxbc0bWzA7Mzc7NDBtzRtbMW3NzSDExMQbWzA7Mzc7'+
'NDBtxMTEG1sxOzMwbcQbWzA7Mzc7NDBtxCAbWzE7MzBtxBtbMDszNzs0MG3ExCDEG1sxbcTEvxtb'+
'MDszNzs0MG0gG1sxbcnNzc3Nzc3NIMTExBtbMDszNzs0MG3ExMTExBtbMTszMG3EG1swOzM3OzQw'+
'bcTEG1sxOzMwbcQbWzA7Mzc7NDBtxBtbMTszMG3EIMTExMTExBtbMzdtxMQbWzA7Mzc7NDBtIBtb'+
'MW3EIMQgxCAgG1swOzM3OzQwbcTExCDEG1sxbcTEvxtbMDszNzs0MG0gG1sxOzQ3bdwbWzBtDQob'+
'WzFt2xtbMDszNzs0MG0gG1sxbbobWzA7Mzc7NDBtICAgICAgICAgICAgICAgICAgICAgICAgG1sx'+
'bbMbWzA7Mzc7NDBtIBtbMW26G1swOzM3OzQwbSAgICAgICAgICAgICAgICAgICAgICAgICAgICAg'+
'ICAgICAgICAgICAgICAgICAbWzFtsxtbMDszNzs0MG0gG1sxbd8bWzBtDQrfILogICAgICAgICAg'+
'ICAgICAgICAgICAgICCzILogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg'+
'ICAgICAgsyAbWzFt2xtbMG0NCtsgG1sxbbobWzA7Mzc7NDBtICAgICAgICAgICAgICAgICAgICAg'+
'ICAgG1sxbbMbWzA7Mzc7NDBtIBtbMW26G1swOzM3OzQwbSAgICAgICAgICAgICAgICAgICAgICAg'+
'ICAgICAgICAgICAgICAgICAgICAgICAbWzFtsxtbMDszNzs0MG0g2w0K2yC6ICAgICAgICAgICAg'+
'ICAgICAgICAgICAgICC6ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg'+
'ICAgICAgG1sxOzMwbdsbWzBtDQobWzE7MzBt2xtbMDszNzs0MG0guiAgICAgICAgICAgICAgICAg'+
'ICAgICAgILMguiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICCz'+
'INsNChtbMTszMG3cG1swOzM3OzQwbSAbWzE7MzBtuhtbMDszNzs0MG0gICAgICAgICAgICAgICAg'+
'ICAgICAgICAuILogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg'+
'LiDcDQobWzE7MzBt3BtbMDszNzs0MG0gsyAgICAgICAgICAgICAgICAgICAgICAgILMgsyAgICAg'+
'ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICCzG1sxOzMwbSDcG1swbQ0K'+
'G1sxOzMwbSAgsxtbMDszNzs0MG0gICAgICAgICAgICAgICAgICAgICAgICAbWzE7MzBtOhtbMDsz'+
'Nzs0MG0gG1sxOzMwbbMbWzA7Mzc7NDBtICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg'+
'ICAgICAgICAgICAgIBtbMTszMG06IBtbMDszNzs0MG3fDQobWzE7MzBtICAbWzA7Mzc7NDBtsyAg'+
'ICAgICAgICAgICAgICAgICAgICAgILMbWzE7MzBtIBtbMDszNzs0MG2zICAgICAgICAgICAgICAg'+
'ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIBtbMTszMG2zINwbWzBtDQrbG1sxOzMwbSAg'+
'ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg'+
'ICAgICAgICAgICAgICAgICAg2xtbMG0NCtwbWzE7MzBtIDobWzA7Mzc7NDBtICAgICAgICAgICAg'+
'ICAgICAgICAgICAgG1sxOzMwbbMbWzA7Mzc7NDBtIBtbMTszMG06G1swOzM3OzQwbSAgICAgICAg'+
'ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAbWzE7MzBtsxtbMG0NCtsbWzE7'+
'MzBtICAgICAgICAgICAgICAgICAgICAgICAgICAbWzA7Mzc7NDBtsyAgICAgICAgICAgICAgICAg'+
'ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgILMg2w0K3xtbMTszMG0gG1swOzM3OzQwbTog'+
'ICAgICAgICAgICAgICAgICAgICAgICAbWzE7MzBtuhtbMDszNzs0MG0gOiAgICAgICAgICAgICAg'+
'ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAbWzE7MzBtuiAbWzQ3bdwbWzBtDQobWzE7'+
'NDdt3xtbMzA7NDBtIBtbMDszNzs0MG0gICAgICAgICAgICAgICAgICAgICAgICAguiAgICAgICAg'+
'ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgILobWzE7MzBtIBtbMDszNzs0'+
'MG3fDQrbILMgICAgICAgICAgICAgICAgICAgICAgICC6ILMgICAgICAgICAgICAgICAgICAgICAg'+
'ICAgICAgICAgICAgICAgICAgICAgICAguiAbWzE7NDdt3BtbMG0NChtbMTs0N23fG1swOzM3OzQw'+
'bSAbWzFtsxtbMDszNzs0MG0gICAgICAgICAgICAgICAgICAgICAgICAbWzFtuhtbMDszNzs0MG0g'+
'G1sxbbMbWzA7Mzc7NDBtICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg'+
'ICAgIBtbMW26G1swOzM3OzQwbSDbDQrcIBtbMW3AxMTEG1swOzM3OzQwbcTEICAgIMQbWzE7MzBt'+
'xBtbMDszNzs0MG3ExBtbMTszMG3EG1swOzM3OzQwbcQbWzFtxBtbMDszNzs0MG3Ezc0bWzFtzc0b'+
'WzA7Mzc7NDBtzRtbMW3NzbwbWzA7Mzc7NDBtIBtbMW3AxMTEG1swOzM3OzQwbcTEICAgIMTExMTE'+
'xBtbMW3EG1szMG3ExBtbMzdtxBtbMzBtxBtbMzdtIBtbMzBtxCDExMTEIMTEG1swOzM3OzQwbSAg'+
'xMQbWzE7MzBtxBtbMDszNzs0MG3ExMTEzc0bWzFtzc3Nzc28G1swOzM3OzQwbSAbWzFt2xtbMG0N'+
'ChtbMW3bG1swOzM3OzQwbSAbWzc1QyAbWzFt2xtbMG0NChtbMW3bG1s0N23cG1s0MG3c3NwbWzA7'+
'Mzc7NDBt3CDc3Nzc3Nwg3BtbMTszMG3cG1swOzM3OzQwbSDc3NzcG1sxOzMwbdzc3CDcG1swOzM3'+
'OzQwbdwbWzE7MzBt3Nzc3NzcG1swOzM3OzQwbdwbWzE7MzBt3NzcG1swOzM3OzQwbSAgICAgG1sx'+
'OzMwbdzc3Nzc3Nwg3Nzc3Nzc3NwgG1swOzM3OzQwbdwbWzE7MzBt3CDcIBtbMDszNzs0MG3c3Nwb'+
'WzE7MzBt3BtbMDszNzs0MG3c3CDc3NzcG1sxbdzcG1s0N23cG1s0MG3bG1swbQ==')

# do not change anything below here

packs = []
years = []
files = []
filesdet = []

colors = {
        0:"\033[30m",
        1:"\033[34m",
        2:"\033[32m",
        3:"\033[36m",
        4:"\033[31m",
        5:"\033[35m",
        6:"\033[33m",
        7:"\033[0;37m",
        8:"\033[90m",
        9:"\033[94m",
        10:"\033[92m",
        11:"\033[96m",
        12:"\033[91m",
        13:"\033[95m",       
        14:"\033[93m",
        15:"\033[1;37m",
        16:"\033[40m",
        17:"\033[44m",
        18:"\033[42m",
        19:"\033[46m",
        20:"\033[41m",
        21:"\033[45m",
        22:"\033[43m",      
        23:"\033[47m"
}

fdir = ""


def dispfile(filename):
    write(colors[7]+colors[16])
    clrscr()
    with open(sys.path[0]+os.sep+"temp.ans",encoding="CP437") as fp:  
            lines = fp.readlines()
            cnt = 0
            #write(mci)
            while cnt<=len(lines)-1:
                a=lines[cnt]
                os.write(1,bytes(a,"CP437"))
                sleep(delay)
                cnt+=1

def attr2color(att):
    ret = colors[att % 16]
    ret = ret + colors[(att // 16)+16]
    return ret
    
def byte2str(v):
    s=''.join(str(v))
    return s[2:-1]

def readkey():
    ch1=''
    ch2=''
    fd = sys.stdin.fileno()
    old_settings = termios.tcgetattr(fd)
    try:
        tty.setraw(sys.stdin.fileno())
        ch = sys.stdin.read(1)
    finally:
        termios.tcsetattr(fd, termios.TCSADRAIN, old_settings)
    return ch
    
def clrscr():
    sys.stdout.write('\033[2J')
#   n=0 clears from cursor until end of screen,
#   n=1 clears from cursor to beginning of screen
#   n=2 clears entire screen
    sys.stdout.flush()
    gotoxy(1,1)    
    
def readcursor():
    c = readkey()
    if ord(c) != 27:
        return None
    c = readkey()
    c = readkey()
    if c=='A':
        return 'Up'
    if c=='B':
        return 'Down'
    if c=='C':
        return 'Right'
    if c=='D':
        return 'Left'
    

def gotoxy(x,y):
    if x < 1:
        x = 1
    if x > 80:
        x = 80
    if y<1:
        y = 1
    if y>25:
        y=25
    sys.stdout.write('\033['+str(y)+';'+str(x)+'H')
    sys.stdout.flush()

def write(s):
    #sys.stdout.write(textattr_str)
    sys.stdout.write(str(s))
    sys.stdout.flush()    
    
def writexy(x,y,a,s):
    gotoxy(x,y)
    sys.stdout.write(attr2color(a))
    sys.stdout.write(s)

def getyears():
    global years
    global ftp
    ftp.cwd("/pack/")
    fdir = "/pack"
    ls = []
    ftp.retrlines('LIST', ls.append)
    for entry in ls:
        years.append(entry[56:56+10])

def getpacks(year):
    global packs
    global ftp
    packs.clear()
    ftp.cwd("/pack/"+year+"/")
    fdir = "/pack/"+year+"/"
    ls = []
    ftp.retrlines('LIST', ls.append)
    for entry in ls:
        packs.append(entry[56:56+50])

def getpackfiles(year,pack):
    global files
    global filesdet
    global ftp
    files.clear()
    filesdet.clear()
    ftp.cwd("/pack/"+year+"/"+pack+"/raw/")
    fdir = "/pack/"+year+"/"+pack+"/raw/"
    ls = []
    ftp.retrlines('LIST', ls.append)
    for entry in ls:
        files.append(entry[56:56+50])
        filesdet.append(entry)

def drawbg():
    write(colors[0]+colors[16])
    clrscr()
    os.write(1,bg)
    writexy(8,25,7,"[ ENTER/select ][ Up/Down/Home/End ][ Left/back or exit ] XQTR/2019")

def crumbs(s):
    writexy(19,3,3,s.ljust(50," "))
    
def str2kb(s):
    ret = ""
    size = int(s)
    if size < 1000:
        ret = str(size)+"b"
    elif size >= 1000 and size <1000000:
        ret = size / 1000
        ret = "{:.2f}".format(ret)+"kb"
    elif size >= 1000000 and size <= 1000000000:
        ret = size / 1000000
        ret = "{:.2f}".format(ret)+"mb"
    return ret
        
def menu(items,x1,y1,x2,y2,hc,nc,sel):
    key = ""
    value = -1
    done = False
    if sel <= len(items):
        top = sel
    else:
        top = 0
    if sel <= len(items):
        selbar = sel
    else:
        selbar = 0
    
    while done == False:
        #writexy(1,1,7,str(top)+"/"+str(selbar)+"/"+str(len(items)))
        gotoxy(x1,y1)
        y = top
        while y1+y-top<=y2:
            if y<len(items):
                writexy(x1,y1+y-top,nc,items[y].ljust(x2-x1, " ")[:x2-x1])
            else:
                writexy(x1,y1+y-top,nc," ".ljust(x2-x1, " ")[:x2-x1])
            y += 1
        writexy(x1,y1+selbar-top,hc,items[selbar].ljust(x2-x1, " ")[:x2-x1])
        writexy(3,23,7,items[selbar].ljust(75," "))
        if len(filesdet)>0:
            writexy(53,23,3,str2kb(filesdet[selbar][29:43]).rjust(8," "))
            writexy(63,23,3,filesdet[selbar][43:56].ljust(14," "))
        gotoxy(1,25)
        
        key = readkey()
        if ord(key) == 27:
            key = readkey()
            key = readkey()
            #writexy(40,1,14,key)
            if key == "A":
                selbar=selbar-1
                if selbar < 1:
                    selbar = 0
                if selbar < top:
                    top = selbar
            
            elif key == "K" or key == "F":
                selbar=len(items)-1
                if len(items)-(y2-y1)-1 > 0:
                    top = len(items)-(y2-y1)-1
                else:
                    top = 0
            
            elif key == "H":
                selbar=0
                top = 0
            elif key == "D":
                value = -999
                done = True
            elif key == "B": 
                selbar=selbar+1
                if selbar > len(items)-1:
                    selbar = len(items)-1
                if selbar > top+y2-y1:
                    top += 1
        elif ord(key) == 13:
            value = selbar
            done = True
        elif key.upper() == "Q":
            value = -999
            done = True
        else:
            value = -1
            done = True
            
    return value

def cleardizarea():
    for i in range(0,dizh+1):
        writexy(dizx,dizy+i,7," ".rjust(dizw," "))
    
def getdiz():
    global files
    global ftp
    cleardizarea()
    if "file_id.diz" in files:
        filename = "file_id.diz"
    elif "file_id.asc" in files:
        filename = "file_id.asc"        
    elif "FILE_ID.DIZ" in files:
        filename = "FILE_ID.DIZ"
    elif "FILE_ID.ASC" in files:
        filename = "FILE_ID.ASC"
    elif "file_id.DIZ" in files:
        filename = "file_id.DIZ"
    try:
        with open(sys.path[0]+os.sep+"fileid.diz", 'wb') as f:
            ftp.cwd("/pack/"+years[y]+"/"+packs[p]+"/raw/")
            ftp.retrbinary('RETR ' + filename, f.write)
        with open("fileid.diz",encoding="CP437") as fp:  
            lines = fp.readlines()
            cnt = 0
            while cnt<=dizh and cnt<=len(lines)-1:
                a=lines[cnt][0:dizw]
                #a=bytes(a,"UTF-8")
                #a=str(a,"CP437")
        #        writexy(dizx,dizy,7,a)
                gotoxy(dizx,dizy+cnt)
                os.write(1,bytes(a,"CP437"))
                cnt += 1
                
    except:
        cleardizarea()
        
def getansi(filename):
    global files
    global ftp
    clrscr()
    try:
        with open(sys.path[0]+os.sep+"temp.ans", 'wb') as f:
            ftp.cwd("/pack/"+years[y]+"/"+packs[p]+"/raw/")
            ftp.retrbinary('RETR ' + filename, f.write)
        dispfile("temp.ans")
    except:
        cleardizarea()        
        

drawbg()
crumbs('/connecting...')
try:
    ftp = ftplib.FTP('16colo.rs', 'anonymous', 'anonymous@'+bbs_address)
except:
    print("Couldn't connect to 16colo.rs site...")
    print("... press any key ....")
    readkey()
    quit()

getyears();
y=0


while y != -999:
    try:
        crumbs('/')
        writexy(5,6,3,' > Year'.ljust(22," "))
        y = menu(years,5,7,27,21,(7*16),7,y)
        ftp.voidcmd("NOOP")
        writexy(70,1,11,str(y))
        if y >= 0:
            getpacks(years[y])
            filesdet.clear()
            drawbg()
            #crumbs('/'+years[y])
            writexy(5,6,3,'> Packs'.ljust(22," "))
            p=0
            f=0
            while p != -999:
                cleardizarea()
                crumbs('/'+years[y])
                p = menu(packs,5,7,27,21,(7*16),7,0)
                writexy(75,1,11,str(y))
                if p >= 0:
                    clrscr()
                    getpackfiles(years[y],packs[p])
                    drawbg()
                    crumbs('/'+years[y]+"/"+packs[p])
                    writexy(5,6,3,'> Files'.ljust(22," "))
                    getdiz()
                    f=0
                    while f >=0:
                        f = menu(files,5,7,27,21,(7*16),7,f)
                        if f>=0:
                            getansi(files[f])
                            drawbg()
                            crumbs('/'+years[y]+"/"+packs[p])
                            writexy(5,6,3,'> Files'.ljust(22," "))
                            ftp.voidcmd("NOOP")
                filesdet.clear()
    except ftplib.error_temp  as e:
        err = "{0}".format(e)
        if "421" in err:
            ftp = ftplib.FTP('16colo.rs', 'anonymous', 'anonymous@'+bbs_address)
            ftp.cwd(fdir)
            drawbg()
        else:
            writexy(1,25,12,"An error occured... Disconnecting. [{0}]".ljust(78," ").format(e))

ftp.quit()
clrscr()


"""
drwxr-xr-x    5 ftp      ftp          4096 Feb 11 23:04 1990
"""