/***************************************************************************/
/*** ProBoard Last Callers v1.00                                         ***/
/*** _LC.C                    Last caller list module for ProBoard v2.30 ***/
/***************************************************************************/
/*** This source file is distributed together with ProBoard v2.30, and   ***/
/*** may be modified and redistributed, provided that this header is     ***/
/*** not modified. When distributing the modified source code, make sure ***/
/*** you add a comment block with your name and any changes you have     ***/
/*** made.                                                               ***/
/***                                                                     ***/
/*** Original author: Philippe Leybaert                                  ***/
/*** Modified by: Jason Bock                                             ***/
/*** Art design by: blakdeth                                             ***/
/*** Written: 12-01-2021                                                 ***/
/*** Last Modified: 06-14-2023                                           ***/
/***************************************************************************/

#include "pb_sdk.h"

char *months_short[] = { "???","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};

void
main(int argc,char *argv[])
{
    bool aliases = FALSE;
    int lc_num  = 10 ,  /* # Entries in list         */
        lc_node =  0 ,  /* Node number to list       */
        i ,
        f ;             /* File handle for BINLOG.PB */

    char fname[80];
    BINLOG *bl;
    long cur_rec;

    strcpy(fname,SysPath);
    strcat(fname,"BINLOG.PB");

    for(i=1;i<argc;i++)
    {
        if(isdigit(argv[i][0])) lc_num = atoi(argv[i]);

        if(argv[i][0] == '/')
        {
            switch(argv[i][1])
            {
                case 'N': if(strlen(argv[i]) > 3) lc_node = atoi(&argv[i][3]);
                          break;
                case 'H': aliases = TRUE;
                          break;
            }
        }
    }

    f = open(fname,O_RDONLY | O_DENYNONE);

    if(f < 0) return;

    bl = malloc( lc_num * sizeof(BINLOG));

    cur_rec = l_div(filelength(f) , sizeof(BINLOG));

    if(cur_rec >= 1) cur_rec--;

    for(i = 0 ; i < lc_num ; cur_rec--)
    {
        lseek(f , l_mul(cur_rec,sizeof(BINLOG)) , SEEK_SET);

        if(read(f , &bl[i] , sizeof(BINLOG)) != sizeof(BINLOG)) break;

        if(!bl[i].baud) continue;

        if(bl[i].uflags & UFLAG_HIDDEN) continue;

        if(lc_node && lc_node != bl[i].node) continue;

        i++;
    }

    close(f);

    lc_num = i;

    EnableStop();

    InitLineCounter();

    //printf("\n\n\007%s\n",LC_HEAD.ANS);
    //printf("\n\f\7ProBoard Last Callers\n");



    printf("\n\f[?7h[255D[0;36m [1;37m [0;36m [1;37m [0;36m߲ [1;37m [0;36m [1;37m[30m(bd) [37m [0;36m߲ [1;37m [0;36m۲\n");
    printf("[1;37m[47m[40m     [47m[40m[47m[40m [47m[40m[47m[40m [47m[40m[47m[40m[47m[40m    [0;36m۲\n");
    printf("[1;37m          [0;36m۲\n");
    printf(" [1;37m          [0;36m\n");
    printf(" [1;37m                     [0;36m\n");
    printf("[?7h[255D[0;36m \7Name                              Date           Online          N#   Speed [0;36m\n");
    printf(" [1;30m [0;36m\n");

    LineCounter();
    LineCounter();
    LineCounter();

    for(i = 0 ; i<lc_num ; i++)
    {
      int onlinetime = 60 * (bl[i].timeOut[0] - bl[i].timeIn[0])
                          + (bl[i].timeOut[1] - bl[i].timeIn[1]);

      if(onlinetime < 0) onlinetime += 60*24;

      if(Stopped()) break;

      if(bl[i].alias[0] == '\0')
         strcpy(bl[i].alias,bl[i].name);

      

      printf("\3 %-31.31s\7 \5 %02d %3.3s \7 \1 %02d:%02d \7-\1 %02d:%02d \7(\2%3d'\7)  \1%3d \7 \3 %5ld [0;36m\n",
            (aliases ? bl[i].alias:bl[i].name),bl[i].date[0],months_short[bl[i].date[1]],
            bl[i].timeIn[0],bl[i].timeIn[1],bl[i].timeOut[0],bl[i].timeOut[1],onlinetime,bl[i].node,bl[i].baud);
      
      /*printf("\3 %-31.31s\7\5 %02d %3.3s \7\1 %02d:%02d \7-\1 %02d:%02d \7(\2%3d'\7) \1%3d \7\3 %5ld \7\n",
            (aliases ? bl[i].alias:bl[i].name),bl[i].date[0],months_short[bl[i].date[1]],
            bl[i].timeIn[0],bl[i].timeIn[1],bl[i].timeOut[0],bl[i].timeOut[1],onlinetime,bl[i].node,bl[i].baud);
      */

      if(!LineCounter()) break;
    }

    if(!Stopped())
      {
       if(LineCounter() && LineCounter() && LineCounter())
         {
          //printf("Ľ\n\n"
            //printf("[77C\n");
            printf("\n");
            printf("[1;30m ProBoard last callers v1.o art design by blakdeth. Programming by Jason Bock.\n\n"); 
            printf("\7 Press \3[Enter]\7 to continue.\t");
         }
      }

    free(bl);
}
