;-----------------------------------------------------------------------------------------------
;  NetFoss Spy Monitor
;  Version 1.16
;  Written by Mike Ehlert - PC Micro Systems, Inc. 
;  http://pcmicro.com/netfoss
;  Released as Public Domain, Licensed Open Source Code.
;  Read NetFoss.txt for license details.
; 
;  Compile in MASM32, using Qeditor > Project > "Console Assemble and Link"
;  or link using Polink.exe for optimum file size.
;------------------------------------------------------------------------------------------------

.586
.model flat,stdcall

option casemap:none
   include \masm32\include\windows.inc	; Windows
   include \masm32\include\user32.inc	; User
   include \masm32\include\kernel32.inc	; Kernel
   include \masm32\include\masm32.inc	; MASM32
   include \masm32\macros\macros.asm	; MASM32 Macros

   includelib \masm32\lib\user32.lib	; User
   includelib \masm32\lib\kernel32.lib	; Kernel
   includelib \masm32\lib\masm32.lib	; MASM32

   StartMonitor      proto
   MonitorMailThread proto
   SetTextColor      proto :BYTE
   SetConsoleSize    proto :DWORD, :DWORD
   
   ESC_CHAR  EQU 16 ; Control-P is used to escape out of the terminal-service mode into the menu mode

.data
align 4

   sb_len             dd 0
   bytes_written      dd 0
   ;fMtStrinG         db  "%lu",0			; Format string mode used by wsprintf
   ;ClassName         db  "ConsoleWindowClass",0
   AppName            db  'NetSpy',0
   NetSpyTitle        db  "NetSpy node "
   NodeTxt            db  "   ",0
   MenuText           db  "BBS node snooping tool - version 1.16", 0 ; 225,"3",0 
   CRLF               db  10,13,0		; Carrage Return, LineFeed string
   HitEscAgainTxt     db  10,10,10,10,10,"        Press [ESC] to exit NetSpy, or any other key to resume."
   
   mailslot_spy_cons  db '\\.\mailslot\netfoss\spy_console' ; mailslot provides NetSpy data from netcom
   slotnodetxt_cons   db "   ",0

   mailslot_spy_input db '\\.\mailslot\netfoss\spy_input' ; mailslot sends input data from NetSpy to netfoss.dll
   slotnodetxt_input  db '   ',0
   outkey             db 0,0 ; The output character, zero terminated

   ;WindowSize         dw 0,0,79,24  ;SMALL_RECT <0,0,79,24>

   Align 4
   hMailslot_CONS     dd 0 ; Handle of our MailSlot
   hMailslot_INPUT    dd 0 ; Handle of Input (must be zero until created)


   ;------------------------------------------------------------------------------------------------
   ;kernel32    db 'kernel32.dll',0    ; Used to access the undocumented "SetConsoleIcon" in Kernel32
   ;FuncName    db 'SetConsoleIcon',0
   ;IconFunc    db 0FFh,025h           ; define a jump entry
   ;            dd pIconFunc
   ;pIconFunc   dd 0
   ;SetConsoleIcon  EQU <pr1 PTR IconFunc>
   ;------------------------------------------------------------------------------------------------


   csbi CONSOLE_SCREEN_BUFFER_INFO <> ; Structure used for Console screen positioning

.data?
align 4

   hWnd           dd ?		; Handle of Console Window
   hIcon0         dd ?        ; Original CMD Icon
   hIcon          dd ?        ; Our Icon
   hStdIn         dd ?		; Handle of Standard Input
   hStdOut        dd ?		; Handle ot Standard Output - Needed for Color text 
   ThreadID       dd ?		; Thread ID is not used currently (write only)
   written        dd ?		; Bytes written to log file - Not currently used (write only)

   CommandLine     db 128 dup (?); Command Line


;----------------------------------------------------------------------------------------------
;  NetSpy MailSlot Packet Structure

   MailSlotData    dd ?     ; Cursor Location
   BufferSize      dd ?     ; -1 = "Die" command, else this is the x/y BufferSize of CHAR_INFO 
   WriteRegion     dd ?,?   ; Area of Screen to write to
   ConsoleSize     dd ?
   wcCHAR_INFO     db 16000 dup (?) ; CHAR_INFO Buffer
;----------------------------------------------------------------------------------------------

   OldConsoleSize  dd   25        ; number of vertical columns
   DebugModeTxt    db   2 dup (?) ; Ascii "0"=disable, "1"=enable - Display debug messages 
   MainViewTxt     db   3 dup (?) ; Ascii text of the ShowWindow mode for this window
   temp            dd          ?  ; Temporary dword used by FillConsoleOutputAttribute

.code

start:
	invoke ArgClC,1,ADDR CommandLine ; Check command line
	mov ax, word ptr CommandLine
	or ah,020h
	cmp ax,'n/' ; check for /n being passed as first Command Line parameter.
	je got_node
	cmp ax,'n-' ; check for -n being passed as first Command Line parameter.
	jne exitnow
got_node:

;-------------------------------------------------------------------------------------------------
; The icon file MyIcon.ico must be located in the project folder, along with a resource file named
; rsrc.rc which contains just the following line of text:
;     100 icon discardable "MyIcon.ico"
;
; Then compile the icon resource into an .RES and finally an .OBJ file using the following commands:
; \masm32\bin\rc /v rsrc.rc
; \masm32\bin\cvtres /machine:ix86 rsrc.res
;
; The resulting object file will automatically be linked when running "Console Assemble and Link".
;
;---------------------------------------------------
; Alternative Undocumented SetConsoleIcon function:
;
;    invoke  GetModuleHandle,ADDR kernel32
;    invoke  GetProcAddress,eax,ADDR FuncName
;    mov     pIconFunc,eax
;
;    invoke  GetModuleHandle,0
;    invoke  LoadIcon,eax,100
;    ;mov     hIcon,eax
;    invoke  SetConsoleIcon,eax; hIcon
;--------------------------------------------------
    xor     eax,eax
    invoke  GetModuleHandle,eax ; 0
    invoke  LoadIcon,eax,100                ; Load the Icon resource
    mov     hIcon,eax                       ; Save the handle
    invoke  GetConsoleWindow
    mov     hWnd,eax
    xor     ebx,ebx
    invoke  SendMessage,eax,7Fh,ebx,ebx	; Request original icon handle
    mov     hIcon0,eax
    invoke  SendMessage,hWnd,80h,0,hIcon     ; Set new icon

;    invoke  MessageBox,0,0,0,0
;    invoke  SendMessage,hWnd,80h,0,hIcon0	; Restore original icon
;    invoke  ExitProcess,0



;-------------------------------------------------------------------------------------------------

	mov eax, dword ptr CommandLine+2 ;Parse the Command Line for the node number
	mov esi,offset NodeTxt
	mov ecx,4
getnodelp:
	cmp al,"0"
	jl  gotnode2
	cmp al,"9"
	ja gotnode2
	mov [esi],al
	shr eax,8
	inc esi
	dec ecx
	jnz getnodelp
	xor eax,eax

gotnode2:
	mov byte ptr [esi],0 
	mov eax, dword ptr NodeTxt
	mov dword ptr slotnodetxt_cons,eax
	mov dword ptr slotnodetxt_input,eax

	invoke StartMonitor
    invoke  SendMessage,hWnd,80h,0,hIcon0	; Restore original icon

exitnow:
	invoke ExitProcess,0

;---------------------------------------------------------------------------------------------

; StartMonitor - Configure Console screen and connect to the Net2BBS MailSlot,
  StartMonitor proc near


;	invoke	AllocConsole ; Allocate Console is not needed?!

init_console:

	invoke GetConsoleWindow                                ; Define Console Window Handle
	mov    hWnd,eax 
	invoke GetStdHandle,STD_OUTPUT_HANDLE                  ; Define Output Handle
	mov    hStdOut,eax
	invoke GetStdHandle,STD_INPUT_HANDLE
	mov    hStdIn,eax
	Invoke SetConsoleTitle, ADDR NetSpyTitle              ; Set Console Window Title
	invoke SetConsoleCtrlHandler,NULL,TRUE ; Prevent Ctrl-C from killing us.
	invoke FillConsoleOutputCharacter,hStdOut,32,ecx,NULL,ADDR temp ; 32=space
	;movzx edx,ATTRIBUTE
	xor    edx,edx
	invoke FillConsoleOutputAttribute,hStdOut,edx,ecx,NULL,ADDR temp ; null=cord
	xor edx,edx
	invoke locate,edx,edx  ; home cursor
	invoke SetTextColor,15 ; white
	;cls

	invoke SetConsoleSize, 80,25
	invoke GetConsoleScreenBufferInfo,hStdOut,ADDR csbi ; Get Console Screen Buffer Info
	movzx  ebx,csbi.dwSize.x ; columns
	movzx  eax,csbi.dwSize.y ; rows
	shl    ebx,6  ; Multiply column count by 64 to create a blue screen
	invoke FillConsoleOutputAttribute,hStdOut,31,ebx,0,ADDR temp    ; Create Blue background color
	invoke SetTextColor,10+(1*16) ;Green text on blue background
	print " NetSpyķ " ; Was -=NetSpy=-
	invoke SetTextColor,15+(1*16) ; white text on blue background
	invoke StdOut,ADDR MenuText
	xor ebx,ebx
 	invoke locate,6,ebx
	print "S"               ; make the "S" in NetSpy white
	invoke SetTextColor,7+(1*16) ; blue text on blue background
	invoke locate,74,ebx
	print chr$(250),"pcm",250,13,10,10 ; sign it .pcm.

;--------------------------------------------------------------------------
; Create spy Read Mailslot (CONSOLE)
;--------------------------------------------------------------------------

; maxsize of the mailslot should be either 8192, or 16384

	invoke CreateMailslot,
	ADDR mailslot_spy_cons,        ; Filename
	16384, ;sizeof CHAR_INFO,      ; Maximum size
	MAILSLOT_WAIT_FOREVER,         ; Read timeout in milliseconds
	NULL                           ; pointer to security struct	

	.if   eax == INVALID_HANDLE_VALUE ; was it created?

		print "NetSpy is already running on node "
		invoke StdOut, addr NodeTxt
		jmp   error_exit
	.endif 

	mov   hMailslot_CONS,eax
	print "NetSpy is waiting for the Node Console to connect.",13,10,"Press any key to abort.",13,10
	;invoke Sleep,1000
	xor eax,eax
	invoke CreateThread,eax,eax,offset MonitorMailThread,eax,eax,addr ThreadID ;hAcceptThread2
	invoke CloseHandle,eax


readkey:
	Call   AnyKey      ; Get a keypress
	and ecx, 00000011b ; Check for ALT-key
	jz noalt
	mov al,0 ; if it is an ALT-key, then AL=0
noalt:
	cmp hMailslot_INPUT,0 ; If a mailslot is created, then send the key... otherwise try to create it.
	jne MailSlotAlive
	push eax

	invoke CreateFile,ADDR mailslot_spy_input,\
			  GENERIC_WRITE,\
			  FILE_SHARE_READ,\
			  0,\
			  OPEN_EXISTING,\
			  FILE_ATTRIBUTE_NORMAL,\
			  0

	cmp eax,INVALID_HANDLE_VALUE
	jne  spycreated

	invoke CloseHandle,hMailslot_CONS ; first close the Read MailSlot
	cls
	print "NetSpy failed to connect to NetFoss on node "
	invoke StdOut, ADDR NodeTxt
	print ".",13,10,10
	POP EAX
	call StopMonitor

spycreated:
	mov hMailslot_INPUT, eax
	pop EAX

MailSlotAlive:

	cmp al,ESC_CHAR ; ctrl-P is the Escape from the redirector key
	je gotesc

	mov word ptr outkey,ax

	invoke WriteFile, hMailslot_INPUT,\   ; handle to write to
		OFFSET outkey,\                ; buffer address
		2,\                            ; max bytes to write is 2
		OFFSET bytes_written,\         ; bytes actually written
		0                              ; Flags

	jmp readkey		; loop

;------
gotesc:
	; The ESC code was pressed - Display a separate console buffer with a Red background to confirm exit

	invoke	SetTextColor,15+(4*16)   ; Create a new Console screen with White Text on Red Background
	xor ecx,ecx
	invoke	CreateConsoleScreenBuffer,GENERIC_READ OR GENERIC_WRITE,ECX,ECX,CONSOLE_TEXTMODE_BUFFER,ECX
	mov	ebx,eax 	    ; Save Handle of Screenbuffer in ebx
	invoke	WriteConsole,ebx,ADDR HitEscAgainTxt, sizeof HitEscAgainTxt, ADDR written, NULL ;Print to it

	invoke	SetConsoleActiveScreenBuffer, ebx ; Activate it
	invoke	SetTextColor,10 + 0 ; Bright Green  ; Restore color of future output
	Call AnyKey			; wait for a second keypress
	push eax
	invoke CloseHandle,ebx	; close the red console buffer first (1.02 fix for Win 7)
	pop eax
	cmp al,01Bh		; ESC key?
	je done		; If so, cleanup and exit
	or al,020h		; force lower-case result
readkeyxSt:
    	jmp readkey    ; Return to main key menu

error_exit:
	invoke SetTextColor,15 + 0	; Color= White
	print chr$(10), 13, "*** Press Enter to Exit ***"
jel:
	call AnyKey
	cmp al,13  ; Got Enter?
	jne jel    ; jello till we do
      ;invoke StdOut,ADDR CRLF
done:
	call StopMonitor
ret
StartMonitor endp


StopMonitor proc near

; move cursor to last screen position
	invoke SetTextColor,15+(1*16) ; white text on blue background
	invoke GetConsoleScreenBufferInfo,hStdOut,ADDR csbi
	movzx  eax,csbi.dwSize.y ; rows
	sub eax,3
 	invoke locate,0,eax
	print "[NetSpy Terminated]",13,10
	invoke SetTextColor,15 + 0	; Set White text on black background
	invoke  SendMessage,hWnd,80h,0,hIcon0	; Restore original icon
	invoke ExitProcess,0

StopMonitor endp

    
;-------------------------------------------------------------------------------------------------------
;-------------------------------------------------------------------------------------------------------
MonitorMailThread proc Near

; This thread receives data from NetCom containing changes to the console screen, and updates the NetSpy console.


;------------------------------------------------------------------------------------------------
;  NetSpy MailSlot Packet Structure
;
;   MailSlotData    dd ?     ; Cursor Location contained in lower 16, screen size in upper 16
;   BufferSize      dd ?     ; -1 = "Die" command, else this is the x/y BufferSize of wcCHAR_INFO 
;   WriteRegion     dd ?,?   ; Area of Screen to write to
;   ConsoleSize     dd ?
;   wcCHAR_INFO     db 16000 dup (?) ; CHAR_INFO Buffer
;------------------------------------------------------------------------------------------------



	invoke ReadFile, hMailslot_CONS,   ; Read data from mailslot
		      OFFSET MailSlotData, ; MailSlot buffer address
		      16020,               ; Max amount to read
		      OFFSET sb_len,       ; number of bytes actually read
		      NULL                 ; overlapped option

	test eax,eax       ; Successful read?
	jz die             ; Exit if not

	mov edx, BufferSize         ; get the x-y size of the window to write to
	cmp edx, -1                 ; Check for "die" command
	je  die

	; 2017 changed ConsoleSize detection
	mov eax,ConsoleSize
	cmp eax,OldConsoleSize
	jne resetsize

setcursor:

; CURSOR POSITIONING provided by NetCom

	mov eax, MailSlotData  ; slotheader contains the x-y cursor position
	movsx ebx,ax           ; place lower 16 bits into ebx
	shr eax,16             ; place higher 16 bits int eax
	invoke locate,ebx,eax  ; position the cursor to the correct location

	mov eax, BufferSize    ; Get the x-y sizes of the rectange to write to
	test eax,eax           ; Is it zero?
	jz MonitorMailThread   ; If the rectangle size is zero, then only a cursor update was requested

	xor ebx,ebx            ; Always set BufferCord to the top left postiion. This is not the WriteRegion!

; eax         = size (in both x and y positions) to write to
; ebx         = first physical position of our console  (this is always the top left, even if writing elsewhere)
; WriteRegion = rectangle upper-left and lower-right coordinates.
 
; Now write the updated remote screen data to this console screen:

	invoke   WriteConsoleOutput, hStdOut, ; Standard Output handle
                        offset wcCHAR_INFO, ; CHAR_INFO   (Buffer containing screen data)
                        eax,                ; BufferSize  (H)-Cols (L)-Lines
                        ebx,                ; BufferCoord (screen position of first buffer cell)
                        offset WriteRegion  ; WriteRegion (WindowSize x-y rectangle)

	test eax,eax
	jnz  MonitorMailThread ; check added 2016

die:
	jmp StopMonitor ; invoke ExitProcess,0 ; Die if told to


resetsize:
	mov OldConsoleSize, eax
	invoke SetConsoleSize,80,eax   ; Adjust the lenght of the Console Window to match the BBS
	jmp setcursor

MonitorMailThread endp

;------------------------------------------------------------------------------------------------
; Convert Double-Word to ASCII string
;
; dwValue is passed as a value, direct, indirect or in register
; lpBuffer is the ADDRESS of the receiving buffer
; Returns with eax= number of characters written to buffer (zero=error).
;
; EXAMPLE:
; invoke dw2a,edx,ADDR buffer


;dw2a proc near dwValue:DWORD, lpBuffer:DWORD
;
;	invoke wsprintfA,lpBuffer,ADDR fMtStrinG,dwValue
;	ret
;dw2a endp


;------------------------------------------------------------------------------------------------
SetTextColor proc near foreback16:BYTE ;was fore:DWORD,back:DWORD

; 
; This proc sets the foreground and background attributes for
; the characters written to the console screen buffer.
;
; The color values are normal 4-bit IRGB character mode
; attributes where:
;   bit3 = intensity
;   bit2 = red
;   bit1 = green
;   bit0 = blue
; 
; The attribute is stored in a single byte (contained in a dword).
	;mov   eax,back
	;shl   eax,4
	;or	  eax,fore
	movzx eax,foreback16
	;mov ATTRIBUTE,al
	invoke SetConsoleTextAttribute,hStdOut,eax ; was ,eax
	ret
SetTextColor endp


;----------------------------------------------------------------------------
SetConsoleSize PROC cols, rows

	local	bz:COORD
	local	rc:SMALL_RECT
	;local	csbi:CONSOLE_SCREEN_BUFFER_INFO

	invoke GetConsoleScreenBufferInfo, hStdOut, addr csbi
	.if EAX
		mov	rc.Left,0
		mov	rc.Top,0
		mov	eax,cols
		mov	bz.x,ax
		dec	eax
		mov	rc.Right,ax
		mov	edx,rows
		mov	bz.y,dx
		dec	edx
		mov	rc.Bottom,dx

		invoke SetConsoleWindowInfo, hStdOut, 1, addr rc
		invoke SetConsoleScreenBufferSize, hStdOut, DWORD PTR bz
		invoke SetConsoleWindowInfo, hStdOut, 1, addr rc  ; set a second time to avoid Console Bug

		;invoke GetConsoleScreenBufferInfo,hStdOut, addr csbi
		;.if EAX
		;	mov	eax,csbi.dwSize
		;	movzx	edx,ax
		;	mov	_scrcol,edx
		;	shr	eax,16
		;	dec	eax
		;	mov	_scrrow,eax
		;.endif
	.endif
	ret
SetConsoleSize ENDP
;----------------------------------------------------------------------------



;*************************************************************************************************************

AnyKey  PROC

;Wait for Any Console Key Press - contributed by DednDave
;
; This function returns when any console key is pressed (bKeyDown = 1).
; A possible drawback is that all input pevent records are removed from
; the console input queue until a key is pressed. In many cases, this is
; not an issue. The virtual key code, virtual scan code, TCHAR character,
; and control key state values are returned in registers.

;Call With: Nothing
;
;  Returns: EAX = TCHAR character (high word of EAX = 0)
;           ECX = control key state flags
;               Bit   Name                Meaning
;                0    RIGHT_ALT_PRESSED   Right ALT key is pressed
;                1    LEFT_ALT_PRESSED    Left ALT key is pressed
;                2    RIGHT_CTRL_PRESSED  Right CTRL key is pressed
;                3    LEFT_CTRL_PRESSED   Left CTRL key is pressed
;                4    SHIFT_PRESSED       SHIFT key is pressed
;                5    NUMLOCK_ON          NUM LOCK light is on
;                6    SCROLLLOCK_ON       SCROLL LOCK light is on
;                7    CAPSLOCK_ON         CAPS LOCK light is on
;                8    ENHANCED_KEY        Key is enhanced
;           EDX:
;           low word (DX) = virtual key code
;               high word = virtual scan code
;
;           all other registers are preserved

        push    edx
        push    ebx
        push    ebp
        sub     esp,(sizeof INPUT_RECORD+3) and -4
        mov     ebp,esp
        ;INVOKE  GetStdHandle,STD_INPUT_HANDLE
mov ebx, hStdIn
        ;xchg    eax,ebx
        push    ecx

AnyKy0:
        invoke  Sleep,10
        invoke  ReadConsoleInput,ebx,ebp,1,esp
        movzx   edx,word ptr [ebp].INPUT_RECORD.EventType
        cmp     edx,KEY_EVENT                             ;KEY_EVENT EQU 1
        jnz     AnyKy0

        cmp     edx,[ebp].INPUT_RECORD.KeyEvent.bKeyDown
        jnz     AnyKy0

        pop     ecx
        movzx   eax,word ptr [ebp].INPUT_RECORD.KeyEvent.UnicodeChar
        mov     edx,dword ptr [ebp].INPUT_RECORD.KeyEvent.wVirtualKeyCode
        shr     edx,16
        mov     ah,dl
        mov     ecx,[ebp].INPUT_RECORD.KeyEvent.dwControlKeyState
        add     esp,(sizeof INPUT_RECORD+3) and -4
        pop     ebp
        pop     ebx
        pop     edx

;--- mikes patch---
	cmp eax,03800h ; check for just alt key - filter this out
	JE AnyKey
;------------------
        ret

AnyKey  ENDP

end start
 