program SyncFos;
(*
**
** Interface to Synchronet BBS FOSSIL driver, for EleBBS
**
** Created : 21-Oct-2001
** Last update : 18-May-2002
** Version: 2.02
**
** (c)2001-2002 by Maarten Bekers - syncfos@elebbs.com.
** Placed in the public domain.
**
** Interfaces to code written which is (c) Rob Swindell.
**
**
*)
uses Windows,
      SysUtils,
       ComBase,                         { EleCOM }
        W32Sngl,                        { EleCOM }
         Telnet;                        { EleCOM }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

const
  DoorDir         : String  = '.\';                   { directory of the door }
  Door32Path      : String  = '';                   { path+name to door32.sys }
  NodeNr          : Longint = 1;                         { current nodenumber }
  TelnetServ      : Boolean = FALSE;           { default to not telnet server }
  InhHandle       : THandle = INVALID_HANDLE_VALUE;   { handle to comm object }
  Version         = '2.02';
  LoopsBeforeYield: Longint = 10;     { Number of loops before dosxtrn yields }
  RedirectToStdIo : Boolean = FALSE;                      { Redirect to STDIO }

var
  ComObj: pCommObj;

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

procedure LogDebug(LogStr: String);
var f: text;
begin
(**
  Assign(f, 'C:\bbs\ele\elebbs.log');
  {$i-} Append(f); {$i+}
  if IoResult > 0 then
    ReWrite(f);

  WriteLn(f, LogStr);

  Close(f);
**)
end; { proc. DoLog }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

function ForceBack (Path: String): String;
begin
  if NOT (Path[length(path)] in ['\', '/', ':']) and (Path<>'') then
    Path := Path + '\';

  ForceBack:=Path;
end; { func. ForceBack }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

function  NoExtension(S: String): String;
var Dir, Name, Ext: String;
begin
  Name := ForceBack(ExtractFilePath(S)) + ExtractFileName(S);

  if Length(ExtractFileExt(Name)) > 0 then
    Delete(Name, (Length(Name) - Length(ExtractFileExt(Name))) + 1, 255);

  NoExtension := Name;
end; { func. NoExtension }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

procedure Int_ComReadProc(var TempPtr: Pointer);
begin
  Case TelnetServ of
    FALSE : PWin32Obj(ComObj)^.Com_DataProc(TempPtr);
    TRUE  : PTelnetObj(ComObj)^.Com_ReadProc(TempPtr);
  end; { case }
end; { proc. Int_ComReadProc }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

procedure Int_ComWriteProc(var TempPtr: Pointer);
begin
  Case TelnetServ of
    FALSE : PWin32Obj(ComObj)^.Com_DataProc(TempPtr);
    TRUE  : PTelnetObj(ComObj)^.Com_WriteProc(TempPtr);
  end; { case }
end; { proc. Int_ComWriteProc }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

procedure ReadDoor32(Door32Path: String);
var File_F   : Text;
    Counter  : Longint;
    TmpArray : Array[1..12] of String;
begin
  {-- open the file --------------------------------------------------------}
  Assign(File_F, ForceBack(Door32Path) + 'door32.sys');

  {-- try to open the file -------------------------------------------------}
  {$i-} Reset(File_F); {$i+}
  if IoResult > 0 then
    begin
      WriteLn('Current path: ', GetCurrentDir);
      WriteLn('Unable to open ', ForceBack(Door32Path)+'door32.sys - aborting');
      EXIT;
    end; { if }

  {-- process the file -----------------------------------------------------}
  for Counter := 01 to 12 do
    ReadLn(File_F, TmpArray[Counter]);

  {-- now process the info we've gotten from it ----------------------------}
  if StrToInt(TmpArray[1]) > 0 then
    begin
      Case StrToInt(TmpArray[1]) of
        01 : { serial } TelnetServ := FALSE;
        02 : { telnet } TelnetServ := TRUE;
      end; { case }

      InhHandle := StrToInt(TmpArray[2]);
      NodeNr := StrToInt(TmpArray[11]);
    end; { if }

  {-- dispose of the file --------------------------------------------------}
  Close(File_F);
end; { proc. ReadDoor32 }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

procedure Log(Category: Char; Msg: String);
begin
  WriteLn(Category, #32, Msg);
end; { proc. Log }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

function JustPath(S: String): String;                   { Returns just path }
begin
  JustPath := ExtractFilepath(S);
end; { func. JustPath }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

procedure ExecuteDosFosProgram(CmdLine: String; LoopsBeforeYield: Longint);
{ We only support NT, Win9x should not be used as a server platform }
const
  XTRN_IO_BUF_LEN = 5000;
  SBBSEXEC_MODE_FOSSIL = 0;                          { Only mode we support }

var Temp_F       : Text;
    TempFile     : String;
    CommandParams: String;
    TmpStr       : String;
    TmpBuf       : Array[0..XTRN_IO_BUF_LEN - 1] of Char;
    Hangup_Event : THandle;                          { Event to hangup door }
    ReadSlot     : THandle;                             { Mailslot for data }
    WriteSlot    : THandle;
    StartupInfo  : TStartupInfo;
    ProcessInfo  : TProcessInformation;
    TermStatus   : Longint;
    InUsed       : Longint;               { used by EleCOMs GetBufferStatus }
    TmpLong      : Longint;               { used by EleCOMs GetBufferStatus }
    Counter      : Longint;
    DosXtrnString: String;
    BufPtr       : Longint;
    SlotCounter  : Longint;
begin
  {-- Initialize DOS xtrn string (Syncs Fossil startkicker) ----------------}
  DosXtrnString := JustPath(ParamStr(0)) + 'dosxtrn.exe';

  {-- Initialise variables -------------------------------------------------}
  ReadSlot := INVALID_HANDLE_VALUE;
  WriteSlot := INVALID_HANDLE_VALUE;
  Hangup_Event := INVALID_HANDLE_VALUE;

  {-- Create a temporary file ----------------------------------------------}
  TempFile := ForceBack(JustPath(ParamStr(2))) + 'ebsyn'+ IntToStr(Nodenr) + '.env';

  Assign(Temp_F, TempFile);
  FileMode := $42; { readwrite + denynone }
  Rewrite(Temp_F);
  WriteLn(Temp_F, CmdLine);
  Close(Temp_F);

  {-- Create an hangup event, we set this if we drop carrier ---------------}
  TmpStr := 'sbbsexec_hungup' + IntToStr(NodeNr) + #0;
  HangUp_Event := CreateEvent(nil,                    { Security attributes }
                              true,           { Flag for manual-reset event }
                              false,               { flag for initial state }
                              @TmpStr[1]);
  if Hangup_Event = INVALID_HANDLE_VALUE then
    begin
      { fail }
      Log('!', 'Unable to create hangup event');
      EXIT;
    end; { if }

  {-- Create a mailslot for reading ----------------------------------------}
  TmpStr := '\\.\mailslot\sbbsexec\rd' + IntToStr(NodeNr) + #0;
  ReadSlot := CreateMailSlot(@TmpStr[1],
                             SizeOf(TmpBuf),         { Maximum message size }
                             0,                              { read timeout }
                             nil);          { pointer to security structure }
  if ReadSlot = INVALID_HANDLE_VALUE then
    begin
      { fail }
      Log('!', 'Unable to create read mailslot');
      CloseHandle(Hangup_Event);
      EXIT;
    end; { if }


  {-- We dont create the write slot until it is signalled that theres data -}
  {-- for us by the FOSSIL driver ------------------------------------------}

  {-- Lets build the actual commandline we are going to pass to dosxtrn ----}
  CommandParams := DosXtrnString + #32 +
                   TempFile + #32 +
                   'NT ' + IntToStr(NodeNR) + #32 +
                   IntToStr(SBBSEXEC_MODE_FOSSIL) + #32 +
                   IntToStr(LoopsBeforeYield) + #0;

  {-- initialize the startup info ------------------------------------------}
  FillChar(StartupInfo, SizeOf(tStartUpInfo), 0);
  StartupInfo.CB := SizeOf(tStartUpInfo);

  {-- Now actually execute the program -------------------------------------}
  if NOT CreateProcess(nil,                     { pointer to name of module }
                       @CommandParams[1],                  { actual program }
                       nil,                  { ptr to process security attr }
                       nil,                   { ptr to thread security attr }
                       true,                      { handle inheritance flag }
                       CREATE_NEW_CONSOLE AND              { creation flags }
                         CREATE_SEPARATE_WOW_VDM,
                       nil,              { Pointer to new environment block }
                       nil,             { Pointer to current directory name }
                       StartupInfo,                { pointer to startupinfo }
                       ProcessInfo) then
    begin
      { fail }
      CloseHandle(Hangup_Event);
      CloseHandle(ReadSlot);

      Log('!', 'Error while executing: ' + CommandParams);
      EXIT;
    end; { if }

  {-- Loop till something happens ------------------------------------------}
  Counter := 0;
  while (true) do
    begin
      {-- Increase counter -------------------------------------------------}
      Inc(Counter);

      {-- Check carrier ----------------------------------------------------}
      if NOT ComObj^.Com_Carrier then
        begin
          SetEvent(Hangup_Event);
          Sleep(5000);
          { we should wait a few seconds, and then terminate the process }
        end; { if }

      {-- Check if the process is still running ----------------------------}
      if GetExitCodeProcess(ProcessInfo.hProcess,
                            TermStatus) then
        begin
          {-- If the process terminated, we terminate as well --------------}
          if TermStatus <> STILL_ACTIVE then
            BREAK;

          {-- now check if theres data available to write to it ------------}
          if ComObj^.Com_CharAvail then
            begin
              {-- reset the counter ----------------------------------------}
              Counter := 0;

{!!!} LogDebug('Char available to send to the door');

              {-- get the inbound buffer -----------------------------------}
              ComObj^.Com_GetBufferStatus(TmpLong, TmpLong,
                                          Inused, TmpLong);

              {-- make sure we dont request more than we can handle --------}
              if (InUsed + 9) > XTRN_IO_BUF_LEN then
                InUsed := XTRN_IO_BUF_LEN - 10;

              {-- retrieve the data ----------------------------------------}
              ComObj^.Com_ReadBlock(TmpBuf[0], InUsed, TmpLong);

              {-- now check if the write handle is valid, if not create it -}
              if WriteSlot = INVALID_HANDLE_VALUE then
                begin
                  TmpStr := '\\.\mailslot\sbbsexec\wr' +
                              IntToStr(NodeNr) + #0;

                  WriteSlot := CreateFile(@TmpStr[1],
                                          GENERIC_WRITE,        { Filemode }
                                          FILE_SHARE_READ,  { sharing mode }
                                          nil,
                                          OPEN_EXISTING,
                                          FILE_ATTRIBUTE_NORMAL,
                                          0);
                end; { if }

              {-- now send the data ----------------------------------------}
              {-- if the above call failed, this data get lost -------------}
              if WriteSlot <> INVALID_HANDLE_VALUE then
                begin
                  WriteFile(WriteSlot,                 { handle to write to }
                            TmpBuf,                                { buffer }
                            TmpLong,                       { bytes to write }
                            InUsed,            { actual nr of bytes written }
                            nil);                              { overlapped }
                end; { if }
            end; { if }

          {-- Check the number of messages ---------------------------------}
          BufPtr := 0;
          TmpLong := 0;

          if GetMailSlotInfo(ReadSlot,                             { handle }
                             nil,                        { max message size }
                             InUsed,                 { size of next message }
                             @TmpLong,            { Number of messages left }
                             nil) then                       { read timeout }
            if TmpLong > 0 then
              begin
{!!!} LogDebug('Number of slot-msgs available: '+ IntToStr(TmpLong));

                {-- if there are more than 200 messages, get the first 200 -}
                if TmpLong > 1500 then
                  TmpLong := 1500;

                {-- Reset usage count --------------------------------------}
                InUsed := 0;

                {-- now check if theres data to read from it ---------------}
                for SlotCounter := 01 to TmpLong do
                 if ReadFile(ReadSlot,                             { handle }
                             TmpBuf[BufPtr],                       { buffer }
                             XTRN_IO_BUF_LEN - BufPtr, { mx data we can get }
                             InUsed,      { number of bytes we actually got }
                             nil) then                         { overlapped }
                   begin
                     Inc(BufPtr, InUsed);

                     {-- make sure buffer wont overflow --------------------}
                     if BufPtr >= (XTRN_IO_BUF_LEN - 10) then
                       BREAK;
                   end; { if }
              end { if }
                else Sleep(1);


            if Bufptr > 0 then
              begin
{!!!} LogDebug('Number of bytes to send to the user= ' + IntToStr(BufPtr));

                {-- reset the counter --------------------------------------}
                Counter := 0;

                ComObj^.Com_SendBlock(TmpBuf[0],                     { data }
                                      BufPtr,              { bytes to write }
                                      InUsed);           { actually written }

                {-- we try to correct some stupid stuff if this door uses --}
                {-- char per char ------------------------------------------}
                if TmpLong > 40 then
                  Sleep(150);
              end; { if }
        end; { if }

        {-- delay if nothing happens ---------------------------------------}
        if Counter > 0 then Sleep(100);
    end; { while }

  {-- delete some tempfiles ------------------------------------------------}
  Assign(Temp_F, TempFile);
  Erase(Temp_F);

  {-- and clean up ---------------------------------------------------------}
  CloseHandle(ProcessInfo.hProcess);
  CloseHandle(ProcessInfo.hThread);

  CloseHandle(Hangup_Event);
  CloseHandle(ReadSlot);
  if WriteSlot <> INVALID_HANDLE_VALUE then
    CloseHandle(WriteSlot);
end; { proc. ExecuteDosFosProgram }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

procedure ReadCfgFile(SyncCfgFile: String);
var File_F   : Text;
    Counter  : Longint;
    TmpStr   : String;
    KeyW     : String;
    Data     : String;
begin
  {-- open the file --------------------------------------------------------}
  Assign(File_F, SyncCfgFile);

  {-- try to open the file -------------------------------------------------}
  {$i-} Reset(File_F); {$i+}
  if IoResult > 0 then
    begin
      {-- apparently no configuration, use default ------------------------}
      WriteLn('Unable to open ', SyncCfgFile, ' - using defaults');
      EXIT;
    end; { if }

  {-- process the file -----------------------------------------------------}
  while NOT EOF(File_F) do
    begin
      {-- read the next line -----------------------------------------------}
      ReadLn(File_F, TmpStr);

      {-- and get the data we want from it ---------------------------------}
      if TmpStr[1] <> ';' then
        begin
          {-- extract the keyword ------------------------------------------}
          KeyW := UpperCase(Copy(TmpStr, 1, Pos('=', TmpStr) - 1));
          Data := Copy(TmpStr, Pos('=', TmpStr) + 1, 255);

          {-- check before yields ------------------------------------------}
          if KeyW = 'YIELDS' then
            begin
              LoopsBeforeYield := StrToInt(Data);
              if LoopsBeforeYield = 0 then
                LoopsBeforeYield := 1;
            end; { if }

          {-- check for Redirect -------------------------------------------}
          if KeyW = 'REDIRECTIO' then
            begin
              if Data = 'YES' then
                RedirectToStdIO := TRUE;
            end; { if }
        end; { if }
    end; { while }

  {-- dispose of the file --------------------------------------------------}
  Close(File_F);
end; { proc. ReadCfgFile }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

var Counter: Longint;
begin
  {-- We read parameters from door32.sys -----------------------------------}
  {-- first path should be to door32.sys, the rest is program --------------}
  Door32Path := ForceBack(ParamStr(1));
  DoorDir := '';
  for Counter := 02 to ParamCount do
    DoorDir := DoorDir + #32 + ParamStr(Counter);
  DoorDir := TrimLeft(DoorDir);

  {-- Show Rob Swindell copyright notice -----------------------------------}
  WriteLn;
  WriteLn('SyncFos v', version);
  WriteLn('FOSSIL code written by Rob Swindell (www.synchro.net).');
  WriteLn('This door is (c)2001-2002 by Maarten Bekers (www.elebbs.com)');
  WriteLn;
  if RedirectToStdIO then
    WriteLn('Redirecting FOSSIL input/output to standard I/O');

  {-- we read a configuration file here ------------------------------------}
  ReadCfgFile(NoExtension(ParamStr(2)) + '.foscfg');

  {-- lets read door32.sys -------------------------------------------------}
  ReadDoor32(Door32Path);

  {-- show which program well run ------------------------------------------}
  WriteLn('Running: "', DoorDir, '"');

  {-- first initialize our comm-engine -------------------------------------}
  if NOT RedirectToStdIO then
    begin
      if TelnetServ then ComObj := New(PTelnetObj, Init)
        else ComObj := New(PWin32Obj, Init);

      {-- setup data handlers ----------------------------------------------}
      ComObj^.Com_SetDataProc(@Int_ComReadProc, @Int_ComWriteProc);
    end
      else begin
             // !! ComObj := New(PTtyObj, Init);
             // !! ComObj^.BlockAll := FALSE;
           end; { else }

  {-- open the file --------------------------------------------------------}
  ComObj^.DontClose := true;  { We use an inherited handle, never close it! }
  ComObj^.Com_OpenQuick(InhHandle);

  {-- first initialize our comm-engine -------------------------------------}
  ExecuteDosFosProgram(DoorDir, LoopsBeforeYield);

  {-- close down the engine ------------------------------------------------}
  Dispose(ComObj, Done);
end.
