;
; ==========================================================================
;               Patch script for NetMgr/2 v1.00 (OS/2 Version)
;                      Version 1.05 - 28. Aug 1999
;
;    Created by Wilfried Brinkmann, Fido 2:24/600, e-mail tsc@cityweb.de
; ==========================================================================
;
; NOTE: This patch script will modify netmgrp.exe and add a lot of new
;       routines to handle the necessary modifications.
;       There is no additional program required to run the patched
;       netmgrp.exe!
;
;       If you wish to understand this patch, you will want to see what
;       the added service routines do. The source code is added as comment.

SIZE 145941                ; filesize netmgrp.exe
;
COPY UNPATCH\NETMGRP.EXE   ; make a backup copy in <NetMgrPath>\unpatch
;
; ---------------------------------------------------------------------------
; Fix for the header text in bounced messages (and other places)
;
VER 0508A FF7114+          ; push     dword ptr [ecx+14]
          C1E002           ; shl      eax,02
          ;
CHA $     E8D1430000+      ; call     +000043D1 (00009460)
          90               ; nop
;
; --------------------------------------------------------------------------
; Fix for writing PKT FTSC date field
;
VER 0A429 C1E002+          ; shl      eax,02
          FF7214           ; push     dword ptr [edx+14]
          ;
CHA $     E83BF0FFFF+      ; call     -00000FC5 (00009469)
          90               ; nop
;
; ---------------------------------------------------------------------------
; Fix interpretation of a two digit year number when reading Squish and
; *.MSG style message bases.
;
VER 101D4 FF7014+          ; push     dword ptr [eax+14]
          89C1             ; mov      ecx,eax
          ;
CHA $     E89E92FFFF       ; call     -00006D62 (00009477)
;
; --------------------------------------------------------------------------
; Fix for writing Squish FTSC date field
;
VER 1339A C1E202+          ; shl      edx,02
          FF7014           ; push     dword ptr [eax+14]
          ;
CHA $     E8D360FFFF+      ; call     -00009F2D (00009472)
          90               ; nop
;
; --------------------------------------------------------------------------
; Fix for writing *.MSG FTSC date field
;
VER 15F1E C1E202+          ; shl      edx,02
          FF7014           ; push     dword ptr [eax+14]
          ;
CHA $     E84F35FFFF+      ; call     -0000CAB1 (00009472)
          90               ; nop
;
;
; The routine that has been added for the five patches from above.
; This routine is called when writing a FTSC date stamp.
; It prevents the 2 digit date field from spilling (without the modulo 100
; operation, "100" would be written there in the year 2000 instead of 00).
;
VER 09460 000000000000000000000000000000+
          000000000000000000000000000000+
          000000000000000000000000000000+
          00000000
          ;
CHA $     C1E002+          ; shl      eax,02
          50+              ; push     eax
          8B4114+          ; mov      eax,[ecx+14]
          EB14+            ; jmp      +14 (0000947D)
          ;
@09469:   C1E002+          ; shl      eax,02
          50+              ; push     eax
          8B4214+          ; mov      eax,[edx+14]
          EB0B+            ; jmp      +0B (0000947D)
          ;
@09472:   C1E202+          ; shl      edx,02
          EB02+            ; jmp      +02 (00009479)
          ;
@09477:   89C1+            ; mov      ecx,eax
          ;
@09479:   50+              ; push     eax
          8B4014+          ; mov      eax,[eax+14]
          ;
@0947D:   51+              ; push     ecx
          52+              ; push     edx
          31C9+            ; xor      ecx,ecx
          B164+            ; mov      cl,64
          99+              ; cwd
          F7F9+            ; idiv     ecx
          92+              ; xchg     edx,eax
          5A+              ; pop      edx
          59+              ; pop      ecx
          87442404+        ; xchg     [esp+04],eax
          870424+          ; xchg     [esp],eax
          C3               ; ret
;
; --------------------------------------------------------------------------
; Fix incorrect interpretation of a hudson time stamp which led to
; totally wrong display of a hudson message date after 2000.
;
VER 0FCFA 0FB745F8+        ; movzx    eax,[ebp-08]
          8945E0           ; mov      [ebp-20],eax
          ;
CHA $     E8C1EAFFFF+      ; call     -0000153F (0000E7C0)
          90+              ; nop
          90               ; nop
;
;
; The routine that has been added for the patch from above.
; This routine is called when reading a message from the Hudson HMB.
; The date that is in [ebp-08] is a two digit year number, but we want
; to have a "tm.tm-year" style year number in eax. Therefore, we check
; if the value is smaller than 80, and if so, we assume that it is in
; the 21st century and therefore add 100 to it. This makes HMB save
; until 31-12-2079.
;
VER 0E7C0 00000000000000000000000000000000
          ;
CHA $     0FB745F8+        ; movzx    eax,[ebp-08]
          83F850+          ; cmp      eax,50
          7703+            ; jnbe     +03 (0000E7CC)
          83C064+          ; add      eax,64
@0E7CC:   8945E0+          ; mov      [ebp-20],eax
          C3               ; ret
;
; ---------------------------------------------------------------------------
; Fix interpretation of a two digit year number when reading Squish and
; *.MSG style message bases.
;
VER 1C305 83E850+          ; sub      eax,50
          30E4             ; xor      ah,ah
          ;
CHA $     E8C624FFFF       ; call     -0000DB3A (0000E7D0)
;
;
; The routine that has been added for the patch from above.
; Convert a two digit year number that has is stored in eax into a DOS time
; compliant year number (which gives the number of years that have been passed
; since 1980). The method we use is save until 2080. Prevent wrong binary t
; imestamps (TimEd derives them from the two digit FTSC date) in Squish and
; MSG areas.
;
VER 0E7D0 0000000000000000000000
          ;
CHA $     83E850+          ; sub      eax,50
          7703+            ; jnbe     +03 (0000E7D8)
          83C064+          ; add      eax,64
@0E7D8:   30E4+            ; xor      ah,ah
          C3               ; ret
;
; --------------------------------------------------------------------------
; Fix incorrect dates in replies generated with a template containing
; the %year token.  Previously, a three digit year number was pushed to
; the stack.
;
VER 0570B FF7714+          ; push     dword ptr [edi+14]
          68E5120400       ; push     000412E5
          ;
CHA $     E8CB900000+      ; call     +000090CB (0000E7DB)
          90+              ; nop
          90+              ; nop
          90               ; nop
;
;
; The routine that has been added for the patch from above.
; This routine is called from the patch from above when writing the day number
; for a %year variable in a message template. We have patched the executable
; to use %4.4i instead of 19%2.2i as sprintf format string, so we have to
; push a four digit year number now.
;
VER 0E7DB 000000000000000000000000000000000000
          ;
CHA $     8B4714+          ; mov      eax,[edi+14]
          056C070000+      ; add      eax,0000076C
          870424+          ; xchg     [esp],eax
          68E5120400+      ; push     000412E5
          50+              ; push     eax
          C3               ; ret
          ;
VER 1FD9A 313925322E326900 ; db "19%2.2i",0
          ;
CHA $     25342E3469000000 ; db "%4.4i",0,0,0
;
;Change version numbers from 1.00 to 1.0y
VER 1EAFB    30
CHA $        79
VER 1EF30    30
CHA $        79
VER 1EF5C    30
CHA $        79
VER 1EF73    30
CHA $        79
VER 1F040    30
CHA $        79
VER 1F0D2    30
CHA $        79
VER 2102C    30
CHA $        79
VER 214C3    30
CHA $        79
;
; Done!
;

