/*************************************************************************
  Wordcnt     Count the number of words in the block or file

  Author:     SemWare

  Date:       Aug, 1995
              Jun, 2005 - respect the wordset, so that non-English
                users can make use of this macro.

  Overview:

  Count the number of words in the current file, or, if the cursor is
  in a block, the number of words in the block.  The result is
  displayed.

  Words are assumed to be in the set a-z, A-Z, 0-9 and _.

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

proc main()
    integer block, lastline, count
//    string wordset[32]

//    wordset = Set(WordSet, ChrSet("a-zA-Z0-9_"))
    block = isCursorInBlock()

    PushPosition()
    PushBlock()
    if block
        GotoBlockBegin()
        lastline = Query(BlockEndLine)
        count = isWord() <> FALSE
        while WordRight() and CurrLine() <= lastline
            if isWord() and isCursorInBlock()
                count = count + 1
            endif
        endwhile
    else
        BegFile()
        count = isWord() <> FALSE
        while WordRight()
            if isWord()
                count = count + 1
            endif
        endwhile
    endif
//    Set(WordSet, wordset)
    PopPosition()
    PopBlock()
    Message(count, " words found.")
end

