/************************************************************************
  vMatch      Visual Match

  Author:     SemWare

  Date:       Feb  9, 1995 - Initial version (GDB, RB, KAC)
              Apr 29, 1997 - SEM Incorporate with Match
              Feb  2, 1998 - SEM Match when cursor passes over match chars
              Feb 10, 1998 - SEM Fix hiliting side-effects
              Oct 16, 1998 - SEM Cut down on horizontal scrolling
              Mar 2004 - SEM - add "<>" to match keys.  Suggested by Knud
                            van Eeden.

  Overview:

  Show the matching open character when a closing character is typed.
  Characters matched are: )]}

  Keys:       (none)

  Usage notes:

  This macro does not have any key assignments.  To use, simply select
  it from the Potpourri menu.

  Copyright 1992-1997 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

string match_chars[] = "(){}[]<>"

integer proc mCurrX()
    return (CurrCol() - CurrXoffset())
end

integer proc aMatch()
    return (ExecMacro("match vmatch") and Query(MacroCmdLine) <> "false")
end

proc ShowMatch()
    PutAttrXY(Query(WindowX1) + mCurrX() - 1, Query(WindowY1) + CurrRow() - 1, Query(HiLiteAttr), 1)
end

/**************************************************************************
  When one of the matching characters is typed, show the matching
  character.
 **************************************************************************/
proc OnSelfInsert()
    integer start_line, start_xoffset, n

    if not Query(KBDMacroRunning)
        start_line = CurrLine()
        start_xoffset = CurrXoffset()
        if Pos(Chr(LoByte(Query(Key))), match_chars)

            PushPosition()

            if Left() and aMatch()
                UpdateDisplay()
                ShowMatch()
                n = iif(CurrLine() == start_line and CurrXoffset() == start_xoffset, 3, 5)
                WaitForKeyPressed(n * 55, FALSE)
                UpdateDisplay(_CLINE_REFRESH_)
            endif

            PopPosition()
        endif
    endif
end

proc ReallyAfterUpdateDisplay()
    integer start_line, top_line, bottom_line
    integer start_col, first_col, last_col

    if Pos(Chr(CurrChar()), match_chars)

        PushPosition()

        start_line = CurrLine()
        top_line = start_line - CurrRow() + 1
        bottom_line = start_line + (Query(WindowRows) - CurrRow())

        start_col = CurrCol()
        first_col = start_col - mCurrX() + 1
        last_col  = start_col + (Query(WindowCols) - mCurrX())

        if aMatch()
            if ((CurrLine() in top_line..bottom_line) and (CurrCol() in first_col..last_col))
                ShowMatch()
                UpdateDisplayFlags(_THIS_CLINE_REFRESH_)
            endif
        endif

        PopPosition()
    endif
end

proc WhenLoaded()
    Hook(_POST_UPDATE_ALL_WINDOWS_, ReallyAfterUpdateDisplay)
    Hook(_ON_SELFINSERT_, OnSelfInsert)
end

