/*****************************************************************************
  Format is:
  "[options]"
  Where options are:

  nn    - a number in 25,28,30,33,36,40,43,44,50
 *****************************************************************************/

constant
    MODE_25 = 1, MODE_28, MODE_30, MODE_30X90, MODE_30X94, MODE_33, MODE_34X90,
    MODE_34X94, MODE_36, MODE_40, MODE_40X90, MODE_40X94, MODE_43, MODE_44,
    MODE_50, MODE_80_COL, MODE_MAXLINES, MODE_MAXCOLS, MODE_MAX, MODE_CUSTOM, MODE_RESTORE

constant    CUSTWIDTH = 7

string SECTION[] = "Video",
       HEADING_ROWS[] = "rows",
       HEADING_COLS[] = "cols"

string SAVED_ROWS[] = "$video:saved_rows"
string SAVED_COLS[] = "$video:saved_cols"

integer custom_rows, custom_cols, max_rows, max_cols

integer proc AllowedFlags(integer rows, integer cols)
    if isFullScreen()
        if WhichOS() == _WINDOWS_NT_
            return (iif((rows in 25, 28, 43, 50) and cols == 80, _MF_CLOSE_ALL_BEFORE_, _MF_GRAYED_))
        else
            return (iif((rows in 25, 43, 50) and cols == 80, _MF_CLOSE_ALL_BEFORE_, _MF_GRAYED_))
        endif
    endif
    return (iif(max_rows >= rows and max_cols >= cols, _MF_CLOSE_ALL_BEFORE_, _MF_GRAYED_))
end

proc Try(integer mode)
    string rows[3], cols[4]

    case mode           // since parent uses DONTCLOSE, must get value this way
        when MODE_25        SetVideoRowsCols(25, 80)
        when MODE_28        SetVideoRowsCols(28, 80)
        when MODE_30        SetVideoRowsCols(30, 80)
        when MODE_30X90     SetVideoRowsCols(30, 90)
        when MODE_30X94     SetVideoRowsCols(30, 94)
        when MODE_33        SetVideoRowsCols(33, 80)
        when MODE_34X90     SetVideoRowsCols(34, 90)
        when MODE_34X94     SetVideoRowsCols(34, 94)
        when MODE_36        SetVideoRowsCols(36, 80)
        when MODE_40        SetVideoRowsCols(40, 80)
        when MODE_40X90     SetVideoRowsCols(40, 90)
        when MODE_40X94     SetVideoRowsCols(40, 94)
        when MODE_43        SetVideoRowsCols(43, 80)
        when MODE_44        SetVideoRowsCols(44, 80)
        when MODE_50        SetVideoRowsCols(50, 80)
        when MODE_80_COL    SetVideoRowsCols(Query(ScreenRows), 80)
        when MODE_MAXLINES  SetVideoRowsCols(-1, Query(ScreenCols))
        when MODE_MAXCOLS   SetVideoRowsCols(Query(ScreenRows), -1)
        when MODE_MAX       SetVideoRowsCols(-1, -1)
        when MODE_CUSTOM
            rows = Str(custom_rows)
            cols = Str(custom_cols)
            if AskNumeric("Number of Lines wanted", rows) and AskNumeric("Number of Cols wanted", cols)
                SetVideoRowsCols(Max(Val(rows), 3), Max(Val(cols), 6))
                WriteProfileStr(SECTION, HEADING_ROWS, Str(Query(ScreenRows)))
                WriteProfileStr(SECTION, HEADING_COLS, Str(Query(ScreenCols)))
            endif
        when MODE_RESTORE   SetVideoRowsCols(GetGlobalInt(SAVED_ROWS), GetGlobalInt(SAVED_COLS))
    endcase
end

menu ExtendedModesMenu()
    history
    "2&8 Lines by 80 Columns"       , Try(MODE_28),     AllowedFlags(28, 80)
    "3&0 Lines by 80 Columns"       , Try(MODE_30),     AllowedFlags(30, 80)
    "30 Lines by 90 Columns"        , Try(MODE_30X90),  AllowedFlags(30, 90)
    "30 Lines by 94 Columns"        , Try(MODE_30X94),  AllowedFlags(30, 94)
    "&33 Lines by 80 Columns"       , Try(MODE_33),     AllowedFlags(33, 80)
    "34 Lines by 90 Columns"        , Try(MODE_34X90),  AllowedFlags(34, 90)
    "34 Lines by 94 Columns"        , Try(MODE_34X94),  AllowedFlags(34, 94)
    "3&6 Lines by 80 Columns"       , Try(MODE_36),     AllowedFlags(36, 80)
    "40 &Lines by 80 Columns"       , Try(MODE_40),     AllowedFlags(40, 80)
    "40 Lines by 90 Columns"        , Try(MODE_40X90),  AllowedFlags(40, 90)
    "40 Lines by 94 Columns"        , Try(MODE_40X94),  AllowedFlags(40, 94)
    "&44 Lines by 80 Columns"       , Try(MODE_44),     AllowedFlags(44, 80)
end

menu FontMenu()
    history
    "&25 Lines by 80 Columns"   , Try(MODE_25)
    "&43 Lines by 80 Columns"   , Try(MODE_43), AllowedFlags(43, 80)
    "&50 Lines by 80 Columns"   , Try(MODE_50), AllowedFlags(50, 80)
    "Max &Lines"                , Try(MODE_MAXLINES)
    "Max &Cols"                 , Try(MODE_MAXCOLS)
    "&Max Lines/Cols"    [Format(max_rows, "x", max_cols):CUSTWIDTH] , Try(MODE_MAX), AllowedFlags(-1, -1)
    "C&ustom Lines/Cols" [Format(custom_rows, "x", custom_cols):CUSTWIDTH] , Try(MODE_CUSTOM), AllowedFlags(-2, -2)
    "&Restore" [Format(GetGlobalInt(SAVED_ROWS), "x", GetGlobalInt(SAVED_COLS)):CUSTWIDTH], Try(MODE_RESTORE)
    "&Extended Modes  "        , ExtendedModesMenu(), DontClose
end

proc main()
    string rows[3], cols[3], cmdline[255]
    integer done = FALSE

    if not ExistGlobalVar(SAVED_ROWS)
        SetGlobalInt(SAVED_ROWS, Query(ScreenRows))
        SetGlobalInt(SAVED_COLS, Query(ScreenCols))
    endif

    GetMaxRowsCols(max_rows, max_cols)
    custom_rows = GetProfileInt(SECTION, HEADING_ROWS, max_rows)
    custom_cols = GetProfileInt(SECTION, HEADING_COLS, max_cols)
    custom_rows = Min(max_rows, custom_rows)
    custom_cols = Min(max_cols, custom_cols)

    rows = ""
    cols = ""
    cmdline = Trim(Query(MacroCmdLine))
    if cmdline <> ""
        rows = GetToken(cmdline, ',', 1)
        if NumTokens(cmdline, ',') > 1
            cols = GetToken(cmdline, ',', 2)
        endif
        if rows == "-1" and cols == ""
            cols = "-1"
        endif
        if Val(rows) and Val(cols) and SetVideoRowsCols(Val(rows), Val(cols))
            done = TRUE
        endif
    endif

    if not done
        FontMenu()
    /**************************************************************************
      SEM 09/14/2000 It has been reported that on some systems, in full-screen
      (in other words, non-windowed) mode, changing from 25 lines to 50 lines
      leaves the display blank.  The following line fixes that.
     **************************************************************************/
        UpdateDisplay(_ALL_WINDOWS_REFRESH_)
    endif

    PurgeMacro(CurrMacroFilename())
end

