/**************************************************************************
  Toggle between horizontal and vertical windows.
  Requires exactly two windows.
 **************************************************************************/
proc main()
    integer x1, y1, whichwin, wintype
    constant TOPWIN, BOTTOMWIN, HORIZONTAL, VERTICAL

    if NumWindows() <> 2
        if NumWindows() > 2
            Warn("Requires exactly 2 windows")
        endif
        return ()
    endif

    x1 = Query(WindowX1)
    y1 = Query(WindowY1)

    PushPosition()
    NextWindow()            // to the next window
    PushPosition()          // save position in 'other' window

    whichwin = TOPWIN

    if Query(WindowX1) == x1
        wintype = HORIZONTAL
        if y1 > Query(WindowY1)
            whichwin = BOTTOMWIN
        endif
    else
        wintype = VERTICAL
        if x1 > Query(WindowX1)
            whichwin = BOTTOMWIN
        endif
    endif

    NextWindow()            // back to original window
    OneWindow()

    if wintype == HORIZONTAL
        VWindow()
    else
        HWindow()
    endif

    if whichwin == BOTTOMWIN
        NextWindow()
    endif

    PopPosition()
    NextWindow()
    PopPosition()
end

