/*************************************************************************
  SynHiUtl    Toggle SyntaxHilite for a file/Load an arbitrary .syn file

  Author:     SemWare

  Date:       Jun 26,,1997 - Initial version

  Overview:

  This macro allows one to:

    Turn SyntaxHilite on/off on a file by file basis.

    Load an arbitrary SyntaxHilite (.syn) file.

  Usage notes:

  Upon running this macro, the user is given a menu from which to
  select the supported actions.

  If you wish to make this macro a permanent part of your
  configuration, then simply add "synhiutl" to the AutoLoad list via
  the Macro menu.

  Copyright 1992-1997 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright notice,
  is not removed; and provided that no fee or other remuneration is received
  for distribution.  You may add your own copyright notice to cover new matter
  you add to the macro, but SemWare Corporation will neither support nor
  assume legal responsibility for any material added or any changes made to
  the macro.

*************************************************************************/

string
    color_dir[] = "synhi",
    syn_fn[_MAXPATH_]
integer menu_flag

integer proc MenuFlag2()
    return (menu_flag)
end

integer proc MenuFlag1()
    return (iif(GetSynFilename() == "", _MF_GRAYED_, _MF_CLOSE_ALL_BEFORE_))
end

proc GetThisSyn()
    string ext[_MAXPATH_]

    ext = CurrExt()
    if ext <> "."
        ext = ext[2:_MAXPATH_]
    endif
    ExecMacro("synext -s" + ext)
    syn_fn = Query(MacroCmdLine)
    if syn_fn == ""
        syn_fn = GetSynFilename()
    endif
    syn_fn = SearchPath(syn_fn, "", color_dir)
    menu_flag = (iif(syn_fn == "", _MF_GRAYED_, _MF_CLOSE_ALL_BEFORE_))
end


proc LoadArbitrary()
    string syn_fn[_MAXPATH_] = ""

    while Ask("SyntaxHilite (.syn) file to load?", syn_fn) and Trim(syn_fn) <> ""
        if LinkSynFile(syn_fn, _LOAD_FROM_DISK_)
            return ()
        endif
        Warn("File not found:", syn_fn)
    endwhile
end

menu UtilMenu()
    "Current SyntaxHilite file" [syn_fn:40],                    ,                SKIP
    "&Terminate SyntaxHilite for this file",             PurgeSynHi(),           MenuFlag1()
    "&Activate SyntaxHilite for this file",              InitSynhiCurrFile(),    MenuFlag2()
    "&Load a Mapping (.syn) file for this file...",      LoadArbitrary()
end

proc main()
    GetThisSyn()
    UtilMenu()
end
