/***************************************************************
  StarTrek - the game, in SAL.

  Dec 01 2006  Initial version, by an unknown programmer. "Live
            long and prosper!"

  Dec 05 2006 - Help added by Richard Blackburn.  Additionally, a
            few more GOTO's were removed.

  This SAL macro is based on a Tiny Basic version of StarTrek,
  dated in the mid-seventies.  Here is some of the original
  documentation:

 StarTrek, by Bruce Sherry.

 This is a modified version of Lynn Cochran's StarTrek
 (published in the June 1976 issue of SCSS Interface).  It is
 coded in Tiny Basic (palo alto version) and thus takes less
 memory (8k instead of 12k) and is faster (4 seconds to set up
 the galaxy most of the time, instead of 10 seconds).  It is a
 little different from lynn's version:

 (1) Commands are given in words instead of numbers.

     w or warp for warp engine
     t or torpedo for photon torpedo
     p or phaser for phasers
     s or short for short range scan
     l or long for long range scan
     g or galaxy for galaxy map

 (2) There is one more command: 'report' or 'r' which prints out
 pertinent information (including damages).

 (3) Direction (or course) is given in degrees (0 for north, 90
 for east, 180 for south, and 270 for west), and distance (or
 warps) is given in units of sectors.  Both must be integers.

 (4) The warp engine has better controls now.  You can move
 precisly to where you want to go, even after crossing the
 quadrant boundary. It still takes 1 stardate to make a move, but
 for long distance moves you will burn a disproportionally large
 amount of energy.

 (5) When Klingons fire at you, you could get hurt now.  (In
 Lynn's version, they cannot damage you, and they deplete their
 own energy more than yours.)  So, don't try to sit there and
 wear them out.

 (6) If you hit a Klingon with yout photon torpedo, the Klingon
 might not get totally destroyed.  Also, if you hit a star, it
 might not get effected at all.  When a star is destroyed, it
 might nova and the radiation will hurt you.

 (7) On the positive side, you get more energy (4000 units) at
 each docking, and you are well protected by your shiield.  You
 never get hurt unless the shield is damaged.

 The galaxy consists of 64 quadrants in an 8 by 8 array.  Each
 quadrant consists of 64 sectors in an 8 by 8 array.  When you
 move you give the number of sectors you wish to move.  That is,
 3 quadrants would be 24 sectors (8 sectors x 3 quadrants).

                                ,------------------,
              ,---------------   '---  -----------'
               '-------- ----'     /  /
                   ,---' '--------/  /--,
                    '------------------'

                The USS Enterprise -- NCC-1701

 ***************************************************************/

integer a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,r,s,t,u,v,w,x,y

helpdef st_help
    title  = "Star Trek Help"

    " "
    " "
    "Main screen:"
    " Enterprise in Q-33 S-43"
    " "
    " The galaxy consists of 64 quadrants in an 8 by 8 array.  Each"
    " quadrant consists of 64 sectors in an 8 by 8 array.  "
    " "
    " So you would use the coordinates listed to find yourself on the "
    " Galaxy.  The Q number tells your quadrant Y axis is first number, "
    " X axis is the second number.  The S number tells you where you are"
    " in the current sector."
    " "
    "<R>    Report"
    "------------------"
    " "
    "<S>    SR. sensor"
    "------------------"
    "Shows local quadrant"
    "* = Star"
    "K = Klingon Ship"
    "B = Starbase"
    " "
    "<L>    LR. sensor"
    "------------------"
    "Shows the surrounding quadrants"
    "the 3 potential numbers in each quadrant are:"
    "First Number:      Klingon ships"
    "Second Number:     Starbases"
    "Third Number:      Stars"
    " "
    "<G>    Galaxy map"
    "------------------"
    " "
    "<P>    Phaser"
    "------------------"
    " "
    "<T>    Torpedo"
    "------------------"
    " "
    "<W>    Warp engine"
    "------------------"
    " "
    " When you move you give the number of sectors you wish to move."
    " That is, 3 quadrants would be 24 sectors (8 sectors x 3 quadrants)."
    " "
    " Direction (or course) is given in degrees (0 for north, 90"
    " for east, 180 for south, and 270 for west), and distance (or"
    " warps) is given in units of sectors.  Both must be integers."
    " "
    " "
    " "
    "<Q>    Quit"
    "------------------"
    "Quits game"
    " "
    "<H>    The help"
    "------------------"
    " "
end

integer random_seed
integer proc rnd(integer n)
    random_seed = random_seed * 1103515245 + 12345
    return (((((random_seed / 65536) mod 32768) & 0x7fffffff) mod n) + 1)
end

proc set_array(integer i, integer v)
    SetBufferInt(Str(i), v)
end

integer proc get_array(integer i)
    if not ExistBufferVar(Str(i))
        Warn("Index ", i, " has not been assigned")
        Halt
    endif
    return (GetBufferInt(Str(i)))
end

string proc input_str(string prompt)
    string response[1] = ""

    loop
        Write(prompt)
        Read(response)
        WriteLine("")
        if Trim(response) <> ""
            break
        endif
        WriteLine("You must enter a response")
    endloop
    return (response)
end

integer proc input_int(string prompt)
    string response[4] = ""

    loop
        Write(prompt)
        ReadNumeric(response)
        WriteLine("")
        if Trim(response) <> ""
            break
        endif
        WriteLine("You must enter a response")
    endloop
    return (Val(response))
end

proc list_commands()
    WriteLine("")
    WriteLine("r=Report       s=SR. sensor   l=LR. sensor")
    WriteLine("g=Galaxy map   p=Phaser       t=Torpedo")
    WriteLine("w=Warp engine  h=Help         q=Quit")
    WriteLine("")
end

forward proc L40()
forward proc L45()
forward proc L65()
forward proc L145()
forward proc L160()
forward proc L165()
forward proc L175()
forward proc L180()
forward proc L200()
forward proc L220()
forward proc L260()
forward proc L295()
forward proc L305()
forward proc L325()
forward proc L360()
forward proc L375()
forward proc L420()
forward proc L465()
forward proc L555()
forward proc L615()

// ------ Subroutines ------

proc L40()
    u=rnd(8)
    v=rnd(8)
    x=rnd(8)
    y=rnd(8)
    L45()
end

proc L45()
    for i=71 to 152
        set_array(i, 0)
    endfor
    set_array(8*x+y+62, 4)
    m=abs(get_array(8*u+v-9))
    n=m/100
    i=1
    if n
        for j = 1 to n
            L165()
            set_array(j+134, 300)
            set_array(j+140, s)
            set_array(j+146, t)
        endfor
    endif

    L175()
    m=m-100*n
    i=2
    if m/10
        L165()
    endif
    m=m-m/10*10
    i=3
    if m
        for j=1 to m
            L165()
        endfor
    endif
    L65()
end

proc L65()
    L145()
    L325()
    if k == 0
        WriteLine("")
        WriteLine("Mission accomplished.")
        if d<3
            WriteLine("Boy, you barely made it.")
        endif
        if d>5
            WriteLine("Good work...")
            if d>9
                WriteLine("Fantastic!")
                if d>13
                    WriteLine("Unbelievable!")
                endif
            endif
        endif
        d=30-d
        i=h*100/d*10
        WriteLine(h," Klingons in ",d," stardates. (",i,")")
        j=100*(c==0)-5*c
        WriteLine(c," casualties incurred. (",j,")")
        WriteLine("Your score:",i+j)
    else
        if d<0
            WriteLine(
                "It's too late, the federation has been conquered.")
        endif
    endif
end

proc L145()
    for i=x-(x>1) to x+(x<8)
       for j=y-(y>1) to y+(y<8)
           if get_array(8*i+j+62) == 2
               if o==0
                   WriteLine(
                   "Sulu: 'Captain, we are docked at Starbase.'")
               endif
               L160()
               return ()
           endif
       endfor
    endfor
    o=0
end

proc L160()
    e=4000
    f=10
    o=1
    for i=64 to 70
        set_array(i, 0)
    endfor
end

proc L165()
    repeat
        s=rnd(8)
        t=rnd(8)
        a=8*s+t+62
    until not get_array(a)
    set_array(a, i)
end

proc L175()
    WriteLine("Enterprise in q-", u, v, " s-", x, y)
end

// Galaxy Map
proc L180()
    L175()
    j=2
    L375()
    if i
        return ()
    endif
    WriteLine(" of galaxy map")
    for i=0 to 7
        WriteLine("")
        Write(i+1,":")
        for j=0 to 7
            m=get_array(8*i+j)
            Write((m>0)*m:4)
        endfor
        WriteLine("")
    endfor
    Write("  ")
    for i=0 to 7
        Write("  ..")
    endfor
    WriteLine("")
    Write("  ")
    for i=1 to 8
       Write(i:4)
    endfor
    WriteLine("")
    WriteLine("")
end

// Long Range Sensor
proc L200()
    L175()
    j=3
    L375()
    if i
        return ()
    endif
    WriteLine("")
    for i=u-1 to u+1
        for j=v-1 to v+1
            m=8*i+j-9
            a=0
            if(i>0)*(i<9)*(j>0)*(j<9)
                a=abs(get_array(m))
                set_array(m, a)
            endif
           Write(a:4)
        endfor
       WriteLine("")
    endfor
end

// Short Range Sensor
proc L220()
    L175()
    j=1
    L375()
    if i
        return ()
    endif
    m=8*u+v-9
    set_array(m, abs(get_array(m)))
    WriteLine("")
    for i=1 to 8
        Write(i)
        for j=1 to 8
            m=get_array(8*i+j+62)
            case m
                when 0 Write(" .")
                when 1 Write(" K")
                when 2 Write(" B")
                when 3 Write(" *")
                when 4 Write(" E")
            endcase
        endfor
        WriteLine("")
    endfor
    Write(" ")
    for i=1 to 8
       Write(i:2)
    endfor
    WriteLine("")
end

// Phaser - can end game
proc L260()
    j=4
    L375()
    if i
        return ()
    endif
    a = input_int(" energized. Units to fire:")
    if a<1
        return ()
    endif
    if a>e
        WriteLine("Spock: 'We have only ", e, " units.'")
        return ()
    endif
    e=e-a
    if n<1
        WriteLine("Phaser fired at empty space.")
        L65()
        return ()
    endif
    a=a/n
    for m=135 to 140
        if get_array(m) <> 0
            L295()
            Write(s:3 ," units hit ")
            L305()
        endif
    endfor
    L65()
end

proc L295()
    if a>1090
        WriteLine("...overloaded..")
        j=4
        set_array(67, 1)
        a=9
        L375()
    endif
    i=get_array(m+6)-x
    j=get_array(m+12)-y
    s=a*30/(30+i*i+j*j)+1
end

proc L305()
    Write("Klingon at s-",get_array(m+6), get_array(m+12))
    set_array(m, get_array(m)-s)
    if get_array(m)>0
        WriteLine(" **damaged**")
        return ()
    endif
    set_array(m, 0)
    i=8*u+v-9
    j=get_array(i)/abs(get_array(i))
    set_array(i, get_array(i)-100*j)
    k=k-1
    i=8*get_array(m+6)+get_array(m+12)+62
    set_array(i, 0)
    n=n-1
    WriteLine(" ***destroyed***")
end

proc L325()
    if n==0
        return()
    endif
    WriteLine("Klingon attack")
    if o
        WriteLine("Starbase protects Enterprise")
        return ()
    endif
    t=0
    for m=135 to 140
        if get_array(m) <> 0
            a=(get_array(m)+rnd(get_array(m)))/2
            L295()
            t=t+s
            i=get_array(m+6)
            j=get_array(m+12)
            WriteLine(s:3," units hit from Klingon at s-", i, j)
        endif
    endfor

    e=e-t
    if e<=0
        WriteLine("*** bang ***")
        return ()
    endif
    WriteLine(e, " units of energy left.")
    if rnd(e/4)>t
        return()
    endif
    L360()
end

proc L360()
    if get_array(70)==0
        set_array(70, rnd(t/50+1))
        j=7
        L375()
        return ()
    endif
    j=rnd(6)
    set_array(j+63, rnd(t/99+1)+get_array(j+63))
    i=rnd(8)+1
    c=c+i
    WriteLine("McCoy: 'Sickbay to bridge, we suffered",
            i:2, " casualties.'")
    L375()
end

proc L375()
    i=get_array(j+63)
    case j
        when 1 Write("Short range sensor")
        when 2 Write("Computer display")
        when 3 Write("Long range sensor")
        when 4 Write("Phaser")
        when 5 Write("Warp engine")
        when 6 Write("Photon torpedo tubes")
        when 7 Write("Shield")
    endcase
    if i<>0
        WriteLine(" damaged, ", i,
                " stardates estimated for repair")
    endif
end

// Report
proc L420()
    WriteLine("Status report:")
    WriteLine("stardate", 3230-d:10)
    WriteLine("time left", d:7)
    Write("Condition     ")
    if o
        WriteLine("Docked")
    elseif n
        WriteLine("Red")
    elseif e<999
        WriteLine("Yellow")
    else
        WriteLine("Green")
    endif
    WriteLine("position      q-",u,v," s-",x,y)
    WriteLine("energy", e:12)
    WriteLine("torpedoes",f:7)
    WriteLine("Klingons left",k:3)
    WriteLine("Starbases",b:6)
    for j=1 to 7
        if get_array(j+63)
            L375()
        endif
    endfor
end

proc L525()
    set_array(8*x+y+62, 4)
    L175()
    L65()
end

proc L521()
    WriteLine("**Emergency stop**")
    WriteLine("Spock: 'To err is human.'")
    L525()
end

proc L530()
    p=u*72+p/5+w/5*s/r-9
    u=p/72
    g=v*72+g/5+w/5*t/r-9
    v=g/72
    if rnd(9)<2
        WriteLine("***Space storm***")
        t=100
        L360()
    endif
    if(u>0)*(u<9)*(v>0)*(v<9)
        x=(p+9-72*u)/9
        y=(g+9-72*v)/9
        L45()
        return ()
    endif
    WriteLine("**You wandered outside the galaxy**")
    WriteLine("On board computer takes over, and saved your life")
    L40()
end

// Warp Engine - can end game
proc L465()
     j=5
    L375()
    if i==0
        WriteLine("")
    endif
    loop
        w = input_int("sector distance:")
        if w<1
            return ()
        endif
        if i*(w>2) == 0
            break
        endif
        WriteLine("Chekov: 'We can try 2 at most, sir.'")
    endloop
    if w>91
        w=91
        WriteLine("Spock: 'Are you sure, Captain?'")
    endif
    if e<w*w/2
        WriteLine("Scotty: 'Sir, we do not have the energy.'")
        return ()
    endif
    L615()
    if r==0
        return ()
    endif
    d=d-1
    e=e-w*w/2
    set_array(8*x+y+62, 0)
    for m=64 to 70
        set_array(m, (get_array(m)-1)*(get_array(m)>0))
    endfor
    p=45*x+22
    g=45*y+22
    w=45*w

    for m=1 to 8
        w=w-r
        if w<-22
            L525()
            return ()
        endif
        p=p+s
        g=g+t
        i=p/45
        j=g/45
        if(i<1)+(i>8)+(j<1)+(j>8)
            L530()
            return ()
        endif
        if get_array(8*i+j+62)<>0
            L521()
            return ()
        endif
        x=i
        y=j
    endfor
    L521()
end

proc L590()
    s=rnd(99)+280
    for m=135 to 140
        if (get_array(m+6)==i)*(get_array(m+12)==j)
            L305()
        endif
    endfor
    L65()
end

proc L595()
    b=b-1
    set_array(l, 0)
    set_array(w, get_array(w)-10*r)
    WriteLine("Starbase destroyed")
    WriteLine("Spock: 'I often find human behaviour fascinating.'")
    L65()
end

proc L610()
    t=300
    WriteLine("It novas    ***Radiation alarm***")
    L360()
    L65()
end

proc L605()
    set_array(l, 0)
    set_array(w, get_array(w)-r)
    if rnd(9)<6
        WriteLine("Star destroyed")
        L65()
        return ()
    endif
    L610()
end

proc L600()
    WriteLine("Hit a star")
    if rnd(9)<3
        WriteLine("Torpedo absorbed")
        L65()
        return ()
    endif
    L605()
end

// Torpedo - can end game
proc L555()
    j=6
    L375()
    if i
        return ()
    endif
    if f==0
        WriteLine(" empty")
        return ()
    endif
    WriteLine(" loaded")
    L615()
    if r==0
        return ()
    endif
    Write("torpedo track ")
    f=f-1
    p=45*x+22
    g=45*y+22

    for m=1 to 8
        p=p+s
        g=g+t
        i=p/45
        j=g/45
        if(i<1)+(i>8)+(j<1)+(j>8) == 0
            l=8*i+j+62
            w=8*u+v-9
            r=get_array(w)/abs(get_array(w))
            Write(i," ", j," ")
            case get_array(l)
                when 1
                    L590()
                    return ()
                when 2
                    L595()
                    return ()
                when 3
                    L600()
                    return ()
                when 4
                    L605()
                    return ()
                when 5
                    L610()
                    return ()
            endcase
        endif
    endfor
    WriteLine("...missed")
    L65()
end

// Get Course
proc L615()
    i = input_int("course (0-360):")
    if(i>360)+(i<0)
        r=0
        return()
    endif
    s=(i+45)/90
    i=i-s*90
    r=(45+i*i)/110+45
    case s
        when 1
            s=i
            t=45
        when 2
            s=45
            t=-i
        when 3
            s=-i
            t=-45
        otherwise
            s=-45
            t=i
    endcase
end

proc main()
    random_seed = GetTime()
    PopWinOpen(1, 1, Query(ScreenCols), Query(ScreenRows), 1,
            "StarTrek", 7)
    Set(Attr, 7)
    ClrScr()

    repeat
        y=2999
        if input_str("Do you want a difficult game? (y or n):") == "y"
            y=999
        endif
        WriteLine("")
        Write("Stardate 3200:  your mission is ")
        repeat
            k=0
            b=0
            d=30
            for i=0 to 63
                j=rnd(99)<5
                b=b+j
                m=rnd(y)
                m=(m<209)+(m<99)+(m<49)+(m<24)+(m<9)+(m<2)
                k=k+m
                set_array(i, -100*m-10*j-rnd(8))
            endfor
        until (b<2)+(k<4) == 0

        WriteLine("to destroy ", k, " Klingons in 30 stardates.")
        WriteLine("There are ", b, " Starbases.")
        WriteLine("")
        L160()
        c=0
        h=k
        L40()

        list_commands()
        while e >= 0 and d >= 0
            case input_str("Captain? ")
                when "g" L180()
                when "l" L200()
                when "s" L220()
                when "p" L260()
                when "r" L420()
                when "w" L465()
                when "t" L555()
                when "q" break
                when "h" QuickHelp(st_help)
                otherwise list_commands()
            endcase
        endwhile

        if e <= 0
            WriteLine("Enterprise destroyed")
            if h-k>9
                WriteLine("But you were a good man")
            endif
        endif
        y=987
        WriteLine("")
    until input_str("Another game?  (y or n):") <> 'y'

    WriteLine("Good bye.")
    Writeline("Press a key to close window")
    GetKey()
    PopWinClose()
end

