/*************************************************************************
  ShowCurr    Show ascii and hex value of current character on the StatusLine

  Author:     SemWare (Richard Blackburn)

  Date:       1994

              Jan 31, 1997  Use load/purge to turn on/off

  Overview:

  This macro will display the ascii and hex values of the current
  character on the right edge of the status line.

  Keys:     (none)

  Usage notes:

  To invoke, simply load this macro.  To turn the feature off, purge
  this macro.


  Copyright 1992-1997 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

proc mShowChar()
    integer n = CurrChar(),
            y = Query(StatusLineRow),
            attr = Set(Attr, Query(StatusLineAttr))

    if Query(StatusLineUpdating)
        VGotoXY(Query(ScreenCols) - 6, y)
        PutStr(iif(n < 0, "<EOL>" +iif(n == _AT_EOL_, "  ", "+ "),
                          Format(n:2:"0":16, "h,", n:-3)))
    endif
    Set(Attr, attr)
end

proc WhenLoaded()
    Hook(_AFTER_UPDATE_STATUSLINE_, mShowChar)
end

