/*************************************************************************
  CUAMark     Enables <Shift>+cursor-keys to emulate CUA-style block marking

  Author:     SemWare
              Additional help from Gary Weinfurther and Bradley Small.

  Date:       Apr  5, 1994 - Initial version
              Jun 21, 1994 - Enhancements and improvements

  Overview:

  This macro modifies the <Shift>+cursor-keys to emulate CUA-style
  block marking and manipulating.  It also assigns other keys to
  comply with CUA standards, including key assignments for Paste (from
  the System ClipBoard), CopyBlock (from the System ClipBoard), Cut
  (to the System ClipBoard), and DelBlock.

  Keys:
        <Shift Ins>             Paste-to-clipboard
        <Ctrl Ins>              Copy-from-clipboard
        <Shift Del>             Cut-to-clipboard
        <Ctrl Del>              DelBlock

        <Shift CursorRight>     Mark while going right
        <Shift CursorLeft>      Mark while going left
        <Shift CursorUp>        Mark while going up
        <Shift CursorDown>      Mark while going down
        <Shift Home>            Mark while going to begline
        <Shift End>             Mark while going to endline
        <Shift PgUp>            Mark while going page up
        <Shift PgDn>            Mark while going page down
        <CtrlShift CursorRight> Mark while going word right
        <CtrlShift CursorLeft>  Mark while going word left
        <CtrlShift Home>        Mark while going begwindow
        <CtrlShift End>         Mark while going endwindow
        <CtrlShift PgUp>        Mark while going begfile
        <CtrlShift PgDn>        Mark while going endfile

  Usage notes:

  If you wish to make this macro a permanent part of your
  configuration, then simply add "CUAMark" to the AutoLoad list on
  the Macro menu.

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

// Is the cursor at the end of a block?
integer proc isEndOfBlock()
    integer rc = FALSE

    PushPosition()
    rc = not GotoBlockBegin()
    PopPosition()
    PushPosition()
    rc = rc or (not GotoBlockEnd())
    PopPosition()

    return (rc)
end

// Handle CUA style shift-cursor blockmarking
proc ShiftCursor()
    if isBlockInCurrFile() == _NON_INCLUSIVE_ and isEndOfBlock()
        Set(Marking, ON)
    else
        UnMarkBlock()
        MarkChar()
    endif
    case Query(key)
        when <Shift CursorRight>
            Right()
        when <Shift CursorLeft>
            Left()
        when <Shift CursorUp>
            Up()
        when <Shift CursorDown>
            Down()
        when <Shift Home>
            BegLine()
        when <Shift End>
            EndLine()
        when <Shift PgUp>
            PageUp()
        when <Shift PgDn>
            PageDown()
        when <CtrlShift CursorRight>
            WordRight()
        when <CtrlShift CursorLeft>
            WordLeft()
        when <CtrlShift Home>
            BegWindow()
        when <CtrlShift End>
            EndWindow()
        when <CtrlShift PgUp>
            BegFile()
        when <CtrlShift PgDn>
            EndFile()
    endcase
    MarkChar()

end

// key definitions

<Shift Ins>         Paste()
<Ctrl Ins>          Copy()
<Shift Del>         Cut()
<Ctrl Del>          DelBlock()

<Shift CursorRight>         ShiftCursor()
<Shift CursorLeft>          ShiftCursor()
<Shift CursorUp>            ShiftCursor()
<Shift CursorDown>          ShiftCursor()
<Shift Home>                ShiftCursor()
<Shift End>                 ShiftCursor()
<Shift PgUp>                ShiftCursor()
<Shift PgDn>                ShiftCursor()
<CtrlShift CursorRight>     ShiftCursor()
<CtrlShift CursorLeft>      ShiftCursor()
<CtrlShift Home>            ShiftCursor()
<CtrlShift End>             ShiftCursor()
<CtrlShift PgUp>            ShiftCursor()
<CtrlShift PgDn>            ShiftCursor()

