/**************************************************************************
  ShellExe    Runs the selected text or the current file via Window Associations.

  Author:     SemWare

  Overview:

  If a block is marked, the first line of the block is passed to the
  Windows ShellExecute function.  You can use this to go to a URL in the
  default browser, or to send an email via the default mailer.

  If you are editing an html file and would like to preview it in a
  Browser window, simply run ShellExe, and as long as the file extension
  is .htm or .html, the file will open in the default browser.

  To go to a web page, mark the following URL and run ShellExe:

  www.semware.com

  To send an email, mark any of the following addresses and run
  ShellExe:

  james.t.kirk@starfleet.command.org
  James T. Kirk <james.t.kirk@starfleet.command.org>
  mailto:James T. Kirk <james.t.kirk@starfleet.command.org>

  Keys:       (none)

  Usage notes:

  This macro does not have any key assignments.  To use, simply select
  it from the Potpourri menu.

  If something passed on the cmdline, run it
  elseif there is a marked block, run it,
  else run the current file.

  So, to view a url, just mark it and run this macro.
  To view a html page in the browser, just run this macro.
 **************************************************************************/
constant SW_SHOWNORMAL = 1

dll "<shell32.dll>"
 integer proc ShellExecute(
   integer h,          // handle to parent window
   string op:cstrval,  // specifies operation to perform
   string file:cstrval,// filename string
   string parm:cstrval,// specifies executable-file parameters
   string dir:cstrval, // specifies default directory
   integer show)       // whether file is shown when opened
   :"ShellExecuteA"
end

proc main()
    string s[255]
    integer flag

    if Query(MacroCmdLine) <> ""
        s = Query(MacroCmdLine)
        flag = 1
    elseif isBlockMarked()
        s = GetMarkedText()
        flag = 2
    else
        if FileChanged()
            SaveFile()
        endif
        s = CurrFilename()
        flag = 3
    endif

    if ShellExecute(GetWinHandle(), "open", s, "", "", SW_SHOWNORMAL) <= 32
        if flag in 1,2
            if Pos("@", s) in 2..Length(s)-1
                if ShellExecute(GetWinHandle(), "open", "mailto:" + s, "", "", SW_SHOWNORMAL) > 32
                    return ()
                endif
            endif
            Warn("I do not know what to do with: ", s)
        else
            if CurrExt() == ""
                Warn("Windows needs a File extension for an association")
            else
                Warn(CurrExt(), " does not have an association")
            endif
        endif
    endif
end
